/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.client.AbstractApOtherBillReportQueryUI;
import com.kingdee.eas.fi.ap.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ApOtherBillReportQueryUI
extends AbstractApOtherBillReportQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(ApOtherBillReportQueryUI.class);
    CompanyOrgUnitInfo currentCompany = null;
    private static final String COMPANY_IS_NULL = "CompanyIsNull";
    private static final String APRESOUCE = "com.kingdee.eas.fi.ap.client.ApResource";
    protected HashMap map = new HashMap();
    protected ArApSysParamInfo sysInfo = null;
    protected IArApBillFacade iBillFacade = null;
    private int comboAsstActTypeSelectedIndex = 0;

    public ApOtherBillReportQueryUI() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
        String companyId = this.getCompanyId();
        this.map.put("isSCM", Boolean.FALSE);
        this.map.put("sysEnum", SystemEnum.ACCOUNTSPAYABLE);
        this.sysInfo = this.iBillFacade.getSysParams(this.currentCompany, this.map);
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.setBillTypeItem();
        this.setAsstActType();
        ArApBillUIUtil.setOrgUnitF7(this.prmtPurGroupFrom, this.prmtPurGroupTo, OrgType.Purchase, companyId);
        this.prmtPurGroupFrom.setEnabledMultiSelection(false);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgFrom, false, true, false);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgTo, false, true, false);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonFrom);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonTo);
        this.setCUForBillNumber();
    }

    private void setBillTypeItem() {
        this.comboBillType.addItem((Object)OtherBillType.OtherPay);
        this.comboBillType.addItem((Object)OtherBillType.InvoiceBill);
        this.comboBillType.addItem((Object)OtherBillType.ExpenseInvoice);
        this.comboBillType.addItem((Object)OtherBillType.DebitAdjust);
        this.comboBillType.addItem((Object)ComBoxInfo.ITEM_ALL);
        this.comboBillType.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
    }

    private void setAsstActType() {
        try {
            BaseDataUtil.makeBillAsstActType(this.combAsstActType, this.getCompanyId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.combAsstActType.addItem((Object)ComBoxInfo.ITEM_ALL);
        this.combAsstActType.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
        this.comboAsstActTypeSelectedIndex = this.combAsstActType.getSelectedIndex();
    }

    private void setCUForBillNumber() throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyId(), CompareType.EQUALS));
        filter.setMaskString(" #0");
        viewInfo.setFilter(filter);
        this.prmtBillNumberFrom.setEntityViewInfo(viewInfo);
        this.prmtBillNumberTo.setEntityViewInfo(viewInfo);
        this.prmtBillNumberFrom.setEditable(true);
        this.prmtBillNumberTo.setEditable(true);
    }

    public RptParams getCustomCondition() {
        DataBaseInfo receivedOrgUnit;
        DataBaseInfo person;
        DataBaseInfo adminorg;
        DataBaseInfo purchaseOrg;
        OtherBillInfo otherBillInfo;
        Object obj;
        CurrencyInfo currency;
        RptParams params = new RptParams();
        params.setString("company", this.getCompanyId());
        Object billTypeEnum = this.comboBillType.getSelectedItem();
        if (!ComBoxInfo.ITEM_ALL.equals(billTypeEnum)) {
            params.setString("billType", "" + ((OtherBillType)billTypeEnum).getValue());
        }
        if ((currency = (CurrencyInfo)this.prmtCurrency.getData()) != null) {
            params.setString("currency", "" + currency.getId());
            params.setString("currencyNumber", currency.getNumber());
            params.setString("currencyName", currency.getName());
        }
        if (!ComBoxInfo.ITEM_ALL.equals(obj = this.combAsstActType.getSelectedItem())) {
            params.setString("asstActType", ((AsstActTypeInfo)((ComBoxInfo)obj).getobjInfo()).getId().toString());
        }
        params.setInt("asstActTypeSelectedIndex", this.combAsstActType.getSelectedIndex());
        DataBaseInfo asstActRec = (DataBaseInfo)this.prmtAsstActRecFrom.getData();
        if (asstActRec != null) {
            params.setString("asstActNumberFrom", asstActRec.getNumber());
            params.setString("asstActNumberFromID", "" + asstActRec.getId());
        }
        if ((asstActRec = (DataBaseInfo)this.prmtAsstActRecTo.getData()) != null) {
            params.setString("asstActNumberTo", asstActRec.getNumber());
            params.setString("asstActNumberToID", "" + asstActRec.getId());
        }
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date billDate = (Date)this.kdBillStartDate.getValue();
        if (billDate != null) {
            params.setString("billDateFrom", dtFormat.format(billDate));
        }
        if ((billDate = (Date)this.kdBillEndDate.getValue()) != null) {
            params.setString("billDateTo", dtFormat.format(billDate));
        }
        if ((otherBillInfo = (OtherBillInfo)this.prmtBillNumberFrom.getData()) != null) {
            params.setString("numberFrom", otherBillInfo.getNumber());
        }
        if ((otherBillInfo = (OtherBillInfo)this.prmtBillNumberTo.getData()) != null) {
            params.setString("numberTo", otherBillInfo.getNumber());
        }
        if ((purchaseOrg = (DataBaseInfo)this.prmtPurGroupFrom.getData()) != null) {
            params.setString("purOrgNumberFrom", purchaseOrg.getNumber());
            params.setString("purOrgNameFrom", purchaseOrg.getName());
        }
        if ((purchaseOrg = (DataBaseInfo)this.prmtPurGroupTo.getData()) != null) {
            params.setString("purOrgNumberTo", purchaseOrg.getNumber());
            params.setString("purOrgNameTo", purchaseOrg.getName());
        }
        if ((adminorg = (DataBaseInfo)this.prmtAdminOrgFrom.getData()) != null) {
            params.setString("adminOrgNumberFrom", adminorg.getNumber());
            params.setString("adminOrgNameFrom", adminorg.getName());
        }
        if ((adminorg = (DataBaseInfo)this.prmtAdminOrgTo.getData()) != null) {
            params.setString("adminOrgNumberTo", adminorg.getNumber());
            params.setString("adminOrgNameTo", adminorg.getName());
        }
        if ((person = (DataBaseInfo)this.prmtPersonFrom.getData()) != null) {
            params.setString("personNumberFrom", person.getNumber());
            params.setString("personNameFrom", person.getName());
        }
        if ((person = (DataBaseInfo)this.prmtPersonTo.getData()) != null) {
            params.setString("personNumberTo", person.getNumber());
            params.setString("personNameTo", person.getName());
        }
        if ((receivedOrgUnit = (DataBaseInfo)this.prmtReceivedOrgUnitFrom.getData()) != null) {
            params.setString("receivedOrgUnitNumberFrom", receivedOrgUnit.getNumber());
            params.setString("receivedOrgUnitNameFrom", receivedOrgUnit.getName());
        }
        if ((receivedOrgUnit = (DataBaseInfo)this.prmtReceivedOrgUnitTo.getData()) != null) {
            params.setString("receivedOrgUnitNumberTo", receivedOrgUnit.getNumber());
            params.setString("receivedOrgUnitNameTo", receivedOrgUnit.getName());
        }
        if (this.rbNotAudit.isSelected()) {
            params.setString("audit", "no");
        } else if (this.rbAudit.isSelected()) {
            params.setString("audit", "yes");
        } else {
            params.setString("audit", "all");
        }
        if (this.rbNotVerify.isSelected()) {
            params.setString("verify", "no");
        } else if (this.rbVerifySome.isSelected()) {
            params.setString("verify", "some");
        } else if (this.rbVerified.isSelected()) {
            params.setString("verify", "yes");
        } else {
            params.setString("verify", "all");
        }
        if (this.rbNotVoucher.isSelected()) {
            params.setString("voucher", "no");
        } else if (this.rbVouchered.isSelected()) {
            params.setString("voucher", "yes");
        } else {
            params.setString("voucher", "all");
        }
        if (this.cbSumAdminOrg.isSelected()) {
            params.setString("sumAdminorg", "yes");
        }
        if (this.cbSumAsstActRec.isSelected()) {
            params.setString("sumAsstact", "yes");
        }
        if (this.cbSumPerson.isSelected()) {
            params.setString("sumPerson", "yes");
        }
        return params;
    }

    public void setCustomCondition(RptParams params) {
        StorageOrgUnitInfo storageOrgUnitInfo;
        PersonInfo personInfo;
        AdminOrgUnitInfo adminOrgInfo;
        PurchaseOrgUnitInfo purOrgInfo;
        OtherBillInfo otherBillInfo;
        this.resetValue();
        if (UIRuleUtil.isNotNull((String)params.getString("billType"))) {
            int billTypeNumber = Integer.parseInt(params.getString("billType"));
            this.comboBillType.setSelectedItem((Object)OtherBillType.getEnum((int)billTypeNumber));
        } else {
            this.comboBillType.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("currency"))) {
            CurrencyInfo curInfo = new CurrencyInfo();
            curInfo.setId(BOSUuid.read((String)params.getString("currency")));
            curInfo.setName(params.getString("currencyName"));
            curInfo.setNumber(params.getString("currencyNumber"));
            this.prmtCurrency.setData((Object)curInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("asstActType"))) {
            this.combAsstActType.setSelectedIndex(params.getInt("asstActTypeSelectedIndex"));
            if (!this.combAsstActType.getSelectedItem().equals(ComBoxInfo.ITEM_ALL)) {
                this.prmtAsstActRecFrom.setEnabled(true);
                this.prmtAsstActRecTo.setEnabled(true);
            } else {
                this.prmtAsstActRecFrom.setEnabled(false);
                this.prmtAsstActRecTo.setEnabled(false);
            }
        }
        if (UIRuleUtil.isNotNull((String)params.getString("asstActNumberFrom"))) {
            this.setBizPromptData(this.prmtAsstActRecFrom, params.getString("asstActNumberFromID"));
        }
        if (UIRuleUtil.isNotNull((String)params.getString("asstActNumberTo"))) {
            this.setBizPromptData(this.prmtAsstActRecTo, params.getString("asstActNumberToID"));
        }
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (UIRuleUtil.isNotNull((String)params.getString("billDateFrom"))) {
            try {
                this.kdBillStartDate.setValue((Object)dtFormat.parse(params.getString("billDateFrom")));
            }
            catch (ParseException e) {
                this.kdBillStartDate.setValue((Object)new Date());
            }
        }
        if (UIRuleUtil.isNotNull((String)params.getString("billDateTo"))) {
            try {
                this.kdBillEndDate.setValue((Object)dtFormat.parse(params.getString("billDateTo")));
            }
            catch (ParseException e) {
                this.kdBillEndDate.setValue((Object)new Date());
            }
        }
        if (UIRuleUtil.isNotNull((String)params.getString("numberFrom"))) {
            otherBillInfo = new OtherBillInfo();
            otherBillInfo.setNumber(params.getString("numberFrom"));
            this.prmtBillNumberFrom.setData((Object)otherBillInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("numberTo"))) {
            otherBillInfo = new OtherBillInfo();
            otherBillInfo.setNumber(params.getString("numberTo"));
            this.prmtBillNumberTo.setData((Object)otherBillInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("purOrgNumberFrom"))) {
            purOrgInfo = new PurchaseOrgUnitInfo();
            purOrgInfo.setNumber(params.getString("purOrgNumberFrom"));
            purOrgInfo.setName(params.getString("purOrgNameFrom"));
            this.prmtPurGroupFrom.setDisplayFormat("$name$");
            this.prmtPurGroupFrom.setData((Object)purOrgInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("purOrgNumberTo"))) {
            purOrgInfo = new PurchaseOrgUnitInfo();
            purOrgInfo.setNumber(params.getString("purOrgNumberTo"));
            purOrgInfo.setName(params.getString("purOrgNameTo"));
            this.prmtPurGroupTo.setDisplayFormat("$name$");
            this.prmtPurGroupTo.setData((Object)purOrgInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("adminOrgNumberFrom"))) {
            adminOrgInfo = new AdminOrgUnitInfo();
            adminOrgInfo.setNumber(params.getString("adminOrgNumberFrom"));
            adminOrgInfo.setName(params.getString("adminOrgNameFrom"));
            this.prmtAdminOrgFrom.setDisplayFormat("$name$");
            this.prmtAdminOrgFrom.setData((Object)adminOrgInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("adminOrgNumberTo"))) {
            adminOrgInfo = new AdminOrgUnitInfo();
            adminOrgInfo.setNumber(params.getString("adminOrgNumberTo"));
            adminOrgInfo.setName(params.getString("adminOrgNameTo"));
            this.prmtAdminOrgTo.setDisplayFormat("$name$");
            this.prmtAdminOrgTo.setData((Object)adminOrgInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("personNumerFrom"))) {
            personInfo = new PersonInfo();
            personInfo.setNumber(params.getString("personNumerFrom"));
            personInfo.setName(params.getString("personNameFrom"));
            this.prmtPersonFrom.setDisplayFormat("$name$");
            this.prmtPersonFrom.setData((Object)personInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("personNumerTo"))) {
            personInfo = new PersonInfo();
            personInfo.setNumber(params.getString("personNumerTo"));
            personInfo.setName(params.getString("personNameTo"));
            this.prmtPersonTo.setDisplayFormat("$name$");
            this.prmtPersonTo.setData((Object)personInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("receivedOrgUnitNumberFrom"))) {
            storageOrgUnitInfo = new StorageOrgUnitInfo();
            storageOrgUnitInfo.setNumber(params.getString("receivedOrgUnitNumberFrom"));
            storageOrgUnitInfo.setName(params.getString("receivedOrgUnitNameFrom"));
            this.prmtReceivedOrgUnitFrom.setDisplayFormat("$number$");
            this.prmtReceivedOrgUnitFrom.setData((Object)storageOrgUnitInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("receivedOrgUnitNumberTo"))) {
            storageOrgUnitInfo = new StorageOrgUnitInfo();
            storageOrgUnitInfo.setNumber(params.getString("receivedOrgUnitNumberTo"));
            storageOrgUnitInfo.setName(params.getString("receivedOrgUnitNameTo"));
            this.prmtReceivedOrgUnitTo.setDisplayFormat("$number$");
            this.prmtReceivedOrgUnitTo.setData((Object)storageOrgUnitInfo);
        }
        this.rbAuditAll.setSelected(true);
        if ("yes".equals(params.getString("audit"))) {
            this.rbAudit.setSelected(true);
        } else if ("no".equals(params.getString("audit"))) {
            this.rbNotAudit.setSelected(true);
        }
        this.rbVerifyAll.setSelected(true);
        if ("yes".equals(params.getString("verify"))) {
            this.rbVerified.setSelected(true);
        } else if ("some".equals(params.getString("verify"))) {
            this.rbVerifySome.setSelected(true);
        } else if ("no".equals(params.getString("verify"))) {
            this.rbNotVerify.setSelected(true);
        }
        this.rbVoucherAll.setSelected(true);
        if ("yes".equals(params.getString("voucher"))) {
            this.rbVouchered.setSelected(true);
        } else if ("no".equals(params.getString("voucher"))) {
            this.rbNotVoucher.setSelected(true);
        }
        if ("yes".equals(params.getString("sumAdminorg"))) {
            this.cbSumAdminOrg.setSelected(true);
        }
        if ("yes".equals(params.getString("sumPerson"))) {
            this.cbSumPerson.setSelected(true);
        }
        if ("yes".equals(params.getString("sumAsstact"))) {
            this.cbSumAsstActRec.setSelected(true);
        }
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    private String getCompanyId() {
        if (this.currentCompany.isIsOnlyUnion()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)APRESOUCE, (String)COMPANY_IS_NULL));
            SysUtil.abort();
        }
        return this.currentCompany.getId().toString();
    }

    private void resetValue() {
        this.comboBillType.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
        this.prmtCurrency.setData(null);
        this.combAsstActType.setSelectedIndex(this.comboAsstActTypeSelectedIndex);
        this.prmtAsstActRecFrom.setData(null);
        this.prmtAsstActRecFrom.setEnabled(false);
        this.prmtAsstActRecTo.setData(null);
        this.prmtAsstActRecTo.setEditable(false);
        this.prmtBillNumberFrom.setData(null);
        this.prmtBillNumberTo.setData(null);
        this.kdBillStartDate.setValue(null);
        this.kdBillEndDate.setValue(null);
        this.prmtPurGroupFrom.setData(null);
        this.prmtPurGroupTo.setData(null);
        this.prmtAdminOrgFrom.setData(null);
        this.prmtAdminOrgTo.setData(null);
        this.prmtPersonFrom.setData(null);
        this.prmtPersonTo.setData(null);
        this.rbAuditAll.setSelected(true);
        this.rbVerifyAll.setSelected(true);
        this.rbVoucherAll.setSelected(true);
        this.cbSumAdminOrg.setSelected(false);
        this.cbSumAsstActRec.setSelected(false);
        this.cbSumPerson.setSelected(false);
    }

    public void clear() {
        this.resetValue();
    }

    @Override
    protected void combBillType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        OtherBillType billType = null;
        this.prmtPurGroupTo.setEnabled(true);
        this.prmtPurGroupFrom.setEnabled(true);
        if (!e.getItem().equals(ComBoxInfo.ITEM_ALL) && (billType = (OtherBillType)e.getItem()).getValue() == 201) {
            this.prmtPurGroupTo.setEnabled(false);
            this.prmtPurGroupFrom.setEnabled(false);
        }
    }

    @Override
    protected void comboAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        String queryInfo;
        if (e.getStateChange() != 1 || this.combAsstActType.getItemCount() == 0 || this.combAsstActType.getSelectedItem() == null) {
            return;
        }
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        String companyId = this.currentCompany.getId().toString();
        this.prmtAsstActRecFrom.setValue(null);
        this.prmtAsstActRecTo.setValue(null);
        Object obj = this.combAsstActType.getSelectedItem();
        if (this.combAsstActType.getItemCount() == 0 || obj == null || ComBoxInfo.ITEM_ALL.equals(obj)) {
            this.prmtAsstActRecFrom.setEnabled(false);
            this.prmtAsstActRecTo.setEnabled(false);
            return;
        }
        AsstActTypeInfo asstActType = (AsstActTypeInfo)((ComBoxInfo)obj).getobjInfo();
        if (!ComBoxInfo.ITEM_ALL.equals(obj) && !UIRuleUtil.isNull((String)(queryInfo = asstActType.getDefaultQueryName()))) {
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAsstActRecFrom, this.prmtAsstActRecTo, asstActType, companyId, this.sysInfo, true);
            this.prmtAsstActRecFrom.setEnabled(true);
            this.prmtAsstActRecTo.setEnabled(true);
        }
    }
}

