/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.AbstractBadAccountParamAssignUI;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.arap.BaseServiceFacadeFactory;
import com.kingdee.eas.fi.arap.IBaseServiceFacade;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class BadAccountParamAssignUI
extends AbstractBadAccountParamAssignUI {
    IBadAccountFacade iBadAccountFacade;
    Set company = new HashSet();
    private static final Logger logger = CoreUIObject.getLogger(BadAccountParamAssignUI.class);
    public static final String CRTL = "\n\r";

    public void onLoad() throws Exception {
        super.onLoad();
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor check_CellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.tblMain.getColumn("isSelected").setEditor((ICellEditor)check_CellEditor);
        this.tblMain.getColumn("isAccountBadDebt").setEditor((ICellEditor)check_CellEditor);
        this.tblMain.getColumn("isSelected").getStyleAttributes().setLocked(false);
        this.btnSelectAll.setEnabled(true);
        this.btnClearAll.setEnabled(true);
        this.btnBatchUpdate.setEnabled(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.company.add(this.tblMain.getCell(i, "id").getValue());
        }
        try {
            this.company = this.getAccountBadDebtCompany(this.company);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        this.setIsAccountBadDebt();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setIsAccountBadDebt();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.setIsAccountBadDebt();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.setIsAccountBadDebt();
    }

    public void setIsAccountBadDebt() {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (this.company.contains(this.tblMain.getCell(i, "id").getValue())) {
                this.tblMain.getCell(i, "isAccountBadDebt").setValue((Object)true);
                continue;
            }
            this.tblMain.getCell(i, "isAccountBadDebt").setValue((Object)false);
        }
    }

    public Set getAccountBadDebtCompany(Set company) throws BOSException {
        HashSet<String> companyId = new HashSet<String>();
        if (company.size() == 0) {
            return companyId;
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("select FCompanyID from ").append("T_AR_AccountBadDebt ");
        sql.append(" where FCompanyID in(").append(ArApBillUtil.getSqlIDs(company)).append(")");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                companyId.add(rs.getString("FCompanyID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return companyId;
    }

    public Set checkBadAccountOrgPermisson() throws BOSException, EASBizException {
        HashSet<String> orgIdSet = new HashSet<String>();
        Context ctx = new Context();
        ctx.setCaller(this.getUserPk());
        IBaseServiceFacade baseservice = BaseServiceFacadeFactory.getRemoteInstance();
        OrgUnitInfo[] orgColl = baseservice.getAuthorizedOrgUnits(1, "fi_arap_BadAccountParameter");
        for (int i = 0; i < orgColl.length; ++i) {
            orgIdSet.add(orgColl[i].getId().toString());
        }
        return orgIdSet;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        try {
            Set orgIdSet = this.checkBadAccountOrgPermisson();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgIdSet, CompareType.INCLUDE));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        return filter;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, "isSelected").setValue((Object)true);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, "isSelected").setValue((Object)false);
        }
    }

    public static boolean isMapEmpty(Map map) {
        return null == map || map.size() == 0;
    }

    public static double getDoubleValue(Map map, String key) {
        if (!BadAccountParamAssignUI.isMapEmpty(map)) {
            Object value = map.get(key);
            return null == value ? 0.0 : Double.valueOf(value.toString());
        }
        return 0.0;
    }

    public static String getStringValue(Map map, String key) {
        if (!BadAccountParamAssignUI.isMapEmpty(map)) {
            Object value = map.get(key);
            return null == value ? "" : value.toString();
        }
        return "";
    }

    @Override
    public void actionBatchUpdate_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchUpdate_actionPerformed(e);
        this.iBadAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
        String msg = this.iBadAccountFacade.batchUpdateParams(SysContext.getSysContext().getCurrentFIUnit(), this.getSelectCompany());
        HashMap msgMap = (HashMap)Kson.getGson().fromJson(msg, HashMap.class);
        if (null != msgMap) {
            double errorCount = BadAccountParamAssignUI.getDoubleValue(msgMap, "errorCount");
            String summaryMsg = BadAccountParamAssignUI.getStringValue(msgMap, "summaryMsg");
            if (errorCount > 0.0) {
                StringBuilder buf = new StringBuilder(300).append(summaryMsg);
                Object object = msgMap.get("detailMesgs");
                if (null != object && object instanceof List) {
                    buf.append(CRTL);
                    List detailMesgs = (List)object;
                    for (int i = 0; i < detailMesgs.size(); ++i) {
                        buf.append(i + 1).append(" ").append((String)detailMesgs.get(i)).append(CRTL);
                    }
                }
                MsgBox.showWarning((String)buf.toString());
            } else {
                MsgBox.showInfo((String)summaryMsg);
            }
        } else {
            MsgBox.showError((String)BadAccountParamAssignUI.getArResource("no_response"));
        }
    }

    public static String getArResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ArResource", (String)key);
    }

    public CompanyOrgUnitCollection getSelectCompany() throws BOSException, EASBizException {
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            CompanyOrgUnitInfo company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.tblMain.getCell(i, "id").getValue().toString()));
            if (!((Boolean)this.tblMain.getCell(i, "isSelected").getValue()).booleanValue()) continue;
            companyColl.add(company);
        }
        return companyColl;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

