/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.ApCloseAccountManagerUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

class CloseAccountThread
extends Thread {
    private static final Logger logger = CoreUIObject.getLogger(CloseAccountThread.class);
    private ApCloseAccountManagerUI page;

    public CloseAccountThread(ApCloseAccountManagerUI aPage) {
        this.page = aPage;
    }

    @Override
    public void run() {
        try {
            this.CloseAccountForThread();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void CloseAccountForThread() throws EASBizException, BOSException {
        Boolean isAr = Boolean.FALSE;
        Object[] companys = this.page.getValidCompanys();
        final StringBuilder sb = new StringBuilder(150);
        int len = companys.length;
        for (int i = 0; i < len; ++i) {
            Object[] params = new Object[]{companys[i], isAr, SysContext.getSysContext().getLocale(), SysContext.getSysContext().getCurrentUserInfo()};
            JobConfig jobCfg = this.creteJobCfg((CompanyOrgUnitInfo)companys[i]);
            if (this.page.iCreateJobFacade.checkDuplicateTask(jobCfg.getTaskType())) {
                sb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"ApClosrAccountIsInQueue"), ((CompanyOrgUnitInfo)companys[i]).getName()));
                sb.append("\r\n");
                continue;
            }
            sb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"ApClosrAccountJoinInQueue"), ((CompanyOrgUnitInfo)companys[i]).getName()));
            sb.append("\r\n");
            Object objResult = this.page.iCreateJobFacade.executeJob(jobCfg, (Object)params);
            Map result = null;
            if (objResult instanceof Map) {
                result = (Map)objResult;
            }
            if (result == null || result.get("jobInstExtId") == null) continue;
            JobMonitorManager.getInstance().addMonitorInfo((String)result.get("jobInstExtId"), jobCfg.getTitle());
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"ApCloseAccountFinish"), (String)sb.toString(), (int)1);
                return null;
            }
        };
        worker.start();
    }

    private JobConfig creteJobCfg(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)company);
        String title = currentPeriod.toString() + "\u3010" + company.getName() + "(" + company.getNumber() + ")\u3011" + EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"ApCloseAccount");
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setSyn(true);
        jobCfg.setTaskType("SCM_FI_AP_001" + company.getNumber());
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(true);
        jobCfg.setMutex("Apcloseaccount");
        jobCfg.setNumber("SCM_FI_AP_001");
        return jobCfg;
    }
}

