/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.AbstractImportBalanceFromGLUI;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ar.IImpInitDataGLFacade;
import com.kingdee.eas.fi.ar.ImpInitDataGLFacadeFactory;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ImportBalanceFromGLUI
extends AbstractImportBalanceFromGLUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportBalanceFromGLUI.class);
    private CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
    private IImpInitDataGLFacade iImpInitDataGLFacade = null;

    public ImportBalanceFromGLUI() throws Exception {
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.curCompany);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (ApClientUtils.getApStartPeriod(this.curCompany) == null) {
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.curCompany.getName() + this.getSystemEnumForOA().getAlias()});
        }
        this.iImpInitDataGLFacade = ImpInitDataGLFacadeFactory.getRemoteInstance();
        this.initialize();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSPAYABLE;
    }

    private void initialize() {
        this.labWizardImg.setIcon(EASResource.getIcon((String)"imgGuide_pic338"));
        this.windowTitle = ApClientUtils.getApStringResource("ImportGuideTitle");
        StringBuffer text = new StringBuffer();
        text.append(ApClientUtils.getApStringResource("ImportGuideInfo_0")).append("\r\n");
        text.append(ApClientUtils.getApStringResource("ImportGuideInfo_1")).append("\r\n");
        text.append(ApClientUtils.getApStringResource("ImportGuideInfo_2")).append("\r\n");
        text.append(ApClientUtils.getApStringResource("ImportGuideInfo_3"));
        this.descriptionTextArea.setText(text.toString());
    }

    @Override
    protected void btnNext_actionPerformed(ActionEvent e) throws Exception {
        if (!ApClientUtils.apIsStart(this.curCompany)) {
            MsgBox.showInfo((Component)((Object)this), (String)(ApClientUtils.getApStringResource("ApHasNotFinished") + ApClientUtils.getApStringResource("PleaseUseInitDataImport")));
            this.abort();
        }
        PeriodInfo apCurrentPeriod = ApClientUtils.getApCurrentPeriod(this.curCompany);
        PeriodInfo glCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.curCompany);
        if (apCurrentPeriod == null || glCurrentPeriod == null || PeriodUtils.PeriodCompare((String)glCurrentPeriod.getId().toString(), (String)apCurrentPeriod.getId().toString()) != 0) {
            this.descriptionTextArea.setText(new MessageFormat(ApClientUtils.getApStringResource("ImportGuideAlert")).format(new String[]{"\n"}));
            this.btnNext.setVisible(false);
        } else {
            String s = EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"periodInfo");
            MessageFormat mf = new MessageFormat(s);
            String message = mf.format(new String[]{apCurrentPeriod.getPeriodYear() + "", apCurrentPeriod.getPeriodNumber() + ""});
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)new MessageFormat(ApClientUtils.getApStringResource("ImportConfirm")).format(new String[]{message}));
            if (2 == result) {
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("company", this.curCompany);
            params.put("period", apCurrentPeriod);
            this.iImpInitDataGLFacade.importBalanceFromGL(params);
            this.descriptionTextArea.setText(ApClientUtils.getApStringResource("ImportSuccess"));
            this.btnNext.setVisible(false);
            this.btnCancel.setText(ApClientUtils.getApStringResource("Finish"));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)resKey);
    }
}

