/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.ap.client.AbstractInitCheckListUI;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InitCheckListUI
extends AbstractInitCheckListUI {
    private static final Logger logger = CoreUIObject.getLogger(InitCheckListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.setColumnMoveable(false);
        this.tHelper.setCanSetHideColumn(false);
        this.tblMain.getColumn("date").getStyleAttributes().setNumberFormat(ArApBillUtil.getDateFormatString());
        this.tblMain.getColumn("debitAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("debitAmtLoc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("creditAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("creditAmtLoc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("periodAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("periodAmtLoc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("glDebitAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("glDebitAmtLoc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("glCreditAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("glCreditAmtLoc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("glPeriodAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("glPeriodAmtLoc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        Vector result = (Vector)this.getUIContext().get("result");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        String period = this.getUIContext().get("period").toString();
        if (this.getUIContext().get("system").toString().equalsIgnoreCase("ar")) {
            this.tblMain.getHeadRow(0).getCell("debitAmt").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"19_InitCheckListUI"));
        } else {
            this.tblMain.getHeadRow(0).getCell("debitAmt").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"20_InitCheckListUI"));
        }
        ObjectUuidPK compk = new ObjectUuidPK(company.getId());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("baseCurrency"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("invalidDate"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        ICompanyOrgUnit comorg = CompanyOrgUnitFactory.getRemoteInstance();
        company = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        ObjectUuidPK orgPk = new ObjectUuidPK(company.getId());
        int checkType = -1;
        checkType = "ar".equals(this.getUIContext().get("system")) ? Integer.parseInt(ParamManager.getParamValue(null, (IObjectPK)orgPk, (String)"AR_INIT_CHECK_TYPE")) : Integer.parseInt(ParamManager.getParamValue(null, (IObjectPK)orgPk, (String)"AP_INIT_CHECK_TYPE"));
        if (checkType == 0) {
            this.tblMain.getColumn("debitAmtLoc").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("creditAmtLoc").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("periodAmtLoc").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("glDebitAmtLoc").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("glCreditAmtLoc").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("glPeriodAmtLoc").getStyleAttributes().setHided(true);
        } else if (checkType == 1) {
            this.tblMain.getColumn("debitAmt").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("creditAmt").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("periodAmt").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("glDebitAmt").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("glCreditAmt").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("glPeriodAmt").getStyleAttributes().setHided(true);
        }
        this.fillData(result, company, period);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void fillData(Vector checkResult, CompanyOrgUnitInfo companyInfo, String period) {
        IRow row = null;
        HashMap result = null;
        int iCount = checkResult.size();
        String localString = this.getFormatString(companyInfo.getBaseCurrency().getPrecision());
        for (int i = 0; i < iCount; ++i) {
            result = (HashMap)checkResult.get(i);
            row = this.tblMain.addRow();
            row.getCell("company").setValue((Object)companyInfo.getName());
            row.getCell("date").setValue((Object)period);
            row.getCell("acctcuss").setValue(result.get("acctcuss_name"));
            row.getCell("account").setValue(result.get("account"));
            row.getCell("currency").setValue(result.get("currency"));
            String sourceString = this.getFormatString(result.get("currency_prec"));
            row.getCell("debitAmt").setValue(result.get("debitAmt"));
            row.getCell("debitAmt").getStyleAttributes().setNumberFormat(sourceString);
            row.getCell("debitAmtLoc").setValue(result.get("debitAmtLoc"));
            row.getCell("debitAmtLoc").getStyleAttributes().setNumberFormat(localString);
            row.getCell("creditAmt").setValue(result.get("creditAmt"));
            row.getCell("creditAmt").getStyleAttributes().setNumberFormat(sourceString);
            row.getCell("creditAmtLoc").setValue(result.get("creditAmtLoc"));
            row.getCell("creditAmtLoc").getStyleAttributes().setNumberFormat(localString);
            row.getCell("periodAmt").setValue(result.get("periodAmt"));
            row.getCell("periodAmt").getStyleAttributes().setNumberFormat(sourceString);
            row.getCell("periodAmtLoc").setValue(result.get("periodAmtLoc"));
            row.getCell("periodAmtLoc").getStyleAttributes().setNumberFormat(localString);
            row.getCell("glDebitAmt").setValue(result.get("glDebitAmt"));
            row.getCell("glDebitAmt").getStyleAttributes().setNumberFormat(sourceString);
            row.getCell("glDebitAmtLoc").setValue(result.get("glDebitAmtLoc"));
            row.getCell("glDebitAmtLoc").getStyleAttributes().setNumberFormat(localString);
            row.getCell("glCreditAmt").setValue(result.get("glCreditAmt"));
            row.getCell("glCreditAmt").getStyleAttributes().setNumberFormat(sourceString);
            row.getCell("glCreditAmtLoc").setValue(result.get("glCreditAmtLoc"));
            row.getCell("glCreditAmtLoc").getStyleAttributes().setNumberFormat(localString);
            row.getCell("glPeriodAmt").setValue(result.get("glPeriodAmt"));
            row.getCell("glPeriodAmt").getStyleAttributes().setNumberFormat(sourceString);
            row.getCell("glPeriodAmtLoc").setValue(result.get("glPeriodAmtLoc"));
            row.getCell("glPeriodAmtLoc").getStyleAttributes().setNumberFormat(localString);
        }
    }

    private String getFormatString(Object prec) {
        int precision = Integer.parseInt(prec.toString());
        if (precision == 0) {
            precision = 2;
        }
        return PrecisionFormatUtils.getFormatString(precision);
    }
}

