/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.client.AbstractOtherBillPlanListUI;
import com.kingdee.eas.fi.ap.client.OtherBillEditUI;
import com.kingdee.eas.fi.ap.client.OtherBillPlanQueryUI;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.client.ArApCommonQueryProcessor;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.ArApBillListUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class OtherBillPlanListUI
extends AbstractOtherBillPlanListUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherBillPlanListUI.class);
    private static String PAYMENT_BILL_BOSTYPE = "40284E81";
    private OtherBillPlanQueryUI userPanel = null;
    private CommonQueryDialog dialog = null;
    private String[] amountFields = new String[]{"payPlan.recievePayAmount", "payPlan.recievePayAmountLoc", "payPlan.verifyAmount", "payPlan.verifyAmountLocal", "payPlan.unVerifyAmount", "payPlan.unVerifyAmountLoc", "payPlan.lockAmount", "payPlan.lockAmountLoc", "payPlan.unLockAmount", "entries.unLockAmt", "payPlan.unLockAmountLoc"};
    public static final String COL_PRECISION = "currency.precision";
    public static final String COL_BASEPRECISION = "baseCurrency.precision";
    private static String isNotQuickFilteringSupport = null;
    protected ArApSysParamInfo cache = null;
    protected IArApBillFacade iBillFacade;
    ArApCommonQueryProcessor processor = null;
    FillListener fillListener = new FillListener();
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public OtherBillPlanListUI() throws Exception {
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
        this.cache = new ArApSysParamInfo();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        if (!ArApBillListUI.isSameStatus(this.tblMain, BillStatusEnum.AUDITED)) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("billIsUnAudited"));
            SysUtil.abort();
        }
        Set<String> planIDSet = new HashSet();
        HashMap map = new HashMap();
        List selectedRows = ArApBillUIUtil.getSelectedRows(this.tblMain);
        if (selectedRows.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("PAY_PLAN_SELECT_ENTRY_CANNOT_NULL"));
            SysUtil.abort();
        }
        for (int i = 0; i < selectedRows.size(); ++i) {
            IRow row = (IRow)selectedRows.get(i);
            String id = (String)row.getCell("id").getValue();
            String planID = (String)row.getCell("payPlan.id").getValue();
            if (map.containsKey(id)) {
                planIDSet = (Set)map.get(id);
            } else {
                planIDSet = new HashSet();
                map.put(id, planIDSet);
            }
            planIDSet.add(planID);
        }
        this.getBizInterface().checkSelectedPlan(map);
        String srcBillType = this.getBizType().toString();
        SelectorItemCollection botpSelectors = new SelectorItemCollection();
        botpSelectors.add("*");
        botpSelectors.add("rules.ruleSegments.*");
        String pk = this.getSelectedKeyValue();
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("Owner", (Object)this);
        uiContext.put("idList", ArApBillUtil.convertListToStringArray(this.getSelectedIdValues()));
        uiContext.put("entryNames", new String[]{"entry"});
        uiContext.put("srcBillType", srcBillType);
        uiContext.put("botpSelectors", botpSelectors);
        uiContext.put("SRCBILLLIST", (Object)this);
        uiContext.put("map", map);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.fi.arap.client.ARAPBTPMakeBillUIWithoutGrp", uiContext, null);
        window.show();
    }

    protected OtherBillPlanQueryUI getUserPanel() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = new OtherBillPlanQueryUI();
        }
        return this.userPanel;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(true);
            this.processor = new ArApCommonQueryProcessor();
            this.processor.set("isArSys", Boolean.FALSE);
            this.processor.set("isInit", Boolean.FALSE);
            this.processor.setCompanyInfo(this.cache.getCompany());
            this.dialog.setProcessor((IProcessor)this.processor);
            try {
                this.dialog.addUserPanel((KDPanel)this.getUserPanel());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.dialog;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected IOtherBill getBizInterface() throws Exception {
        return OtherBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getEditUIName() {
        return OtherBillEditUI.class.getName();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if (this.getUIContext().get("BTPNAVCTX") != null && this.getUIContext().get("BOTPFilter") != null) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("company.id"));
            view.getSelector().add(new SelectorItemInfo("company.number"));
            view.getSelector().add(new SelectorItemInfo("company.name"));
            view.setFilter(((EntityViewInfo)this.getUIContext().get("BOTPFilter")).getFilter());
            try {
                CoreBaseCollection coll = this.getBizInterface().getCollection(view);
                if (coll.size() > 0) {
                    CompanyOrgUnitInfo company = ((ArApBillBaseInfo)coll.get(0)).getCompany();
                    this.getUIContext().put(this.getMainBizOrgType(), company);
                    this.initUIMainOrgContext(company.getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        if (this.getBOTPViewStatus() == 1) {
            this.getUIContext().put("SumVisible", "true");
            return super.getDefaultFilterForQuery();
        }
        return super.getDefaultFilterForQuery();
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "company.name", "number", "billStatus", "billDate", "bizDate", "billType", "asstActType.name", "asstActNumber", "asstActName"};
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        destBosTypeList.clear();
        destBosTypeList.add("40284E81");
        destBosTypeList.add("D001019A");
        return super.getDestBosTypeForBotp(srcBillInfos, destBosTypeList);
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        if (row == null) {
            return null;
        }
        int columnCount = this.tblMain.getColumnCount();
        for (int c = 0; c < columnCount; ++c) {
            ICell cell = row.getCell(c);
            cell.getStyleAttributes().setNumberFormat("###,##0.##########");
        }
        return row;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    private void setListUITablePrecision(int start, int end) {
        String[] amountFields = this.getAmountFields();
        String[] localAmountFields = this.getLocalAmountFields();
        for (int i = start; i <= end; ++i) {
            int j;
            IRow row = this.tblMain.getRow(i);
            int precision = 2;
            ICell cell = row.getCell(COL_PRECISION);
            if (cell != null && cell.getValue() != null && !(cell.getValue() instanceof String)) {
                precision = Integer.parseInt(cell.getValue().toString());
            }
            int baseprecision = 2;
            cell = row.getCell(COL_BASEPRECISION);
            if (cell != null && cell.getValue() != null && !(cell.getValue() instanceof String)) {
                baseprecision = Integer.parseInt(cell.getValue().toString());
            }
            for (j = 0; j < amountFields.length; ++j) {
                CasForArApUtil.setPrecision((ICell)row.getCell(amountFields[j]), (int)precision);
            }
            for (j = 0; j < localAmountFields.length; ++j) {
                CasForArApUtil.setPrecision((ICell)row.getCell(localAmountFields[j]), (int)baseprecision);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected String[] getAmountFields() {
        return new String[]{"payPlan.recievePayAmount", "payPlan.verifyAmount", "payPlan.unVerifyAmount", "payPlan.lockAmount", "payPlan.unLockAmount"};
    }

    protected String[] getLocalAmountFields() {
        return new String[]{"payPlan.recievePayAmountLoc", "payPlan.verifyAmountLocal", "payPlan.unVerifyAmountLoc", "payPlan.lockAmountLoc", "payPlan.unLockAmountLoc"};
    }

    protected boolean isVoucherVisible() {
        return false;
    }

    protected boolean isPCVoucherVisible() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isNotQuickFilteringSupport() {
        if (isNotQuickFilteringSupport == null) {
            try {
                IParamControl ipc = ParamControlFactory.getRemoteInstance();
                isNotQuickFilteringSupport = ipc.getParamValue(null, "USEQUICKQUERY");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
        }
        if ("false".equals(isNotQuickFilteringSupport)) {
            return true;
        }
        return super.isNotQuickFilteringSupport();
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if ((this.cache == null || this.cache.getCompany() == null) && this.getUIContext().get("BTPNAVCTX") == null) {
            try {
                IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
                this.cache = iBillFacade.getSysParams(null, this.getUIParam());
                return this.qfsi.supportSingleMainOrg((OrgUnitInfo)this.cache.getCompany());
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        return this.qfsi;
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysEnum", this.getSysEnum());
        map.put("isSCM", Boolean.FALSE);
        map.put("permissionItem", this.getPermissionItem());
        return map;
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSPAYABLE;
    }

    protected String getPermissionItem() {
        return "fi_ap_ApOtherBill_View";
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            OtherBillPlanListUI.this.setListUITablePrecision(e.getFirstRow(), e.getLastRow());
        }
    }
}

