/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillBeforGroupListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.client.AbstractPayRequestBillSumListUI;
import com.kingdee.eas.fi.ap.client.PayRequestBillEditUI;
import com.kingdee.eas.fi.ap.client.PayRequestBillSumQueryUI;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.scm.common.client.BillOptionsHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayRequestBillSumListUI
extends AbstractPayRequestBillSumListUI {
    private static final long serialVersionUID = -8526261819043746226L;
    private static final Logger logger = CoreUIObject.getLogger(PayRequestBillSumListUI.class);
    private static String isNotQuickFilteringSupport = null;
    public ArApSysParamInfo cache = null;
    protected IArApBillFacade iBillFacade;
    protected String[] AMOUNT_FIELDS = new String[]{"sumEntry.reqPayAmount", "sumEntry.auditAmount", "sumEntry.payedAmt", "sumEntry.unpayAmount", "sumEntry.lockAmount", "sumEntry.unLockAmount"};
    protected String[] BASEAMOUNT_FIELDS = new String[]{"sumEntry.auditAmountLoc", "sumEntry.lockAmountLoc", "sumEntry.unLockAmountLoc"};
    public static final String COL_PROCESSNODE = "processNode";
    public static final String COL_DEPARTMENT = "department";
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public PayRequestBillSumListUI() throws Exception {
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
        this.cache = new ArApSysParamInfo();
    }

    protected String getOrgFieldName() {
        return "company.id";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PayRequestBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "company.name", "number", "billStatus", "bizDate", "currency.name", "creator.name", "createTime", "lastUpdateUser.name", "lastUpdateTime", "auditor.name", "auditDate", "costCenter.name", "currency.number", "isPaySchedule", "requestReason", "description", COL_PROCESSNODE, COL_DEPARTMENT};
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    protected String getTDFileName() {
        return "/FI/AP/payrequestbill";
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isAutoIgnoreZero() {
        return false;
    }

    public void onLoad() throws Exception {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && qfsi.getSystemSolutionItem().getDefaultFilter().size() == 0) {
            qfsi.getSystemSolutionItem().getDefaultFilter().add("company.id", CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add("bizDate", CompareType.IS, (Object)DateEnum.RECENTONEMONTH);
        }
        super.onLoad();
        this.actionViewImage.setEnabled(true);
        this.ActionTDPrint.setEnabled(true);
        this.ActionTDPrintPreview.setEnabled(true);
        this.ActionBatchSubmit.setEnabled(true);
        this.ActionViewBdgBalance.setEnabled(true);
        this.ActionAudit.setEnabled(true);
        this.ActionAntiAudit.setEnabled(true);
        this.menuItemMultiPrint.setIcon(EASResource.getIcon((String)"imgTbtn_printcontinue"));
        this.menuItemMultiPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_printpreview"));
        this.ActionMultiPrint.setEnabled(true);
        this.ActionMultiPrintPreview.setEnabled(true);
        this.menuItemBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.btnBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                PayRequestBillSumListUI.this.tbl_afterDataFill(e);
            }
        });
        this.getMainTable().getDataRequestManager().addDataFillBeforeGroup(new KDTDataFillBeforGroupListener(){

            public void beforeGroupAction(KDTDataRequestEvent e) {
                try {
                    ArApBillUIUtil.tbl_afterDataFillDealProcessNode(PayRequestBillSumListUI.this.getMainTable(), PayRequestBillSumListUI.COL_PROCESSNODE, e);
                }
                catch (Exception e1) {
                    PayRequestBillSumListUI.this.handUIException(e1);
                }
            }
        });
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.supportExecutionWithoutFilters();
        if (this.cache == null || this.cache.getCompany() == null) {
            try {
                IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
                this.cache = iBillFacade.getSysParams(null, this.getUIParam());
                return this.qfsi.supportSingleMainOrg((OrgUnitInfo)this.cache.getCompany());
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        return this.qfsi;
    }

    @Override
    protected String getBillEntryName() {
        return "sumEntry";
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fi.ap.app.PayRequestBillQuery");
    }

    @Override
    protected CoreUI getListUI() {
        return this;
    }

    protected String getEditUIName() {
        return PayRequestBillEditUI.class.getName();
    }

    @Override
    protected boolean isNotQuickFilteringSupport() {
        if (isNotQuickFilteringSupport == null) {
            try {
                IParamControl ipc = ParamControlFactory.getRemoteInstance();
                isNotQuickFilteringSupport = ipc.getParamValue(null, "USEQUICKQUERY");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
        }
        if ("false".equals(isNotQuickFilteringSupport)) {
            return true;
        }
        return super.isNotQuickFilteringSupport();
    }

    protected void updateInfoByCompany(DataBaseInfo info) throws Exception {
        this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
    }

    protected void initCompany() throws EASBizException, BOSException {
        if (this.cache.getCompany() == null) {
            this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            request.put("uiparam", (Object)this.getUIParam());
            request.setClassName(this.getUIHandlerClassName());
            if (this.getUIContext().get("BTPNAVCTX") != null) {
                request.put("BTPNAVCTX", (Object)true);
            }
            request.put("CONFIG_TYPE_VIEW", (Object)BillOptionsHelper.getConfigTypeAllEntityView((String)this.getMetaDataPK().getFullName().toString()));
            request.put("_SCMMAINORGTYPE", (Object)this.getMainBizOrgType());
            request.setMainOrgType(this.getMainBizOrgType());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    protected List getQueryPKFields() {
        ArrayList<String> pkList = new ArrayList<String>();
        pkList.add("id");
        pkList.add("sumEntry.id");
        return pkList;
    }

    @Override
    protected PayRequestBillSumQueryUI getUserPanel() throws Exception {
        return new PayRequestBillSumQueryUI(this.getUIParam());
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        String[] NUBMERFORMAT_COLS = new String[]{"sumEntry.reqPayAmount", "sumEntry.auditAmount", "sumEntry.auditAmountLoc", "sumEntry.lockAmount", "sumEntry.lockAmountLoc", "sumEntry.unLockAmount", "sumEntry.unLockAmountLoc", "sumEntry.payedAmt", "sumEntry.unpayAmount"};
        int from = e.getFirstRow();
        int last = e.getLastRow();
        BigDecimal amout = null;
        for (int i = from; i <= last; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            for (int j = 0; j < NUBMERFORMAT_COLS.length; ++j) {
                Object scaleObj;
                if (row.getCell(NUBMERFORMAT_COLS[j]) == null || (scaleObj = row.getCell(NUBMERFORMAT_COLS[j]).getValue()) == null || !(scaleObj instanceof BigDecimal)) continue;
                amout = (BigDecimal)scaleObj;
                row.getCell(NUBMERFORMAT_COLS[j]).getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(amout.scale()));
            }
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            Map colMap = null;
            int baseCurrencyPrecision = 2;
            if (this.cache.getCompany() != null && this.cache.getCompany().getBaseCurrency() != null) {
                baseCurrencyPrecision = this.cache.getCompany().getBaseCurrency().getPrecision();
            }
            while (rowSet.next()) {
                if (colMap == null) {
                    colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
                }
                SCMClientUtils.iniColumnsPrecision((int)rowSet.getInt("currency.precision"), (String[])this.AMOUNT_FIELDS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)baseCurrencyPrecision, (String[])this.BASEAMOUNT_FIELDS, (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }
}

