/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSelect;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgUnitTreePromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.AbstractPaymentBillDetailReportQueryUI;
import com.kingdee.eas.fi.ap.client.util.ApPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.ArPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.BizSysPeriodHelper;
import com.kingdee.eas.fi.ar.util.AsstActTypeUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class PaymentBillDetailReportQueryUI
extends AbstractPaymentBillDetailReportQueryUI {
    private static final Logger logger = Logger.getLogger(PaymentBillDetailReportQueryUI.class);
    private static final String resClassName = "com.kingdee.eas.fi.ar.ArReport";
    private HashMap conditions = new HashMap();
    private DataBaseInfo typeFrom = null;
    private DataBaseInfo typeTo = null;
    private boolean isPeriodSum = false;
    private boolean isChkSum = false;
    private boolean noAudit = false;
    private boolean isPeriod = false;
    private boolean isBillDate = false;
    private String companyId = "";
    private String billType = "";
    private PeriodInfo currentPeriod = null;
    private boolean fAR = false;
    private BizSysPeriodHelper periodHelper = null;
    private CompanyOrgUnitInfo currentCompany = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private int defaultCussTypeInd = 0;
    private int defaultCurrencyInd = 0;

    public PaymentBillDetailReportQueryUI() throws Exception {
    }

    public PaymentBillDetailReportQueryUI(boolean fIsAr, ActionEvent e) throws Exception {
        this.fAR = fIsAr;
    }

    public void onLoad() throws Exception {
        this.setAccordingPeriod(this.rdBtnPeriod.isSelected());
        this.initPrompt();
        super.onLoad();
        this.setComponentVal();
        this.prmptCussentFrom.setEditable(true);
        this.prmptCussentFrom.setCommitFormat("$number$");
        this.prmptCussentTo.setEditable(true);
        this.prmptCussentTo.setCommitFormat("$number$");
    }

    private void initPrompt() throws EASBizException, BOSException {
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
            this.companyId = this.currentCompany.getId().toString();
        }
        catch (Exception ex) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyFail"));
            SysUtil.abort();
        }
        this.setCompanyF7();
        this.setCurrency();
        this.setPeriod();
        this.setAsstActType();
    }

    public void setAsstActType() throws EASBizException, BOSException {
        String cpid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(" where isAccountCussent = 1 and  company.id='" + cpid + "' ");
        int count = asstActTypeColl.size();
        Object[] typeValue = new Object[count];
        IAsstActType iaat = AsstActTypeFactory.getRemoteInstance();
        int desiredIndex = 0;
        String defaultTbl = this.fAR ? "t_bd_customer" : "t_bd_supplier";
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo value = asstActTypeColl.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)value.getAsstActType().getString("id")));
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("name");
            selectors.add("number");
            selectors.add("defaultQueryName");
            selectors.add("realtionDataObject");
            selectors.add("glAsstActTypeGrp.id");
            AsstActTypeInfo asstInfo = iaat.getAsstActTypeInfo((IObjectPK)pk, selectors);
            String typeName = asstInfo.getName();
            String typeId = asstInfo.getId().toString();
            String typeQueryName = asstInfo.getDefaultQueryName();
            String typeTableName = asstInfo.getRealtionDataObject();
            if (typeTableName.equalsIgnoreCase(defaultTbl)) {
                desiredIndex = i;
            }
            int csType = 0;
            AsstActTypeUtils asstActType = new AsstActTypeUtils(typeName, typeId, typeTableName, typeQueryName, csType);
            if (asstInfo.getGlAsstActTypeGrp() != null) {
                asstActType.glAsstActGrpId = asstInfo.getGlAsstActTypeGrp().getId().toString();
            }
            typeValue[i] = asstActType;
        }
        this.comboCussentType.removeAllItems();
        this.comboCussentType.addItems(typeValue);
        this.comboCussentType.setSelectedIndex(desiredIndex);
        this.defaultCussTypeInd = desiredIndex;
    }

    private void setPeriod() throws EASBizException, BOSException {
        PeriodInfo startPeriod = null;
        if (this.fAR) {
            this.periodHelper = ArPeriodHelper.getInstance(true);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
            this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
        } else {
            this.periodHelper = ApPeriodHelper.getInstance(true);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)this.currentCompany);
            this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)this.currentCompany);
        }
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.kDSpnPeriodYearFrom, this.kDSpinnerNumFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodNumberTo);
        this.kDDatePickerFrom.setValue((Object)this.currentPeriod.getBeginDate());
        this.kDDatePickerTo.setValue((Object)this.currentPeriod.getEndDate());
        this.kDDatePickerFrom.setMinimumDate(startPeriod.getBeginDate());
        this.kDDatePickerFrom.setMaximumDate((java.util.Date)this.currentPeriod.getEndDate());
        this.kDDatePickerTo.setMinimumDate(startPeriod.getBeginDate());
        this.kDDatePickerTo.setMaximumDate((java.util.Date)this.currentPeriod.getEndDate());
    }

    @Override
    protected void comboCussentType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.comboCussentType.getItemCount() == 0 || this.comboCussentType.getSelectedItem() == null) {
            return;
        }
        AsstActTypeUtils type = (AsstActTypeUtils)this.comboCussentType.getSelectedItem();
        if (type.typeId != null || type.typeQueryName != null) {
            this.prmptCussentFrom.setEnabled(true);
            this.prmptCussentTo.setEnabled(true);
            AsstActTypeInfo typeInfo = new AsstActTypeInfo();
            typeInfo.put("id", (Object)type.typeId);
            typeInfo.setDefaultQueryName(type.typeQueryName);
            typeInfo.setRealtionDataObject(type.tableName);
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmptCussentFrom, typeInfo, this.companyId, true);
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmptCussentTo, typeInfo, this.companyId, true);
        } else {
            this.prmptCussentFrom.setEnabled(false);
            this.prmptCussentTo.setEnabled(false);
        }
        this.prmptCussentFrom.setValue(null);
        this.prmptCussentTo.setValue(null);
    }

    private void setCurrency() throws EASBizException, BOSException {
        ICurrency iCurrency = null;
        CurrencyCollection con = null;
        try {
            iCurrency = CurrencyFactory.getRemoteInstance();
            con = iCurrency.getCurrencyCollection(true);
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"currencyFail"));
            SysUtil.abort();
        }
        if (con != null) {
            Object[] typeValue = new Object[con.size()];
            int companyCurrInd = 0;
            for (int i = 0; i < con.size(); ++i) {
                String typeQueryName;
                String typeId;
                CurrencyInfo currencyInfo = con.get(i);
                String typeName = currencyInfo.getName();
                AsstActTypeUtils asstActType = new AsstActTypeUtils(typeName, typeId = currencyInfo.getId().toString(), typeQueryName = currencyInfo.getNumber());
                if (asstActType == null) continue;
                typeValue[i] = asstActType;
                if (!typeId.equals(this.currentCompany.getBaseCurrency().getId().toString())) continue;
                companyCurrInd = i;
            }
            this.comboCurrency.removeAllItems();
            this.comboCurrency.addItems(typeValue);
            this.comboCurrency.setSelectedIndex(companyCurrInd);
            this.defaultCurrencyInd = companyCurrInd;
            String allType = EASResource.getString((String)resClassName, (String)"allType");
            this.comboCurrency.addItem((Object)new AsstActTypeUtils(allType, null, null));
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"currencyFail"));
            SysUtil.abort();
        }
    }

    private void setCompanyF7() {
        OrgType[] CompanyType = new OrgType[]{OrgType.Company};
        this.bizPromptCompany.setEditFormat("$number$");
        this.bizPromptCompany.setDisplayFormat("$name$");
        this.bizPromptCompany.setEditable(true);
        this.bizPromptCompany.setCommitFormat("$number$");
        OrgUnitTreePromptBox boxCompany = new OrgUnitTreePromptBox((IUIObject)this, CompanyType, null, OrgSelect.OnlySelectCompanyEntity, false, false, false);
        this.bizPromptCompany.setSelector((KDPromptSelector)boxCompany);
        this.bizPromptCompany.setData((Object)this.currentCompany);
        this.bizPromptCompany.setEnabled(false);
    }

    public Object getParam() {
        if (this.bizPromptCompany.getData() != null) {
            this.companyId = ((OrgUnitInfo)this.bizPromptCompany.getData()).getId().toString();
        }
        AsstActTypeUtils currency = null;
        if (this.comboCurrency.getSelectedItem() != null) {
            currency = (AsstActTypeUtils)this.comboCurrency.getSelectedItem();
        }
        AsstActTypeUtils asstActType = null;
        if (this.comboCussentType.getSelectedItem() != null) {
            asstActType = (AsstActTypeUtils)this.comboCussentType.getSelectedItem();
        }
        String typeFromVal = "";
        if (this.prmptCussentFrom.getData() != null) {
            Object objectValue = this.prmptCussentFrom.getValue();
            typeFromVal = ((DataBaseInfo)objectValue).getNumber().toString();
        }
        String typeToVal = "";
        if (this.prmptCussentTo.getData() != null) {
            Object objectValue = this.prmptCussentTo.getValue();
            typeToVal = ((DataBaseInfo)objectValue).getNumber().toString();
        }
        String periodYearFrom = null;
        String periodYearTo = null;
        String periodNumFrom = null;
        String periodNumTo = null;
        periodYearFrom = this.kDSpnPeriodYearFrom.getValue().toString();
        periodYearTo = this.kDSpnPeriodYearTo.getValue().toString();
        periodNumFrom = this.kDSpinnerNumFrom.getValue().toString();
        periodNumTo = this.kDSpnPeriodNumberTo.getValue().toString();
        Date dateFrom = null;
        Date dateTo = null;
        if (this.kDDatePickerFrom.getTimestamp() != null) {
            dateFrom = BaseDataUtil.downTimestamp(this.kDDatePickerFrom.getTimestamp());
        }
        if (this.kDDatePickerTo.getTimestamp() != null) {
            dateTo = BaseDataUtil.downTimestamp(this.kDDatePickerTo.getTimestamp());
        }
        if (dateFrom == null || dateTo == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"dateFail"));
            SysUtil.abort();
        } else if (dateFrom.after(dateTo)) {
            Date dateTemp = dateFrom;
            dateFrom = dateTo;
            dateTo = dateTemp;
        }
        this.conditions.put("currentCompany", this.currentCompany);
        this.conditions.put("cuId", this.currentCompany.getCU().getString("id"));
        this.conditions.put("companyId", this.companyId);
        this.conditions.put("currency", currency);
        this.conditions.put("asstActType", asstActType);
        this.conditions.put("typeFromVal", typeFromVal);
        this.conditions.put("typeToVal", typeToVal);
        this.conditions.put("currentPeriodInfo", this.currentPeriod);
        this.conditions.put("periodYearFrom", periodYearFrom);
        this.conditions.put("periodYearTo", periodYearTo);
        this.conditions.put("periodNumFrom", periodNumFrom);
        this.conditions.put("periodNumTo", periodNumTo);
        this.conditions.put("isPeriodSum", this.kDChkPeriodSum.isSelected());
        this.conditions.put("isChkSum", this.kDChkSum.isSelected());
        this.conditions.put("noAudit", this.kDChkNoAudit.isSelected());
        this.conditions.put("billType", this.billType);
        this.conditions.put("dateFrom", dateFrom);
        this.conditions.put("dateTo", dateTo);
        this.conditions.put("isPeriod", this.rdBtnPeriod.isSelected());
        this.conditions.put("isBillDate", this.rdBtnDate.isSelected());
        this.conditions.put("typeFromSelected", this.prmptCussentFrom.getData());
        this.conditions.put("typeToSelected", this.prmptCussentTo.getData());
        this.conditions.put("currencySelected", new Integer(this.comboCurrency.getSelectedIndex()));
        this.conditions.put("typeSelected", new Integer(this.comboCussentType.getSelectedIndex()));
        return this.conditions;
    }

    public void setCustomerParams(CustomerParams cp) {
        String periodNumTo;
        String periodNumFrom;
        String periodYearTo;
        String periodYearFrom;
        String asstActTypeId;
        String currencyId = cp.getCustomerParam("currencyId");
        if (!StringUtils.isEmpty((String)currencyId)) {
            int n = this.comboCurrency.getItemCount();
            for (int i = 0; i < n; ++i) {
                AsstActTypeUtils item = (AsstActTypeUtils)this.comboCurrency.getItemAt(i);
                if (!currencyId.equals(item.typeId)) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
        if (!StringUtils.isEmpty((String)(asstActTypeId = cp.getCustomerParam("asstActTypeId")))) {
            int n = this.comboCussentType.getItemCount();
            for (int i = 0; i < n; ++i) {
                AsstActTypeUtils item = (AsstActTypeUtils)this.comboCussentType.getItemAt(i);
                if (!asstActTypeId.equals(item.typeId)) continue;
                this.comboCussentType.setSelectedIndex(i);
                break;
            }
        }
        String typeFromVal = cp.getCustomerParam("typeFromVal");
        String cussFromId = cp.getCustomerParam("cussFromId");
        String cussFromName = cp.getCustomerParam("cussFromName");
        if (cussFromId != null) {
            AsstActTypeInfo info = new AsstActTypeInfo();
            info.put("id", (Object)cussFromId);
            info.setNumber(typeFromVal);
            info.setName(cussFromName);
            this.prmptCussentFrom.setData((Object)info);
        }
        String typeToVal = cp.getCustomerParam("typeToVal");
        String cussToId = cp.getCustomerParam("cussToId");
        String cussToName = cp.getCustomerParam("cussToName");
        if (cussToId != null) {
            AsstActTypeInfo info = new AsstActTypeInfo();
            info.put("id", (Object)cussToId);
            info.setNumber(typeToVal);
            info.setName(cussToName);
            this.prmptCussentTo.setData((Object)info);
        }
        if ((periodYearFrom = cp.getCustomerParam("periodYearFrom")) != null) {
            this.kDSpnPeriodYearFrom.setValue((Object)new Integer(periodYearFrom));
        }
        if ((periodYearTo = cp.getCustomerParam("periodYearTo")) != null) {
            this.kDSpnPeriodYearTo.setValue((Object)new Integer(periodYearTo));
        }
        if ((periodNumFrom = cp.getCustomerParam("periodNumFrom")) != null) {
            this.kDSpinnerNumFrom.setValue((Object)new Integer(periodNumFrom));
        }
        if ((periodNumTo = cp.getCustomerParam("periodNumTo")) != null) {
            this.kDSpnPeriodNumberTo.setValue((Object)new Integer(periodNumTo));
        }
        String dateFrom = cp.getCustomerParam("dateFrom");
        try {
            if (dateFrom != null) {
                java.util.Date utilDate = this.dateFormat.parse(dateFrom);
                this.kDDatePickerFrom.setValue((Object)utilDate);
            }
        }
        catch (ParseException e) {
            logger.error((Object)("can't parse the date: " + dateFrom), (Throwable)e);
        }
        String dateTo = cp.getCustomerParam("dateTo");
        try {
            if (dateTo != null) {
                java.util.Date utilDate = this.dateFormat.parse(dateTo);
                this.kDDatePickerTo.setValue((Object)utilDate);
            }
        }
        catch (ParseException e) {
            logger.error((Object)("can't parse the date: " + dateTo), (Throwable)e);
        }
        this.kDChkPeriodSum.setSelected(cp.getBoolean("isPeriodSum"));
        this.kDChkSum.setSelected(cp.getBoolean("isChkSum"));
        this.kDChkNoAudit.setSelected(cp.getBoolean("noAudit"));
        this.rdBtnPeriod.setSelected(cp.getBoolean("isPeriod"));
        this.rdBtnDate.setSelected(cp.getBoolean("isBillDate"));
    }

    public CustomerParams getCustomerParams() {
        DataBaseInfo cussInfo;
        CustomerParams custParam = new CustomerParams();
        HashMap qryParam = (HashMap)this.getParam();
        if (qryParam.get("currency") != null) {
            AsstActTypeUtils currency = (AsstActTypeUtils)qryParam.get("currency");
            custParam.addCustomerParam("currencyId", currency.typeId);
            custParam.addCustomerParam("currencyName", currency.typeName);
            custParam.addCustomerParam("currencyNum", currency.typeQueryName);
        }
        if (qryParam.get("asstActType") != null) {
            AsstActTypeUtils asstActType = (AsstActTypeUtils)qryParam.get("asstActType");
            custParam.addCustomerParam("asstActTypeId", asstActType.typeId);
            custParam.addCustomerParam("asstActTypeTbl", asstActType.tableName);
            custParam.addCustomerParam("glAsstActGrpId", asstActType.glAsstActGrpId);
        }
        if (qryParam.get("typeFromVal") != null) {
            custParam.addCustomerParam("typeFromVal", (String)qryParam.get("typeFromVal"));
        }
        if (qryParam.get("typeFromSelected") != null) {
            cussInfo = (DataBaseInfo)qryParam.get("typeFromSelected");
            custParam.addCustomerParam("cussFromId", cussInfo.getId().toString());
            custParam.addCustomerParam("cussFromName", cussInfo.getName());
        }
        if (qryParam.get("typeToVal") != null) {
            custParam.addCustomerParam("typeToVal", (String)qryParam.get("typeToVal"));
        }
        if (qryParam.get("typeToSelected") != null) {
            cussInfo = (DataBaseInfo)qryParam.get("typeToSelected");
            custParam.addCustomerParam("cussToId", cussInfo.getId().toString());
            custParam.addCustomerParam("cussToName", cussInfo.getName());
        }
        if (qryParam.get("periodYearFrom") != null) {
            String periodYearFrom = (String)qryParam.get("periodYearFrom");
            custParam.addCustomerParam("periodYearFrom", periodYearFrom);
        }
        if (qryParam.get("periodYearTo") != null) {
            String periodYearTo = (String)qryParam.get("periodYearTo");
            custParam.addCustomerParam("periodYearTo", periodYearTo);
        }
        if (qryParam.get("periodNumFrom") != null) {
            String periodNumFrom = (String)qryParam.get("periodNumFrom");
            custParam.addCustomerParam("periodNumFrom", periodNumFrom);
        }
        if (qryParam.get("periodNumTo") != null) {
            String periodNumTo = (String)qryParam.get("periodNumTo");
            custParam.addCustomerParam("periodNumTo", periodNumTo);
        }
        custParam.putBoolean("isPeriodSum", this.kDChkPeriodSum.isSelected());
        custParam.putBoolean("isChkSum", this.kDChkSum.isSelected());
        custParam.putBoolean("noAudit", this.kDChkNoAudit.isSelected());
        Date dateFrom = this.kDDatePickerFrom.getSqlDate();
        Date dateTo = this.kDDatePickerTo.getSqlDate();
        custParam.addCustomerParam("dateFrom", this.dateFormat.format(dateFrom));
        custParam.addCustomerParam("dateTo", this.dateFormat.format(dateTo));
        custParam.putBoolean("isPeriod", this.rdBtnPeriod.isSelected());
        custParam.putBoolean("isBillDate", this.rdBtnDate.isSelected());
        return custParam;
    }

    public void setComponentVal() {
        Date dateTo1;
        Date dateFrom1 = (Date)this.conditions.get("dateFrom");
        if (dateFrom1 != null) {
            this.kDDatePickerFrom.setValue((Object)dateFrom1);
        }
        if ((dateTo1 = (Date)this.conditions.get("dateTo")) != null) {
            this.kDDatePickerTo.setValue((Object)dateTo1);
        }
        if (this.conditions.get("periodYearFrom") != null && !this.conditions.get("periodYearFrom").equals("")) {
            this.kDSpnPeriodYearFrom.setValue((Object)new Integer((String)this.conditions.get("periodYearFrom")));
        }
        if (this.conditions.get("periodYearTo") != null && !this.conditions.get("periodYearTo").equals("")) {
            this.kDSpnPeriodYearTo.setValue((Object)new Integer((String)this.conditions.get("periodYearTo")));
        }
        if (this.conditions.get("periodNumFrom") != null && !this.conditions.get("periodNumFrom").equals("")) {
            this.kDSpinnerNumFrom.setValue((Object)new Integer((String)this.conditions.get("periodNumFrom")));
        }
        if (this.conditions.get("periodNumTo") != null && !this.conditions.get("periodNumTo").equals("")) {
            this.kDSpnPeriodNumberTo.setValue((Object)new Integer((String)this.conditions.get("periodNumTo")));
        }
        if (this.conditions.get("isPeriodSum") != null) {
            this.isPeriodSum = (Boolean)this.conditions.get("isPeriodSum");
            this.kDChkPeriodSum.setSelected(this.isPeriodSum);
        }
        if (this.conditions.get("isChkSum") != null) {
            this.isChkSum = (Boolean)this.conditions.get("isChkSum");
            this.kDChkSum.setSelected(this.isChkSum);
        }
        if (this.conditions.get("noAudit") != null) {
            this.noAudit = (Boolean)this.conditions.get("noAudit");
            this.kDChkNoAudit.setSelected(this.noAudit);
        }
        int type = 0;
        if (this.conditions.get("typeSelected") != null) {
            type = (Integer)this.conditions.get("typeSelected");
            this.comboCussentType.setSelectedIndex(type);
        }
        this.typeFrom = (DataBaseInfo)this.conditions.get("typeFromSelected");
        this.prmptCussentFrom.setData((Object)this.typeFrom);
        this.typeTo = (DataBaseInfo)this.conditions.get("typeToSelected");
        this.prmptCussentTo.setData((Object)this.typeTo);
        if (this.conditions.get("currencySelected") != null) {
            int currencyIndex = (Integer)this.conditions.get("currencySelected");
            this.comboCurrency.setSelectedIndex(currencyIndex);
        }
        if (this.conditions.get("isPeriod") != null) {
            this.isPeriod = this.conditions.get("isPeriod").toString().equals("true");
            this.rdBtnPeriod.setSelected(this.isPeriod);
            if (this.isPeriod) {
                this.kDLabelContainerDateFrom.setEnabled(false);
                this.kDLabelContainerDateTo.setEnabled(false);
                this.kDDatePickerFrom.setEnabled(false);
                this.kDDatePickerTo.setEnabled(false);
                this.kDLabelContainerPeriodYearFrom.setEnabled(true);
                this.kDLabelContainerPeriodYearTo.setEnabled(true);
                this.kDLabelContainerPeriodNumFrom.setEnabled(true);
                this.kDLabelContainerPeriodNumTo.setEnabled(true);
                this.kDSpnPeriodYearFrom.setEnabled(true);
                this.kDSpnPeriodYearTo.setEnabled(true);
                this.kDSpinnerNumFrom.setEnabled(true);
                this.kDSpnPeriodNumberTo.setEnabled(true);
            }
        }
        if (this.conditions.get("isBillDate") != null) {
            this.isBillDate = this.conditions.get("isBillDate").toString().equals("true");
            this.rdBtnDate.setSelected(this.isBillDate);
        }
    }

    public void setParam(Object obj) {
        this.conditions = (HashMap)obj;
        this.setComponentVal();
    }

    public void loadData(EntityViewInfo viewInfo) {
        this.setComponentVal();
    }

    public void clear() {
        this.comboCussentType.setSelectedIndex(this.defaultCussTypeInd);
        this.comboCurrency.setSelectedIndex(this.defaultCurrencyInd);
        this.prmptCussentFrom.setData(null);
        this.prmptCussentTo.setData(null);
        this.kDChkPeriodSum.setSelected(false);
        this.kDChkSum.setSelected(false);
        this.kDChkNoAudit.setSelected(false);
        this.rdBtnPeriod.setSelected(true);
        this.rdBtnDate.setSelected(false);
        Integer currYear = new Integer(this.currentPeriod.getPeriodYear());
        Integer currNum = new Integer(this.currentPeriod.getPeriodNumber());
        this.kDSpnPeriodYearFrom.setValue((Object)currYear);
        this.kDSpnPeriodYearTo.setValue((Object)currYear);
        this.kDSpinnerNumFrom.setValue((Object)currNum);
        this.kDSpnPeriodNumberTo.setValue((Object)currNum);
        this.kDDatePickerFrom.setValue((Object)this.currentPeriod.getBeginDate());
        this.kDDatePickerTo.setValue((Object)this.currentPeriod.getEndDate());
    }

    @Override
    protected void rdBtnDate_stateChanged(ChangeEvent e) throws Exception {
        this.setAccordingPeriod(!this.rdBtnDate.isSelected());
    }

    @Override
    protected void rdBtnPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.setAccordingPeriod(this.rdBtnPeriod.isSelected());
    }

    private void setAccordingPeriod(boolean fPeriod) {
        this.panelPeriod.setVisible(fPeriod);
        this.panelDate.setVisible(!fPeriod);
    }

    public boolean verify() {
        if (this.bizPromptCompany.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyFail"));
            return false;
        }
        if (this.comboCussentType.getSelectedIndex() == -1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"asstActTypeFail"));
            return false;
        }
        if (this.kDDatePickerFrom.getValue() == null && this.kDDatePickerTo.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"dateFail"));
            return false;
        }
        if (this.comboCurrency.getSelectedIndex() == -1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"currencyFail"));
            return false;
        }
        return super.verify();
    }

    @Override
    protected void kDSpnPeriodYearFrom_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.setPeriodNum(this.currentCompany, this.kDSpinnerNumFrom, this.kDSpnPeriodYearFrom);
        this.periodHelper.periodChange(this.kDSpnPeriodYearFrom, this.kDSpinnerNumFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodNumberTo, false);
    }

    @Override
    protected void kDSpnPeriodYearTo_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.kDSpnPeriodYearFrom, this.kDSpinnerNumFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodNumberTo, false);
        this.periodHelper.setPeriodNum(this.currentCompany, this.kDSpnPeriodNumberTo, this.kDSpnPeriodYearTo);
    }

    @Override
    protected void kDSpinnerNumFrom_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.kDSpnPeriodYearFrom, this.kDSpinnerNumFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodNumberTo, true);
    }

    @Override
    protected void kDSpnPeriodNumberTo_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.kDSpnPeriodYearFrom, this.kDSpinnerNumFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodNumberTo, true);
    }
}

