/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSelect;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgUnitTreePromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.client.AbstractPaymentBillSumReportQueryUI;
import com.kingdee.eas.fi.ap.client.util.ApPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.ArPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.BizSysPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.ar.util.AsstActTypeUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PaymentBillSumReportQueryUI
extends AbstractPaymentBillSumReportQueryUI {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.client.PaymentBillSumReportQueryUI");
    public String resClassName = "com.kingdee.eas.fi.ar.ArReport";
    private HashMap conditions = new HashMap();
    private String companyId = "";
    private PeriodInfo currentPeriod = null;
    private boolean fAR = false;
    private BizSysPeriodHelper periodHelper = null;
    private CompanyOrgUnitInfo currentCompany = null;
    private int defaultCussTypeInd = 0;
    private int defaultCurrencyInd = 0;
    private SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");

    public PaymentBillSumReportQueryUI() throws Exception {
    }

    public PaymentBillSumReportQueryUI(boolean systemflg, ActionEvent evt) throws Exception {
        this.fAR = systemflg;
    }

    public void onLoad() throws Exception {
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
            this.companyId = this.currentCompany.getId().toString();
        }
        catch (Exception ex) {
            this.handUIException(ex);
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"companyFail"));
            SysUtil.abort();
        }
        this.initialize();
        this.initPrompt();
    }

    private void initPrompt() throws Exception {
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
        }
        catch (Exception ex) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"companyFail"));
            SysUtil.abort();
        }
        this.setCompanyF7();
        this.setCurrency();
        this.setAsstActType();
        this.setPeriod();
        int c = this.comboCussentType.getItemCount();
        String d = "";
        for (int k = 0; k < c; ++k) {
            d = ((AsstActTypeInfo)((ComBoxInfo)this.comboCussentType.getItemAt(k)).getobjInfo()).getRealtionDataObject();
            if (this.fAR) {
                if (!d.equalsIgnoreCase("t_bd_customer")) continue;
                if (this.comboCussentType.getSelectedIndex() == k) break;
                this.comboCussentType.setSelectedIndex(k);
                break;
            }
            if (!d.equalsIgnoreCase("t_bd_supplier")) continue;
            if (this.comboCussentType.getSelectedIndex() == k) break;
            this.comboCussentType.setSelectedIndex(k);
            break;
        }
        this.defaultCussTypeInd = this.comboCussentType.getSelectedIndex();
    }

    private void setPeriod() throws EASBizException, BOSException {
        PeriodInfo startPeriod = null;
        if (this.fAR) {
            this.periodHelper = ArPeriodHelper.getInstance(true);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
            this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
        } else {
            this.periodHelper = ApPeriodHelper.getInstance(true);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)this.currentCompany);
            this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)this.currentCompany);
        }
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.kDSpnPeriodYearFrom, this.kDSpnPeriodFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodTo);
        this.kDDateFrom.setValue((Object)this.currentPeriod.getBeginDate());
        this.kDDateTo.setValue((Object)this.currentPeriod.getEndDate());
        this.kDDateFrom.setMinimumDate(startPeriod.getBeginDate());
        this.kDDateFrom.setMaximumDate((java.util.Date)this.currentPeriod.getEndDate());
        this.kDDateTo.setMinimumDate(startPeriod.getBeginDate());
        this.kDDateTo.setMaximumDate((java.util.Date)this.currentPeriod.getEndDate());
    }

    private void initialize() {
        this.kDChkPeriodSum.setEnabled(true);
        this.kDChkSum.setEnabled(true);
        this.kDPanel1.setVisible(true);
        this.panelPeriod.setVisible(true);
        this.panelDate.setVisible(false);
        this.prmptCussentFrom.setEditable(true);
        this.prmptCussentFrom.setCommitFormat("$number$");
        this.prmptCussentTo.setEditable(true);
        this.prmptCussentTo.setCommitFormat("$number$");
        this.kDSpnPeriodTo.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 12, 1));
        this.kDSpnPeriodFrom.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 12, 1));
        this.kDSpnPeriodYearFrom.setModel((SpinnerModel)new SpinnerNumberModel(1901, 1901, 2100, 1));
        this.kDSpnPeriodYearTo.setModel((SpinnerModel)new SpinnerNumberModel(1901, 1901, 2100, 1));
        this.rdBtnPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PaymentBillSumReportQueryUI.this.setAccordingPeriod(PaymentBillSumReportQueryUI.this.rdBtnPeriod.isSelected());
            }
        });
        this.rdBtnDate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PaymentBillSumReportQueryUI.this.setAccordingPeriod(!PaymentBillSumReportQueryUI.this.rdBtnDate.isSelected());
            }
        });
        this.kDRadioBtnAccountDate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PaymentBillSumReportQueryUI.this.setAccordingPeriod(!PaymentBillSumReportQueryUI.this.kDRadioBtnAccountDate.isSelected());
            }
        });
    }

    private void setAccordingPeriod(boolean fPeriod) {
        this.panelPeriod.setVisible(fPeriod);
        this.panelDate.setVisible(!fPeriod);
    }

    public void setAsstActType() {
        try {
            String cpId = this.currentCompany.getId().toString();
            BaseDataUtil.makeAsstActType(this.comboCussentType, cpId);
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"asstActTypeFail"));
            SysUtil.abort();
        }
    }

    @Override
    protected void kDSpnPeriodYearFrom_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.kDSpnPeriodYearFrom, this.kDSpnPeriodFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodTo, false);
        this.periodHelper.setPeriodNum(this.currentCompany, this.kDSpnPeriodFrom, this.kDSpnPeriodYearFrom);
    }

    @Override
    protected void kDSpnPeriodYearTo_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.kDSpnPeriodYearFrom, this.kDSpnPeriodFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodTo, false);
        this.periodHelper.setPeriodNum(this.currentCompany, this.kDSpnPeriodTo, this.kDSpnPeriodYearTo);
    }

    @Override
    protected void kDSpnPeriodFrom_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.kDSpnPeriodYearFrom, this.kDSpnPeriodFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodTo, true);
    }

    @Override
    protected void kDSpnPeriodTo_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.kDSpnPeriodYearFrom, this.kDSpnPeriodFrom, this.kDSpnPeriodYearTo, this.kDSpnPeriodTo, true);
    }

    @Override
    protected void comboCussentType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.comboCussentType.getItemCount() == 0 || this.comboCussentType.getSelectedItem() == null) {
            return;
        }
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.comboCussentType.getSelectedItem()).getobjInfo();
        if (asstActTypeInfo == null) {
            this.prmtCsspGrp.setEnabled(false);
            this.prmptCussentFrom.setEnabled(false);
            this.prmptCussentTo.setEnabled(false);
            return;
        }
        if (asstActTypeInfo.getDefaultQueryName() != null) {
            this.prmptCussentFrom.setEnabled(true);
            this.prmptCussentTo.setEnabled(true);
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmptCussentFrom, asstActTypeInfo, this.companyId, true);
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmptCussentTo, asstActTypeInfo, this.companyId, true);
            ArApQueryUIUtil.setCsspGrpF7((IUIObject)this, this.prmtCsspGrp, asstActTypeInfo);
        }
        this.prmtCsspGrp.setValue(null);
        this.prmptCussentFrom.setValue(null);
        this.prmptCussentTo.setValue(null);
    }

    @Override
    protected void prmtCsspGrp_dataChanged(DataChangeEvent e) throws Exception {
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.comboCussentType.getSelectedItem()).getobjInfo();
        ArApQueryUIUtil.csspGrpValueChangeProcess((CoreUIObject)this, this.companyId, asstActTypeInfo, this.prmtCsspGrp, this.prmptCussentFrom, this.prmptCussentTo);
    }

    private void setCurrency() {
        ICurrency iCurrency = null;
        CurrencyCollection con = null;
        try {
            iCurrency = CurrencyFactory.getRemoteInstance();
            con = iCurrency.getCurrencyCollection(true);
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"currencyFail"));
            SysUtil.abort();
        }
        if (con != null) {
            Object[] typeValue = new Object[con.size()];
            int companyCurrInd = 0;
            AsstActTypeUtils currency = null;
            for (int i = 0; i < con.size(); ++i) {
                String typeQueryName;
                String typeId;
                CurrencyInfo currencyInfo = con.get(i);
                String typeName = currencyInfo.getName();
                currency = new AsstActTypeUtils(typeName, typeId = currencyInfo.getId().toString(), typeQueryName = "");
                if (currency == null) continue;
                typeValue[i] = currency;
                if (!typeId.equals(this.currentCompany.getBaseCurrency().getId().toString())) continue;
                companyCurrInd = i;
            }
            this.comboCurrency.removeAllItems();
            this.comboCurrency.addItems(typeValue);
            this.comboCurrency.setSelectedIndex(companyCurrInd);
            this.defaultCurrencyInd = companyCurrInd;
            String allType = EASResource.getString((String)this.resClassName, (String)"allType");
            this.comboCurrency.addItem((Object)new AsstActTypeUtils(allType, null, null));
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"currencyFail"));
            SysUtil.abort();
        }
    }

    private void setCompanyF7() {
        OrgType[] CompanyType = new OrgType[]{OrgType.Company};
        this.bizPromptCompany.setEditFormat("$number$");
        this.bizPromptCompany.setDisplayFormat("$name$");
        this.bizPromptCompany.setEditable(true);
        this.bizPromptCompany.setCommitFormat("$number$");
        OrgUnitTreePromptBox boxCompany = new OrgUnitTreePromptBox((IUIObject)this, CompanyType, null, OrgSelect.OnlySelectCompanyEntity, false, false, false);
        this.bizPromptCompany.setSelector((KDPromptSelector)boxCompany);
        this.bizPromptCompany.setData((Object)this.currentCompany);
        this.bizPromptCompany.setEnabled(false);
    }

    public Object getParam() {
        this.conditions.clear();
        if (this.bizPromptCompany.getData() != null) {
            this.companyId = ((OrgUnitInfo)this.bizPromptCompany.getData()).getId().toString();
        }
        AsstActTypeUtils currency = null;
        if (this.comboCurrency.getSelectedItem() != null) {
            currency = (AsstActTypeUtils)this.comboCurrency.getSelectedItem();
        }
        AsstActTypeInfo asstActTypeInfo = null;
        if (this.comboCussentType.getSelectedItem() != null) {
            asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.comboCussentType.getSelectedItem()).getobjInfo();
        }
        CSSPGroupInfo csspGrpInfo = null;
        if (this.prmtCsspGrp.getData() != null) {
            csspGrpInfo = (CSSPGroupInfo)this.prmtCsspGrp.getData();
        }
        String typeFromVal = "";
        if (this.prmptCussentFrom.getData() != null) {
            Object objectValue = this.prmptCussentFrom.getValue();
            typeFromVal = ((DataBaseInfo)objectValue).getNumber().toString();
        }
        String typeToVal = "";
        if (this.prmptCussentTo.getData() != null) {
            Object objectValue = this.prmptCussentTo.getValue();
            typeToVal = ((DataBaseInfo)objectValue).getNumber().toString();
        }
        String periodYearFrom = null;
        String periodYearTo = null;
        String periodNumFrom = null;
        String periodNumTo = null;
        Date dateFrom = null;
        Date dateTo = null;
        if (this.rdBtnPeriod.isSelected()) {
            periodYearFrom = this.kDSpnPeriodYearFrom.getValue().toString();
            periodYearTo = this.kDSpnPeriodYearTo.getValue().toString();
            periodNumFrom = this.kDSpnPeriodFrom.getValue().toString();
            periodNumTo = this.kDSpnPeriodTo.getValue().toString();
        } else if (this.rdBtnDate.isSelected() || this.kDRadioBtnAccountDate.isSelected()) {
            dateFrom = this.kDDateFrom.getSqlDate();
            dateTo = this.kDDateTo.getSqlDate();
            if (dateFrom != null && dateTo != null && dateFrom.after(dateTo)) {
                Date dateTemp = dateFrom;
                dateFrom = dateTo;
                dateTo = dateTemp;
            }
        }
        this.conditions.put("currentCompany", this.currentCompany);
        this.conditions.put("companyId", this.companyId);
        this.conditions.put("cuId", this.currentCompany.getCU().getString("id"));
        this.conditions.put("currency", currency);
        this.conditions.put("asstActType", asstActTypeInfo);
        this.conditions.put("csspGrp", csspGrpInfo);
        this.conditions.put("typeFromVal", typeFromVal);
        this.conditions.put("typeToVal", typeToVal);
        this.conditions.put("currentPeriodInfo", this.currentPeriod);
        this.conditions.put("periodYearFrom", periodYearFrom);
        this.conditions.put("periodYearTo", periodYearTo);
        this.conditions.put("periodNumFrom", periodNumFrom);
        this.conditions.put("periodNumTo", periodNumTo);
        this.conditions.put("isPeriodSum", this.kDChkPeriodSum.isSelected());
        this.conditions.put("isChkSum", this.kDChkSum.isSelected());
        this.conditions.put("noAudit", this.kDChkNoAudit.isSelected());
        this.conditions.put("isPeriod", this.rdBtnPeriod.isSelected());
        this.conditions.put("isBillDate", this.rdBtnDate.isSelected());
        this.conditions.put("isAccountDate", this.kDRadioBtnAccountDate.isSelected());
        this.conditions.put("dateFrom", dateFrom);
        this.conditions.put("dateTo", dateTo);
        this.conditions.put("typeFromSelected", this.prmptCussentFrom.getData());
        this.conditions.put("typeToSelected", this.prmptCussentTo.getData());
        this.conditions.put("currencySelected", new Integer(this.comboCurrency.getSelectedIndex()));
        this.conditions.put("typeSelected", new Integer(this.comboCussentType.getSelectedIndex()));
        return this.conditions;
    }

    public void setCustomerParams(CustomerParams cp) {
        String periodNumTo;
        String periodNumFrom;
        String periodYearTo;
        String periodYearFrom;
        String csspGrpId;
        String asstActTypeId;
        if (cp == null) {
            return;
        }
        String currencyId = cp.getCustomerParam("currencyId");
        if (!StringUtils.isEmpty((String)currencyId)) {
            int n = this.comboCurrency.getItemCount();
            for (int i = 0; i < n; ++i) {
                AsstActTypeUtils item = (AsstActTypeUtils)this.comboCurrency.getItemAt(i);
                if (!currencyId.equals(item.typeId)) continue;
                this.comboCurrency.setSelectedIndex(i);
                break;
            }
        }
        if (!StringUtils.isEmpty((String)(asstActTypeId = cp.getCustomerParam("asstActTypeId")))) {
            int n = this.comboCussentType.getItemCount();
            for (int i = 0; i < n; ++i) {
                ComBoxInfo item = (ComBoxInfo)this.comboCussentType.getItemAt(i);
                if (item == null || item.getobjInfo() == null || !asstActTypeId.equals(item.getobjInfo().getString("id"))) continue;
                this.comboCussentType.setSelectedIndex(i);
                break;
            }
        }
        if (!StringUtils.isEmpty((String)(csspGrpId = cp.getCustomerParam("csspGrpId")))) {
            CSSPGroupInfo info = new CSSPGroupInfo();
            info.put("id", (Object)csspGrpId);
            info.setNumber(cp.getCustomerParam("csspGrpNum"));
            info.setName(cp.getCustomerParam("csspGrpName"));
            String grpStdId = cp.getCustomerParam("csspGrpStdId");
            if (!StringUtils.isEmpty((String)grpStdId)) {
                CSSPGroupStandardInfo grpStdInfo = new CSSPGroupStandardInfo();
                grpStdInfo.put("id", (Object)grpStdId);
                info.setGroupStandard(grpStdInfo);
            }
            this.prmtCsspGrp.setData((Object)info);
        }
        String typeFromVal = cp.getCustomerParam("typeFromVal");
        String cussFromId = cp.getCustomerParam("cussFromId");
        String cussFromName = cp.getCustomerParam("cussFromName");
        if (cussFromId != null) {
            AsstActTypeInfo info = new AsstActTypeInfo();
            info.put("id", (Object)cussFromId);
            info.setNumber(typeFromVal);
            info.setName(cussFromName);
            this.prmptCussentFrom.setData((Object)info);
        }
        String typeToVal = cp.getCustomerParam("typeToVal");
        String cussToId = cp.getCustomerParam("cussToId");
        String cussToName = cp.getCustomerParam("cussToName");
        if (cussToId != null) {
            AsstActTypeInfo info = new AsstActTypeInfo();
            info.put("id", (Object)cussToId);
            info.setNumber(typeToVal);
            info.setName(cussToName);
            this.prmptCussentTo.setData((Object)info);
        }
        if ((periodYearFrom = cp.getCustomerParam("periodYearFrom")) != null) {
            this.kDSpnPeriodYearFrom.setValue((Object)new Integer(periodYearFrom));
        }
        if ((periodYearTo = cp.getCustomerParam("periodYearTo")) != null) {
            this.kDSpnPeriodYearTo.setValue((Object)new Integer(periodYearTo));
        }
        if ((periodNumFrom = cp.getCustomerParam("periodNumFrom")) != null) {
            this.kDSpnPeriodFrom.setValue((Object)new Integer(periodNumFrom));
        }
        if ((periodNumTo = cp.getCustomerParam("periodNumTo")) != null) {
            this.kDSpnPeriodTo.setValue((Object)new Integer(periodNumTo));
        }
        String dateFrom = cp.getCustomerParam("dateFrom");
        try {
            if (dateFrom != null) {
                java.util.Date utilDate = this.dtFormat.parse(dateFrom);
                this.kDDateFrom.setValue((Object)utilDate);
            }
        }
        catch (ParseException e) {
            logger.error((Object)("can't parse the date: " + dateFrom), (Throwable)e);
        }
        String dateTo = cp.getCustomerParam("dateTo");
        try {
            if (dateTo != null) {
                java.util.Date utilDate = this.dtFormat.parse(dateTo);
                this.kDDateTo.setValue((Object)utilDate);
            }
        }
        catch (ParseException e) {
            logger.error((Object)("can't parse the date: " + dateTo), (Throwable)e);
        }
        this.kDChkPeriodSum.setSelected(cp.getBoolean("isPeriodSum"));
        this.kDChkSum.setSelected(cp.getBoolean("isChkSum"));
        this.kDChkNoAudit.setSelected(cp.getBoolean("noAudit"));
        this.rdBtnPeriod.setSelected(cp.getBoolean("isPeriod"));
        this.rdBtnDate.setSelected(cp.getBoolean("isBillDate"));
    }

    public CustomerParams getCustomerParams() {
        DataBaseInfo cussInfo;
        CustomerParams custParam = new CustomerParams();
        HashMap qryParam = (HashMap)this.getParam();
        custParam.addCustomerParam("companyId", this.currentCompany.getId().toString());
        custParam.addCustomerParam("cuId", this.currentCompany.getCU().getId().toString());
        if (qryParam.get("currency") != null) {
            AsstActTypeUtils currency = (AsstActTypeUtils)qryParam.get("currency");
            custParam.addCustomerParam("currencyId", currency.typeId);
        }
        if (qryParam.get("asstActType") != null) {
            AsstActTypeInfo asstActType = (AsstActTypeInfo)qryParam.get("asstActType");
            custParam.addCustomerParam("asstActTypeId", asstActType.getId().toString());
        }
        if (qryParam.get("csspGrp") != null) {
            CSSPGroupInfo csspGrpInfo = (CSSPGroupInfo)qryParam.get("csspGrp");
            custParam.addCustomerParam("csspGrpId", csspGrpInfo.getId().toString());
            if (csspGrpInfo.getGroupStandard() != null) {
                custParam.addCustomerParam("csspGrpStdId", csspGrpInfo.getGroupStandard().getId().toString());
            }
            custParam.addCustomerParam("csspGrpNum", csspGrpInfo.getNumber());
            custParam.addCustomerParam("csspGrpName", csspGrpInfo.getName());
        }
        if (qryParam.get("typeFromVal") != null) {
            custParam.addCustomerParam("typeFromVal", (String)qryParam.get("typeFromVal"));
        }
        if (qryParam.get("typeFromSelected") != null) {
            cussInfo = (DataBaseInfo)qryParam.get("typeFromSelected");
            custParam.addCustomerParam("cussFromId", cussInfo.getId().toString());
            custParam.addCustomerParam("cussFromName", cussInfo.getName());
        }
        if (qryParam.get("typeToVal") != null) {
            custParam.addCustomerParam("typeToVal", (String)qryParam.get("typeToVal"));
        }
        if (qryParam.get("typeToSelected") != null) {
            cussInfo = (DataBaseInfo)qryParam.get("typeToSelected");
            custParam.addCustomerParam("cussToId", cussInfo.getId().toString());
            custParam.addCustomerParam("cussToName", cussInfo.getName());
        }
        if (qryParam.get("periodYearFrom") != null) {
            String periodYearFrom = (String)qryParam.get("periodYearFrom");
            custParam.addCustomerParam("periodYearFrom", periodYearFrom);
        }
        if (qryParam.get("periodYearTo") != null) {
            String periodYearTo = (String)qryParam.get("periodYearTo");
            custParam.addCustomerParam("periodYearTo", periodYearTo);
        }
        if (qryParam.get("periodNumFrom") != null) {
            String periodNumFrom = (String)qryParam.get("periodNumFrom");
            custParam.addCustomerParam("periodNumFrom", periodNumFrom);
        }
        if (qryParam.get("periodNumTo") != null) {
            String periodNumTo = (String)qryParam.get("periodNumTo");
            custParam.addCustomerParam("periodNumTo", periodNumTo);
        }
        custParam.putBoolean("isPeriodSum", this.kDChkPeriodSum.isSelected());
        custParam.putBoolean("isChkSum", this.kDChkSum.isSelected());
        custParam.putBoolean("noAudit", this.kDChkNoAudit.isSelected());
        Date dateFrom = this.kDDateFrom.getSqlDate();
        Date dateTo = this.kDDateTo.getSqlDate();
        if (dateFrom != null) {
            custParam.addCustomerParam("dateFrom", this.dtFormat.format(dateFrom));
        }
        if (dateTo != null) {
            custParam.addCustomerParam("dateTo", this.dtFormat.format(dateTo));
        }
        custParam.putBoolean("isPeriod", this.rdBtnPeriod.isSelected());
        custParam.putBoolean("isBillDate", this.rdBtnDate.isSelected());
        return custParam;
    }

    public void clear() {
        this.comboCussentType.setSelectedIndex(this.defaultCussTypeInd);
        this.comboCurrency.setSelectedIndex(this.defaultCurrencyInd);
        this.prmtCsspGrp.setValue(null);
        this.prmptCussentFrom.setData(null);
        this.prmptCussentTo.setData(null);
        this.kDChkPeriodSum.setSelected(false);
        this.kDChkPeriodSum.setSelected(false);
        this.kDChkSum.setSelected(false);
        this.kDChkNoAudit.setSelected(false);
        this.rdBtnPeriod.setSelected(true);
        this.rdBtnDate.setSelected(false);
        this.kDRadioBtnAccountDate.setSelected(false);
        Integer currYear = new Integer(this.currentPeriod.getPeriodYear());
        Integer currNum = new Integer(this.currentPeriod.getPeriodNumber());
        this.kDSpnPeriodYearFrom.setValue((Object)currYear);
        this.kDSpnPeriodYearTo.setValue((Object)currYear);
        this.kDSpnPeriodFrom.setValue((Object)currNum);
        this.kDSpnPeriodTo.setValue((Object)currNum);
        this.kDDateFrom.setValue((Object)this.currentPeriod.getBeginDate());
        this.kDDateTo.setValue((Object)this.currentPeriod.getEndDate());
    }

    public boolean verify() {
        if (this.bizPromptCompany.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"companyFail"));
            return false;
        }
        if (this.comboCussentType.getSelectedIndex() == -1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"asstActTypeFail"));
            return false;
        }
        if (this.kDSpnPeriodYearFrom.getValue() == null && this.kDSpnPeriodYearTo.getValue() == null && this.kDSpnPeriodFrom.getValue() == null && this.kDSpnPeriodTo.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"periodFail"));
            return false;
        }
        if (this.rdBtnDate.isSelected() && (this.kDDateFrom.getValue() == null || this.kDDateTo.getValue() == null)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"bill_date_not_null"));
            return false;
        }
        if (this.comboCurrency.getSelectedIndex() == -1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"currencyFail"));
            return false;
        }
        return super.verify();
    }
}

