/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.SwapRateBillFactory;
import com.kingdee.eas.fi.ap.VerificationBillInfo;
import com.kingdee.eas.fi.ap.client.AbstractSwapRateBillListUI;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.ArApVerificationCommonQueryProcessor;
import com.kingdee.eas.fi.ar.client.SwapRateBillQueryUI;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBatchUtil;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.cas.client.PaymentBillUI;
import com.kingdee.eas.fi.cas.client.ReceivingBillUI;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SwapRateBillListUI
extends AbstractSwapRateBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(SwapRateBillListUI.class);
    private String sysType = "";
    private CompanyOrgUnitInfo currentCompany = null;
    private UserInfo defaultUserInfo = null;
    private Vector selectedBill = new Vector();
    private Vector selectedBillDate = new Vector();
    private SwapRateBillQueryUI queryUI;
    private CommonQueryDialog dialog;

    protected ICoreBase getBizInterface() throws Exception {
        return SwapRateBillFactory.getRemoteInstance();
    }

    public String[] getMergeColumnKeys() {
        String[] mergeCols = new String[]{"id", "selected", "billID", "company.id", "company.name", "number", "period.id", "period.number", "asstActType.id", "asstActType.name", "asstActID", "asstActNumber", "asstActName", "adminOrgUnit.id", "adminOrgUnit.name", "person.id", "person.name", "voucherType.id", "voucherType.name", "voucherNumber", "billNumber", "billDate", "billType", "currency.id", "currency.name", "direction", "swapRateBefore", "swapRateAfter", "createTime"};
        return mergeCols;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            if (this.queryUI == null) {
                this.queryUI = new SwapRateBillQueryUI(this.sysType);
            }
            this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(true);
            this.dialog.setQueryObjectPK(this.mainQueryPK);
            this.dialog.addUserPanel((KDPanel)this.queryUI);
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setHeight(360);
            this.dialog.setWidth(590);
            this.dialog.setTitle(this.getStrResource("ap_label_swapQuery"));
            ArApVerificationCommonQueryProcessor processor = new ArApVerificationCommonQueryProcessor();
            processor.set("isArSys", Boolean.TRUE);
            processor.set("ARAP_COMPANY_KEY", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            this.dialog.setProcessor((IProcessor)processor);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.dialog;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("isFromWriteOff") == null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void onLoad() throws Exception {
        ArApReportUIUtil.checkCompany((Component)((Object)this), SysContext.getSysContext().getCurrentFIUnit());
        if (this.defaultUserInfo == null) {
            this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        this.sysType = (String)this.getUIContext().get("UIClassParam") != null ? (String)this.getUIContext().get("UIClassParam") : "ap";
        super.onLoad();
        this.btnViewVoucher.setVisible(true);
        this.btnViewVoucher.setEnabled(true);
        this.btnViewBill.setVisible(true);
        this.btnViewBill.setEnabled(true);
        this.actionSelectAll.setVisible(true);
        this.actionSelectAll.setEnabled(true);
        this.actionSelectNone.setVisible(true);
        this.actionSelectNone.setEnabled(true);
        this.btnAuditResult.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionLocate.setVisible(false);
        this.actionLocate.setEnabled(false);
        this.actionAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNone.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.btnViewVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.tblMain.getColumn("selected").getStyleAttributes().setLocked(false);
        KDTableUtils.setBigDecimalColumnPrecision(this.tblMain, new String[]{"entrys.amount", "entrys.amtLocalBefore", "entrys.amtLocalAfter", "entrys.rateGainLoss"}, 2);
        KDTableUtils.setBigDecimalColumnPrecision(this.tblMain, new String[]{"swapRateBefore", "swapRateAfter"}, 9);
        this.tblMain.getColumn("swapRateBefore").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("swapRateAfter").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entrys.amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entrys.amtLocalBefore").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entrys.amtLocalAfter").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entrys.rateGainLoss").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder;
        if ((String)this.getUIContext().get("UIClassParam") != null) {
            this.sysType = (String)this.getUIContext().get("UIClassParam");
        }
        if ((clientHanlder = super.prepareInit()) != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
            request.setBosType(new VerificationBillInfo().getBOSType());
            request.put("company", null);
            request.put("uiparam", (Object)this.getUIParam());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public String getUITitle() {
        String subSys = "";
        if (this.sysType.equalsIgnoreCase("ar")) {
            subSys = this.getStrResource("lable_arsystem") + " - ";
        } else if (this.sysType.equalsIgnoreCase("ap")) {
            subSys = this.getStrResource("label_apsystem") + " - ";
        }
        return subSys + super.getUITitle();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.setSelectedCell(e);
            return;
        }
        super.tblMain_tableClicked(e);
        if (e.getColIndex() == this.tblMain.getColumnIndex("selected")) {
            this.setSelectedCell(e);
        }
    }

    private void setSelectedCell(KDTMouseEvent e) throws Exception {
        String tmpID;
        int i;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        if (row == null) {
            return;
        }
        if (row.getCell("selected").getStyleAttributes().getBackground().equals(ArApConstants.LOCK_COLOR)) {
            return;
        }
        String billID = row.getCell("id").getValue().toString();
        Date billDate = (Date)row.getCell("billDate").getValue();
        Boolean isSelected = (Boolean)row.getCell("selected").getValue();
        if (isSelected.equals(Boolean.TRUE)) {
            isSelected = Boolean.FALSE;
            this.selectedBill.remove(billID);
            this.selectedBillDate.remove(billDate);
        } else {
            isSelected = Boolean.TRUE;
            this.selectedBill.add(billID);
            this.selectedBillDate.add(billDate);
        }
        boolean isMatched = false;
        for (i = selectBlock.getTop(); i >= 0; --i) {
            row = this.tblMain.getRow(i);
            tmpID = row.getCell("id").getValue().toString();
            if (tmpID.equals(billID)) {
                isMatched = true;
                row.getCell("selected").setValue((Object)isSelected);
                continue;
            }
            if (!tmpID.equals(billID) && isMatched) break;
        }
        for (i = selectBlock.getTop() + 1; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            tmpID = row.getCell("id").getValue().toString();
            if (tmpID.equals(billID)) {
                isMatched = true;
                row.getCell("selected").setValue((Object)isSelected);
                continue;
            }
            if (!tmpID.equals(billID) && isMatched) break;
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.checkRows(true);
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        this.checkRows(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        boolean flag = this.selectMethod();
        if (flag) {
            this.checkRows(false);
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("errorSelectMethod"));
            SysUtil.abort();
        }
        HashSet billIdSet = new HashSet(this.getSelectedIdValues());
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList<String> requestIdList = new ArrayList<String>();
        try {
            String billId = null;
            boolean isLocked = false;
            Map result = iMutex.batchRequestBizObjIDForUpdate(new ArrayList(billIdSet));
            Iterator it = billIdSet.iterator();
            while (it.hasNext()) {
                billId = it.next().toString();
                if (result.get(billId) != null && ((Boolean)result.get(billId)).booleanValue()) {
                    requestIdList.add(billId);
                    continue;
                }
                isLocked = true;
            }
            if (isLocked) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new String[]{ArApBillUIUtil.getStrResource("DataMutex")});
            }
            super.actionVoucher_actionPerformed(e);
            it = billIdSet.iterator();
            while (it.hasNext()) {
                String billID = it.next().toString();
                SwapRateBillFactory.getRemoteInstance().updateVoucherInfo(billID);
            }
            this.refresh(e);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        finally {
            if (requestIdList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(requestIdList);
            }
        }
    }

    @Override
    public void actionEditVouchers_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell("id").getValue().toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("VoucherCannotEdit"));
            SysUtil.abort();
        }
        IIDList voucherIDList = this.arrayList2IIDList(voucherColl);
        String voucherId = voucherColl.get(0).toString();
        if (CreateJobFacadeFactory.getRemoteInstance().checkDuplicateTask("SCM_FI_AR_001" + this.queryUI.getCompanyOrgUnitInfo().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)voucherId);
        uiContext.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        uiContext.put((Object)"IDList", (Object)voucherIDList);
        String uiClass = "com.kingdee.eas.fi.gl.client.VoucherEditUI";
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (CreateJobFacadeFactory.getRemoteInstance().checkDuplicateTask("SCM_FI_AR_001" + this.queryUI.getCompanyOrgUnitInfo().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        ArrayList list = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(list);
        try {
            super.actionDelVoucher_actionPerformed(e);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                String billID = list.get(i).toString();
                SwapRateBillFactory.getRemoteInstance().deleteVoucherInfo(billID);
            }
            this.refresh(e);
        }
        finally {
            ArApBatchUtil.releasePureMutex(list);
        }
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = UIRuleUtil.getString((Object)row.getCell("billID").getValue());
        String bosType = UIRuleUtil.getString((Object)BOSUuid.getBOSObjectType((String)billId, (boolean)false));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)billId);
        String uiClass = "";
        if ("FA44FD5B".equals(bosType)) {
            uiClass = ReceivingBillUI.class.getName();
        } else if ("40284E81".equals(bosType)) {
            uiClass = PaymentBillUI.class.getName();
        } else if ("48DA3A71".equals(bosType)) {
            uiClass = "com.kingdee.eas.fi.ap.client.OtherBillEditUI";
        } else if ("FC910EF3".equals(bosType)) {
            uiClass = "com.kingdee.eas.fi.ar.client.OtherBillEditUI";
        }
        IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClass, (Map)uiContext, null, OprtState.VIEW);
        popUI.show();
    }

    @Override
    public void actionViewVoucher_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell("id").getValue().toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("lab_novoucher_beview"));
            return;
        }
        String voucherId = voucherColl.get(0).toString();
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)voucherId);
        ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        IUIWindow uiVerificationWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.VIEW);
        uiVerificationWindow.show();
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysEnum", this.getSysEnum());
        map.put("isSCM", Boolean.FALSE);
        map.put("permissionItem", this.getPermissionItem());
        return map;
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected String getPermissionItem() {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
    }

    private IIDList arrayList2IIDList(ArrayList al) {
        RealModeIDList List2 = RealModeIDList.getEmptyIDList();
        if (al != null && al.size() != 0) {
            for (int i = 0; i < al.size(); ++i) {
                List2.add(i, (String)al.get(i));
            }
        }
        return List2;
    }

    private void checkRows(boolean flag) {
        Boolean check = flag;
        int iCount = this.tblMain.getRowCount();
        for (int i = 0; i < iCount; ++i) {
            if (this.tblMain.getRow(i).getCell("selected").getStyleAttributes().getBackground().equals(ArApConstants.LOCK_COLOR)) continue;
            this.tblMain.getRow(i).getCell("selected").setValue((Object)check);
            String billID = this.tblMain.getRow(i).getCell("id").getValue().toString();
            Date billDate = (Date)this.tblMain.getRow(i).getCell("billDate").getValue();
            if (!flag || this.selectedBill.contains(billID)) continue;
            this.selectedBill.add(billID);
            this.selectedBillDate.add(billDate);
        }
        if (!flag) {
            this.selectedBill.removeAllElements();
            this.selectedBillDate.removeAllElements();
        }
    }

    private boolean selectMethod() {
        int iCount = this.tblMain.getRowCount();
        boolean flag = false;
        for (int i = 0; i < iCount; ++i) {
            Boolean isSelected = UIRuleUtil.getBoolean((Object)this.tblMain.getRow(i).getCell("selected").getValue());
            if (!isSelected.equals(Boolean.TRUE)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)resKey);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }
}

