/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.IPayRequestBillEntry;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PayReqUtils {
    private static final String res = "com.kingdee.eas.fi.ap.ApResource";

    public static Map<String, String> batchExecute(Context ctx, Set idSet, String methodName, Object[] params) throws EASBizException, BOSException {
        String summaryMsg;
        PayRequestBillEntryInfo entryInfo;
        PayRequestBillEntryCollection entryColl = PayReqUtils.getPayrequestBillEnrtyCollection(ctx, idSet);
        int totalCount = entryColl.size();
        HashMap<String, String> result = new HashMap<String, String>();
        LinkedHashMap<String, ErrorInfo> errorMsgMap = new LinkedHashMap<String, ErrorInfo>();
        int errorCount = 0;
        IPayRequestBillEntry iPayRequestBillEntry = null;
        IPayRequestBill iPayRequestBill = null;
        if (ctx == null) {
            iPayRequestBillEntry = PayRequestBillEntryFactory.getRemoteInstance();
            iPayRequestBill = PayRequestBillFactory.getRemoteInstance();
        } else {
            iPayRequestBillEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
            iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
        }
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            try {
                if ("close".equalsIgnoreCase(methodName)) {
                    iPayRequestBill.close((IObjectPK)new ObjectUuidPK(entryInfo.getId()), (IObjectPK)new ObjectUuidPK(entryInfo.getParent().getId()), (String)params[0]);
                    continue;
                }
                if (!"unClose".equalsIgnoreCase(methodName)) continue;
                iPayRequestBill.unClose((IObjectPK)new ObjectUuidPK(entryInfo.getId()), (IObjectPK)new ObjectUuidPK(entryInfo.getParent().getId()));
                continue;
            }
            catch (EASBizException e) {
                ErrorInfo errorInfo = new ErrorInfo();
                errorInfo.setErrMsg(e.getMessage());
                errorInfo.setEntryInfo(entryInfo);
                errorMsgMap.put(entryInfo.getId().toString(), errorInfo);
                ++errorCount;
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        HashSet<String> billIdSet = new HashSet<String>();
        for (Map.Entry entry : errorMsgMap.entrySet()) {
            billIdSet.add(((ErrorInfo)entry.getValue()).getEntryInfo().getParent().getId().toString());
        }
        PayRequestBillCollection billColl = iPayRequestBill.getPayRequestBillCollection("select id,number where id in (" + ArApBillHelper.ids2SqlString(billIdSet) + ")");
        HashMap<String, String> numberMap = new HashMap<String, String>();
        for (int i = 0; i < billColl.size(); ++i) {
            numberMap.put(billColl.get(i).getId().toString(), billColl.get(i).getNumber());
        }
        StringBuilder errMsg = new StringBuilder(200);
        for (Map.Entry entry : errorMsgMap.entrySet()) {
            entryInfo = ((ErrorInfo)entry.getValue()).getEntryInfo();
            errMsg.append(PayReqUtils.getStrRes(ctx, "NUMBER_SEQ_FIELDRESON", new Object[]{numberMap.get(entryInfo.getParent().getId().toString()), entryInfo.getSeq(), ((ErrorInfo)entry.getValue()).getErrMsg()}));
            errMsg.append(ctx == null || LoginType.GUI.equals(ctx.get((Object)"LOGIN_TYPE")) ? "\n" : "<br>");
        }
        if (errorCount == 0) {
            summaryMsg = PayReqUtils.getStrRes(ctx, "ALLSUCCESS");
        } else {
            String method = "";
            if ("close".equalsIgnoreCase(methodName)) {
                method = PayReqUtils.getStrRes(ctx, "CLOSE");
            } else if ("unClose".equalsIgnoreCase(methodName)) {
                method = PayReqUtils.getStrRes(ctx, "UNCLOSE");
            }
            summaryMsg = PayReqUtils.getStrRes(ctx, "SELECT_SUCCESSCOUNT_ERRORCOUNT", new Object[]{totalCount, errorCount, method});
        }
        result.put("summaryMsg", summaryMsg);
        result.put("detailMsg", errMsg.toString());
        return result;
    }

    private static PayRequestBillEntryCollection getPayrequestBillEnrtyCollection(Context ctx, Set idSet) throws BOSException {
        IPayRequestBillEntry iPayRequestBillEntry = null;
        iPayRequestBillEntry = ctx == null ? PayRequestBillEntryFactory.getRemoteInstance() : PayRequestBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo si = new SorterItemInfo("parent.number");
        si.setSortType(SortType.DESCEND);
        sic.add(si);
        sic.add(new SorterItemInfo("parent.id"));
        sic.add(new SorterItemInfo("seq"));
        ev.setSorter(sic);
        return iPayRequestBillEntry.getPayRequestBillEntryCollection(ev);
    }

    public static String getStrRes(Context ctx, String key, Object[] params) {
        if (ctx == null) {
            return EASResource.getString((String)res, (String)key, (Object[])params);
        }
        return ResourceBase.getString((String)res, (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }

    public static String getStrRes(Context ctx, String key) {
        if (ctx == null) {
            return EASResource.getString((String)res, (String)key);
        }
        return ResourceBase.getString((String)res, (String)key, (Locale)ctx.getLocale());
    }

    private static class ErrorInfo {
        private String number;
        private PayRequestBillEntryInfo entryInfo;
        private String errMsg;

        private ErrorInfo() {
        }

        public PayRequestBillEntryInfo getEntryInfo() {
            return this.entryInfo;
        }

        public void setEntryInfo(PayRequestBillEntryInfo entryInfo) {
            this.entryInfo = entryInfo;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }
    }
}

