/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ImportLog
implements Serializable {
    public Date startTime = null;
    public int billCount = 0;
    public int newCount = 0;
    public int index = -1;
    public int failCount = 0;
    public Date endTime = null;
    public List errList = null;
    public String dataFile = null;
    public BigDecimal totalAmount = BigDecimal.ZERO;
    public BigDecimal actualAmount = BigDecimal.ZERO;

    public ImportLog() {
        this.startTime = new Date();
        this.errList = new ArrayList();
    }

    public String getCostTime() {
        if (this.endTime == null) {
            this.endTime = new Date();
        }
        long cost = this.endTime.getTime() - this.startTime.getTime();
        int iH = (int)cost / 360000;
        int iM = (int)(cost -= (long)iH * 360000L) / 60000;
        int iS = (int)(cost -= (long)iM * 60000L) / 1000;
        StringBuffer sDesc = new StringBuffer(8);
        sDesc.append(iH > 9 ? String.valueOf(iH) : "0" + iH);
        sDesc.append(":");
        sDesc.append(iM > 9 ? String.valueOf(iM) : "0" + iM);
        sDesc.append(":");
        sDesc.append(iS > 9 ? String.valueOf(iS) : "0" + iS);
        return sDesc.toString();
    }

    public String getErrDetailMsg() {
        int errCount = this.errList.size();
        if (errCount == 0) {
            return null;
        }
        StringBuffer msg = new StringBuffer("");
        int n = errCount;
        for (int i = 0; i < n; ++i) {
            msg.append(this.errList.get(i)).append("\r\n");
        }
        return msg.toString();
    }
}

