/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.IReportFacade;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.ReportFacadeFactory;
import com.kingdee.eas.fi.ar.ReportInfo;
import com.kingdee.eas.fi.arap.client.ArApReportPrintDelegate;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class AccountAgeRptDelegate
extends ArApReportPrintDelegate {
    private String companyName = null;

    public AccountAgeRptDelegate(ArApQueryParam reportParam, String compName) {
        super(reportParam);
        this.companyName = compName;
    }

    @Override
    protected String[] getCols(ArApQueryParam param) {
        ArrayList<String> lstCols = new ArrayList<String>();
        lstCols.add("FAsstAct");
        lstCols.add("FEndDate");
        lstCols.add("FCurrencySum");
        lstCols.add("FAmt");
        lstCols.add("FContact");
        lstCols.add("FCompany");
        lstCols.add("FCurrency");
        lstCols.add("FUndue");
        List rptFlds = param.getReportFields();
        int oDueInd = 1;
        int n = rptFlds.size();
        for (int i = 0; i < n; ++i) {
            String fld = rptFlds.get(i).toString();
            if (fld.indexOf("FOL") == -1) continue;
            lstCols.add("FOverdue" + oDueInd);
            ++oDueInd;
        }
        lstCols.add("FSum");
        lstCols.add("FCredit");
        lstCols.add("FOverdraft");
        lstCols.add("FOverdraftPer");
        lstCols.add("FPrintDate");
        String[] cols = new String[lstCols.size()];
        lstCols.toArray(cols);
        return cols;
    }

    @Override
    protected IReportData getReportData(IReportQueryParam param) throws BOSException, EASBizException {
        IReportFacade iRpt = ReportFacadeFactory.getRemoteInstance();
        boolean fAr = ((AccountAgeQueryParam)param).isArRpt();
        if (fAr) {
            return iRpt.getARAgesReport(param);
        }
        return iRpt.getAPAgesReport(param);
    }

    @Override
    protected void convert2RowSet(IRowSet rs, ReportInfo rptInfo, ArApQueryParam param) throws SQLException {
        int scale = 2;
        if (param.getCurrencyInfo() != null) {
            scale = param.getCurrencyInfo().getPrecision();
        }
        List rptFlds = param.getReportFields();
        BigDecimal undueAmt = SysConstant.BIGZERO;
        int oDueInd = 1;
        int n = rptFlds.size();
        for (int i = 0; i < n; ++i) {
            String fld = rptFlds.get(i).toString();
            BigDecimal amt = null;
            if (fld.indexOf("FUL_") != -1 && (amt = rptInfo.getBigDecimal(fld)) != null) {
                undueAmt = undueAmt.add(amt);
            }
            if (fld.indexOf("FOL_") == -1) continue;
            amt = rptInfo.getBigDecimal(fld);
            rs.updateString("FOverdue" + oDueInd, this.formatAmt(amt, scale));
            ++oDueInd;
        }
        rs.updateString("FAsstAct", rptInfo.getString("FCussName"));
        Date endDate = ((AccountAgeQueryParam)param).getEndDate();
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        String sEndDate = dtFormat.format(endDate);
        rs.updateString("FEndDate", sEndDate);
        rs.updateString("FUndue", this.formatAmt(undueAmt, scale));
        rs.updateString("FCurrency", rptInfo.getString("FCurrency"));
        if (rptInfo.isSumLine() || rptInfo.isTotalLine()) {
            rs.updateString("FCurrency", rptInfo.getString("FCussName"));
        }
        rs.updateString("FSum", this.formatAmt(rptInfo.getBigDecimal("FBalance"), scale));
        rs.updateString("FCurrencySum", rptInfo.getString("FCurrency"));
        rs.updateString("FAmt", this.formatAmt(rptInfo.getBigDecimal("FBalance"), scale));
        UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
        PersonInfo contactInfo = curUser.getPerson();
        String contact = contactInfo.getName();
        if (!StringUtils.isEmpty((String)contactInfo.getCell())) {
            contact = contact + "( " + contactInfo.getCell() + " )";
        }
        rs.updateString("FContact", contact);
        rs.updateString("FCompany", this.companyName);
        Date curDay = new Date(System.currentTimeMillis());
        rs.updateString("FPrintDate", curDay.toString());
    }
}

