/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.IReportFacade;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.ReportFacadeFactory;
import com.kingdee.eas.fi.ar.ReportInfo;
import com.kingdee.eas.fi.ar.client.AbstractAccountAgeRptUI;
import com.kingdee.eas.fi.ar.client.AccountAgeQueryUI;
import com.kingdee.eas.fi.ar.client.AccountAgeRptDelegate;
import com.kingdee.eas.fi.ar.client.ReportLinkHelper;
import com.kingdee.eas.fi.ar.client.RptBaseQueryUI;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.ComboBoxModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class AccountAgeRptUI
extends AbstractAccountAgeRptUI {
    private static final Logger logger = Logger.getLogger((String)AccountAgeRptUI.class.getName());
    private AccountAgeQueryUI queryUI = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private HashMap rateMap = null;
    private boolean fAllCurr = false;

    @Override
    protected void initUI() {
        super.initUI();
        this.actionFormulPrint.setVisible(true);
        this.actionFormulPrintPreview.setVisible(true);
    }

    @Override
    protected boolean isQueryChangeTable() {
        return true;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected RptBaseQueryUI getQueryPanel() throws Exception {
        if (this.queryUI == null) {
            boolean hasLocAmt = this.getUIContext().get("UIClassParam") != null;
            this.queryUI = new AccountAgeQueryUI(hasLocAmt);
        }
        return this.queryUI;
    }

    @Override
    protected CommonQueryDialog getQueryDialog() throws Exception {
        this.dialog = super.getQueryDialog();
        this.dialog.setWidth(493);
        this.dialog.setHeight(397);
        return this.dialog;
    }

    @Override
    protected boolean isViewEnabled() {
        return false;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.getSelectedId();
        if (billId == null || billId.length() == 0) {
            return;
        }
        ReportLinkHelper.showBillUI((IUIObject)this, billId);
    }

    private String getSelectedId() throws Exception {
        if (this.tblMain.getColumn("FBillId") == null) {
            return null;
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return null;
        }
        int rowInd = selectBlock.getTop();
        String billId = (String)this.tblMain.getRow(rowInd).getCell("FBillId").getValue();
        return billId;
    }

    @Override
    protected IReportData getReport() throws BOSException, EASBizException {
        boolean fView = this.isViewEnabled();
        this.actionView.setEnabled(fView);
        IReportFacade iReport = ReportFacadeFactory.getRemoteInstance();
        IReportData rptData = iReport.getARAgesReport((IReportQueryParam)this.filterParam);
        return rptData;
    }

    @Override
    protected boolean isGetAllNodesRptFirstTime() {
        return true;
    }

    @Override
    protected void refresh(ActionEvent e) throws Exception {
        AccountAgeQueryParam qryParam = (AccountAgeQueryParam)this.filterParam;
        this.setCurrencyRate(qryParam);
        super.refresh(e);
    }

    @Override
    protected void customizeReportHead() {
        AccountAgeQueryParam qryParam = (AccountAgeQueryParam)this.filterParam;
        if (!qryParam.hasLocAmt()) {
            return;
        }
        String resName = "com.kingdee.eas.fi.ar.client.ArResource";
        IRow addedRow = this.tblMain.addHeadRow();
        int iHeadRows = this.tblMain.getHeadRowCount();
        IColumn col = null;
        int ulStartInd = 0;
        int ulEndInd = 0;
        int olStartInd = 0;
        int olEndInd = 0;
        int n = this.tblMain.getColumnCount();
        for (int i = 0; i < n; ++i) {
            col = this.tblMain.getColumn(i);
            String key = col.getKey();
            if (key.equals("FBalance") || key.equals("FDue") || key.startsWith("FUL_") || key.startsWith("FOL_")) {
                StyleAttributes colStyles = col.getStyleAttributes();
                IColumn colLoc = this.tblMain.addColumn(i + 1);
                colLoc.setKey(key + "LocAmt");
                colLoc.setWidth(col.getWidth());
                colLoc.getStyleAttributes().setNumberFormat(colStyles.getNumberFormat());
                colLoc.getStyleAttributes().setHorizontalAlign(colStyles.getHorizontalAlign());
                addedRow.getCell(i).setValue((Object)EASResource.getString((String)resName, (String)"Lbl_FAmt"));
                addedRow.getCell(i + 1).setValue((Object)EASResource.getString((String)resName, (String)"Lbl_FLocAmt"));
                if (ulStartInd == 0 && key.startsWith("FUL_")) {
                    ulStartInd = i;
                }
                if (olStartInd == 0 && key.startsWith("FOL_")) {
                    olStartInd = i;
                    int n2 = ulEndInd = ulStartInd > 0 ? i - 1 : ulEndInd;
                }
                if (key.equals("FDue")) {
                    if (ulEndInd == 0) {
                        int n3 = ulEndInd = ulStartInd > 0 ? i - 1 : ulEndInd;
                    }
                    if (olEndInd == 0) {
                        int n4 = olEndInd = olStartInd > 0 ? i - 1 : olEndInd;
                    }
                }
                if (key.equals("FBalance") || key.equals("FDue")) {
                    logger.debug((Object)key);
                    this.tblMain.getHeadMergeManager().mergeBlock(0, i, iHeadRows - 2, i + 1);
                } else {
                    this.tblMain.getHeadMergeManager().mergeBlock(1, i, iHeadRows - 2, i + 1);
                }
                ++i;
                ++n;
                continue;
            }
            this.tblMain.getHeadMergeManager().mergeBlock(0, i, iHeadRows - 1, i);
        }
        if (ulStartInd != ulEndInd) {
            this.tblMain.getHeadMergeManager().mergeBlock(0, ulStartInd, 0, ulEndInd);
        }
        if (olStartInd != olEndInd) {
            this.tblMain.getHeadMergeManager().mergeBlock(0, olStartInd, 0, olEndInd);
        }
    }

    @Override
    protected String getColTitle(String key) {
        if (key.indexOf("_") != -1) {
            String title = "";
            String resLbl = "Lbl_" + key.substring(0, key.indexOf("_"));
            Object[] args = key.substring(key.indexOf("_") + 1).split("t");
            if (args[0].length() == 0) {
                resLbl = resLbl + "_M";
                int day = Integer.parseInt(args[1]);
                Object[] arg = new String[]{String.valueOf(day)};
                title = EASResource.getString((String)this.getResource(), (String)resLbl);
                title = MessageFormat.format(title, arg);
            } else {
                int day = Integer.parseInt(args[0]);
                if (day > 1) {
                    args[0] = String.valueOf(day + 1);
                }
                title = EASResource.getString((String)this.getResource(), (String)resLbl);
                title = MessageFormat.format(title, args);
            }
            return title;
        }
        return super.getColTitle(key);
    }

    @Override
    protected boolean isShowAllNodesData() {
        return true;
    }

    @Override
    protected EntityViewInfo getTreeView() {
        EntityViewInfo view = super.getTreeView();
        return view;
    }

    @Override
    protected void loadRow(IRow row, IObjectValue rowInfo) {
        if (rowInfo == null) {
            return;
        }
        ReportInfo rptRowInfo = (ReportInfo)rowInfo;
        boolean fNotSumTotal = !rptRowInfo.isSumLine() && !rptRowInfo.isTotalLine();
        String currName = rowInfo.getString("FCurrency");
        int precision = 4;
        int n = this.tblMain.getColumnCount();
        for (int j = 0; j < n; ++j) {
            boolean fLocFld;
            String key = this.tblMain.getColumn(j).getKey();
            Object cellVal = rowInfo.get(key);
            boolean bl = fLocFld = key.lastIndexOf("LocAmt") != -1;
            if (!fLocFld && cellVal == null) continue;
            if (cellVal != null && !(cellVal instanceof BigDecimal)) {
                row.getCell(j).setValue(cellVal);
                continue;
            }
            BigDecimal amt = null;
            if (cellVal != null) {
                amt = rowInfo.getBigDecimal(key);
            } else if (fLocFld) {
                int ind = key.lastIndexOf("LocAmt");
                amt = rowInfo.getBigDecimal(key.substring(0, ind));
                amt = this.calcLocAmt(amt, currName);
            }
            if (this.fAllCurr) {
                Object[] objArr = (Object[])this.rateMap.get(currName);
                if (objArr != null && objArr[0] != null) {
                    CurrencyInfo currInfo = (CurrencyInfo)objArr[0];
                    precision = currInfo.getPrecision();
                }
                String numFmt = "%-[]." + precision + "n";
                row.getCell(j).getStyleAttributes().setNumberFormat(numFmt);
            }
            if (amt != null && amt.signum() == 0 && fNotSumTotal) {
                row.getCell(j).setValue(null);
                continue;
            }
            row.getCell(j).setValue((Object)amt);
        }
    }

    private BigDecimal calcLocAmt(BigDecimal amt, String currName) {
        ExchangeRateInfo rateInfo;
        if (amt == null) {
            return amt;
        }
        BigDecimal locAmt = amt;
        Object[] currInfoExgRateInfoArr = (Object[])this.rateMap.get(currName);
        if (currInfoExgRateInfoArr != null && currInfoExgRateInfoArr[0] != null && (rateInfo = (ExchangeRateInfo)currInfoExgRateInfoArr[1]) != null) {
            if (rateInfo.getExchangeAux() != null && rateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                if (rateInfo.getConvertRate().compareTo(ZERO) != 0) {
                    locAmt = locAmt.divide(rateInfo.getConvertRate(), 4);
                }
            } else {
                locAmt = locAmt.multiply(rateInfo.getConvertRate());
            }
        }
        return locAmt;
    }

    @Override
    protected void printRpt(boolean fPrint) throws Exception {
        TreePath treePath = this.treeMain.getSelectionPath();
        if (treePath == null || treePath.getPathCount() == 1) {
            return;
        }
        AccountAgeQueryParam param = (AccountAgeQueryParam)this.filterParam;
        if (param.getAnalyseObjIndex() == 1 || this.tblMain.getRowCount() == 0) {
            return;
        }
        super.printRpt(fPrint);
    }

    @Override
    public BOSQueryDelegate getPrintProvider() {
        return new AccountAgeRptDelegate(this.filterParam, this.companyInfo.getName());
    }

    @Override
    public String getPrintTemplatePath() {
        return "/FI/AR/AccountAge";
    }

    private void setCurrencyRate(AccountAgeQueryParam qryParam) {
        String currencyId = qryParam.getCurrencyId();
        this.fAllCurr = currencyId != null && currencyId.equals("all");
        this.rateMap = new HashMap();
        Date rateDate = qryParam.getEndDate();
        try {
            PeriodInfo qryPeriod = PeriodUtils.getPeriodInfo((Date)qryParam.getEndDate(), (CompanyOrgUnitInfo)this.companyInfo);
            rateDate = qryPeriod.getEndDate();
        }
        catch (Exception e) {
            logger.error((Object)"can not get the periodInfo");
        }
        if (this.fAllCurr) {
            ComboBoxModel comboModel = null;
            try {
                comboModel = ((AccountAgeQueryUI)this.getQueryPanel()).comboCurrency.getModel();
            }
            catch (Exception e) {
                return;
            }
            int n = comboModel.getSize();
            for (int i = 0; i < n; ++i) {
                CurrencyInfo currInfo = (CurrencyInfo)comboModel.getElementAt(i);
                if (currInfo.getString("id").equals("all")) continue;
                ExchangeRateInfo rateInfo = null;
                try {
                    rateInfo = BaseDataUtil.getExchangeRate(this.companyInfo, currInfo, rateDate);
                }
                catch (Exception e) {
                    logger.error((Object)"can not get the exchangeRate ");
                }
                Object[] objArr = new Object[]{currInfo, rateInfo};
                this.rateMap.put(currInfo.getName(), objArr);
            }
        } else if (currencyId != null) {
            CurrencyInfo currInfo = qryParam.getCurrencyInfo();
            if (currInfo == null) {
                try {
                    ICurrency iCurr = CurrencyFactory.getRemoteInstance();
                    currInfo = (CurrencyInfo)iCurr.getObjectBaseInfo("select id, name, number, precision where id = '" + currencyId + "'");
                }
                catch (Exception e) {
                    logger.error((Object)("can not get the currencyInfo by id " + currencyId));
                }
            }
            ExchangeRateInfo rateInfo = null;
            try {
                rateInfo = BaseDataUtil.getExchangeRate(this.companyInfo, currInfo, rateDate);
            }
            catch (Exception e) {
                logger.error((Object)"can not get the exchangeRate ");
            }
            Object[] objArr = new Object[]{currInfo, rateInfo};
            this.rateMap.put(currInfo.getName(), objArr);
        }
    }
}

