/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.PrepareOptionMethodEnum;
import com.kingdee.eas.fi.ar.AccountBadDebtBDFacadeFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtBillAnalysisEntryCollection;
import com.kingdee.eas.fi.ar.AccountBadDebtBillAnalysisEntryInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtCollection;
import com.kingdee.eas.fi.ar.AccountBadDebtCustPrepareFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtCustPrepareInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtException;
import com.kingdee.eas.fi.ar.AccountBadDebtFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtInfo;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.BadAcctException;
import com.kingdee.eas.fi.ar.BadAcctFactory;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IAccountBadDebt;
import com.kingdee.eas.fi.ar.IAccountBadDebtBDFacade;
import com.kingdee.eas.fi.ar.IAccountBadDebtCustPrepare;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.ar.IBadAcct;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebtBackUI;
import com.kingdee.eas.fi.ar.client.AccountBadDebtBackQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AccountBadDebtBackUI
extends AbstractAccountBadDebtBackUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountBadDebtBackUI.class);
    private static final BigDecimal ZERO = new BigDecimal("0.0");
    private IBadAccountFacade iBadAccountFacade = null;
    private CompanyOrgUnitInfo curCompany;
    private CommonQueryDialog dialog;
    private IAccountBadDebtBDFacade facade = null;
    private String currPrecision = null;
    private int precision = 0;
    private CurrencyInfo localCurrency = null;
    private CurrencyInfo custCurrency = null;
    private AccountBadDebtInfo workFlownfo = null;
    private IAccountBadDebt accountBadDebt = null;
    private boolean isWorkFlow = false;
    private PeriodInfo currPeriod = null;
    private Map countBadDebtMethodOptions = null;
    private Map customerLossAmountMap = new HashMap();
    private String filterCondition = "";
    private boolean isPrepareCurrency = false;
    private boolean isRelationGL = false;
    private PeriodInfo startPeriod = null;
    private IBadAcct iBadAcct = null;

    public void onLoad() throws Exception {
        this.curCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.curCompany);
        this.isRelationGL = this.isNeedChecked();
        this.iBadAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
        this.isPrepareCurrency = !CommonClientUtils.isDisplayLocalCurrency();
        this.iBadAcct = BadAcctFactory.getRemoteInstance();
        Object id = this.getUIContext().get("ID");
        if (id != null) {
            ObjectUuidPK pk = new ObjectUuidPK(id.toString());
            this.accountBadDebt = AccountBadDebtFactory.getRemoteInstance();
            this.countBadDebtMethodOptions = ArClientUtils.getCountBadDebtMethodOptions();
            this.workFlownfo = this.accountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
            this.isWorkFlow = true;
            this.kdtAccountBadDebtBillAnalysis.getStyleAttributes().setLocked(true);
            this.kdtAccountBadDebtBillAnalysis.checkParsed();
            this.setOprtState("EDIT");
        } else {
            this.setOprtState("ADDNEW");
        }
        super.onLoad();
        this.initialize();
        this.initComponet();
        this.kdtAccountBadDebtBillAnalysis.getDataRequestManager().setDataRequestMode(0);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    private void initialize() throws Exception {
        this.facade = AccountBadDebtBDFacadeFactory.getRemoteInstance();
        this.accountBadDebt = (IAccountBadDebt)this.getBizInterface();
        CurrencyInfo currencyInfo = this.curCompany.getBaseCurrency();
        this.currPrecision = PrecisionFormatUtils.getFormatString(currencyInfo);
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.curCompany);
        this.custCurrency = this.localCurrency = CommonClientUtils.getCurrency(String.valueOf(this.curCompany.getBaseCurrency().getId()));
        this.precision = this.localCurrency.getPrecision();
        if (this.precision == 0) {
            this.precision = 2;
        }
        if (this.iBadAccountFacade.isDerectorTransferCancelMethod(this.curCompany)) {
            throw new AccountBadDebtException(AccountBadDebtException.NO_SET_PARAM);
        }
        this.countBadDebtMethodOptions = ArClientUtils.getCountBadDebtMethodOptions();
        this.kdtAccountBadDebtBillAnalysis.getStyleAttributes().setLocked(true);
        this.kdtAccountBadDebtBillAnalysis.checkParsed();
    }

    private void initComponet() throws Exception {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnRefresh.setEnabled(true);
        this.btnVoucher.setEnabled(true);
        this.btnAudit.setEnabled(true);
        this.btnVoucher.setVisible(this.isRelationGL);
        this.menuAccount.setVisible(this.isRelationGL);
        this.txtPrepareAmount.setHorizontalAlignment(4);
        this.txtYearPrepareAmount.setHorizontalAlignment(4);
        this.txtPatch.setHorizontalAlignment(4);
        this.txtRush.setHorizontalAlignment(4);
        this.setOprtState(OprtState.EDIT);
        this.initBillAnalysis();
        this.setDataFormat();
        this.dateBillDate.setValue((Object)this.getJTDate());
        this.btnAttachment.setVisible(false);
        this.actionAudit.setEnabled(false);
        this.actionAudit.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.actionVoucher.setVisible(false);
    }

    private void initBillAnalysis() {
        String preateRateFormat = PrecisionFormatUtils.getFormatString(4);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnUnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnQuery.setVisible(true);
        this.menuItemSave.setVisible(false);
        this.btnSelectAll.setVisible(true);
        this.btnUnSelectAll.setVisible(true);
        this.menuItemVoucher.setVisible(true);
        this.btnSelectAll.setEnabled(true);
        this.btnUnSelectAll.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.menuItemSave.setEnabled(false);
        this.menuItemSelectAll.setEnabled(true);
        this.menuItemUnSelectAll.setEnabled(true);
        this.menuItemRefresh.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
        this.menuItemAudit.setEnabled(true);
        this.menuItemVoucher.setEnabled(true);
        this.setComponetVisible(false);
        boolean isPrepareCurrency = this.isPrepareCurrency();
        this.kdtAccountBadDebtBillAnalysis.getColumn("recievePayAmount").getStyleAttributes().setHided(!isPrepareCurrency);
        this.kdtAccountBadDebtBillAnalysis.getColumn("recievePayAmountLocal").getStyleAttributes().setHided(isPrepareCurrency);
        this.kdtAccountBadDebtBillAnalysis.getColumn("verifyAmount").getStyleAttributes().setHided(!isPrepareCurrency);
        this.kdtAccountBadDebtBillAnalysis.getColumn("verifyAmountLocal").getStyleAttributes().setHided(isPrepareCurrency);
        this.kdtAccountBadDebtBillAnalysis.getColumn("unVerifyAmount").getStyleAttributes().setHided(!isPrepareCurrency);
        this.kdtAccountBadDebtBillAnalysis.getColumn("unVerifyAmountLocal").getStyleAttributes().setHided(isPrepareCurrency);
        this.kdtAccountBadDebtBillAnalysis.getColumn("lockUnVerifyAmt").getStyleAttributes().setHided(!isPrepareCurrency);
        this.kdtAccountBadDebtBillAnalysis.getColumn("lockUnVerifyAmtLocal").getStyleAttributes().setHided(isPrepareCurrency);
        this.kdtAccountBadDebtBillAnalysis.getColumn("preparedBadAmount").getStyleAttributes().setHided(!isPrepareCurrency);
        this.kdtAccountBadDebtBillAnalysis.getColumn("preparedBadAmountLocal").getStyleAttributes().setHided(isPrepareCurrency);
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor check_CellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.kdtAccountBadDebtBillAnalysis.getColumn("checkbox").setEditor((ICellEditor)check_CellEditor);
        this.kdtAccountBadDebtBillAnalysis.getColumn("checkbox").getStyleAttributes().setLocked(false);
        KDFormattedTextField floatDrawing = new KDFormattedTextField((Object)new BigDecimal(String.valueOf("0.0")));
        KDTDefaultCellEditor floatDrawingCellEditor = new KDTDefaultCellEditor((JTextField)floatDrawing);
        this.kdtAccountBadDebtBillAnalysis.getColumn("prepareRate").setEditor((ICellEditor)floatDrawingCellEditor);
        this.kdtAccountBadDebtBillAnalysis.getColumn("prepareRate").setEditor((ICellEditor)floatDrawingCellEditor);
        this.kdtAccountBadDebtBillAnalysis.getColumn("prepareRate").getStyleAttributes().setLocked(false);
        this.kdtAccountBadDebtBillAnalysis.getColumn("recievePayAmountLocal").getStyleAttributes().setNumberFormat(this.currPrecision);
        this.kdtAccountBadDebtBillAnalysis.getColumn("verifyAmountLocal").getStyleAttributes().setNumberFormat(this.currPrecision);
        this.kdtAccountBadDebtBillAnalysis.getColumn("unVerifyAmountLocal").getStyleAttributes().setNumberFormat(this.currPrecision);
        this.kdtAccountBadDebtBillAnalysis.getColumn("lockUnVerifyAmtLocal").getStyleAttributes().setNumberFormat(this.currPrecision);
        this.kdtAccountBadDebtBillAnalysis.getColumn("recievePayAmountLocal").getStyleAttributes().setNumberFormat(this.currPrecision);
        this.kdtAccountBadDebtBillAnalysis.getColumn("preparedBadAmountLocal").getStyleAttributes().setNumberFormat(this.currPrecision);
        this.kdtAccountBadDebtBillAnalysis.getColumn("prepareRate").getStyleAttributes().setNumberFormat(preateRateFormat);
        if (!this.isPrepareCurrency()) {
            this.kdtAccountBadDebtBillAnalysis.getColumn("prepareAmount").getStyleAttributes().setNumberFormat(this.currPrecision);
            this.kdtAccountBadDebtBillAnalysis.getColumn("patch").getStyleAttributes().setNumberFormat(this.currPrecision);
            this.kdtAccountBadDebtBillAnalysis.getColumn("rush").getStyleAttributes().setNumberFormat(this.currPrecision);
        }
        this.kdtAccountBadDebtBillAnalysis.getColumn("prepareAmount").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
        this.kdtAccountBadDebtBillAnalysis.getColumn("patch").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
        this.kdtAccountBadDebtBillAnalysis.getColumn("rush").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
    }

    private void setComponetVisible(boolean b) {
        this.kDLabelContainer1.setVisible(b);
        this.kDLabelContainer2.setVisible(b);
        this.kDLabelContainer3.setVisible(b);
        this.kDLabelContainer4.setVisible(b);
        this.kDLabelContainer5.setVisible(b);
        this.kDLabelContainer6.setVisible(b);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.isWorkFlow) {
            this.editData = this.workFlownfo;
        } else {
            this.getSelectors();
        }
    }

    @Override
    public void storeFields() {
        this.storeAccountAnalysisBadDebtBillDetail();
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return new AccountBadDebtInfo();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new AccountBadDebtBillAnalysisEntryInfo();
    }

    protected KDTable getDetailTable() {
        return this.kdtAccountBadDebtBillAnalysis;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountBadDebtFactory.getRemoteInstance();
    }

    public void initWorkFlow() {
        this.txtPatch.setValue((Object)this.editData.getPatch());
        this.txtRush.setValue((Object)this.editData.getRush());
        this.txtPrepareAmount.setValue((Object)this.editData.getPrepareAmount());
        this.txtYearPrepareAmount.setValue((Object)this.editData.getThisPrepareAmount());
    }

    protected void initWorkButton() {
        try {
            this.startPeriod = ArClientUtils.getArStartPeriod(this.curCompany);
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.curCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
            this.checkParam();
            String accuralParam = this.iBadAccountFacade.getAccuralParam(this.curCompany);
            if (!accuralParam.equalsIgnoreCase(String.valueOf(6))) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_set_bill_prepare_param"));
                this.abort();
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.menuItemSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.menuItemUnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnQuery);
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    private AccountViewInfo getBadAcctPrepareAccount(String key) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = null;
        if (this.countBadDebtMethodOptions.get(key) != null && ((ParamItemInfo)this.countBadDebtMethodOptions.get(key)).getValue() != null && ((ParamItemInfo)this.countBadDebtMethodOptions.get(key)).getValue().toString().length() != 0) {
            accountViewInfo = ArClientUtils.getBadDebtPrepareAccount(this.countBadDebtMethodOptions, key);
        }
        return accountViewInfo;
    }

    private void setDataFormat() {
        this.txtPrepareAmount.setPrecision(this.localCurrency.getPrecision());
        this.txtYearPrepareAmount.setPrecision(this.localCurrency.getPrecision());
        this.txtPatch.setPrecision(this.localCurrency.getPrecision());
        this.txtRush.setPrecision(this.localCurrency.getPrecision());
        this.txtPrepareAmount.getNumberFeatureMode().setRemoveingZeroInDispaly(false);
        this.txtYearPrepareAmount.getNumberFeatureMode().setRemoveingZeroInDispaly(false);
        this.txtPatch.getNumberFeatureMode().setRemoveingZeroInDispaly(false);
        this.txtRush.getNumberFeatureMode().setRemoveingZeroInDispaly(false);
    }

    private BigDecimal multiplyByPercent(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return ZERO;
        }
        return a.multiply(b).divide(new BigDecimal("100.0"), this.precision, 4);
    }

    private void fillAccountBadDebtBillAnalysisAccount(String filter) {
        String currencyID = null;
        String currPrecision = null;
        this.kdtAccountBadDebtBillAnalysis.getViewManager().setFreezeView(0, 7);
        this.kdtAccountBadDebtBillAnalysis.removeRows();
        try {
            IRowSet rs = this.facade.getBillAnalysis(filter, this.isRelationGL);
            while (rs.next()) {
                IRow row = this.kdtAccountBadDebtBillAnalysis.addRow();
                row.getCell("checkbox").setValue((Object)false);
                row.getCell("id").setValue((Object)rs.getString("FID"));
                row.getCell("billID").setValue((Object)rs.getString("FID"));
                row.getCell("billNumber").setValue((Object)rs.getString("FNumber"));
                if (rs.getString("FBillStatus") != null) {
                    row.getCell("billStatusDes").setValue((Object)BillStatusEnum.getEnum((int)rs.getInt("FBillStatus")));
                }
                row.getCell("billStatus").setValue((Object)String.valueOf(rs.getInt("FBillStatus")));
                row.getCell("billDate").setValue((Object)rs.getDate("FBillDate"));
                if (rs.getString("FSourceBillType") != null) {
                    row.getCell("sourceBillTypeDes").setValue((Object)OtherBillTypeEnum.getEnum((int)rs.getInt("FSourceBillType")));
                }
                row.getCell("sourceBillType").setValue((Object)String.valueOf(rs.getInt("FSourceBillType")));
                row.getCell("asstActTypeID").setValue((Object)rs.getString("FAsstActTypeID"));
                row.getCell("asstActTypeName").setValue((Object)rs.getString("FAsstActTypeName"));
                row.getCell("asstActID").setValue((Object)rs.getString("FAsstActID"));
                row.getCell("asstActName").setValue((Object)rs.getString("FAsstActName"));
                currencyID = rs.getString("FCurrencyID");
                row.getCell("currencyID").setValue((Object)currencyID);
                currPrecision = this.getFormatString(currencyID);
                row.getCell("currencyName").setValue((Object)rs.getString("FCurrencyName"));
                row.getCell("adminOrgUnitID").setValue((Object)rs.getString("FAdminOrgUnitID"));
                row.getCell("adminOrgUnitName").setValue((Object)rs.getString("FAdminOrgUnitName"));
                row.getCell("saleOrgID").setValue((Object)rs.getString("FSaleOrgID"));
                row.getCell("saleOrgName").setValue((Object)rs.getString("FSaleOrgName"));
                row.getCell("personID").setValue((Object)rs.getString("FPersonID"));
                row.getCell("personName").setValue((Object)rs.getString("FPersonName"));
                row.getCell("abstractName").setValue((Object)rs.getString("FAbstractName"));
                row.getCell("fiVouchered").setValue((Object)rs.getString("FFiVouchered"));
                row.getCell("companyID").setValue((Object)rs.getString("FCompanyID"));
                row.getCell("companyName").setValue((Object)rs.getString("FCompanyName"));
                row.getCell("entryID").setValue((Object)rs.getString("FEntryID"));
                row.getCell("entrySeq").setValue((Object)String.valueOf(rs.getInt("FSeq")));
                row.getCell("recievePayAmount").setValue((Object)rs.getBigDecimal("FRecievePayAmount"));
                row.getCell("recievePayAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("recievePayAmountLocal").setValue((Object)rs.getBigDecimal("FRecievePayAmountLocal"));
                row.getCell("verifyAmount").setValue((Object)rs.getBigDecimal("FVerifyAmount"));
                row.getCell("verifyAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("verifyAmountLocal").setValue((Object)rs.getBigDecimal("FVerifyAmountLocal"));
                row.getCell("unVerifyAmount").setValue((Object)rs.getBigDecimal("FUnVerifyAmount"));
                row.getCell("unVerifyAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("unVerifyAmountLocal").setValue((Object)rs.getBigDecimal("FUnVerifyAmountLocal"));
                row.getCell("lockUnVerifyAmt").setValue((Object)rs.getBigDecimal("FLockUnVerifyAmt"));
                row.getCell("lockUnVerifyAmt").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("lockUnVerifyAmtLocal").setValue((Object)rs.getBigDecimal("FLockUnVerifyAmtLocal"));
                row.getCell("preparedBadAmount").setValue((Object)rs.getBigDecimal("FPreparedBadAmount"));
                row.getCell("preparedBadAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("preparedBadAmountLocal").setValue((Object)rs.getBigDecimal("FPreparedBadAmountLocal"));
                row.getCell("prepareRate").setValue((Object)new BigDecimal("100.00"));
                row.getCell("prepareAmount").setValue((Object)ZERO);
                row.getCell("patch").setValue((Object)ZERO);
                row.getCell("rush").setValue((Object)ZERO);
                if (!this.isPrepareCurrency()) continue;
                row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("patch").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("rush").getStyleAttributes().setNumberFormat(currPrecision);
            }
            this.setBillTableConfig();
            this.setBillTableConfig();
            this.bizCurrency.setData((Object)this.getBillCurrency());
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private CurrencyInfo getBillCurrency() {
        CurrencyInfo currencyInfo = null;
        if (this.kdtAccountBadDebtBillAnalysis.getRowCount3() > 0) {
            IRow row = this.kdtAccountBadDebtBillAnalysis.getRow(0);
            String currencyID = row.getCell("currencyID").getValue().toString();
            currencyInfo = this.getCurrency(currencyID);
        }
        return currencyInfo;
    }

    private BigDecimal getDateExchangeRate(CurrencyInfo currencyInfo, Date date) {
        if (!this.isPrepareCurrency()) {
            return new BigDecimal("1.0");
        }
        if (currencyInfo == null) {
            return new BigDecimal("1.0");
        }
        if (this.localCurrency.getId().toString().equals(currencyInfo.getId().toString())) {
            return new BigDecimal("1.0");
        }
        BigDecimal exchangeRate = BaseDataUtil.ZERO;
        try {
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(this.curCompany, currencyInfo, date);
            exchangeRate = rateInfo != null ? rateInfo.getConvertRate() : new BigDecimal("1.0");
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return exchangeRate;
    }

    private void saveBadAccountAccuralHead() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        AccountViewInfo account = null;
        AccountViewInfo badAccount = null;
        this.editData.setCompany(company);
        CurrencyInfo currencyInfo = this.getBillCurrency();
        this.editData.setCurrency(currencyInfo);
        this.editData.setExchangeRate(this.getDateExchangeRate(currencyInfo, this.getJTDate()));
        this.editData.setAccountType(PrepareOptionMethodEnum.BadPrepareBackMethod);
        account = this.getBadAcctPrepareAccount("arap001002002");
        badAccount = this.getBadAcctPrepareAccount("arap001001002");
        ParamItemInfo paramItemInfo = (ParamItemInfo)this.countBadDebtMethodOptions.get("arap003");
        String arOtherParamID = paramItemInfo.getId().toString();
        this.editData.setArOtherParam(arOtherParamID);
        this.editData.setCU(this.curCompany.getCU());
        this.editData.setAccount(account);
        this.editData.setBadAccount(badAccount);
        this.editData.setAccountYear(((Date)this.dateBillDate.getValue()).getYear() + 1900);
        this.editData.setRush(this.txtRush.getBigDecimalValue());
        this.editData.setPatch(this.txtPatch.getBigDecimalValue());
        this.editData.setThisPrepareAmount(this.txtYearPrepareAmount.getBigDecimalValue());
        this.editData.setPrepareAmount(this.txtPrepareAmount.getBigDecimalValue());
        this.editData.setDescription(this.getStrResource("badacct_prepare_back"));
    }

    private BigDecimal getAccountBalance(AccountViewInfo accountViewInfo) throws EASBizException, BOSException {
        if (!this.isRelationGL || accountViewInfo == null) {
            return ZERO;
        }
        BigDecimal accountBalance = CommonClientUtils.getRecentPrepareBalance(accountViewInfo);
        return accountBalance;
    }

    private void storeAccountAnalysisBadDebtBillDetail() {
        HashMap<String, BigDecimal> billPrepareMap = new HashMap<String, BigDecimal>();
        String billEntryID = null;
        String billID = null;
        BigDecimal prepareAmount = ZERO;
        Map asstActNameMap = null;
        try {
            this.saveBadAccountAccuralHead();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        int rowCount = this.kdtAccountBadDebtBillAnalysis.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow mergeRow = this.kdtAccountBadDebtBillAnalysis.getRow(i);
            if (Boolean.FALSE.equals((Boolean)mergeRow.getCell("checkbox").getValue()) || mergeRow.getCell("checkbox").getMergeBlock() == null) continue;
            int top = mergeRow.getCell("checkbox").getMergeBlock().getTop();
            int bottom = mergeRow.getCell("checkbox").getMergeBlock().getBottom();
            for (int j = top; j <= bottom; ++j) {
                IRow row = this.kdtAccountBadDebtBillAnalysis.getRow(j);
                AccountBadDebtBillAnalysisEntryInfo info = new AccountBadDebtBillAnalysisEntryInfo();
                billID = row.getCell("billID").getValue().toString();
                info.setBillID(row.getCell("billID").getValue().toString());
                info.setBillNumber(row.getCell("billNumber").getValue().toString());
                info.setBillStatus(Integer.parseInt(row.getCell("billStatus").getValue().toString()));
                info.setBillDate((java.sql.Date)row.getCell("billDate").getValue());
                info.setSourceBillType(Integer.parseInt(row.getCell("sourceBillType").getValue().toString()));
                info.setAsstActID(row.getCell("asstActID").getValue().toString());
                info.setAsstActName(row.getCell("asstActName").getValue().toString());
                try {
                    asstActNameMap = this.iBadAcct.getAsstActName(billID, "otherbill");
                    info.setAsstActName(asstActNameMap.get("L1").toString(), ArApBillUIUtil.L1);
                    info.setAsstActName(asstActNameMap.get("L2").toString(), ArApBillUIUtil.L2);
                    info.setAsstActName(asstActNameMap.get("L3").toString(), ArApBillUIUtil.L3);
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
                billEntryID = row.getCell("entryID").getValue().toString();
                info.setEntryID(billEntryID);
                info.setEntrySeq(Integer.parseInt(row.getCell("entrySeq").getValue().toString()));
                info.setFiVouchered(Integer.parseInt(row.getCell("fiVouchered").getValue().toString()));
                info.setRecievePayAmount(new BigDecimal(row.getCell("recievePayAmount").getValue().toString()));
                info.setRecievePayAmountLocal(new BigDecimal(row.getCell("recievePayAmountLocal").getValue().toString()));
                info.setVerifyAmount(new BigDecimal(row.getCell("verifyAmount").getValue().toString()));
                info.setVerifyAmountLocal(new BigDecimal(row.getCell("verifyAmountLocal").getValue().toString()));
                info.setUnVerifyAmount(new BigDecimal(row.getCell("unVerifyAmount").getValue().toString()));
                info.setUnVerifyAmountLocal(new BigDecimal(row.getCell("unVerifyAmountLocal").getValue().toString()));
                info.setLockUnVerifyAmt(new BigDecimal(row.getCell("lockUnVerifyAmt").getValue().toString()));
                info.setLockUnVerifyAmtLocal(new BigDecimal(row.getCell("lockUnVerifyAmtLocal").getValue().toString()));
                info.setPreparedBadAmount(ZERO);
                info.setPreparedBadAmountLocal(ZERO);
                if (row.getCell("prepareRate").getValue() != null) {
                    info.setPrepareRate(new BigDecimal(row.getCell("prepareRate").getValue().toString()));
                } else {
                    info.setPrepareRate(ZERO);
                }
                if (row.getCell("prepareAmount").getValue() != null) {
                    prepareAmount = new BigDecimal(row.getCell("prepareAmount").getValue().toString());
                    prepareAmount = prepareAmount == null ? ZERO : prepareAmount;
                    info.setPrepareAmount(prepareAmount);
                }
                billPrepareMap.put(billEntryID, ZERO);
                if (row.getCell("patch").getValue() != null) {
                    info.setPatch(new BigDecimal(row.getCell("patch").getValue().toString()));
                }
                if (row.getCell("rush").getValue() != null) {
                    info.setRush(new BigDecimal(row.getCell("rush").getValue().toString()));
                }
                String currencyID = row.getCell("currencyID").getValue().toString();
                CurrencyInfo currencyInfo = this.getCurrency(currencyID);
                info.setCurrency(currencyInfo);
                info.setExchangeRate(this.getDateExchangeRate(currencyInfo, this.getJTDate()));
                if (row.getCell("adminOrgUnitID").getValue() != null) {
                    String adminOrgUnitID = row.getCell("adminOrgUnitID").getValue().toString();
                    AdminOrgUnitInfo adminOrgUnitInfo = this.getAdminOrgUnit(adminOrgUnitID);
                    info.setAdminOrgUnit(adminOrgUnitInfo);
                }
                if (row.getCell("saleOrgID").getValue() != null) {
                    String saleOrgID = row.getCell("saleOrgID").getValue().toString();
                    SaleOrgUnitInfo saleOrgInfo = this.getSaleOrgUnit(saleOrgID);
                    info.setSaleOrgUnit(saleOrgInfo);
                }
                String asstActTypeID = row.getCell("asstActTypeID").getValue().toString();
                AsstActTypeInfo asstActTypeInfo = this.getAsstActType(asstActTypeID);
                info.setAsstActType(asstActTypeInfo);
                if (row.getCell("personID").getValue() != null) {
                    String personID = row.getCell("personID").getValue().toString();
                    PersonInfo personInfo = this.getPerson(personID);
                    info.setPerson(personInfo);
                }
                this.editData.getBillAnalysisEntry().add(info);
            }
        }
    }

    private boolean isPrepareCurrency() {
        return this.isPrepareCurrency;
    }

    private CurrencyInfo getCurrency(String ID) {
        CurrencyInfo info = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(ID);
            info = iCurrency.getCurrencyInfo((IObjectPK)pk);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return info;
    }

    private AdminOrgUnitInfo getAdminOrgUnit(String ID) {
        AdminOrgUnitInfo info = null;
        try {
            IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(ID);
            info = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)pk);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return info;
    }

    private PersonInfo getPerson(String ID) {
        PersonInfo info = null;
        try {
            IPerson iPerson = PersonFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(ID);
            info = iPerson.getPersonInfo((IObjectPK)pk);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return info;
    }

    private AsstActTypeInfo getAsstActType(String ID) {
        AsstActTypeInfo info = null;
        try {
            IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(ID);
            info = iAsstActType.getAsstActTypeInfo((IObjectPK)pk);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return info;
    }

    private SaleOrgUnitInfo getSaleOrgUnit(String ID) {
        SaleOrgUnitInfo info = null;
        try {
            ISaleOrgUnit iSaleOrgUnit = SaleOrgUnitFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(ID);
            info = iSaleOrgUnit.getSaleOrgUnitInfo((IObjectPK)pk);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return info;
    }

    private CustomerInfo getCustomer(String ID) {
        CustomerInfo info = null;
        try {
            ICustomer iCustomer = CustomerFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(ID);
            info = iCustomer.getCustomerInfo((IObjectPK)pk);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return info;
    }

    private void checkParam() throws Exception {
        IBadAccountFacade iBadAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
        boolean isSetAccurralParam = iBadAccountFacade.isSetAccurralParam(this.curCompany);
        if (!isSetAccurralParam) {
            MsgBox.showInfo((String)this.getStrResource("no_set_accurral_param"));
            this.abort();
        }
    }

    private Date getJTDate() {
        Date currDate = null;
        if (this.currPeriod != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.currPeriod.getEndDate());
            currDate = new Date(calendar.getTime().getTime());
        }
        return currDate;
    }

    public String getStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key);
    }

    public boolean isModify() {
        return false;
    }

    private FilterInfo getDefalutQueryFilter() {
        try {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            EntityViewInfo viewInfo = (EntityViewInfo)iQuery.getDefaultFilterInfo("com.kingdee.eas.fi.ar.client.AccountBadDebtBackUI", "com.kingdee.eas.base.message.MsgQuery");
            if (viewInfo != null) {
                return viewInfo.getFilter();
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return null;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isWorkFlow) {
            super.actionQuery_actionPerformed(e);
            if (this.dialog == null) {
                this.dialog = new CommonQueryDialog();
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
                this.dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery"));
                this.dialog.addUserPanel((KDPanel)new AccountBadDebtBackQueryUI());
                this.dialog.setShowFilter(false);
                this.dialog.setShowSorter(false);
                this.dialog.setHeight(260);
                this.dialog.setWidth(510);
                this.dialog.setTitle(this.getStrResource("badacct_back_query_title"));
                this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            }
            if (this.dialog.show()) {
                AccountBadDebtBackQueryUI panel = (AccountBadDebtBackQueryUI)this.dialog.getUserPanel(0);
                panel.getFilterInfo();
                this.filterCondition = this.dialog.getEntityViewInfoResult().toString();
                this.fillAccountBadDebtBillAnalysisAccount(this.filterCondition);
            } else {
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.filterCondition != null && !"".equals(this.filterCondition)) {
            this.fillAccountBadDebtBillAnalysisAccount(this.filterCondition);
        }
    }

    private void auditedVerify() throws Exception {
        boolean retvalue = true;
        if (this.editData.getId() == null) {
            throw new AccountBadDebtException(AccountBadDebtException.NO_SAVE);
        }
        BigDecimal rush = this.txtRush.getBigDecimalValue();
        BigDecimal patch = this.txtPatch.getBigDecimalValue();
        BigDecimal temp = ZERO;
        if (rush.compareTo(temp) == 0 && patch.compareTo(temp) == 0) {
            MsgBox.showInfo((String)this.getStrResource("msg_ar_accBad_noaudited"));
            SysUtil.abort();
        }
    }

    private void createNewCustPrepare(String customerID, String customerNumber, String currencyID, CompanyOrgUnitInfo company) {
        try {
            IAccountBadDebtCustPrepare iAccountBadDebtCustPrepare = AccountBadDebtCustPrepareFactory.getRemoteInstance();
            AccountBadDebtCustPrepareInfo info = new AccountBadDebtCustPrepareInfo();
            CustomerInfo customerInfo = this.getCustomer(customerID);
            CurrencyInfo currencyInfo = this.getCurrency(currencyID);
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(this.curCompany, currencyInfo);
            info.setCustomer(customerInfo);
            info.setCustomerNumber(customerNumber);
            info.setCurrency(currencyInfo);
            info.setCompany(company);
            if (rateInfo != null) {
                info.setExchangeRate(rateInfo.getConvertRate());
            } else {
                info.setExchangeRate(new BigDecimal("1.00"));
            }
            info.setPrepareAmount(ZERO);
            info.setLastPrepareAmount(ZERO);
            info.setTotalPrepareAmount(ZERO);
            iAccountBadDebtCustPrepare.submit((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private CurrencyInfo getCurrency() {
        return this.custCurrency;
    }

    private String getJTStrDate() {
        Date date = this.upDate(this.getJTDate());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public Date upDate(Date oldDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldDate);
        calendar.add(5, 1);
        Date dateUp = new Date(calendar.getTime().getTime());
        return dateUp;
    }

    private List getBillID() {
        ArrayList<String> billIDList = new ArrayList<String>();
        BigDecimal patch = ZERO;
        BigDecimal rush = ZERO;
        int rowCount = this.kdtAccountBadDebtBillAnalysis.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow mergeRow = this.kdtAccountBadDebtBillAnalysis.getRow(i);
            if (Boolean.FALSE.equals((Boolean)mergeRow.getCell("checkbox").getValue()) || mergeRow.getCell("checkbox").getMergeBlock() == null) continue;
            int top = mergeRow.getCell("checkbox").getMergeBlock().getTop();
            int bottom = mergeRow.getCell("checkbox").getMergeBlock().getBottom();
            for (int j = top; j <= bottom; ++j) {
                String billID;
                BigDecimal preparedBadAmount = ZERO;
                BigDecimal preparedBadAmountLocal = ZERO;
                BigDecimal prepareAmount = ZERO;
                IRow row = this.kdtAccountBadDebtBillAnalysis.getRow(j);
                if (row.getCell("patch").getValue() != null) {
                    patch = (BigDecimal)row.getCell("patch").getValue();
                }
                if (row.getCell("rush").getValue() != null) {
                    rush = (BigDecimal)row.getCell("rush").getValue();
                }
                if (patch.compareTo(ZERO) == 0 && rush.compareTo(ZERO) == 0 || billIDList.contains(billID = row.getCell("billID").getValue().toString())) continue;
                billIDList.add(billID);
            }
        }
        return billIDList;
    }

    public void checkVoucheredOrSettleAccount(String checkType, String fid) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountDate", (Object)this.currPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountDate", (Object)this.upDate(this.currPeriod.getEndDate()), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.curCompany.getId().toString()));
        if (!checkType.equalsIgnoreCase("submit")) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        AccountBadDebtCollection coll = this.accountBadDebt.getAccountBadDebtCollection(view);
        List billList = this.getBillID();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            boolean isSameBill = false;
            boolean isSameCurrency = false;
            AccountBadDebtInfo info = coll.get(i);
            AccountBadDebtBillAnalysisEntryCollection billEntryCollection = info.getBillAnalysisEntry();
            int count = billEntryCollection.size();
            for (int j = 0; j < count; ++j) {
                AccountBadDebtBillAnalysisEntryInfo billEntryInfo = billEntryCollection.get(j);
                String billID = billEntryInfo.getBillID();
                if (!billList.contains(billID)) continue;
                if (checkType.equalsIgnoreCase("submit") && (info.getAuditDate() == null || info.getAuditor() == null)) {
                    throw new AccountBadDebtException(AccountBadDebtException.NO_AUDIT_BACK);
                }
                if (!this.isRelationGL) continue;
                if ((checkType.equalsIgnoreCase("submit") || checkType.equalsIgnoreCase("audited")) && !info.isFiVouchered()) {
                    throw new AccountBadDebtException(AccountBadDebtException.NO_VOUCHER_BACK);
                }
                if (!this.accountBadDebt.checkSettleAccounts(info.getId().toString())) continue;
                throw new AccountBadDebtException(AccountBadDebtException.NO_SETTLE_ACCOUNTS_BACK);
            }
        }
    }

    private void existDateExchangeRate(CurrencyInfo currencyInfo, Date date) {
        try {
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(this.curCompany, currencyInfo, date);
            if (rateInfo == null) {
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void verifyInput() throws Exception {
        int rowCount;
        if (this.editData.getId() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("badacct_back_saved"));
            SysUtil.abort();
        }
        if ((rowCount = this.kdtAccountBadDebtBillAnalysis.getRowCount3()) == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
        boolean isSelected = false;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtAccountBadDebtBillAnalysis.getRow(i);
            if (row.getCell("checkbox").getValue() == null) continue;
            Boolean checkValue = (Boolean)row.getCell("checkbox").getValue();
            if (!Boolean.valueOf(true).equals(checkValue)) continue;
            isSelected = true;
            break;
        }
        if (!isSelected) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("select_data"));
            SysUtil.abort();
        }
        BigDecimal rush = this.txtRush.getBigDecimalValue();
        BigDecimal patch = this.txtPatch.getBigDecimalValue();
        BigDecimal temp = ZERO;
        if (rush.compareTo(temp) == 0 && patch.compareTo(temp) == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("rush_patch_zero"));
            SysUtil.abort();
        }
        this.checkVoucheredOrSettleAccount("submit", null);
        if (this.isPrepareCurrency()) {
            CurrencyInfo currencyInfo = this.getBillCurrency();
            if (!this.localCurrency.getId().toString().equals(currencyInfo.getId().toString())) {
                this.existDateExchangeRate(currencyInfo, this.getJTDate());
            }
        }
    }

    public void voucheredVerify(AccountBadDebtInfo info) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
        AccountBadDebtInfo newInfo = (AccountBadDebtInfo)this.accountBadDebt.getValue((IObjectPK)pk);
        if (newInfo == null || newInfo.getAuditDate() == null || newInfo.getAuditor() == null) {
            throw new BadAcctException(BadAcctException.BILL_NOT_AUDIT);
        }
    }

    private void createVoucher(AccountBadDebtInfo accbadDebtInfo) {
        try {
            IAccountBadDebt acctBad = (IAccountBadDebt)this.getBizInterface();
            BOSUuid uuid = accbadDebtInfo.getId();
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            accbadDebtInfo = (AccountBadDebtInfo)acctBad.getValue((IObjectPK)pk);
            AccountBadDebtCollection acctBadInfoCol = new AccountBadDebtCollection();
            acctBadInfoCol.add(accbadDebtInfo);
            VoucherInfo vch = (VoucherInfo)acctBad.genVoucher(accbadDebtInfo.getId().toString());
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"ID", (Object)vch.getId());
            ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String id = (String)this.getUIContext().get("ID");
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        iMutex.requestObjIDForUpdate(id);
        this.caculateTotalPrepareAmount();
        this.caculatePatchRush();
        if (this.editData.getId() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("badacct_back_saved"));
            SysUtil.abort();
        }
        this.verifyInput();
        this.editData.setCompany(this.curCompany);
        String sysNumber = null;
        sysNumber = BaseDataUtil.getNumberFromCodeRule(this.editData);
        if (sysNumber == null || sysNumber.trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("badacct_back_number_null"));
            SysUtil.abort();
        }
        this.editData.setNumber(sysNumber);
        this.editData.setIsRelationGL(this.isRelationGL);
        this.save();
        iMutex.releaseObjIDForUpdate(id);
    }

    private void save() throws Exception {
        this.doBeforeSubmitForWF((CoreBaseInfo)this.editData);
        IObjectPK pk = null;
        try {
            pk = this.runSubmit();
        }
        catch (AlreadyBindProcessInstanceException wfExceptoin) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_BindWfInstance"));
            return;
        }
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        this.showSubmitSuccess();
        if (this.isWorkFlow) {
            this.setOprtState("EDIT");
        } else {
            this.setOprtState("ADDNEW");
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.idList.add(this.idList.getCurrentIndex() + 1, pk.toString());
            this.setDataObject(this.createNewData());
            this.fillAccountBadDebtBillAnalysisAccount(this.filterCondition);
            if (this.wfContext.isBindWorkFlow()) {
                this.wfContext.addToDataMap((Object)pk.toString(), (Object)pk.toString());
            }
        } else if (this.wfContext.isBindWorkFlow()) {
            this.wfContext.addToDataMap((Object)pk.toString(), (Object)pk.toString());
        }
        this.setSave(true);
    }

    private void reverseCustPrepareAmount() throws EASBizException, BOSException {
        String currencyID = this.getCurrency().getId().toString();
        String companyID = this.curCompany.getId().toString();
        Iterator customerLossItr = this.customerLossAmountMap.keySet().iterator();
        while (customerLossItr.hasNext()) {
            String customerID = customerLossItr.next().toString();
            BigDecimal preAmount = this.facade.getPreAmount(customerID, currencyID, this.getJTStrDate(), this.isRelationGL, this.isPrepareCurrency(), false);
            preAmount = preAmount == null ? BaseDataUtil.ZERO : preAmount;
            BigDecimal prepareAmount = new BigDecimal(this.customerLossAmountMap.get(customerID).toString());
            BigDecimal balance = (prepareAmount = prepareAmount == null ? BaseDataUtil.ZERO : prepareAmount).subtract(preAmount);
            if (balance.compareTo(new BigDecimal("0.0")) < 0) {
                balance = new BigDecimal("0.0");
            }
            this.facade.reversePrepareAmount(balance, companyID, customerID, currencyID, true);
        }
    }

    protected void showSubmitSuccess() {
        this.setMessageText(this.getStrResource("prepare_rush_success"));
        this.showMessage();
        this.setOprtState("EDIT");
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk;
        AccountBadDebtInfo info;
        super.actionAudit_actionPerformed(e);
        if (this.editData.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("badacct_back_not_save"));
            SysUtil.abort();
        }
        if ((info = this.accountBadDebt.getAccountBadDebtInfo((IObjectPK)(pk = new ObjectUuidPK(this.editData.getId().toString())))).getAuditDate() != null && info.getAuditor() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("badacct_back_audited"));
            SysUtil.abort();
        }
        this.auditedVerify();
        this.accountBadDebt.audit(this.editData.getId().toString());
        this.setMessageText(this.getStrResource("audited_success"));
        this.showMessage();
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk;
        AccountBadDebtInfo info;
        if (!this.isRelationGL) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gl_not_relation_or_start"));
            return;
        }
        if (this.editData.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("bill_not_saved_for_voucher"));
            SysUtil.abort();
        }
        if ((info = this.accountBadDebt.getAccountBadDebtInfo((IObjectPK)(pk = new ObjectUuidPK(this.editData.getId().toString())))).getAuditDate() == null || info.getAuditor() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("badacct_back_not_audit"));
            SysUtil.abort();
        }
        if (info.isFiVouchered()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("already_vouchered"));
            SysUtil.abort();
        }
        this.voucheredVerify(this.editData);
        this.createVoucher(this.editData);
    }

    @Override
    public void txtPrepareAmount_focusLost(FocusEvent e) throws Exception {
        this.caculatePatchRush();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.kdtAccountBadDebtBillAnalysis.getRowCount3();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtAccountBadDebtBillAnalysis.getRow(i);
            row.getCell("checkbox").setValue((Object)true);
            row.getCell("prepareRate").setValue((Object)ZERO);
            this.backPrepareAmount(row);
        }
    }

    @Override
    public void actionUnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.kdtAccountBadDebtBillAnalysis.getRowCount3();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtAccountBadDebtBillAnalysis.getRow(i);
            row.getCell("checkbox").setValue((Object)false);
            row.getCell("prepareRate").setValue((Object)ZERO);
            this.backPrepareAmount(row);
        }
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtAccountBadDebtBillAnalysis);
        this.kdtAccountBadDebtBillAnalysis.getPrintManager().printPreview();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtAccountBadDebtBillAnalysis);
        this.kdtAccountBadDebtBillAnalysis.getPrintManager().print();
    }

    @Override
    public void kdtAccountBadDebtBillAnalysis_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private void backPrepareAmount(IRow row) {
        Boolean selected = Boolean.FALSE;
        if (row.getCell("checkbox").getValue() != null) {
            selected = (Boolean)row.getCell("checkbox").getValue();
        }
        this.cancelPrepareAmount(row, selected);
    }

    private void cancelPrepareAmount(IRow row, Boolean selected) {
        String currencyID;
        CurrencyInfo currencyInfo;
        int currencyPrecision;
        BigDecimal preparedBadAmount = ZERO;
        if (Boolean.TRUE.equals(selected)) {
            if (this.isPrepareCurrency()) {
                if (row.getCell("preparedBadAmount").getValue() != null) {
                    preparedBadAmount = new BigDecimal(row.getCell("preparedBadAmount").getValue().toString());
                }
            } else if (row.getCell("preparedBadAmountLocal").getValue() != null) {
                preparedBadAmount = new BigDecimal(row.getCell("preparedBadAmountLocal").getValue().toString());
            }
        }
        if ((currencyPrecision = (currencyInfo = this.getCurrency(currencyID = row.getCell("currencyID").getValue().toString())).getPrecision()) == 0) {
            currencyPrecision = 2;
        }
        row.getCell("patch").setValue((Object)ZERO);
        preparedBadAmount = preparedBadAmount.divide(new BigDecimal("1.00"), currencyPrecision, 4);
        row.getCell("prepareAmount").setValue((Object)preparedBadAmount);
        row.getCell("rush").setValue((Object)preparedBadAmount);
    }

    private void caculateTotalPrepareAmount() {
        int size = this.kdtAccountBadDebtBillAnalysis.getRowCount3();
        BigDecimal totalPatch = ZERO;
        BigDecimal totalRush = ZERO;
        BigDecimal totalPrepareAmount = ZERO;
        for (int i = 0; i < size; ++i) {
            IRow mergeRow = this.kdtAccountBadDebtBillAnalysis.getRow(i);
            if (Boolean.FALSE.equals((Boolean)mergeRow.getCell("checkbox").getValue()) || mergeRow.getCell("checkbox").getMergeBlock() == null) continue;
            int top = mergeRow.getCell("checkbox").getMergeBlock().getTop();
            int bottom = mergeRow.getCell("checkbox").getMergeBlock().getBottom();
            for (int j = top; j <= bottom; ++j) {
                IRow row = this.kdtAccountBadDebtBillAnalysis.getRow(j);
                BigDecimal patch = ZERO;
                BigDecimal rush = ZERO;
                BigDecimal prepareAmount = ZERO;
                if (row.getCell("prepareAmount").getValue() != null) {
                    prepareAmount = new BigDecimal(row.getCell("prepareAmount").getValue().toString());
                    prepareAmount = prepareAmount == null ? BaseDataUtil.ZERO : prepareAmount;
                    totalPrepareAmount = totalPrepareAmount.add(prepareAmount);
                }
                if (row.getCell("patch").getValue() != null) {
                    patch = new BigDecimal(row.getCell("patch").getValue().toString());
                    patch = patch == null ? BaseDataUtil.ZERO : patch;
                    totalPatch = totalPatch.add(patch);
                }
                if (row.getCell("rush").getValue() == null) continue;
                rush = new BigDecimal(row.getCell("rush").getValue().toString());
                rush = rush == null ? BaseDataUtil.ZERO : rush;
                totalRush = totalRush.add(rush);
            }
        }
        this.txtPrepareAmount.setValue((Object)totalPrepareAmount);
        this.txtPatch.setValue((Object)totalPatch);
        this.txtRush.setValue((Object)totalRush);
    }

    @Override
    public void kdtAccountBadDebtBillAnalysis_editValueChanged(KDTEditEvent e) throws Exception {
        super.kdtAccountBadDebtBillAnalysis_editValueChanged(e);
        boolean isSelected = false;
        if (e.getColIndex() == this.kdtAccountBadDebtBillAnalysis.getColumn("checkbox").getColumnIndex()) {
            IRow row = this.kdtAccountBadDebtBillAnalysis.getRow(e.getRowIndex());
            int top = row.getCell("checkbox").getMergeBlock().getTop();
            int bottom = row.getCell("checkbox").getMergeBlock().getBottom();
            if (Boolean.TRUE.equals(e.getValue())) {
                isSelected = true;
            }
            for (int i = top; i <= bottom; ++i) {
                IRow blockRow = this.kdtAccountBadDebtBillAnalysis.getRow(i);
                if (isSelected) {
                    this.cancelPrepareAmount(blockRow, isSelected);
                    continue;
                }
                blockRow.getCell("prepareAmount").setValue((Object)ZERO);
                blockRow.getCell("rush").setValue((Object)ZERO);
                blockRow.getCell("patch").setValue((Object)ZERO);
            }
        }
    }

    @Override
    public void kdtAccountBadDebtBillAnalysis_editStopped(KDTEditEvent e) throws Exception {
        super.kdtAccountBadDebtBillAnalysis_editStopped(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("cu.id"));
        return sic;
    }

    private void caculatePatchRush() {
        BigDecimal totalPrepareBadDebt = this.txtPrepareAmount.getBigDecimalValue();
        BigDecimal badAcctPreBalanceByAnalysis = this.txtYearPrepareAmount.getBigDecimalValue();
        if (totalPrepareBadDebt == null) {
            totalPrepareBadDebt = ZERO;
        }
        if (badAcctPreBalanceByAnalysis == null) {
            badAcctPreBalanceByAnalysis = ZERO;
        }
        if (totalPrepareBadDebt.compareTo(badAcctPreBalanceByAnalysis) >= 0) {
            BigDecimal difference = totalPrepareBadDebt.subtract(badAcctPreBalanceByAnalysis);
            this.txtPatch.setValue((Object)difference);
            this.txtRush.setValue((Object)ZERO);
        } else {
            BigDecimal difference = badAcctPreBalanceByAnalysis.subtract(totalPrepareBadDebt);
            this.txtPatch.setValue((Object)ZERO);
            this.txtRush.setValue((Object)difference);
        }
    }

    private void setBillTableConfig() {
        this.kdtAccountBadDebtBillAnalysis.getGroupManager().setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getGroupManager().group();
        this.kdtAccountBadDebtBillAnalysis.getGroupManager().group();
        this.kdtAccountBadDebtBillAnalysis.getColumn("id").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("checkbox").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("billNumber").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("billDate").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("sourceBillTypeDes").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("asstActTypeName").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("asstActNumber").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("asstActName").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("currencyName").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("adminOrgUnitName").setGroup(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("id").setMergeable(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("checkbox").setMergeable(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("billNumber").setMergeable(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("billDate").setMergeable(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("sourceBillTypeDes").setMergeable(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("asstActTypeName").setMergeable(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("asstActNumber").setMergeable(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("asstActName").setMergeable(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("currencyName").setMergeable(true);
        this.kdtAccountBadDebtBillAnalysis.getColumn("adminOrgUnitName").setMergeable(true);
    }

    private String getFormatString(String currencyID) {
        int precision = 0;
        if (currencyID == null) {
            precision = 2;
        } else {
            CurrencyInfo currencyInfo = this.getCurrency(currencyID);
            if (currencyInfo != null) {
                precision = currencyInfo.getPrecision();
            }
        }
        if (precision == 0) {
            precision = 2;
        }
        return PrecisionFormatUtils.getFormatString(precision);
    }

    private boolean isNeedChecked() throws EASBizException, BOSException {
        boolean arIsRltdAccunt = ArClientUtils.arIsRelatedAccount(this.curCompany);
        boolean glIsStart = CommonClientUtils.glIsStart(this.curCompany);
        return arIsRltdAccunt && glIsStart;
    }

    public String getClientStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)key);
    }
}

