/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebtCustDetail4JoinListUI;
import com.kingdee.eas.fi.ar.client.OtherBillEditUI;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountBadDebtCustDetail4JoinListUI
extends AbstractAccountBadDebtCustDetail4JoinListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountBadDebtCustDetail4JoinListUI.class);

    protected String getKeyFieldName() {
        return super.getKeyFieldName();
    }

    protected String getEditUIName() {
        return OtherBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OtherBillFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectedOtherbillNumber();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)row.getCell("otherbillNumber").getValue().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)row.getCell("company.id").getValue().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        OtherBillCollection coll = OtherBillFactory.getRemoteInstance().getOtherBillCollection(view);
        if (coll.size() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)coll.get(0).getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void onLoad() throws Exception {
        this.setMergeColumn(new String[]{"company.number", "company.name", "number", "customer.number", "customer.name"});
        super.onLoad();
        this.tblMain.getColumn("jtRate").getStyleAttributes().setNumberFormat("%r-[=]{#,##0.00}f");
        boolean isBizDate = false;
        HashMap paramMap = new HashMap();
        paramMap.put("AR_BadDebt_02", SysContext.getSysContext().getCurrentFIUnit().getId());
        paramMap = ArApParamHelper.getParamHashMap(null, paramMap);
        int AR_BadDebt_02 = Integer.valueOf((String)paramMap.get("AR_BadDebt_02"));
        if (AR_BadDebt_02 == 1) {
            isBizDate = true;
        }
        this.tblMain.getHeadRow(0).getCell("recieveData").setValue((Object)this.getStrResource(isBizDate ? "BIZ_DATE" : "AR_DATE"));
        this.rdInvoiceBill.setSelected(true, true);
        this.mainQuery.setFilter(this.getFilterInfo(false));
        this.refreshList();
    }

    private FilterInfo getFilterInfo(Boolean isOtherBill) {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("badDebtNumbers") != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", this.getUIContext().get("badDebtNumbers"), CompareType.INCLUDE));
        }
        if (isOtherBill.booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("billType", (Object)101, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("billType", (Object)101, CompareType.NOTEQUALS));
        }
        return filter;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void setMergeColumn(String[] mergeColumnKeys) {
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    @Override
    protected void rdInvoiceBill_actionPerformed(ActionEvent e) throws Exception {
        this.mainQuery.setFilter(this.getFilterInfo(false));
        this.refreshList();
    }

    @Override
    protected void rdOtherBill_actionPerformed(ActionEvent e) throws Exception {
        this.mainQuery.setFilter(this.getFilterInfo(true));
        this.refreshList();
    }

    private IRow getSelectedOtherbillNumber() {
        int[] selectIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectIndex.length == 0) {
            MsgBox.showWarning((String)this.getStrResource("select_data"));
            SysUtil.abort();
        }
        IRow row = this.tblMain.getRow(selectIndex[0]);
        return row;
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }
}

