/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.AccountBadDebtCustEntryFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtCustEntryInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtCustPrepareFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtCustPrepareInfo;
import com.kingdee.eas.fi.ar.IAccountBadDebtCustEntry;
import com.kingdee.eas.fi.ar.IAccountBadDebtCustPrepare;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebtCustPrepareListUI;
import com.kingdee.eas.fi.ar.client.AccountBadDebtCustPrepareQueryUI;
import com.kingdee.eas.fi.ar.client.VerifyDataFileUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.BillEntryBaseCollection;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AccountBadDebtCustPrepareListUI
extends AbstractAccountBadDebtCustPrepareListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(AccountBadDebtCustPrepareListUI.class);
    private CurrencyInfo currCurrency = null;
    private ICurrency iCurrency = null;
    private AccountBadDebtCustPrepareQueryUI queryUI = null;
    private CommonQueryDialog dialog = null;
    private static final String TB_PREPAREAMOUNT = "prepareAmount";
    private static final String TB_LASTPREPAREAMOUNT = "lastPrepareAmount";
    private IAccountBadDebtCustPrepare iAccountBadDebtCustPrepare = null;
    private File importDataFile = null;
    private PeriodInfo startPeriod = null;
    int totalRow = 0;
    private int maxReturnRowCount = 1000;
    private boolean isPrepareCurrency = false;

    public void onLoad() throws Exception {
        logger.info((Object)"-------onLoad--------");
        this.setMergeColumn();
        this.iCurrency = CurrencyFactory.getRemoteInstance();
        this.initComponet();
        this.actionView.setEnabled(false);
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (currentCompany == null || currentCompany.isIsOnlyUnion()) {
            String message = ArClientUtils.getArStringResource("CompanyIsNull");
            MsgBox.showInfo((String)message);
            SysUtil.abort();
        }
        super.onLoad();
    }

    protected IRow appendFootRow() {
        IRow footRow = null;
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            footRow = footRowManager.getFootRow(0);
        }
        BigDecimal sumPrePareAmount = BigDecimal.ZERO;
        BigDecimal sumLastPrepareAmount = BigDecimal.ZERO;
        BigDecimal prepareAmount = BigDecimal.ZERO;
        BigDecimal lastPrepareAmount = BigDecimal.ZERO;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            prepareAmount = (BigDecimal)row.getCell(TB_PREPAREAMOUNT).getValue();
            lastPrepareAmount = (BigDecimal)row.getCell(TB_LASTPREPAREAMOUNT).getValue();
            if (prepareAmount != null) {
                sumPrePareAmount = sumPrePareAmount.add(prepareAmount);
            }
            if (lastPrepareAmount == null) continue;
            sumLastPrepareAmount = sumLastPrepareAmount.add(lastPrepareAmount);
        }
        HashMap<String, BigDecimal> sumAmount = new HashMap<String, BigDecimal>();
        sumAmount.put(TB_PREPAREAMOUNT, sumPrePareAmount);
        sumAmount.put(TB_LASTPREPAREAMOUNT, sumLastPrepareAmount);
        List<String> fieldSumList = this.getFieldSumList();
        String fieldName = "";
        ICell cell = null;
        String colFormat = "%{0.##########}f";
        int length = fieldSumList.size();
        for (int i = 0; i < length; ++i) {
            fieldName = fieldSumList.get(i);
            cell = footRow.getCell(fieldName);
            cell.getStyleAttributes().setNumberFormat(colFormat);
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            cell.getStyleAttributes().setFontColor(Color.BLACK);
            cell.setValue((Object)this.getFormattedDecimal((BigDecimal)sumAmount.get(fieldName)));
        }
        return footRow;
    }

    private String getFormattedDecimal(BigDecimal value) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(8);
        if (value == null) {
            return "0";
        }
        return numberFormat.format(value.doubleValue());
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        this.appendFootRow();
    }

    public List<String> getFieldSumList() {
        String[] fields = new String[]{TB_PREPAREAMOUNT, TB_LASTPREPAREAMOUNT};
        return Arrays.asList(fields);
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = new String[]{"companyNumber", "companyName"};
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
            this.tblMain.getGroupManager().group();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionView.setEnabled(false);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private void initComponet() {
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnUnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setVisible(false);
        this.btnUnSelectAll.setVisible(false);
        KDFormattedTextField floatDrawing = new KDFormattedTextField((Object)new BigDecimal(String.valueOf("0.0")));
        if (this.currCurrency == null || this.currCurrency.getPrecision() == 0) {
            floatDrawing.setPrecision(2);
        } else {
            floatDrawing.setPrecision(this.currCurrency.getPrecision());
        }
        KDTDefaultCellEditor floatDrawingCellEditor = new KDTDefaultCellEditor((JTextField)floatDrawing);
        String formatString = PrecisionFormatUtils.getFormatString(this.currCurrency);
        this.tblMain.checkParsed();
        this.tblMain.getColumn(TB_PREPAREAMOUNT).setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn(TB_PREPAREAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_PREPAREAMOUNT).getStyleAttributes().setNumberFormat(formatString);
        this.tblMain.getColumn(TB_PREPAREAMOUNT).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(TB_LASTPREPAREAMOUNT).getStyleAttributes().setNumberFormat(formatString);
    }

    protected void initWorkButton() {
        try {
            this.iAccountBadDebtCustPrepare = AccountBadDebtCustPrepareFactory.getRemoteInstance();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnSelectAll);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnUnSelectAll);
        this.btnUnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    private void loadData(Set companyIDSet, String currencyID, String numberFrom, String numberTo, String prepareAmountFlag, boolean needCal) throws Exception {
        this.iAccountBadDebtCustPrepare = AccountBadDebtCustPrepareFactory.getRemoteInstance();
        IRowSet rs = this.iAccountBadDebtCustPrepare.getCustomerPrepareAmount(companyIDSet, currencyID, numberFrom, numberTo, this.maxReturnRowCount, prepareAmountFlag, needCal);
        Set customerSet = this.getAccountBadDebt(companyIDSet, currencyID, numberFrom, numberTo);
        this.tblMain.removeRows();
        this.totalRow = 0;
        BigDecimal totalPrepareAmount = BaseDataUtil.ZERO;
        BigDecimal lastPrepareAmount = BaseDataUtil.ZERO;
        while (rs.next()) {
            ++this.totalRow;
            String customerid = "";
            String companyid = "";
            String currencyid = "";
            IRow row = this.tblMain.addRow();
            row.getCell("companyNumber").setValue((Object)rs.getString("FCompanyNumber"));
            row.getCell("companyName").setValue((Object)rs.getString("FCompanyName"));
            row.getCell("id").setValue((Object)rs.getString("fid"));
            row.getCell("number").setValue((Object)rs.getString("fnumber"));
            row.getCell("name").setValue((Object)rs.getString("fname"));
            customerid = rs.getString("fcustomerid");
            row.getCell("customerid").setValue((Object)customerid);
            row.getCell(TB_PREPAREAMOUNT).setValue((Object)rs.getBigDecimal("FPrepareAmount"));
            totalPrepareAmount = rs.getBigDecimal("FTotalPrepareAmount");
            row.getCell("totalPrepareAmount").setValue((Object)totalPrepareAmount);
            lastPrepareAmount = rs.getBigDecimal("FLastPrepareAmount");
            row.getCell(TB_LASTPREPAREAMOUNT).setValue((Object)lastPrepareAmount);
            companyid = rs.getString("fcompanyid");
            row.getCell("companyid").setValue((Object)companyid);
            currencyid = rs.getString("fcurrencyid");
            row.getCell("currencyid").setValue((Object)currencyid);
            if (customerid == null || companyid == null || currencyid == null || "".equals(customerid) || "".equals(companyid) || "".equals(currencyid)) continue;
            if (customerSet.contains(customerid + currencyid)) {
                row.getCell(TB_PREPAREAMOUNT).getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                row.getCell(TB_PREPAREAMOUNT).getStyleAttributes().setLocked(true);
                continue;
            }
            row.getCell(TB_PREPAREAMOUNT).getStyleAttributes().setLocked(false);
        }
        this.tblMain.setRowCount(this.totalRow);
    }

    private Set getAccountBadDebt(Set companyIDSet, String currencyId, String numFrom, String numTo) throws BOSException {
        IAccountBadDebtCustEntry iEntry = AccountBadDebtCustEntryFactory.getRemoteInstance();
        String companyIDStr = AccountBadDebtCustPrepareListUI.getInStringFromSet(companyIDSet);
        StringBuffer sb = new StringBuffer();
        sb.append("select accountBadDebt.company.id,customer.id,currency.id");
        sb.append(" where accountBadDebt.company.id in");
        sb.append(companyIDStr);
        if (currencyId != null) {
            sb.append(" and currency.id='");
            sb.append(currencyId);
            sb.append("' ");
        }
        if (numFrom != null) {
            sb.append(" and customer.number>='");
            sb.append(numFrom).append("' ");
        }
        if (numTo != null) {
            sb.append(" and customer.number<='");
            sb.append(numTo).append("'");
        }
        BillEntryBaseCollection coll = iEntry.getBillEntryBaseCollection(sb.toString());
        Iterator iter = coll.iterator();
        HashSet<String> keySet = new HashSet<String>();
        while (iter.hasNext()) {
            AccountBadDebtCustEntryInfo entryInfo = (AccountBadDebtCustEntryInfo)iter.next();
            if (entryInfo.getCustomer() == null) continue;
            String customerId = entryInfo.getCustomer().getId().toString();
            String currencyIdTemp = entryInfo.getCurrency().getId().toString();
            keySet.add(customerId + currencyIdTemp);
        }
        return keySet;
    }

    private void setColumnLocked() throws BOSException, EASBizException {
        int size = this.tblMain.getRowCount();
        String customerid = "";
        String companyid = "";
        String currencyid = "";
        IRow row = null;
        HashMap comCusCurMap = new HashMap();
        String key = null;
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("companyid").getValue() != null) {
                companyid = row.getCell("companyid").getValue().toString();
            }
            if (row.getCell("customerid").getValue() != null) {
                customerid = row.getCell("customerid").getValue().toString();
            }
            if (row.getCell("currencyid").getValue() != null) {
                currencyid = row.getCell("currencyid").getValue().toString();
            }
            if (StringUtils.isEmpty((String)companyid) || comCusCurMap.containsKey(key = companyid + customerid + currencyid)) continue;
            ArrayList<String> comCusCurList = new ArrayList<String>();
            comCusCurList.add(companyid);
            comCusCurList.add(customerid);
            comCusCurList.add(currencyid);
            comCusCurMap.put(key, comCusCurList);
        }
        Map valueMap = this.iAccountBadDebtCustPrepare.existPrepareData(comCusCurMap);
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("customerid").getValue() != null) {
                customerid = row.getCell("customerid").getValue().toString();
            }
            if (row.getCell("companyid").getValue() != null) {
                companyid = row.getCell("companyid").getValue().toString();
            }
            if (row.getCell("currencyid").getValue() != null) {
                currencyid = row.getCell("currencyid").getValue().toString();
            }
            if (StringUtils.isEmpty((String)companyid)) continue;
            key = companyid + customerid + currencyid;
            if (valueMap.containsKey(key)) {
                if (!((Boolean)valueMap.get(key)).booleanValue()) continue;
                row.getCell(TB_PREPAREAMOUNT).getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                row.getCell(TB_PREPAREAMOUNT).getStyleAttributes().setLocked(true);
                continue;
            }
            row.getCell(TB_PREPAREAMOUNT).getStyleAttributes().setLocked(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.dialog.setShowFilter(false);
            this.dialog.setShowSorter(false);
            this.dialog.setQueryObjectPK(this.mainQueryPK);
            this.dialog.addUserPanel((KDPanel)new AccountBadDebtCustPrepareQueryUI());
            this.dialog.setHeight(200);
            this.dialog.setWidth(300);
            this.dialog.setTitle(this.getStrResource("customer_init_prepare_amount"));
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        }
        if (this.dialog.show()) {
            this.maxReturnRowCount = this.dialog.getMaxReturnRowCount();
            this.refreshList();
        } else {
            SysUtil.abort();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshList();
    }

    public void refreshList() throws Exception {
        super.refreshList();
        String propertyName = null;
        String compareType = null;
        Object compareValue = null;
        Set<String> companyIDSet = new HashSet<String>();
        String currencyID = null;
        String numberFrom = null;
        String numberTo = null;
        String prepareAmountFlag = null;
        boolean needCal = false;
        this.queryUI = (AccountBadDebtCustPrepareQueryUI)this.dialog.getUserPanel(0);
        FilterInfo filterInfo = this.queryUI.getFilterInfo();
        FilterItemCollection filterItemColl = filterInfo.getFilterItems();
        int size = filterItemColl.size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo filterItemInfo = filterItemColl.get(i);
            propertyName = filterItemInfo.getPropertyName();
            compareType = filterItemInfo.getCompareType().toString();
            compareValue = filterItemInfo.getCompareValue();
            if (propertyName.equals("companyid")) {
                if (compareValue == null) continue;
                if (compareValue instanceof String) {
                    companyIDSet.add(compareValue.toString());
                    continue;
                }
                if (!(compareValue instanceof Set)) continue;
                companyIDSet = (Set)compareValue;
                continue;
            }
            if (propertyName.equals("currencyid")) {
                currencyID = compareValue.toString();
                continue;
            }
            if (propertyName.equals("number") && compareType.equals(">=")) {
                numberFrom = compareValue.toString();
                continue;
            }
            if (propertyName.equals("number") && compareType.equals("<=")) {
                numberTo = compareValue.toString();
                continue;
            }
            if (propertyName.equals("prepareAmountFlag")) {
                prepareAmountFlag = compareValue.toString();
                continue;
            }
            if (!propertyName.equals("needCal")) continue;
            needCal = new Boolean(compareValue.toString());
        }
        this.isPrepareCurrency = currencyID != null;
        this.loadData(companyIDSet, currencyID, numberFrom, numberTo, prepareAmountFlag, needCal);
        if (this.isPrepareCurrency) {
            ObjectUuidPK currencyPK = new ObjectUuidPK(currencyID);
            this.currCurrency = this.iCurrency.getCurrencyInfo((IObjectPK)currencyPK);
        }
        this.setColumnLocked();
        this.setMergeColumn();
        this.appendFootRow();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        String id = "";
        String customerid = "";
        String companyid = "";
        BigDecimal prepareAmount = null;
        String currencyid = "";
        boolean isSave = false;
        ExchangeRateInfo rateInfo = null;
        CustomerInfo customerInfo = null;
        CoreBaseCollection updateColl = new CoreBaseCollection();
        CoreBaseCollection addNewColl = new CoreBaseCollection();
        ArrayList<Integer> rowNum = new ArrayList<Integer>();
        Timestamp now = new Timestamp(new Date().getTime());
        IRow row = null;
        BigDecimal totalPrepareAmount = BaseDataUtil.ZERO;
        HashMap comCusCurMap = new HashMap();
        HashSet<String> companyIdSet = new HashSet<String>();
        HashMap<String, CompanyOrgUnitInfo> cacheCompany = new HashMap<String, CompanyOrgUnitInfo>();
        HashMap<String, BigDecimal> rateCache = new HashMap<String, BigDecimal>();
        String rateCacheKey = null;
        BigDecimal convertRate = BigDecimal.ZERO;
        String key = null;
        for (int i = 0; i < this.totalRow; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("companyid").getValue() != null) {
                companyid = row.getCell("companyid").getValue().toString();
            }
            if (row.getCell("customerid").getValue() != null) {
                customerid = row.getCell("customerid").getValue().toString();
            }
            if (row.getCell("currencyid").getValue() != null) {
                currencyid = row.getCell("currencyid").getValue().toString();
            }
            if (StringUtils.isEmpty((String)companyid)) continue;
            companyIdSet.add(companyid);
            key = companyid + customerid + currencyid;
            if (comCusCurMap.containsKey(key)) continue;
            ArrayList<String> comCusCurList = new ArrayList<String>();
            comCusCurList.add(companyid);
            comCusCurList.add(customerid);
            comCusCurList.add(currencyid);
            comCusCurMap.put(key, comCusCurList);
        }
        if (companyIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                cacheCompany.put(coll.get(i).getId().toString(), coll.get(i));
            }
        }
        Map valueMap = this.iAccountBadDebtCustPrepare.existPrepareData(comCusCurMap);
        for (int i = 0; i < this.totalRow; ++i) {
            id = "";
            row = this.tblMain.getRow(i);
            isSave = true;
            if (row.getCell("companyid").getValue() != null) {
                companyid = row.getCell("companyid").getValue().toString();
            }
            AccountBadDebtCustPrepareInfo info = new AccountBadDebtCustPrepareInfo();
            if (row.getCell("id").getValue() != null) {
                id = row.getCell("id").getValue().toString();
                info.setId(BOSUuid.read((String)id));
            }
            if (row.getCell("customerid").getValue() != null) {
                customerid = row.getCell("customerid").getValue().toString();
                customerInfo = new CustomerInfo();
                customerInfo.setId(BOSUuid.read((String)customerid));
                info.setCustomer(customerInfo);
            }
            if (row.getCell("number").getValue() != null) {
                String customerNumber = row.getCell("number").getValue().toString();
                info.setCustomerNumber(customerNumber);
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = null;
            if (companyid != null) {
                companyOrgUnitInfo = (CompanyOrgUnitInfo)cacheCompany.get(companyid);
                info.setCompany(companyOrgUnitInfo);
                info.setCU(companyOrgUnitInfo.getCU());
            }
            if (companyOrgUnitInfo == null) continue;
            if (row.getCell("currencyid").getValue() != null) {
                currencyid = row.getCell("currencyid").getValue().toString();
            }
            if (this.isPrepareCurrency) {
                info.setCurrency(this.currCurrency);
            } else if (companyOrgUnitInfo != null) {
                info.setCurrency(companyOrgUnitInfo.getBaseCurrency());
            }
            rateCacheKey = companyOrgUnitInfo.getId().toString() + info.getCurrency().getId().toString();
            convertRate = (BigDecimal)rateCache.get(rateCacheKey);
            if (convertRate == null) {
                rateInfo = BaseDataUtil.getExchangeRate(companyOrgUnitInfo, info.getCurrency());
                convertRate = rateInfo != null ? rateInfo.getConvertRate() : new BigDecimal("1.00");
                rateCache.put(rateCacheKey, convertRate);
            }
            info.setExchangeRate(convertRate);
            if (row.getCell(TB_PREPAREAMOUNT).getValue() != null) {
                prepareAmount = new BigDecimal(row.getCell(TB_PREPAREAMOUNT).getValue().toString());
                info.setPrepareAmount(prepareAmount);
                info.setLastPrepareAmount(prepareAmount);
            }
            if (!StringUtils.isEmpty((String)companyid) && valueMap.containsKey(key = companyid + customerid + currencyid) && ((Boolean)valueMap.get(key)).booleanValue()) continue;
            if (!"".equals(id)) {
                info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
                info.setLastUpdateTime(now);
                updateColl.add((CoreBaseInfo)info);
                continue;
            }
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setCreateTime(now);
            addNewColl.add((CoreBaseInfo)info);
            rowNum.add(Integer.valueOf(String.valueOf(i)));
        }
        if (updateColl.size() > 0) {
            this.iAccountBadDebtCustPrepare.updateBatchData(updateColl);
        }
        if (addNewColl.size() > 0) {
            IObjectPK[] pks = this.iAccountBadDebtCustPrepare.addnewBatchData(addNewColl);
            int size = rowNum.size();
            for (int i = 0; i < size; ++i) {
                this.tblMain.getRow(((Integer)rowNum.get(i)).intValue()).getCell("id").setValue((Object)pks[i].toString());
            }
        }
        this.refreshList();
        if (isSave) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
            this.showMessage();
        }
    }

    private void verifyInput() throws Exception {
        if (this.totalRow == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
        IRow row = null;
        String companyid = "";
        String customerid = "";
        String currencyid = "";
        String key = "";
        HashMap comCusCurMap = new HashMap();
        for (int i = 0; i < this.totalRow; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("companyid").getValue() != null) {
                companyid = row.getCell("companyid").getValue().toString();
            }
            if (row.getCell("customerid").getValue() != null) {
                customerid = row.getCell("customerid").getValue().toString();
            }
            if (row.getCell("currencyid").getValue() != null) {
                currencyid = row.getCell("currencyid").getValue().toString();
            }
            if (StringUtils.isEmpty((String)companyid) || comCusCurMap.containsKey(key = companyid + customerid + currencyid)) continue;
            ArrayList<String> comCusCurList = new ArrayList<String>();
            comCusCurList.add(companyid);
            comCusCurList.add(customerid);
            comCusCurList.add(currencyid);
            comCusCurMap.put(key, comCusCurList);
        }
        Map valueMap = this.iAccountBadDebtCustPrepare.existPrepareData(comCusCurMap);
        BigDecimal prepareAmount = BigDecimal.ZERO;
        String customerName = null;
        ArrayList<String> customerNamelist = new ArrayList<String>();
        for (int i = 0; i < this.totalRow; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(TB_PREPAREAMOUNT).getValue() != null) {
                prepareAmount = new BigDecimal(row.getCell(TB_PREPAREAMOUNT).getValue().toString());
            }
            if (row.getCell("name").getValue() != null) {
                customerName = row.getCell("name").getValue().toString();
            }
            if (row.getCell("companyid").getValue() != null) {
                companyid = row.getCell("companyid").getValue().toString();
            }
            if (row.getCell("customerid").getValue() != null) {
                customerid = row.getCell("customerid").getValue().toString();
            }
            if (row.getCell("currencyid").getValue() != null) {
                currencyid = row.getCell("currencyid").getValue().toString();
            }
            if (!(StringUtils.isEmpty((String)companyid) || valueMap.containsKey(key = companyid + customerid + currencyid) || prepareAmount != null && prepareAmount.compareTo(new BigDecimal("0.0")) != 0)) {
                customerNamelist.add(customerName);
            }
            if (prepareAmount.compareTo(new BigDecimal("0.0")) >= 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("bad_prepare_amount"));
            SysUtil.abort();
        }
        if (customerNamelist.size() > 0) {
            String message = ((Object)customerNamelist).toString() + ":" + this.getStrResource("bad_prepare_amount_null");
            int result = MsgBox.showConfirm3a((Component)((Object)this), (String)this.getStrResource("bad_prepare_amount_null_new"), (String)message);
            if (2 == result) {
                SysUtil.abort();
            }
        }
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)currentCompany);
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "AccountBadDebtCustPrepare";
        param.alias = this.getStrResource("CUSTOMER_INIT_BALANCE");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private File getImportFile() throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"selectedFile", (Object)this.importDataFile);
        IUIWindow uiFile = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VerifyDataFileUI.class.getName(), (Map)uiCtx);
        uiFile.show();
        VerifyDataFileUI fileUI = (VerifyDataFileUI)uiFile.getUIObject();
        return fileUI.getSelectedFile();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountBadDebtCustPrepareFactory.getRemoteInstance();
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    public static String getInStringFromSet(Set<String> idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator<String> iter = idSet.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }
}

