/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.bos.workflow.monitor.client.ProcessRunningListUI;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.PrepareOptionMethodEnum;
import com.kingdee.eas.fi.ar.AccountBadDebtBDFacadeFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtBillAnalysisEntryCollection;
import com.kingdee.eas.fi.ar.AccountBadDebtBillAnalysisEntryInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtCollection;
import com.kingdee.eas.fi.ar.AccountBadDebtCustAnalysisEntryCollection;
import com.kingdee.eas.fi.ar.AccountBadDebtCustAnalysisEntryInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtCustDetailFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtException;
import com.kingdee.eas.fi.ar.AccountBadDebtFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtInfo;
import com.kingdee.eas.fi.ar.IAccountBadDebt;
import com.kingdee.eas.fi.ar.IAccountBadDebtBDFacade;
import com.kingdee.eas.fi.ar.IAccountBadDebtCustDetail;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebtListUI;
import com.kingdee.eas.fi.ar.client.AccountBadDebtCustDetail4JoinListUI;
import com.kingdee.eas.fi.ar.client.AccountBadDebtQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class AccountBadDebtListUI
extends AbstractAccountBadDebtListUI {
    private CompanyOrgUnitInfo currentCompany = null;
    private static final String DATE_FORMAT = ArApBillUtil.getDateFormatString();
    private AccountBadDebtQueryUI accountBadDebtQueryUI = null;
    private IAccountBadDebtBDFacade iAccountBadDebtBDFacade = null;
    private ICurrency iCurrency = null;
    private IAccountBadDebt iAccountBadDebt = null;
    private PeriodInfo currPeriod = null;
    private boolean isRelationGL = false;
    private CommonQueryDialog dialog = null;
    private boolean isPrepareCurrency = false;
    private boolean isBillWorkFlow = false;
    private boolean isCustWorkFlow = false;
    private boolean isCustView = false;
    private boolean isBillView = false;
    private boolean iscountAndSumRowshowView = false;
    private PeriodInfo startPeriod = null;
    private String filter = "";
    private PrepareOptionMethodEnum accountType = null;
    LogUtil logUtil = new LogUtil();

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.tblBillAnalysis.putBindContents("mainQuery", new String[]{"id", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""});
        this.tblCustomerAnalysis.putBindContents("mainQuery", new String[]{"id", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""});
    }

    protected String[] getLocateNames() {
        KDTable table = this.getMainTable();
        ArrayList<String> locateNamesList = new ArrayList<String>();
        if (table == this.tblMain) {
            locateNamesList.add("number");
        } else if (table == this.tblCustomerAnalysis) {
            locateNamesList.add("number");
            locateNamesList.add("customerNumber");
            locateNamesList.add("customerName");
        } else if (table == this.tblBillAnalysis) {
            locateNamesList.add("number");
            locateNamesList.add("asstActName");
        }
        String[] locateNames = new String[locateNamesList.size()];
        locateNamesList.toArray(locateNames);
        return locateNames;
    }

    public void onLoad() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
        this.iAccountBadDebtBDFacade = AccountBadDebtBDFacadeFactory.getRemoteInstance();
        this.iCurrency = CurrencyFactory.getRemoteInstance();
        this.iAccountBadDebt = AccountBadDebtFactory.getRemoteInstance();
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
        this.isRelationGL = this.isNeedChecked();
        this.isPrepareCurrency = !CommonClientUtils.isDisplayLocalCurrency();
        this.setTableVisible(PrepareOptionMethodEnum.AnalyseAccountDateMethod);
        Object value = this.getUIContext().get("IDList");
        if (value != null && value instanceof String[] && ((String[])value).length > 0) {
            String[] idList = (String[])value;
            ObjectUuidPK pk = new ObjectUuidPK(idList[0]);
            AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
            if (info.getAccountType().getValue() == 6 || info.getAccountType().getValue() == 7) {
                this.isBillWorkFlow = true;
                this.tblMain = this.tblBillAnalysis;
            } else if (info.getAccountType().getValue() == 5) {
                this.isCustWorkFlow = true;
                this.tblMain = this.tblCustomerAnalysis;
            }
        }
        this.setIsNeedDefaultFilter(true);
        super.onLoad();
        this.tblBillAnalysis.getDataRequestManager().setDataRequestMode(0);
        this.tblCustomerAnalysis.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        if (!this.isBillWorkFlow && !this.isCustWorkFlow) {
            this.setMainTableConfig();
        }
        this.actionEditVouchers.setEnabled(true);
        this.btnEditVouchers.setEnabled(true);
        this.btnAttachment.setVisible(true);
        this.formatTable();
    }

    public void showCountAndSumRow() {
        if (!this.iscountAndSumRowshowView) {
            this.calculateSum();
            this.setMessageBarText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"61_ListUI"));
            int rowList = this.tblMain.getRowCount();
            this.setMessageBarText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ArAllResource", (String)"MatchConditionBillTotal") + rowList + EASResource.getString((String)"com.kingdee.eas.fi.ar.ArAllResource", (String)"Slip"));
            this.iscountAndSumRowshowView = true;
            this.setIsCountAndSumRow(true);
        }
    }

    public void refreshList() throws Exception {
        if (this.isBillWorkFlow) {
            Object value = this.getUIContext().get("IDList");
            if (value != null && value instanceof String[] && ((String[])value).length > 0) {
                String[] idList = (String[])value;
                this.loadBillAnalysis(idList);
                this.tblBillAnalysis.getColumn("checkbox").getStyleAttributes().setWeight(0.0f);
                this.tblBillAnalysis.setVisible(true);
            }
        } else if (this.isCustWorkFlow) {
            Object value = this.getUIContext().get("IDList");
            if (value != null && value instanceof String[] && ((String[])value).length > 0) {
                String[] idList = (String[])value;
                this.loadCustAnalysis(idList);
                this.tblCustomerAnalysis.setVisible(true);
            }
        } else {
            if (this.accountBadDebtQueryUI != null) {
                this.accountType = this.accountBadDebtQueryUI.getAccountType();
                this.setTableVisible(this.accountType);
                this.filter = this.accountBadDebtQueryUI.getFilterInfo().toString();
                FilterInfo commonFilter = this.getCommonFilter();
                if (commonFilter != null) {
                    this.filter = this.filter + ";" + commonFilter.toString();
                }
            }
            if (this.accountType != null && this.accountType.getValue() == 5) {
                this.queryCustomerAnalysis(this.filter);
            } else if (this.accountType != null && (this.accountType.getValue() == 6 || this.accountType.getValue() == 7)) {
                this.queryBillAnalysis(this.filter);
            } else {
                super.refreshList();
                this.setMainTableConfig();
            }
        }
    }

    private void calculateSum() {
        HashMap<String, String> sumMap = new HashMap<String, String>(128);
        BigDecimal prepareAmountSum = BigDecimal.ZERO;
        BigDecimal thisPrepareAmountSum = BigDecimal.ZERO;
        BigDecimal patchSum = BigDecimal.ZERO;
        BigDecimal rushSum = BigDecimal.ZERO;
        BigDecimal balanceSum = BigDecimal.ZERO;
        BigDecimal accountBalanceSum = BigDecimal.ZERO;
        int rowList = this.tblMain.getRowCount();
        for (int i = 0; i < rowList; ++i) {
            IRow iRow = this.tblMain.getRow(i);
            String number = iRow.getCell("number").getValue().toString();
            if (!sumMap.containsKey(number)) {
                if (iRow.getCell("prepareAmount") != null && iRow.getCell("prepareAmount").getValue() != null) {
                    prepareAmountSum = prepareAmountSum.add(new BigDecimal(iRow.getCell("prepareAmount").getValue().toString()));
                }
                if (iRow.getCell("thisPrepareAmount") != null && iRow.getCell("thisPrepareAmount").getValue() != null) {
                    thisPrepareAmountSum = thisPrepareAmountSum.add(new BigDecimal(iRow.getCell("thisPrepareAmount").getValue().toString()));
                }
                if (iRow.getCell("patch") != null && iRow.getCell("patch").getValue() != null) {
                    patchSum = patchSum.add(new BigDecimal(iRow.getCell("patch").getValue().toString()));
                }
                if (iRow.getCell("rush") != null && iRow.getCell("rush").getValue() != null) {
                    rushSum = rushSum.add(new BigDecimal(iRow.getCell("rush").getValue().toString()));
                }
                sumMap.put(number, number);
            }
            if (iRow.getCell("balance") != null && iRow.getCell("balance").getValue() != null) {
                balanceSum = balanceSum.add(new BigDecimal(iRow.getCell("balance").getValue().toString()));
            }
            if (iRow.getCell("accountBalance") == null || iRow.getCell("accountBalance").getValue() == null) continue;
            accountBalanceSum = accountBalanceSum.add(new BigDecimal(iRow.getCell("accountBalance").getValue().toString()));
        }
        IRow footRow = this.tblMain.getFootManager().getFootRow(0);
        String baseCurrPrecision = this.getFormatString();
        footRow.getCell("prepareAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
        footRow.getCell("thisPrepareAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
        footRow.getCell("patch").getStyleAttributes().setNumberFormat(baseCurrPrecision);
        footRow.getCell("rush").getStyleAttributes().setNumberFormat(baseCurrPrecision);
        footRow.getCell("balance").getStyleAttributes().setNumberFormat(baseCurrPrecision);
        footRow.getCell("accountBalance").getStyleAttributes().setNumberFormat(baseCurrPrecision);
        footRow.getCell("prepareAmount").setValue((Object)prepareAmountSum);
        footRow.getCell("thisPrepareAmount").setValue((Object)thisPrepareAmountSum);
        footRow.getCell("patch").setValue((Object)patchSum);
        footRow.getCell("rush").setValue((Object)rushSum);
        footRow.getCell("balance").setValue((Object)balanceSum);
        footRow.getCell("accountBalance").setValue((Object)accountBalanceSum);
    }

    public KDTable getMainTable() {
        if (this.isBillWorkFlow || this.isBillView) {
            return this.tblBillAnalysis;
        }
        if (this.isCustWorkFlow || this.isCustView) {
            return this.tblCustomerAnalysis;
        }
        if (this.accountType != null) {
            if (this.accountType.getValue() == 5) {
                return this.tblCustomerAnalysis;
            }
            if (this.accountType.getValue() == 6 || this.accountType.getValue() == 7) {
                return this.tblBillAnalysis;
            }
            return this.tblMain;
        }
        return this.tblMain;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                AccountBadDebtListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountBadDebtFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    private void formatTable() {
        String baseCurrPrecision = this.getFormatString();
        if (!this.isBillWorkFlow && !this.isCustWorkFlow) {
            this.formatMainTable(baseCurrPrecision);
        }
        this.formatCustomerTable(this.isPrepareCurrency);
        this.formatBillTable(this.isPrepareCurrency, baseCurrPrecision);
    }

    private void formatMainTable(String precision) {
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor check_CellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.tblMain.getColumn("checkbox").setEditor((ICellEditor)check_CellEditor);
        this.tblMain.getColumn("checkbox").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("prepareAmount").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("prepareAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("thisPrepareAmount").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("thisPrepareAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("patch").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("patch").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("rush").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("rush").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accrualRate").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("accrualRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("receiveBalance").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("receiveBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("otherReceiveRate").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("otherReceiveRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("otherReceiveBalance").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("otherReceiveBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("estimateLossSum").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("estimateLossSum").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("balance").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accountPercent").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("accountPercent").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accountBalance").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("accountBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accuralRate").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("accuralRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("saleTotalAmounts").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("saleTotalAmounts").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accuralAmounts").getStyleAttributes().setNumberFormat(precision);
        this.tblMain.getColumn("accuralAmounts").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    private void formatCustomerTable(boolean isPrepareCurrency) {
        this.tblCustomerAnalysis.checkParsed();
        this.tblCustomerAnalysis.getColumn("accountDate").getStyleAttributes().setNumberFormat(DATE_FORMAT);
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor check_CellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.tblCustomerAnalysis.getColumn("checkbox").setEditor((ICellEditor)check_CellEditor);
        int count = this.tblCustomerAnalysis.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if ("checkbox".equals(this.tblCustomerAnalysis.getColumn(i).getKey())) {
                this.tblCustomerAnalysis.getColumn(i).getStyleAttributes().setLocked(false);
                continue;
            }
            this.tblCustomerAnalysis.getColumn(i).getStyleAttributes().setLocked(true);
        }
        if (this.isCustWorkFlow) {
            this.tblCustomerAnalysis.getColumn("checkbox").getStyleAttributes().setHided(true);
        }
        this.tblCustomerAnalysis.getColumn("estimateLossSum").getStyleAttributes().setHided(true);
        this.tblCustomerAnalysis.getColumn("otherReceiveBalanceAmount").getStyleAttributes().setHided(false);
        this.tblCustomerAnalysis.getColumn("prepareAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("preReceiveAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("badPrepareAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("patch").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("rush").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("receiveBalanceAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("accrualRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("otherReceiveBalanceAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("otherReceiveRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("saleRecAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("otherSaleRecAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getColumn("estimateLossSum").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCustomerAnalysis.getSelectManager().setSelectMode(10);
    }

    private void formatBillTable(boolean isPrepareCurrency, String precision) {
        this.tblBillAnalysis.checkParsed();
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor check_CellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.tblBillAnalysis.getColumn("checkbox").setEditor((ICellEditor)check_CellEditor);
        int count = this.tblBillAnalysis.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if ("checkbox".equals(this.tblBillAnalysis.getColumn(i).getKey())) {
                this.tblBillAnalysis.getColumn(i).getStyleAttributes().setLocked(false);
                continue;
            }
            this.tblBillAnalysis.getColumn(i).getStyleAttributes().setLocked(true);
        }
        this.setBillColumnVisible();
        this.tblBillAnalysis.getColumn("recievePayAmountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("verifyAmountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("unVerifyAmountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("lockUnVerifyAmtLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("preparedBadAmountLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("preparedBadAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("prepareRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("prepareAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("patch").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("rush").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBillAnalysis.getColumn("accountDate1").getStyleAttributes().setNumberFormat(DATE_FORMAT);
        this.tblBillAnalysis.getColumn("billDate").getStyleAttributes().setNumberFormat(DATE_FORMAT);
        this.tblBillAnalysis.getSelectManager().setSelectMode(10);
    }

    private void setBillColumnVisible() {
        if (this.isPrepareCurrency) {
            this.tblBillAnalysis.getColumn("recievePayAmount").getStyleAttributes().setHided(false);
            this.tblBillAnalysis.getColumn("verifyAmount").getStyleAttributes().setHided(false);
            this.tblBillAnalysis.getColumn("unVerifyAmount").getStyleAttributes().setHided(false);
            this.tblBillAnalysis.getColumn("lockUnVerifyAmt").getStyleAttributes().setHided(false);
            this.tblBillAnalysis.getColumn("preparedBadAmount").getStyleAttributes().setHided(false);
            this.tblBillAnalysis.getColumn("recievePayAmountLocal").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("verifyAmountLocal").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("unVerifyAmountLocal").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("lockUnVerifyAmtLocal").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("preparedBadAmountLocal").getStyleAttributes().setHided(true);
        } else {
            this.tblBillAnalysis.getColumn("recievePayAmount").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("verifyAmount").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("unVerifyAmount").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("lockUnVerifyAmt").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("preparedBadAmount").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("exchangeRate").getStyleAttributes().setHided(true);
            this.tblBillAnalysis.getColumn("recievePayAmountLocal").getStyleAttributes().setHided(false);
            this.tblBillAnalysis.getColumn("verifyAmountLocal").getStyleAttributes().setHided(false);
            this.tblBillAnalysis.getColumn("unVerifyAmountLocal").getStyleAttributes().setHided(false);
            this.tblBillAnalysis.getColumn("lockUnVerifyAmtLocal").getStyleAttributes().setHided(false);
            this.tblBillAnalysis.getColumn("preparedBadAmountLocal").getStyleAttributes().setHided(false);
        }
    }

    private QueryPanelInfo getQueryPanelInfo(QuerySolutionInfo querySolutionInfo, QueryPanelTypeEnum panelType) {
        QueryPanelCollection queryPanelCollection = querySolutionInfo.getQueryPanelInfo();
        int size = queryPanelCollection.size();
        for (int i = 0; i < size; ++i) {
            QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
            if (!panelType.equals((Object)queryPanelInfo.getQueryPanelType())) continue;
            return queryPanelInfo;
        }
        return null;
    }

    private FilterInfo getCommonFilter() throws ParserException {
        QueryPanelInfo queryPanelInfo;
        QuerySolutionInfo querySolutionInfo = this.getCurrentSolutionInfo();
        FilterInfo commonFilter = null;
        if (querySolutionInfo != null && (queryPanelInfo = this.getQueryPanelInfo(querySolutionInfo, QueryPanelTypeEnum.FILTER_PANEL)) != null && queryPanelInfo.getFilterInfo() != null) {
            commonFilter = new FilterInfo(queryPanelInfo.getFilterInfo());
            if (!StringUtils.isEmpty((String)queryPanelInfo.getMaskString())) {
                commonFilter.setMaskString(queryPanelInfo.getMaskString());
            }
        }
        if (commonFilter != null) {
            int count = commonFilter.getFilterItems().size();
            for (int i = 0; i < count; ++i) {
                commonFilter.getFilterItems().get(i).setPropertyName("F" + commonFilter.getFilterItems().get(i).getPropertyName());
            }
        }
        return commonFilter;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            if (ev == null || ev.getFilter() == null || this.getUIContext().get("BTPNAVCTX") != null) {
                return;
            }
            FilterInfo conditionFilter = new FilterInfo();
            FilterItemInfo tempFilterItem = null;
            FilterItemCollection filterColl = ev.getFilter().getFilterItems();
            for (int i = 0; i < filterColl.size(); ++i) {
                String propertyName = filterColl.get(i).getPropertyName();
                if (!"FAccountType".equalsIgnoreCase(propertyName) && !"AccountType".equalsIgnoreCase(propertyName) && !"FAccountYear".equalsIgnoreCase(propertyName) && !"AccountYear".equalsIgnoreCase(propertyName) && !"company.FID".equalsIgnoreCase(propertyName) && !"companyID".equalsIgnoreCase(propertyName)) continue;
                if ("AccountType".equalsIgnoreCase(propertyName)) {
                    propertyName = "FAccountType";
                }
                tempFilterItem = new FilterItemInfo(propertyName, filterColl.get(i).getCompareValue(), filterColl.get(i).getCompareType());
                conditionFilter.getFilterItems().add(tempFilterItem);
            }
            if (this.isFirstDefaultQuery()) {
                EntityViewInfo ev1 = new EntityViewInfo();
                ev1.setFilter(conditionFilter);
                if (conditionFilter != null) {
                    this.accountBadDebtQueryUI = new AccountBadDebtQueryUI();
                    this.accountBadDebtQueryUI.loadData(ev1);
                    this.accountType = this.accountBadDebtQueryUI.accountTypeEnum;
                    this.setTableVisible(this.accountBadDebtQueryUI.getAccountType());
                    FilterInfo commonFilter = this.getCommonFilter();
                    this.filter = commonFilter != null ? conditionFilter.toString() + ";" + commonFilter.toString() : conditionFilter.toString();
                    if (this.accountType.getValue() == 5) {
                        ev.setFilter(new FilterInfo());
                        this.queryCustomerAnalysis(this.filter);
                    } else if (this.accountType.getValue() == 6 || this.accountType.getValue() == 7) {
                        ev.setFilter(new FilterInfo());
                        this.queryBillAnalysis(this.filter);
                    } else {
                        super.beforeExcutQuery(ev);
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public boolean isSelectForTable() {
        return true;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFirstDefaultQuery()) {
            super.actionQuery_actionPerformed(e);
        } else {
            CommonQueryDialog dialog = this.initCommonQueryDialog();
            if (dialog.show()) {
                FilterInfo conditionFilter = this.accountBadDebtQueryUI.getFilterInfo();
                FilterInfo commonFilter = dialog.getCommonFilter();
                int count = commonFilter.getFilterItems().size();
                for (int i = 0; i < count; ++i) {
                    commonFilter.getFilterItems().get(i).setPropertyName("F" + commonFilter.getFilterItems().get(i).getPropertyName());
                }
                this.filter = conditionFilter.toString() + ";" + commonFilter.toString();
                this.accountType = this.accountBadDebtQueryUI.getAccountType();
                this.setTableVisible(this.accountType);
                if (this.accountBadDebtQueryUI.getAccountType().getValue() == 5) {
                    this.queryCustomerAnalysis(this.filter);
                } else if (this.accountBadDebtQueryUI.getAccountType().getValue() == 6 || this.accountBadDebtQueryUI.getAccountType().getValue() == 7) {
                    this.queryBillAnalysis(this.filter);
                } else {
                    if (this.mainQuery.getSorter() != null) {
                        this.mainQuery.getSorter().clear();
                    }
                    this.mainQuery = this.getEntityViewInfo(dialog.getEntityViewInfoResult());
                    this.refreshList();
                    this.setColumnVisible();
                }
            }
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            if (this.accountBadDebtQueryUI == null) {
                this.accountBadDebtQueryUI = new AccountBadDebtQueryUI();
                this.accountBadDebtQueryUI.onLoad();
            }
            this.dialog.addUserPanel((KDPanel)this.accountBadDebtQueryUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.dialog.setHeight(200);
        this.dialog.setWidth(400);
        this.dialog.setTitle(this.getStrResource("bad_acct_accural_query_condition"));
        return this.dialog;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    protected void initWorkButton() {
        try {
            this.startPeriod = ArClientUtils.getArStartPeriod(this.currentCompany);
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.btnViewVoucher.setEnabled(true);
        this.btnAttachment.setVisible(true);
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnDelVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.btnViewVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.menuItemDelVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.menuItemViewVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.menuItemEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    private void setTableVisible(PrepareOptionMethodEnum accountType) {
        if (this.isBillWorkFlow) {
            this.tblMain.setVisible(false);
            this.tblCustomerAnalysis.setVisible(false);
            this.tblBillAnalysis.setVisible(true);
        } else if (this.isCustWorkFlow) {
            this.tblMain.setVisible(false);
            this.tblCustomerAnalysis.setVisible(true);
            this.tblBillAnalysis.setVisible(false);
        } else if (accountType != null) {
            if (accountType.getValue() == 5) {
                this.tblCustomerAnalysis.setVisible(true);
                this.tblBillAnalysis.setVisible(false);
                this.tblMain.setVisible(false);
                this.appendFootRow(this.tblCustomerAnalysis);
            } else if (accountType.getValue() == 6 || accountType.getValue() == 7) {
                this.tblBillAnalysis.setVisible(true);
                this.tblCustomerAnalysis.setVisible(false);
                this.tblMain.setVisible(false);
                this.appendFootRow(this.tblBillAnalysis);
            } else {
                this.tblMain.setVisible(true);
                this.tblBillAnalysis.setVisible(false);
                this.tblCustomerAnalysis.setVisible(false);
            }
        }
        this.btnViewDetail.setVisible(this.tblCustomerAnalysis.isVisible());
    }

    private void setColumnVisible() throws BOSException, EASBizException {
        String accountType = null;
        if (this.accountBadDebtQueryUI == null) {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = AccountBadDebtListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
            EntityViewInfo ev = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            String main_query = ev.getFilter().toString();
            int pos = main_query.indexOf("accountType = '") + "accountType = '".length();
            String sub_main_query = main_query.substring(pos);
            int pos1 = sub_main_query.indexOf("'");
            accountType = sub_main_query.substring(0, pos1);
        } else if (this.accountBadDebtQueryUI != null) {
            accountType = String.valueOf(this.accountBadDebtQueryUI.getAccountType().getValue());
        }
        if (accountType != null) {
            this.setColumnVisible(accountType);
        } else {
            this.setColumnVisible("1");
        }
    }

    private void setColumnVisible(String accountType) {
        this.tblMain.getColumn("accountName").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("direction").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("balance").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("accountPercent").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("accountBalance").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("accountAge").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("accrualRate").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("receiveBalance").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("otherReceiveRate").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("otherReceiveBalance").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("estimateLossSum").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("saleAccountName").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("accuralRate").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("saleTotalAmounts").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("accuralAmounts").getStyleAttributes().setHided(false);
        if (accountType.equals("2")) {
            this.tblMain.getColumn("accountName").setWidth(0);
            this.tblMain.getColumn("direction").setWidth(0);
            this.tblMain.getColumn("balance").setWidth(0);
            this.tblMain.getColumn("accountPercent").setWidth(0);
            this.tblMain.getColumn("accountBalance").setWidth(0);
            this.tblMain.getColumn("accountAge").setWidth(100);
            this.tblMain.getColumn("accrualRate").setWidth(130);
            this.tblMain.getColumn("receiveBalance").setWidth(130);
            this.tblMain.getColumn("otherReceiveRate").setWidth(140);
            this.tblMain.getColumn("otherReceiveBalance").setWidth(130);
            this.tblMain.getColumn("estimateLossSum").setWidth(130);
            this.tblMain.getColumn("accuralRate").setWidth(0);
            this.tblMain.getColumn("saleTotalAmounts").setWidth(0);
            this.tblMain.getColumn("accuralAmounts").setWidth(0);
            this.tblMain.getColumn("saleAccountName").setWidth(0);
        } else if (accountType.equals("3")) {
            this.tblMain.getColumn("accountName").setWidth(100);
            this.tblMain.getColumn("accountName").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("direction").setWidth(100);
            this.tblMain.getColumn("direction").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("balance").setWidth(100);
            this.tblMain.getColumn("balance").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("accountPercent").setWidth(100);
            this.tblMain.getColumn("accountPercent").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("accountBalance").setWidth(100);
            this.tblMain.getColumn("accountBalance").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("accountAge").setWidth(0);
            this.tblMain.getColumn("accrualRate").setWidth(0);
            this.tblMain.getColumn("receiveBalance").setWidth(0);
            this.tblMain.getColumn("otherReceiveRate").setWidth(0);
            this.tblMain.getColumn("otherReceiveBalance").setWidth(0);
            this.tblMain.getColumn("estimateLossSum").setWidth(0);
            this.tblMain.getColumn("saleAccountName").setWidth(0);
            this.tblMain.getColumn("accuralRate").setWidth(0);
            this.tblMain.getColumn("saleTotalAmounts").setWidth(0);
            this.tblMain.getColumn("accuralAmounts").setWidth(0);
        } else if (accountType.equals("1")) {
            this.tblMain.getColumn("accountName").setWidth(0);
            this.tblMain.getColumn("direction").setWidth(0);
            this.tblMain.getColumn("balance").setWidth(0);
            this.tblMain.getColumn("accountPercent").setWidth(0);
            this.tblMain.getColumn("accountBalance").setWidth(0);
            this.tblMain.getColumn("accountAge").setWidth(0);
            this.tblMain.getColumn("accrualRate").setWidth(0);
            this.tblMain.getColumn("receiveBalance").setWidth(0);
            this.tblMain.getColumn("otherReceiveRate").setWidth(0);
            this.tblMain.getColumn("otherReceiveBalance").setWidth(0);
            this.tblMain.getColumn("estimateLossSum").setWidth(0);
            this.tblMain.getColumn("saleAccountName").setWidth(100);
            this.tblMain.getColumn("accuralRate").setWidth(100);
            this.tblMain.getColumn("saleTotalAmounts").setWidth(100);
            this.tblMain.getColumn("accuralAmounts").setWidth(100);
        }
        this.tblMain.reLayoutAndPaint();
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        this.changeData(e.getFirstRow(), e.getLastRow());
    }

    private void changeData(int beginRow, int endRow) {
        IRow row = null;
        try {
            for (int i = beginRow; i <= endRow; ++i) {
                row = this.tblMain.getRow(i);
                row.getCell("checkbox").setValue((Object)Boolean.FALSE);
                String id = "";
                if (row.getCell("id").getValue() != null) {
                    id = row.getCell("id").getValue().toString();
                }
                if ("".equals(id)) continue;
                ObjectUuidPK pk = new ObjectUuidPK(id);
                AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
                if (info.getAuditor() != null) {
                    row.getCell("billStatusDes").setValue((Object)this.getStrResource("audited"));
                } else {
                    row.getCell("billStatusDes").setValue((Object)this.getStrResource("submited"));
                }
                if (info.isFiVouchered()) {
                    row.getCell("fivouchered").setValue((Object)this.getStrResource("vouchered"));
                    continue;
                }
                row.getCell("fivouchered").setValue((Object)this.getStrResource("unvouchered"));
            }
            if (endRow > 0 && (row = this.tblMain.getRow(0)).getCell("id").getValue() != null) {
                String id = row.getCell("id").getValue().toString();
                AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)new ObjectUuidPK(id));
                this.setColumnVisible(String.valueOf(info.getAccountType().getValue()));
            }
        }
        catch (Exception err) {
            this.handleException(err);
        }
    }

    private void setCustHeaderTitle() {
        IRow headRow = this.tblCustomerAnalysis.getHeadRow(0);
        if (this.isPrepareCurrency) {
            headRow.getCell("receiveBalanceAmount").setValue((Object)this.getStrResource("receiveBalance"));
            headRow.getCell("saleRecAmount").setValue((Object)this.getStrResource("saleRecAmount"));
            headRow.getCell("otherReceiveBalanceAmount").setValue((Object)this.getStrResource("otherReceiveBalance"));
            headRow.getCell("otherSaleRecAmount").setValue((Object)this.getStrResource("saleRecAmount"));
        } else {
            headRow.getCell("receiveBalanceAmount").setValue((Object)this.getStrResource("receiveBalanceLoc"));
            headRow.getCell("saleRecAmount").setValue((Object)this.getStrResource("saleRecAmountLoc"));
            headRow.getCell("otherReceiveBalanceAmount").setValue((Object)this.getStrResource("otherReceiveBalanceLoc"));
            headRow.getCell("otherSaleRecAmount").setValue((Object)this.getStrResource("saleRecAmountLoc"));
        }
    }

    private void loadCustAnalysis(String[] id) throws EASBizException, BOSException, SQLException {
        this.tblCustomerAnalysis.checkParsed();
        this.tblCustomerAnalysis.getViewManager().setFreezeView(0, 6);
        this.tblCustomerAnalysis.removeRows();
        this.tblCustomerAnalysis.getColumn("checkbox").getStyleAttributes().setHided(true);
        int length = id.length;
        for (int i = 0; i < length; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(id[i]);
            AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
            this.loadCustAnalysisInfo(info);
        }
        this.setCustomerAnalysisTableConfig();
    }

    private void queryCustomerAnalysis(String filter) throws EASBizException, BOSException, SQLException {
        String currencyID = null;
        String currPrecision = null;
        String baseCurrPrecision = this.getFormatString();
        this.tblCustomerAnalysis.checkParsed();
        this.tblCustomerAnalysis.getViewManager().setFreezeView(0, 6);
        this.tblCustomerAnalysis.removeRows();
        this.setCustHeaderTitle();
        this.tblCustomerAnalysis.getColumn("estimateLossSum").getStyleAttributes().setHided(true);
        IRowSet rs = this.iAccountBadDebtBDFacade.getCustomerAnalysisDetail(filter);
        HashMap<String, String> sumMap = new HashMap<String, String>(128);
        BigDecimal prepareJTAmountSum = BigDecimal.ZERO;
        BigDecimal preReceiveAmountSum = BigDecimal.ZERO;
        BigDecimal badPrepareAmountSum = BigDecimal.ZERO;
        BigDecimal patchSum = BigDecimal.ZERO;
        BigDecimal rushSum = BigDecimal.ZERO;
        if (this.accountType == null && rs.next()) {
            this.accountType = PrepareOptionMethodEnum.getEnum(Integer.valueOf(rs.getString("FAccountType")));
            rs.previous();
        }
        List<String> fieldList = this.getFieldSumList();
        BigDecimal[] fieldSum = new BigDecimal[fieldList.size()];
        int len = fieldSum.length;
        for (int i = 0; i < len; ++i) {
            fieldSum[i] = BigDecimal.ZERO;
        }
        String customerID = null;
        String companyID = null;
        String key = null;
        while (rs.next()) {
            IRow row = this.tblCustomerAnalysis.addRow();
            row.getCell("id").setValue((Object)rs.getString("FID"));
            row.getCell("checkbox").setValue((Object)Boolean.FALSE);
            row.getCell("companyID").setValue((Object)rs.getString("FCompanyID"));
            row.getCell("companyName").setValue((Object)rs.getString("FCompanyName"));
            row.getCell("number").setValue((Object)rs.getString("FNumber"));
            row.getCell("accountYear").setValue((Object)rs.getString("FAccountYear"));
            row.getCell("accountDate").setValue((Object)rs.getString("FAccountDate"));
            row.getCell("accountType").setValue((Object)Integer.valueOf(rs.getString("FAccountType")));
            PrepareOptionMethodEnum accountTypeEnum = PrepareOptionMethodEnum.getEnum(rs.getInt("FAccountType"));
            row.getCell("accountTypeDes").setValue((Object)accountTypeEnum.getAlias());
            String FAuditorID = rs.getString("FAuditorID");
            if (FAuditorID != null && !"".equals(FAuditorID)) {
                row.getCell("billStatusDes").setValue((Object)this.getStrResource("audited"));
            } else {
                row.getCell("billStatusDes").setValue((Object)this.getStrResource("submited"));
            }
            int ffivoucher = rs.getInt("FFivouchered");
            if (ffivoucher == 1) {
                row.getCell("fivouchered").setValue((Object)this.getStrResource("vouchered"));
            } else {
                row.getCell("fivouchered").setValue((Object)this.getStrResource("unvouchered"));
            }
            row.getCell("voucherType").setValue((Object)rs.getString("FVoucherTypeName"));
            row.getCell("voucherNumber").setValue((Object)rs.getString("FVoucherNumber"));
            currencyID = rs.getString("FCurrencyID");
            row.getCell("currencyID").setValue((Object)currencyID);
            row.getCell("currencyName").setValue((Object)rs.getString("FCurrencyName"));
            row.getCell("customerID").setValue((Object)rs.getString("FCustomerID"));
            row.getCell("customerNumber").setValue((Object)rs.getString("FCustomerNumber"));
            row.getCell("customerName").setValue((Object)rs.getString("FCustomerName"));
            row.getCell("prepareAmount").setValue((Object)rs.getBigDecimal("FPrepareAmount"));
            row.getCell("preReceiveAmount").setValue((Object)rs.getBigDecimal("FPreReceiveAmount"));
            row.getCell("badPrepareAmount").setValue((Object)rs.getBigDecimal("FBadPrepareAmount"));
            row.getCell("patch").setValue((Object)rs.getBigDecimal("FPatch"));
            row.getCell("rush").setValue((Object)rs.getBigDecimal("FRush"));
            row.getCell("accountAge").setValue((Object)rs.getString("FAccountAge"));
            row.getCell("accountDays").setValue((Object)Integer.valueOf(rs.getString("FAccountDays")));
            row.getCell("receiveBalanceAmount").setValue((Object)rs.getBigDecimal("FReceiveBalance"));
            row.getCell("otherReceiveBalanceAmount").setValue((Object)rs.getBigDecimal("FOtherReceiveBalance"));
            row.getCell("estimateLossSum").setValue((Object)rs.getBigDecimal("FEstimateLossSum"));
            row.getCell("saleRecAmount").setValue((Object)rs.getBigDecimal("FSaleRecAmount"));
            row.getCell("otherSaleRecAmount").setValue((Object)rs.getBigDecimal("FOtherSaleRecAmount"));
            row.getCell("accrualRate").setValue((Object)rs.getBigDecimal("FAccrualRate"));
            row.getCell("otherReceiveRate").setValue((Object)rs.getBigDecimal("FOtherReceiveRate"));
            row.getCell("exchangeRate").setValue((Object)rs.getBigDecimal("FExchangeRate"));
            if (this.isPrepareCurrency) {
                currPrecision = this.getFormatString(true, currencyID);
                row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("preReceiveAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("badPrepareAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("patch").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("rush").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("receiveBalanceAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("accrualRate").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("otherReceiveBalanceAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("saleRecAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("otherSaleRecAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("otherReceiveRate").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("estimateLossSum").getStyleAttributes().setNumberFormat(currPrecision);
            } else {
                row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("preReceiveAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("badPrepareAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("patch").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("rush").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("accrualRate").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("receiveBalanceAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("otherReceiveRate").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("otherReceiveBalanceAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("saleRecAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
                row.getCell("otherSaleRecAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            }
            customerID = rs.getString("FCustomerID");
            companyID = rs.getString("FCompanyID");
            key = new StringBuilder(50).append(customerID).append("_").append(companyID).toString();
            if (!sumMap.containsKey(key)) {
                prepareJTAmountSum = prepareJTAmountSum.add(rs.getBigDecimal("FPrepareAmount"));
                preReceiveAmountSum = preReceiveAmountSum.add(rs.getBigDecimal("FPreReceiveAmount"));
                badPrepareAmountSum = badPrepareAmountSum.add(rs.getBigDecimal("FBadPrepareAmount"));
                patchSum = patchSum.add(rs.getBigDecimal("FPatch"));
                rushSum = rushSum.add(rs.getBigDecimal("FRush"));
                sumMap.put(key, key);
            }
            int len2 = fieldSum.length;
            for (int i = 0; i < len2; ++i) {
                fieldSum[i] = fieldSum[i].add((BigDecimal)row.getCell(fieldList.get(i)).getValue());
            }
        }
        IRow footRow = this.tblCustomerAnalysis.getFootManager().getFootRow(0);
        int len3 = fieldSum.length;
        for (int i = 0; i < len3; ++i) {
            footRow.getCell(fieldList.get(i)).setValue((Object)fieldSum[i]);
        }
        footRow.getCell("prepareAmount").setValue((Object)prepareJTAmountSum);
        footRow.getCell("preReceiveAmount").setValue((Object)preReceiveAmountSum);
        footRow.getCell("badPrepareAmount").setValue((Object)badPrepareAmountSum);
        footRow.getCell("patch").setValue((Object)patchSum);
        footRow.getCell("rush").setValue((Object)rushSum);
        this.setCustomerAnalysisTableConfig();
    }

    @Override
    public void tblCustomerAnalysis_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblCustomerAnalysis_editValueChanged(e);
        if (e.getColIndex() == this.tblCustomerAnalysis.getColumn("checkbox").getColumnIndex()) {
            IRow selectRow = this.tblCustomerAnalysis.getRow(e.getRowIndex());
            Boolean selected = (Boolean)e.getValue();
            if (selectRow.getCell("checkbox").getMergeBlock() == null) {
                return;
            }
            int top = selectRow.getCell("checkbox").getMergeBlock().getTop();
            int bottom = selectRow.getCell("checkbox").getMergeBlock().getBottom();
            for (int i = top; i <= bottom; ++i) {
                IRow row = this.tblCustomerAnalysis.getRow(i);
                row.getCell("checkbox").setValue((Object)selected);
            }
        }
    }

    @Override
    public void tblBillAnalysis_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblBillAnalysis_editValueChanged(e);
    }

    @Override
    public void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
    }

    private void loadBillAnalysis(String[] id) throws EASBizException, BOSException, SQLException {
        String currencyID = null;
        String precision = null;
        this.tblBillAnalysis.checkParsed();
        this.tblBillAnalysis.getViewManager().setFreezeView(0, 14);
        this.tblBillAnalysis.removeRows();
        this.setBillColumnVisible();
        String basePrecision = this.getBaseCurrencyPrecision();
        int length = id.length;
        for (int i = 0; i < length; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(id[i]);
            AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
            AccountBadDebtBillAnalysisEntryCollection billCollection = info.getBillAnalysisEntry();
            int size = billCollection.size();
            for (int j = 0; j < size; ++j) {
                AccountBadDebtBillAnalysisEntryInfo entryInfo = billCollection.get(j);
                IRow row = this.tblBillAnalysis.addRow();
                row.getCell("id").setValue((Object)info.getId().toString());
                row.getCell("checkbox").setValue((Object)Boolean.FALSE);
                row.getCell("companyID").setValue((Object)info.getCompany().getId().toString());
                row.getCell("companyName").setValue((Object)info.getCompany().getName());
                row.getCell("number").setValue((Object)info.getNumber());
                row.getCell("accountYear").setValue((Object)String.valueOf(info.getAccountYear()));
                row.getCell("accountDate").setValue((Object)info.getAccountDate());
                row.getCell("accountType").setValue((Object)Integer.valueOf(String.valueOf(info.getAccountType().getValue())));
                PrepareOptionMethodEnum accountTypeEnum = PrepareOptionMethodEnum.getEnum(info.getAccountType().getValue());
                row.getCell("accountTypeDes").setValue((Object)accountTypeEnum.getAlias());
                String FAuditorID = "";
                if (info.getAuditor() != null) {
                    FAuditorID = info.getAuditor().getId().toString();
                }
                if (FAuditorID != null && !"".equals(FAuditorID)) {
                    row.getCell("billStatusDes").setValue((Object)this.getStrResource("audited"));
                } else {
                    row.getCell("billStatusDes").setValue((Object)this.getStrResource("submited"));
                }
                if (info.isFiVouchered()) {
                    row.getCell("fivouchered").setValue((Object)this.getStrResource("vouchered"));
                } else {
                    row.getCell("fivouchered").setValue((Object)this.getStrResource("unvouchered"));
                }
                row.getCell("billID").setValue((Object)entryInfo.getBillID());
                row.getCell("billNumber").setValue((Object)entryInfo.getBillNumber());
                row.getCell("billDate").setValue((Object)entryInfo.getBillDate());
                row.getCell("sourceBillType").setValue((Object)OtherBillTypeEnum.getEnum((int)entryInfo.getSourceBillType()));
                row.getCell("asstActType").setValue((Object)entryInfo.getAsstActType().getName());
                row.getCell("asstActName").setValue((Object)entryInfo.getAsstActName());
                currencyID = info.getCurrency().getId().toString();
                row.getCell("currencyID").setValue((Object)currencyID);
                row.getCell("currencyName").setValue((Object)info.getCurrency().getName());
                precision = this.getFormatString(true, currencyID);
                row.getCell("exchangeRate").setValue((Object)entryInfo.getExchangeRate());
                if (entryInfo.getAdminOrgUnit() != null) {
                    row.getCell("adminOrgUnit").setValue((Object)entryInfo.getAdminOrgUnit().getName());
                }
                row.getCell("entryID").setValue((Object)entryInfo.getEntryID());
                row.getCell("entrySeq").setValue((Object)String.valueOf(entryInfo.getEntrySeq()));
                row.getCell("recievePayAmount").setValue((Object)entryInfo.getRecievePayAmount());
                row.getCell("recievePayAmountLocal").setValue((Object)entryInfo.getRecievePayAmountLocal());
                row.getCell("verifyAmount").setValue((Object)entryInfo.getVerifyAmount());
                row.getCell("verifyAmountLocal").setValue((Object)entryInfo.getVerifyAmountLocal());
                row.getCell("unVerifyAmount").setValue((Object)entryInfo.getUnVerifyAmount());
                row.getCell("unVerifyAmountLocal").setValue((Object)entryInfo.getUnVerifyAmountLocal());
                row.getCell("lockUnVerifyAmt").setValue((Object)entryInfo.getLockUnVerifyAmt());
                row.getCell("lockUnVerifyAmtLocal").setValue((Object)entryInfo.getLockUnVerifyAmtLocal());
                row.getCell("preparedBadAmount").setValue((Object)entryInfo.getPreparedBadAmount());
                row.getCell("preparedBadAmountLocal").setValue((Object)entryInfo.getPreparedBadAmountLocal());
                row.getCell("prepareRate").setValue((Object)entryInfo.getPrepareRate());
                row.getCell("prepareAmount").setValue((Object)entryInfo.getPrepareAmount());
                row.getCell("patch").setValue((Object)info.getPatch());
                row.getCell("rush").setValue((Object)info.getRush());
                row.getCell("recievePayAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("preparedBadAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("verifyAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("unVerifyAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("lockUnVerifyAmt").getStyleAttributes().setNumberFormat(precision);
                row.getCell("recievePayAmountLocal").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("preparedBadAmountLocal").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("verifyAmountLocal").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("unVerifyAmountLocal").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("lockUnVerifyAmtLocal").getStyleAttributes().setNumberFormat(basePrecision);
                if (this.isPrepareCurrency) {
                    row.getCell("exchangeRate").getStyleAttributes().setNumberFormat(precision);
                    row.getCell("prepareRate").getStyleAttributes().setNumberFormat(precision);
                    row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(precision);
                    row.getCell("patch").getStyleAttributes().setNumberFormat(precision);
                    row.getCell("rush").getStyleAttributes().setNumberFormat(precision);
                    continue;
                }
                row.getCell("prepareRate").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("patch").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("rush").getStyleAttributes().setNumberFormat(basePrecision);
            }
        }
        this.tblBillAnalysis.getColumn("checkbox").getStyleAttributes().setHided(true);
        this.setBillAnalysisTableConfig();
    }

    private void loadCustAnalysisInfo(AccountBadDebtInfo info) throws EASBizException, BOSException, SQLException {
        String baseCurrPrecision = this.getFormatString();
        String currPrecision = "";
        AccountBadDebtCustAnalysisEntryCollection custColl = info.getCustAnalysisEntry();
        int size = custColl.size();
        for (int i = 0; i < size; ++i) {
            AccountBadDebtCustAnalysisEntryInfo entryInfo = custColl.get(i);
            IRow row = this.tblCustomerAnalysis.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("checkbox").setValue((Object)Boolean.FALSE);
            row.getCell("companyID").setValue((Object)info.getCompany().getId().toString());
            row.getCell("companyName").setValue((Object)info.getCompany().getName());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("accountYear").setValue((Object)String.valueOf(info.getAccountYear()));
            row.getCell("accountDate").setValue((Object)info.getAccountDate());
            row.getCell("accountType").setValue((Object)String.valueOf((Object)info.getAccountType()));
            PrepareOptionMethodEnum accountTypeEnum = PrepareOptionMethodEnum.getEnum(info.getAccountType().getValue());
            row.getCell("accountTypeDes").setValue((Object)accountTypeEnum.getAlias());
            String auditorID = null;
            if (info.getAuditor() != null) {
                auditorID = info.getAuditor().getId().toString();
            }
            if (auditorID != null && !"".equals(auditorID)) {
                row.getCell("billStatusDes").setValue((Object)this.getStrResource("audited"));
            } else {
                row.getCell("billStatusDes").setValue((Object)this.getStrResource("submited"));
            }
            boolean ffivoucher = info.isFiVouchered();
            if (ffivoucher) {
                row.getCell("fivouchered").setValue((Object)this.getStrResource("vouchered"));
            } else {
                row.getCell("fivouchered").setValue((Object)this.getStrResource("unvouchered"));
            }
            String currencyID = info.getCurrency().getId().toString();
            row.getCell("currencyID").setValue((Object)currencyID);
            row.getCell("currencyName").setValue((Object)info.getCurrency().getName());
            row.getCell("customerID").setValue((Object)entryInfo.getCustomer().getId().toString());
            row.getCell("customerNumber").setValue((Object)entryInfo.getCustomer().getNumber());
            row.getCell("customerName").setValue((Object)entryInfo.getCustomer().getName());
            row.getCell("prepareAmount").setValue((Object)entryInfo.getPrepareAmount());
            row.getCell("preReceiveAmount").setValue((Object)entryInfo.getPreReceiveAmount());
            row.getCell("badPrepareAmount").setValue((Object)entryInfo.getBadPrepareAmount());
            row.getCell("patch").setValue((Object)entryInfo.getPatch());
            row.getCell("rush").setValue((Object)entryInfo.getRush());
            row.getCell("accountAge").setValue((Object)entryInfo.getAccountAge());
            row.getCell("accountDays").setValue((Object)String.valueOf(entryInfo.getAccountDays()));
            row.getCell("receiveBalanceAmount").setValue((Object)entryInfo.getReceiveBalance());
            row.getCell("otherReceiveBalanceAmount").setValue((Object)entryInfo.getOtherReceiveBalance());
            row.getCell("estimateLossSum").setValue((Object)entryInfo.getEstimateLossSum());
            row.getCell("saleRecAmount").setValue((Object)entryInfo.getSaleRecAmount());
            row.getCell("otherSaleRecAmount").setValue((Object)entryInfo.getOtherSaleRecAmount());
            row.getCell("accrualRate").setValue((Object)entryInfo.getAccrualRate());
            row.getCell("otherReceiveRate").setValue((Object)entryInfo.getOtherReceiveRate());
            row.getCell("exchangeRate").setValue((Object)entryInfo.getExchangeRate());
            if (this.isPrepareCurrency) {
                currPrecision = this.getFormatString(true, currencyID);
                row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("preReceiveAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("badPrepareAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("patch").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("rush").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("receiveBalanceAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("accrualRate").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("otherReceiveBalanceAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("saleRecAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("otherSaleRecAmount").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("otherReceiveRate").getStyleAttributes().setNumberFormat(currPrecision);
                row.getCell("estimateLossSum").getStyleAttributes().setNumberFormat(currPrecision);
                continue;
            }
            row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("preReceiveAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("badPrepareAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("patch").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("rush").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("accrualRate").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("receiveBalanceAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("otherReceiveRate").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("otherReceiveBalanceAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("saleRecAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
            row.getCell("otherSaleRecAmount").getStyleAttributes().setNumberFormat(baseCurrPrecision);
        }
    }

    private void queryBillAnalysis(String filter) throws EASBizException, BOSException, SQLException {
        String currencyID = null;
        String precision = null;
        this.tblBillAnalysis.checkParsed();
        this.setBillColumnVisible();
        this.tblBillAnalysis.getViewManager().setFreezeView(0, 12);
        this.tblBillAnalysis.removeRows();
        String basePrecision = this.getBaseCurrencyPrecision();
        IRowSet rs = this.iAccountBadDebtBDFacade.getBillAnalysisDetail(filter);
        List<String> fieldList = this.getFieldSumList();
        BigDecimal[] fieldSum = new BigDecimal[fieldList.size()];
        int len = fieldSum.length;
        for (int i = 0; i < len; ++i) {
            fieldSum[i] = BigDecimal.ZERO;
        }
        while (rs.next()) {
            IRow row = this.tblBillAnalysis.addRow();
            row.getCell("id").setValue((Object)rs.getString("FID"));
            row.getCell("checkbox").setValue((Object)Boolean.FALSE);
            row.getCell("companyID").setValue((Object)rs.getString("FCompanyID"));
            row.getCell("companyName").setValue((Object)rs.getString("FCompanyName"));
            row.getCell("number").setValue((Object)rs.getString("FNumber"));
            row.getCell("accountYear").setValue((Object)rs.getString("FAccountYear"));
            row.getCell("accountDate1").setValue((Object)rs.getDate("FAccountDate"));
            row.getCell("accountType").setValue((Object)Integer.valueOf(rs.getString("FAccountType")));
            PrepareOptionMethodEnum accountTypeEnum = PrepareOptionMethodEnum.getEnum(rs.getInt("FAccountType"));
            row.getCell("accountTypeDes").setValue((Object)accountTypeEnum.getAlias());
            String FAuditorID = rs.getString("FAuditorID");
            if (FAuditorID != null && !"".equals(FAuditorID)) {
                row.getCell("billStatusDes").setValue((Object)this.getStrResource("audited"));
            } else {
                row.getCell("billStatusDes").setValue((Object)this.getStrResource("submited"));
            }
            int ffivoucher = rs.getInt("FFivouchered");
            if (ffivoucher == 1) {
                row.getCell("fivouchered").setValue((Object)this.getStrResource("vouchered"));
            } else {
                row.getCell("fivouchered").setValue((Object)this.getStrResource("unvouchered"));
            }
            row.getCell("voucherType").setValue((Object)rs.getString("FVoucherTypeName"));
            row.getCell("voucherNumber").setValue((Object)rs.getString("FVoucherNumber"));
            row.getCell("billID").setValue((Object)rs.getString("FBillID"));
            row.getCell("billNumber").setValue((Object)rs.getString("FBillNumber"));
            row.getCell("billDate").setValue((Object)rs.getString("FBillDate"));
            if (rs.getString("FSourceBillType") != null) {
                row.getCell("sourceBillType").setValue((Object)OtherBillTypeEnum.getEnum((int)rs.getInt("FSourceBillType")));
            }
            row.getCell("abstractName").setValue((Object)rs.getString("FAbstractName"));
            row.getCell("asstActType").setValue((Object)rs.getString("FAsstActType"));
            row.getCell("asstActName").setValue((Object)rs.getString("FAsstActName"));
            row.getCell("billNumber").setValue((Object)rs.getString("FBillNumber"));
            currencyID = rs.getString("FCurrencyID");
            row.getCell("currencyID").setValue((Object)currencyID);
            row.getCell("currencyName").setValue((Object)rs.getString("FCurrencyName"));
            precision = this.getFormatString(true, currencyID);
            row.getCell("exchangeRate").setValue((Object)rs.getBigDecimal("FExchangeRate"));
            row.getCell("adminOrgUnit").setValue((Object)rs.getString("FAdminOrgUnit"));
            row.getCell("saleOrgUnit").setValue((Object)rs.getString("FSaleOrg"));
            row.getCell("person").setValue((Object)rs.getString("FPerson"));
            row.getCell("entryID").setValue((Object)rs.getString("FEntryID"));
            row.getCell("entrySeq").setValue((Object)Integer.valueOf(rs.getString("FEntrySeq")));
            row.getCell("recievePayAmount").setValue((Object)rs.getBigDecimal("FRecievePayAmount"));
            row.getCell("recievePayAmountLocal").setValue((Object)rs.getBigDecimal("FRecievePayAmountLocal"));
            row.getCell("verifyAmount").setValue((Object)rs.getBigDecimal("FVerifyAmount"));
            row.getCell("verifyAmountLocal").setValue((Object)rs.getBigDecimal("FVerifyAmountLocal"));
            row.getCell("unVerifyAmount").setValue((Object)rs.getBigDecimal("FUnVerifyAmount"));
            row.getCell("unVerifyAmountLocal").setValue((Object)rs.getBigDecimal("FUnVerifyAmountLocal"));
            row.getCell("lockUnVerifyAmt").setValue((Object)rs.getBigDecimal("FLockUnVerifyAmt"));
            row.getCell("lockUnVerifyAmtLocal").setValue((Object)rs.getBigDecimal("FLockUnVerifyAmtLocal"));
            row.getCell("preparedBadAmount").setValue((Object)rs.getBigDecimal("FPreparedBadAmount"));
            row.getCell("preparedBadAmountLocal").setValue((Object)rs.getBigDecimal("FPreparedBadAmountLocal"));
            row.getCell("prepareRate").setValue((Object)rs.getBigDecimal("FPrepareRate"));
            row.getCell("prepareAmount").setValue((Object)rs.getBigDecimal("FPrepareAmount"));
            row.getCell("patch").setValue((Object)rs.getBigDecimal("FPatch"));
            row.getCell("rush").setValue((Object)rs.getBigDecimal("FRush"));
            if (this.isPrepareCurrency) {
                row.getCell("recievePayAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("verifyAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("unVerifyAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("lockUnVerifyAmt").getStyleAttributes().setNumberFormat(precision);
                row.getCell("exchangeRate").getStyleAttributes().setNumberFormat(precision);
                row.getCell("preparedBadAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("preparedBadAmountLocal").getStyleAttributes().setNumberFormat(precision);
                row.getCell("prepareRate").getStyleAttributes().setNumberFormat(precision);
                row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("patch").getStyleAttributes().setNumberFormat(precision);
                row.getCell("rush").getStyleAttributes().setNumberFormat(precision);
            } else {
                row.getCell("recievePayAmountLocal").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("verifyAmountLocal").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("unVerifyAmountLocal").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("lockUnVerifyAmtLocal").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("preparedBadAmount").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("preparedBadAmountLocal").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("prepareRate").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("patch").getStyleAttributes().setNumberFormat(basePrecision);
                row.getCell("rush").getStyleAttributes().setNumberFormat(basePrecision);
            }
            int len2 = fieldSum.length;
            for (int i = 0; i < len2; ++i) {
                fieldSum[i] = fieldSum[i].add((BigDecimal)row.getCell(fieldList.get(i)).getValue());
            }
        }
        IRow footRow = this.tblBillAnalysis.getFootManager().getFootRow(0);
        int len3 = fieldSum.length;
        for (int i = 0; i < len3; ++i) {
            footRow.getCell(fieldList.get(i)).setValue((Object)fieldSum[i]);
        }
        this.setBillAnalysisTableConfig();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.menuItemImportData.setVisible(false);
        this.tblBillAnalysis.getColumn("billStatusDes").getStyleAttributes().setHided(false);
        if (this.getUIContext().get("BTPNAVCTX") != null) {
            EntityViewInfo botpView = (EntityViewInfo)this.getUIContext().get("BOTPFilter");
            botpView.getSelector().add(new SelectorItemInfo("accountType"));
            AccountBadDebtCollection coll = AccountBadDebtFactory.getRemoteInstance().getAccountBadDebtCollection(botpView);
            if (coll != null && coll.size() > 0) {
                this.accountType = coll.get(0).getAccountType();
                this.setTableVisible(this.accountType);
                if (5 == this.accountType.getValue()) {
                    this.queryCustomerAnalysis(botpView.getFilter().toSql().replaceAll("id", "accountBadDebt.fid"));
                    this.isCustView = true;
                } else if (6 == this.accountType.getValue() || 7 == this.accountType.getValue()) {
                    this.queryBillAnalysis(botpView.getFilter().toSql().replaceAll("id", "accountBadDebt.fid"));
                    this.isBillView = true;
                }
            }
        }
    }

    public void setMainTableConfig() {
        this.tblMain.getColumn("id").setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("checkbox").setGroup(true);
        this.tblMain.getColumn("companyName").setGroup(true);
        this.tblMain.getColumn("accountYear").setGroup(true);
        this.tblMain.getColumn("accountDate").setGroup(true);
        this.tblMain.getColumn("accountType").setGroup(true);
        this.tblMain.getColumn("billStatusDes").setGroup(true);
        this.tblMain.getColumn("fivouchered").setGroup(true);
        this.tblMain.getColumn("voucherType").setGroup(true);
        this.tblMain.getColumn("voucherNumber").setGroup(true);
        this.tblMain.getColumn("prepareAmount").setGroup(true);
        this.tblMain.getColumn("thisPrepareAmount").setGroup(true);
        this.tblMain.getColumn("patch").setGroup(true);
        this.tblMain.getColumn("rush").setGroup(true);
        this.tblMain.getColumn("currencyName").setGroup(true);
        this.tblMain.getColumn("id").setMergeable(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("checkbox").setMergeable(true);
        this.tblMain.getColumn("companyName").setMergeable(true);
        this.tblMain.getColumn("accountYear").setMergeable(true);
        this.tblMain.getColumn("accountDate").setMergeable(true);
        this.tblMain.getColumn("accountType").setMergeable(true);
        this.tblMain.getColumn("billStatusDes").setMergeable(true);
        this.tblMain.getColumn("fivouchered").setMergeable(true);
        this.tblMain.getColumn("voucherType").setMergeable(true);
        this.tblMain.getColumn("voucherNumber").setMergeable(true);
        this.tblMain.getColumn("prepareAmount").setMergeable(true);
        this.tblMain.getColumn("thisPrepareAmount").setMergeable(true);
        this.tblMain.getColumn("patch").setMergeable(true);
        this.tblMain.getColumn("rush").setMergeable(true);
        this.tblMain.getColumn("currencyName").setMergeable(true);
        this.tblMain.getGroupManager().group();
    }

    public void setCustomerAnalysisTableConfig() {
        this.tblCustomerAnalysis.getGroupManager().setGroup(true);
        this.tblCustomerAnalysis.getColumn("id").setGroup(true);
        this.tblCustomerAnalysis.getColumn("checkbox").setGroup(true);
        this.tblCustomerAnalysis.getColumn("companyID").setGroup(true);
        this.tblCustomerAnalysis.getColumn("companyName").setGroup(true);
        this.tblCustomerAnalysis.getColumn("number").setGroup(true);
        this.tblCustomerAnalysis.getColumn("accountYear").setGroup(true);
        this.tblCustomerAnalysis.getColumn("accountDate").setGroup(true);
        this.tblCustomerAnalysis.getColumn("accountTypeDes").setGroup(true);
        this.tblCustomerAnalysis.getColumn("billStatusDes").setGroup(true);
        this.tblCustomerAnalysis.getColumn("fivouchered").setGroup(true);
        this.tblCustomerAnalysis.getColumn("voucherType").setGroup(true);
        this.tblCustomerAnalysis.getColumn("voucherNumber").setGroup(true);
        this.tblCustomerAnalysis.getColumn("currencyName").setGroup(true);
        this.tblCustomerAnalysis.getColumn("customerNumber").setGroup(true);
        this.tblCustomerAnalysis.getColumn("customerName").setGroup(true);
        this.tblCustomerAnalysis.getColumn("prepareAmount").setGroup(true);
        this.tblCustomerAnalysis.getColumn("preReceiveAmount").setGroup(true);
        this.tblCustomerAnalysis.getColumn("badPrepareAmount").setGroup(true);
        this.tblCustomerAnalysis.getColumn("patch").setGroup(true);
        this.tblCustomerAnalysis.getColumn("rush").setGroup(true);
        this.tblCustomerAnalysis.getColumn("id").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("checkbox").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("companyID").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("companyName").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("number").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("accountYear").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("accountDate").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("accountTypeDes").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("billStatusDes").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("fivouchered").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("voucherType").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("voucherNumber").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("currencyName").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("customerNumber").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("customerName").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("prepareAmount").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("preReceiveAmount").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("badPrepareAmount").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("patch").setMergeable(true);
        this.tblCustomerAnalysis.getColumn("rush").setMergeable(true);
        this.tblCustomerAnalysis.getGroupManager().group();
    }

    public void setBillAnalysisTableConfig() {
        this.tblBillAnalysis.getGroupManager().setGroup(true);
        this.tblBillAnalysis.getColumn("id").setGroup(true);
        this.tblBillAnalysis.getColumn("checkbox").setGroup(true);
        this.tblBillAnalysis.getColumn("companyName").setGroup(true);
        this.tblBillAnalysis.getColumn("number").setGroup(true);
        this.tblBillAnalysis.getColumn("accountYear").setGroup(true);
        this.tblBillAnalysis.getColumn("accountDate1").setGroup(true);
        this.tblBillAnalysis.getColumn("accountTypeDes").setGroup(true);
        this.tblBillAnalysis.getColumn("billNumber").setGroup(true);
        this.tblBillAnalysis.getColumn("billStatusDes").setGroup(true);
        this.tblBillAnalysis.getColumn("billDate").setGroup(true);
        this.tblBillAnalysis.getColumn("sourceBillType").setGroup(true);
        this.tblBillAnalysis.getColumn("billStatusDes").setGroup(true);
        this.tblBillAnalysis.getColumn("fivouchered").setGroup(true);
        this.tblBillAnalysis.getColumn("voucherType").setGroup(true);
        this.tblBillAnalysis.getColumn("voucherNumber").setGroup(true);
        this.tblBillAnalysis.getColumn("abstractName").setGroup(true);
        this.tblBillAnalysis.getColumn("asstActType").setGroup(true);
        this.tblBillAnalysis.getColumn("asstActName").setGroup(true);
        this.tblBillAnalysis.getColumn("currencyName").setGroup(true);
        this.tblBillAnalysis.getColumn("exchangeRate").setGroup(true);
        this.tblBillAnalysis.getColumn("adminOrgUnit").setGroup(true);
        this.tblBillAnalysis.getColumn("saleOrgUnit").setGroup(true);
        this.tblBillAnalysis.getColumn("person").setGroup(true);
        this.tblBillAnalysis.getColumn("id").setMergeable(true);
        this.tblBillAnalysis.getColumn("checkbox").setMergeable(true);
        this.tblBillAnalysis.getColumn("companyName").setMergeable(true);
        this.tblBillAnalysis.getColumn("number").setMergeable(true);
        this.tblBillAnalysis.getColumn("accountYear").setMergeable(true);
        this.tblBillAnalysis.getColumn("accountDate1").setMergeable(true);
        this.tblBillAnalysis.getColumn("accountTypeDes").setMergeable(true);
        this.tblBillAnalysis.getColumn("billStatusDes").setMergeable(true);
        this.tblBillAnalysis.getColumn("fivouchered").setMergeable(true);
        this.tblBillAnalysis.getColumn("voucherType").setMergeable(true);
        this.tblBillAnalysis.getColumn("voucherNumber").setMergeable(true);
        this.tblBillAnalysis.getColumn("billNumber").setMergeable(true);
        this.tblBillAnalysis.getColumn("billStatusDes").setMergeable(true);
        this.tblBillAnalysis.getColumn("billDate").setMergeable(true);
        this.tblBillAnalysis.getColumn("sourceBillType").setMergeable(true);
        this.tblBillAnalysis.getColumn("abstractName").setMergeable(true);
        this.tblBillAnalysis.getColumn("asstActType").setMergeable(true);
        this.tblBillAnalysis.getColumn("asstActName").setMergeable(true);
        this.tblBillAnalysis.getColumn("currencyName").setMergeable(true);
        this.tblBillAnalysis.getColumn("exchangeRate").setMergeable(true);
        this.tblBillAnalysis.getColumn("adminOrgUnit").setMergeable(true);
        this.tblBillAnalysis.getColumn("saleOrgUnit").setMergeable(true);
        this.tblBillAnalysis.getColumn("person").setMergeable(true);
        this.tblBillAnalysis.getGroupManager().group();
    }

    private String getFormatString() {
        CurrencyInfo currencyInfo = CommonClientUtils.getCurrency(String.valueOf(this.currentCompany.getBaseCurrency().getId()));
        return PrecisionFormatUtils.getFormatString(currencyInfo);
    }

    private String getFormatString(boolean flag, String currencyID) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(currencyID);
        CurrencyInfo currencyInfo = this.iCurrency.getCurrencyInfo((IObjectPK)pk);
        int precision = currencyInfo.getPrecision();
        if (precision == 0) {
            precision = 2;
        }
        StringBuffer buffer = new StringBuffer("%r-[=]{#,##0.");
        for (int i = 0; i < precision; ++i) {
            buffer.append(flag ? "0" : "#");
        }
        buffer.append("}f");
        return buffer.toString();
    }

    private String getBaseCurrencyPrecision() throws BOSException, EASBizException {
        return this.getFormatString(true, this.currentCompany.getBaseCurrency().getId().toString());
    }

    protected void verifyInput(KDTable table) {
        int rowCount = table.getRowCount3();
        if (rowCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
    }

    private List getSelectedID(KDTable table) {
        Boolean selected;
        IRow row;
        int i;
        ArrayList<String> idList = new ArrayList<String>(100);
        boolean isSelect = false;
        int size = table.getRowCount3();
        for (i = 0; i < size; ++i) {
            row = table.getRow(i);
            if (row.getCell("checkbox").getValue() == null || !Boolean.TRUE.equals(selected = (Boolean)row.getCell("checkbox").getValue())) continue;
            isSelect = true;
            break;
        }
        if (!isSelect) {
            MsgBox.showWarning((String)this.getStrResource("select_data"));
            SysUtil.abort();
        }
        for (i = 0; i < size; ++i) {
            String id;
            row = table.getRow(i);
            if (row.getCell("checkbox").getValue() == null || !Boolean.TRUE.equals(selected = (Boolean)row.getCell("checkbox").getValue()) || idList.contains(id = row.getCell("id").getValue().toString())) continue;
            idList.add(id);
        }
        return idList;
    }

    private List getSelectID(KDTable table) {
        ArrayList<String> idList = new ArrayList<String>(100);
        int size = table.getRowCount3();
        for (int i = 0; i < size; ++i) {
            String id;
            Boolean selected;
            IRow row = table.getRow(i);
            if (row.getCell("checkbox").getValue() == null || !Boolean.TRUE.equals(selected = (Boolean)row.getCell("checkbox").getValue()) || idList.contains(id = row.getCell("id").getValue().toString())) continue;
            idList.add(id);
        }
        return idList;
    }

    public void checkVoucheredOrSettleAccount(String checkType, String fid) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountDate", (Object)this.currPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountDate", (Object)this.upDate(this.currPeriod.getEndDate()), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.currentCompany.getId().toString()));
        if (!checkType.equalsIgnoreCase("submit")) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        AccountBadDebtCollection coll = this.iAccountBadDebt.getAccountBadDebtCollection(view);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            AccountBadDebtInfo info = coll.get(i);
            if (checkType.equalsIgnoreCase("submit") && (info.getAuditDate() == null || info.getAuditor() == null)) {
                throw new AccountBadDebtException(AccountBadDebtException.NO_AUDIT);
            }
            if (this.isRelationGL && (checkType.equalsIgnoreCase("submit") || checkType.equalsIgnoreCase("audited")) && !info.isFiVouchered()) {
                throw new AccountBadDebtException(AccountBadDebtException.NO_VOUCHER);
            }
            if (!this.isRelationGL || !this.iAccountBadDebt.checkSettleAccounts(info.getId().toString())) continue;
            throw new AccountBadDebtException(AccountBadDebtException.NO_SETTLE_ACCOUNTS);
        }
    }

    private KDTable getTable() {
        if (this.accountBadDebtQueryUI == null || this.accountBadDebtQueryUI.getAccountType() == null) {
            return this.tblMain;
        }
        KDTable table = null;
        table = this.accountBadDebtQueryUI.getAccountType().getValue() == 5 ? this.tblCustomerAnalysis : (this.accountBadDebtQueryUI.getAccountType().getValue() == 6 || this.accountBadDebtQueryUI.getAccountType().getValue() == 7 ? this.tblBillAnalysis : this.tblMain);
        return table;
    }

    private void deleteCustomerVerify() throws EASBizException, BOSException {
        int size = this.tblCustomerAnalysis.getRowCount3();
        if (size == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
        boolean isSelected = false;
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblCustomerAnalysis.getRow(i);
            Boolean selected = (Boolean)row.getCell("checkbox").getValue();
            if (!selected.equals(Boolean.TRUE)) continue;
            isSelected = true;
            break;
        }
        if (!isSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_select_accural_record"));
            SysUtil.abort();
        }
    }

    private boolean deleteCustomerAnalysis() throws EASBizException, BOSException {
        this.deleteCustomerVerify();
        String ID = null;
        ObjectUuidPK pk = null;
        HashSet<String> deleteBadDebtNumber = new HashSet<String>();
        List idList = this.getSelectID(this.tblCustomerAnalysis);
        int size = this.tblCustomerAnalysis.getRowCount3() - 1;
        StringBuffer errMsg = new StringBuffer();
        String errorId = "";
        for (int i = size; i >= 0; --i) {
            try {
                IRow row = this.tblCustomerAnalysis.getRow(i);
                ID = (String)row.getCell("id").getValue();
                if (!idList.contains(ID) || "".equals(ID) || !this.iAccountBadDebt.exists((IObjectPK)(pk = new ObjectUuidPK(ID))) || ID.equals(errorId)) continue;
                AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
                deleteBadDebtNumber.add(info.getNumber());
                BaseDataUtil.rolbackNumber((CoreBillBaseInfo)info);
                this.iAccountBadDebt.delete((IObjectPK)pk);
                continue;
            }
            catch (EASBizException ex) {
                errorId = ID;
                errMsg.append(ex.getMessage()).append("\n");
            }
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getStrResource("Msg_ActionRemoveError"), (String)errMsg.toString(), (int)8188);
            return false;
        }
        this.deleteBadDebtCustDetail(deleteBadDebtNumber);
        return true;
    }

    private IObjectPK beginLog(IObjectPK pk, String method, String methodDes) throws BOSException, EASBizException {
        AccountBadDebtInfo accountBadDebtInfo = this.iAccountBadDebt.getAccountBadDebtInfo(pk);
        String methodName = this.getStrResource(method);
        String instanceDeatil = accountBadDebtInfo.getNumber();
        ObjectUuidPK iObjectPK = new ObjectUuidPK(accountBadDebtInfo.getId().toString());
        return LogUtil.beginLog(null, (String)methodName, (BOSObjectType)accountBadDebtInfo.getBOSType(), (IObjectPK)iObjectPK, (String)instanceDeatil, (String)methodDes);
    }

    private void afterLog(IObjectPK pk) {
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private void deleteBillVerify() throws EASBizException, BOSException {
        int size = this.tblBillAnalysis.getRowCount3();
        if (size == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
        boolean isSelected = false;
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblBillAnalysis.getRow(i);
            Boolean selected = (Boolean)row.getCell("checkbox").getValue();
            if (!selected.equals(Boolean.TRUE)) continue;
            isSelected = true;
            break;
        }
        if (!isSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_select_accural_record"));
            SysUtil.abort();
        }
    }

    private void checkAuditOrVoucher(String billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
        if (info.isFiVouchered()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("accural_voucher_for_delete"));
            SysUtil.abort();
        }
        if (info.getAuditDate() != null && info.getAuditor() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("accural_audited_for_delete"));
            SysUtil.abort();
        }
    }

    private boolean deleteBillAnalysis() throws EASBizException, BOSException {
        this.deleteBillVerify();
        String ID = null;
        ObjectUuidPK pk = null;
        List idList = this.getSelectID(this.tblBillAnalysis);
        StringBuffer errMsg = new StringBuffer();
        String errorId = "";
        for (int i = this.tblBillAnalysis.getRowCount3() - 1; i >= 0; --i) {
            try {
                IRow row = this.tblBillAnalysis.getRow(i);
                ID = (String)row.getCell("id").getValue();
                if (!idList.contains(ID) || "".equals(ID) || !this.iAccountBadDebt.exists((IObjectPK)(pk = new ObjectUuidPK(ID))) || ID.equals(errorId)) continue;
                AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
                BaseDataUtil.rolbackNumber((CoreBillBaseInfo)info);
                this.iAccountBadDebt.delete((IObjectPK)pk);
                continue;
            }
            catch (EASBizException ex) {
                errorId = ID;
                errMsg.append(ex.getMessage()).append("\n");
            }
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getStrResource("Msg_ActionRemoveError"), (String)errMsg.toString(), (int)8188);
            return false;
        }
        return true;
    }

    private void deleteAccountBadDebtVerify() throws EASBizException, BOSException {
        int size = this.tblMain.getRowCount3();
        if (size == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
        boolean isSelected = false;
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean selected = (Boolean)row.getCell("checkbox").getValue();
            if (!selected.equals(Boolean.TRUE)) continue;
            isSelected = true;
            break;
        }
        if (!isSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_select_accural_record"));
            SysUtil.abort();
        }
    }

    private boolean deleteAccountBadDebt() throws EASBizException, BOSException {
        this.deleteAccountBadDebtVerify();
        ObjectUuidPK pk = null;
        List idList = this.getSelectID(this.tblMain);
        int size = this.tblMain.getRowCount3() - 1;
        StringBuffer errMsg = new StringBuffer();
        String errorId = "";
        String ID = "";
        for (int i = size; i >= 0; --i) {
            try {
                IRow row = this.tblMain.getRow(i);
                ID = (String)row.getCell("id").getValue();
                if (!idList.contains(ID) || "".equals(ID) || !this.iAccountBadDebt.exists((IObjectPK)(pk = new ObjectUuidPK(ID))) || ID.equals(errorId)) continue;
                AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
                BaseDataUtil.rolbackNumber((CoreBillBaseInfo)info);
                this.iAccountBadDebt.delete((IObjectPK)pk);
                continue;
            }
            catch (EASBizException ex) {
                errorId = ID;
                errMsg.append(ex.getMessage()).append("\n");
            }
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getStrResource("Msg_ActionRemoveError"), (String)errMsg.toString(), (int)8188);
            return false;
        }
        return true;
    }

    private void deleteBadDebtCustDetail(Set badDebtNumberSet) throws BOSException, EASBizException {
        if (badDebtNumberSet.size() == 0) {
            return;
        }
        IAccountBadDebtCustDetail iAccountBadDebtCustDetail = AccountBadDebtCustDetailFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)badDebtNumberSet, CompareType.INCLUDE));
        iAccountBadDebtCustDetail.delete(filter);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.accountBadDebtQueryUI == null) {
            return;
        }
        this.setTableVisible(this.accountType);
        if (this.accountType.getValue() == 5) {
            this.queryCustomerAnalysis(this.filter);
        } else if (this.accountType.getValue() == 6 || this.accountType.getValue() == 7) {
            this.queryBillAnalysis(this.filter);
        } else {
            super.actionRefresh_actionPerformed(e);
            this.setMainTableConfig();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean deleteSuccess = true;
        int value = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"confirmDelete"));
        if (value == 1 || value == 2) {
            SysUtil.abort();
        }
        deleteSuccess = this.accountBadDebtQueryUI != null && this.accountBadDebtQueryUI.getAccountType() != null ? (this.accountBadDebtQueryUI.getAccountType().getValue() == 5 ? this.deleteCustomerAnalysis() : (this.accountBadDebtQueryUI.getAccountType().getValue() == 6 || this.accountBadDebtQueryUI.getAccountType().getValue() == 7 ? this.deleteBillAnalysis() : this.deleteAccountBadDebt())) : this.deleteAccountBadDebt();
        if (deleteSuccess) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"deleteSuccessed"));
            this.showMessage();
        }
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        KDTable table = this.getTable();
        this.verifyInput(table);
        List idList = this.getSelectedID(table);
        if (idList.size() == 0) {
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String id = idList.get(i).toString();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
            try {
                this.iAccountBadDebt.audit(id);
                continue;
            }
            catch (EASBizException ex) {
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("Msg_AuditError"), (String)errMsg.toString(), (int)8188);
        } else {
            this.setMessageText(this.getStrResource("audited_success"));
            this.showMessage();
        }
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getTable();
        this.verifyInput(table);
        List idList = this.getSelectedID(table);
        if (idList.size() == 0) {
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String id = idList.get(i).toString();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            AccountBadDebtInfo info = this.iAccountBadDebt.getAccountBadDebtInfo((IObjectPK)pk);
            try {
                this.iAccountBadDebt.unAudit(id);
                continue;
            }
            catch (EASBizException ex) {
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("Msg_AuditError"), (String)errMsg.toString(), (int)8188);
        } else {
            this.setMessageText(this.getStrResource("unAuditSuccessed"));
            this.showMessage();
        }
        this.refreshList();
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getTable();
        this.verifyInput(table);
        List idList = this.getSelectedID(table);
        if (idList.size() == 0) {
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        ArrayList<VoucherInfo> voucherList = new ArrayList<VoucherInfo>();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String id = idList.get(i).toString();
            try {
                VoucherInfo vch = (VoucherInfo)this.iAccountBadDebt.genVoucher(id);
                voucherList.add(vch);
                continue;
            }
            catch (EASBizException ex) {
                errMsg.append(ex.getMessage()).append("\n");
            }
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getStrResource("Msg_ActionVoucherError"), (String)errMsg.toString(), (int)8188);
            SysUtil.abort();
        }
        this.refreshList();
        VoucherInfo vch = null;
        if (voucherList.size() > 0) {
            vch = (VoucherInfo)voucherList.get(0);
        }
        if (vch != null) {
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"ID", (Object)vch.getId());
            ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionEditVouchers_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getTable();
        this.verifyInput(table);
        List idList = this.getSelectedID(table);
        int size = idList.size();
        if (size == 0) {
            return;
        }
        String billId = idList.get(0).toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("VoucherCannotEdit"));
            SysUtil.abort();
        }
        IIDList voucherIDList = this.arrayList2IIDList(voucherColl);
        String voucherId = voucherColl.get(0).toString();
        UserInfo defaultUserInfo = null;
        if (defaultUserInfo == null) {
            defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        if (defaultUserInfo == null || defaultUserInfo == null) {
            return;
        }
        boolean hasPermission = BaseDataUtil.checkEditVoucherPermission((IObjectPK)new ObjectUuidPK(defaultUserInfo.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), "", (IObjectPK)new ObjectUuidPK(voucherId));
        if (!hasPermission) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("NoPermissionCannotEdit"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)voucherId);
        uiContext.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        uiContext.put((Object)"IDList", (Object)voucherIDList);
        String uiClass = "com.kingdee.eas.fi.gl.client.VoucherEditUI";
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private IIDList arrayList2IIDList(ArrayList al) {
        RealModeIDList List2 = RealModeIDList.getEmptyIDList();
        if (al != null && al.size() != 0) {
            for (int i = 0; i < al.size(); ++i) {
                List2.add(i, (String)al.get(i));
            }
        }
        return List2;
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getTable();
        this.verifyInput(table);
        StringBuffer errMsg = new StringBuffer();
        List idList = this.getSelectedID(table);
        int size = idList.size();
        if (size == 0) {
            return;
        }
        int value = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"confirmDelete"));
        if (value == 1 || value == 2) {
            SysUtil.abort();
        }
        for (int i = 0; i < size; ++i) {
            String id = idList.get(i).toString();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            try {
                this.iAccountBadDebt.deleteVoucher((IObjectPK)pk);
                continue;
            }
            catch (EASBizException ex) {
                errMsg.append(ex.getMessage()).append("\n");
            }
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getStrResource("Msg_ActionDeleteError"), (String)errMsg.toString(), (int)8188);
        } else {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"deleteSuccessed"));
            this.showMessage();
        }
        this.refreshList();
    }

    @Override
    public void actionViewVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isRelationGL) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gl_not_relation_or_start"));
            return;
        }
        KDTable table = this.getTable();
        this.verifyInput(table);
        List idList = this.getSelectedID(table);
        int size = idList.size();
        if (size == 0) {
            return;
        }
        String billId = idList.get(0).toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("lab_novoucher_beview"));
            return;
        }
        String voucherId = voucherColl.get(0).toString();
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)voucherId);
        ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        IUIWindow uiVerificationWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.VIEW);
        uiVerificationWindow.show();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.accountBadDebtQueryUI != null && (6 == this.accountBadDebtQueryUI.getAccountType().getValue() || 7 == this.accountBadDebtQueryUI.getAccountType().getValue())) {
            this.preparePrintPage(this.tblBillAnalysis);
            this.tblBillAnalysis.getPrintManager().printPreview();
        } else if (this.accountBadDebtQueryUI != null && 5 == this.accountBadDebtQueryUI.getAccountType().getValue()) {
            this.preparePrintPage(this.tblCustomerAnalysis);
            this.tblCustomerAnalysis.getPrintManager().printPreview();
        } else {
            super.actionPrintPreview_actionPerformed(e);
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.accountBadDebtQueryUI != null && (6 == this.accountBadDebtQueryUI.getAccountType().getValue() || 7 == this.accountBadDebtQueryUI.getAccountType().getValue())) {
            this.preparePrintPage(this.tblBillAnalysis);
            this.tblBillAnalysis.getPrintManager().print();
        } else if (this.accountBadDebtQueryUI != null && 5 == this.accountBadDebtQueryUI.getAccountType().getValue()) {
            this.preparePrintPage(this.tblCustomerAnalysis);
            this.tblCustomerAnalysis.getPrintManager().print();
        } else {
            super.actionPrintPreview_actionPerformed(e);
        }
    }

    private boolean isNeedChecked() throws EASBizException, BOSException {
        boolean arIsRltdAccunt = ArClientUtils.arIsRelatedAccount(this.currentCompany);
        boolean glIsStart = CommonClientUtils.glIsStart(this.currentCompany);
        return arIsRltdAccunt && glIsStart;
    }

    public Date upDate(Date oldDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldDate);
        calendar.add(5, 1);
        Date dateUp = new Date(calendar.getTime().getTime());
        return dateUp;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isFootVisible() {
        return true;
    }

    public List<String> getFieldSumList() {
        if (this.accountType != null && this.accountType.getValue() == 5) {
            return Arrays.asList("receiveBalanceAmount", "saleRecAmount", "otherReceiveBalanceAmount", "otherSaleRecAmount");
        }
        if (this.accountType != null && (this.accountType.getValue() == 6 || this.accountType.getValue() == 7)) {
            return Arrays.asList("recievePayAmount", "recievePayAmountLocal", "verifyAmount", "verifyAmountLocal", "unVerifyAmount", "unVerifyAmountLocal", "lockUnVerifyAmt", "lockUnVerifyAmtLocal", "preparedBadAmount", "preparedBadAmountLocal", "prepareAmount", "patch", "rush");
        }
        if (this.accountType != null && this.accountType.getValue() == 2) {
            return Arrays.asList("balance", "accountBalance", "receiveBalance", "otherReceiveBalance", "estimateLossSum", "saleTotalAmounts", "accuralAmounts");
        }
        return Arrays.asList("prepareAmount", "thisPrepareAmount", "patch", "rush", "balance", "accountBalance", "receiveBalance", "otherReceiveBalance", "estimateLossSum", "saleTotalAmounts", "accuralAmounts");
    }

    private void appendFootRow(KDTable tbl) {
        KDTFootManager footRowManager = tbl.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(tbl);
            footRowManager.addFootView();
            tbl.setFootManager(footRowManager);
            IRow footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            tbl.getIndexColumn().setWidthAdjustMode((short)1);
            tbl.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        }
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        List idList = this.getSelectedID(this.getTable());
        String boID = (String)idList.get(0);
        if (boID == null) {
            return;
        }
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID(boID);
        info.setCode("");
        info.setEdit(true);
        info.setListener(this.createAttatchListener("HEAD"));
        acm.showAttachmentListUIByBoID((Object)this, info);
    }

    @Override
    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        this.doProccess_actionPerformed(e);
    }

    public void doProccess_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getTable();
        this.verifyInput(table);
        List idList = this.getSelectedID(table);
        if (idList.size() == 0) {
            return;
        }
        String fieldName = this.getQueryFieldNameBindingWf();
        String id = (String)this.getSelectedFieldValues(fieldName).get(0);
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo processInstInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(id);
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        if (processInstInfo == null) {
            procInsts = service.getAllProcessInstancesByBizobjId(id);
            if (procInsts == null || procInsts.length <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
            } else if (procInsts.length == 1) {
                this.showWorkflowDiagram(procInsts[0]);
            } else {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"procInsts", (Object)procInsts);
                String className = ProcessRunningListUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
                uiWindow.show();
            }
        } else {
            this.showWorkflowDiagram(processInstInfo);
        }
    }

    private void showWorkflowDiagram(ProcessInstInfo processInstInfo) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"id", (Object)processInstInfo.getProcInstId());
        uiContext.put((Object)"processInstInfo", (Object)processInstInfo);
        BasicWorkFlowMonitorPanel.Show((Map)uiContext);
    }

    public ArrayList getSelectedFieldValues(String fieldName) {
        ArrayList<String> list = new ArrayList<String>();
        KDTable table = this.getTable();
        int[] selectRows = this.getTableSelectRows(table);
        for (int i = 0; i < selectRows.length; ++i) {
            String id;
            ICell cell = table.getRow(selectRows[i]).getCell(fieldName);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (cell.getValue() == null || list.contains(id = cell.getValue().toString())) continue;
            list.add(id);
        }
        return list;
    }

    protected int[] getTableSelectRows(KDTable table) {
        int[] selectRows = this.getSelectedRows(table);
        return selectRows;
    }

    private int[] getSelectedRows(KDTable table) {
        HashSet<Integer> set = new HashSet<Integer>();
        boolean isSelect = false;
        int size = table.getRowCount3();
        for (int i = 0; i < size; ++i) {
            Boolean selected;
            IRow row = table.getRow(i);
            if (row.getCell("checkbox").getValue() == null || !Boolean.TRUE.equals(selected = (Boolean)row.getCell("checkbox").getValue())) continue;
            set.add(i);
            isSelect = true;
        }
        if (!isSelect) {
            MsgBox.showWarning((String)this.getStrResource("select_data"));
            SysUtil.abort();
        }
        Iterator iter = set.iterator();
        int[] rows = new int[set.size()];
        int k = 0;
        while (iter.hasNext()) {
            int i = (Integer)iter.next();
            rows[k++] = i;
        }
        return rows;
    }

    private Set getSelectedCloum(KDTable table, String columName) {
        HashSet<Object> columSet = new HashSet<Object>();
        HashSet<Object> AllColumSet = new HashSet<Object>();
        if (columName == null || "".equals(columName)) {
            return columSet;
        }
        boolean isSelect = false;
        int size = table.getRowCount3();
        for (int i = 0; i < size; ++i) {
            IRow row = table.getRow(i);
            if (row.getCell("checkbox").getValue() == null) continue;
            Boolean selected = (Boolean)row.getCell("checkbox").getValue();
            if (Boolean.TRUE.equals(selected) && row.getCell(columName) != null) {
                columSet.add(row.getCell(columName).getValue());
                isSelect = true;
            }
            if (row.getCell(columName) == null) continue;
            AllColumSet.add(row.getCell(columName).getValue());
        }
        if (isSelect) {
            return columSet;
        }
        return AllColumSet;
    }

    @Override
    protected void btnViewDetail_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        Set badDebtNumberSet = this.getSelectedCloum(this.tblCustomerAnalysis, "number");
        if (badDebtNumberSet.size() != 0) {
            uiContext.put((Object)"badDebtNumbers", (Object)badDebtNumberSet);
        } else {
            uiContext.remove((Object)"badDebtNumbers");
        }
        IUIWindow billUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AccountBadDebtCustDetail4JoinListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        billUI.show();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getVisibleTable();
        int count = table.getRowCount3();
        for (int i = 0; i < count; ++i) {
            table.getCell(i, "checkbox").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnCancelAll_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getVisibleTable();
        int count = table.getRowCount3();
        for (int i = 0; i < count; ++i) {
            table.getCell(i, "checkbox").setValue((Object)Boolean.FALSE);
        }
    }

    private KDTable getVisibleTable() {
        if (this.tblMain.isVisible()) {
            return this.tblMain;
        }
        if (this.tblBillAnalysis.isVisible()) {
            return this.tblBillAnalysis;
        }
        return this.tblCustomerAnalysis;
    }
}

