/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.FinishApInitFacadeFactory;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ar.FinishArInitFacadeFactory;
import com.kingdee.eas.fi.ar.ManageAccountFactory;
import com.kingdee.eas.fi.ar.client.AbstractArInitManagerUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class ArInitManagerUI
extends AbstractArInitManagerUI {
    private static final String ARSYS = "AR";
    private static final String APSYS = "AP";
    private String innerSysType;

    public void onLoad() throws Exception {
        super.onLoad();
        this.getParameter();
        if (this.innerSysType.equals(ARSYS)) {
            CommonClientUtils.checkFunctionPermission("fi_arap_FinishArIni");
        } else if (this.innerSysType.endsWith(APSYS)) {
            CommonClientUtils.checkFunctionPermission("fi_arap_FinishApIni");
        } else {
            throw new IllegalArgumentException();
        }
        this.initialize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void startButton_actionPerformed(ActionEvent e) throws Exception {
        if (this.innerSysType.equals(ARSYS)) {
            if (this.finishInitRadioButton.isSelected()) {
                this.finishArInit();
                return;
            } else {
                if (!this.unFinishInitRadioButton.isSelected()) throw new IllegalArgumentException();
                this.reverseArInit();
            }
            return;
        } else {
            if (!this.innerSysType.equals(APSYS)) throw new IllegalArgumentException();
            if (this.finishInitRadioButton.isSelected()) {
                this.finishApInit();
                return;
            } else {
                if (!this.unFinishInitRadioButton.isSelected()) throw new IllegalArgumentException();
                this.reverseApInit();
            }
        }
    }

    @Override
    protected void closeButton_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void initialize() {
        block13: {
            this.labWizardImg.setIcon(EASResource.getIcon((String)"imgGuide_pic338"));
            CompanyOrgUnitInfo cmpnyOrgUntInf = CommonClientUtils.getCurrentCompany();
            if (cmpnyOrgUntInf == null || cmpnyOrgUntInf.isIsOnlyUnion()) {
                MsgBox.showInfo((Component)((Object)this), (String)ArClientUtils.getArStringResource("CompanyIsNull"));
                this.abort();
            }
            if (this.innerSysType.equals(ARSYS)) {
                this.windowTitle = ArClientUtils.getArStringResource("ArInitManagerTitle");
                try {
                    boolean arIsStrt = ArClientUtils.arIsStart(cmpnyOrgUntInf);
                    if (arIsStrt) {
                        this.setUnFinishInitState();
                        break block13;
                    }
                    this.setFinishInitState();
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else if (this.innerSysType.equals(APSYS)) {
                this.windowTitle = ApClientUtils.getApStringResource("ApInitManagerTitle");
                try {
                    boolean apIsStrt = ApClientUtils.apIsStart(cmpnyOrgUntInf);
                    if (apIsStrt) {
                        this.setUnFinishInitState();
                        break block13;
                    }
                    this.setFinishInitState();
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private void setFinishInitState() {
        String description = ArClientUtils.getArStringResource("FinishInitDescription");
        this.descriptionTextArea.setText(description);
        this.finishInitRadioButton.setSelected(true);
        this.finishInitRadioButton.setEnabled(true);
        this.unFinishInitRadioButton.setEnabled(false);
    }

    private void setUnFinishInitState() {
        String description = ArClientUtils.getArStringResource("UnFinishInitDescription");
        this.descriptionTextArea.setText(description);
        this.unFinishInitRadioButton.setSelected(true);
        this.unFinishInitRadioButton.setEnabled(true);
        this.finishInitRadioButton.setEnabled(false);
    }

    private void getParameter() {
        this.innerSysType = (String)this.getUIContext().get("UIClassParam");
        if (this.innerSysType != null) {
            this.innerSysType = this.innerSysType.trim();
        }
        if (this.innerSysType == null || this.innerSysType.length() == 0) {
            String message = ArClientUtils.getArStringResource("PleaseSetUIParameter");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            this.abort();
        }
    }

    private boolean checkConditin_FinishArInit() {
        try {
            CompanyOrgUnitInfo cmpnyOrgUntInf = CommonClientUtils.getCurrentCompany();
            if (cmpnyOrgUntInf == null || cmpnyOrgUntInf.isIsOnlyUnion()) {
                MsgBox.showInfo((Component)((Object)this), (String)ArClientUtils.getArStringResource("CompanyIsNull"));
                return false;
            }
            boolean arIsStrt = ArClientUtils.arIsStart(cmpnyOrgUntInf);
            if (arIsStrt) {
                String message = ArClientUtils.getArStringResource("InitHasFinished");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
            PeriodInfo strtPrd = ArClientUtils.getArStartPeriod(cmpnyOrgUntInf);
            if (strtPrd == null) {
                String message = ArClientUtils.getArStringResource("StartPeriodIsNull");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
            boolean arIsRltdAccunt = ArClientUtils.arIsRelatedAccount(cmpnyOrgUntInf);
            boolean glIsStart = CommonClientUtils.glIsStart(cmpnyOrgUntInf);
            if (arIsRltdAccunt && glIsStart) {
                ManageAccountFactory.getRemoteInstance().balanceARToGL("");
            }
            return true;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    private boolean checkConditin_UnFinishArInit() {
        try {
            CompanyOrgUnitInfo cmpnyOrgUntInf = CommonClientUtils.getCurrentCompany();
            if (cmpnyOrgUntInf == null || cmpnyOrgUntInf.isIsOnlyUnion()) {
                MsgBox.showInfo((Component)((Object)this), (String)ArClientUtils.getArStringResource("CompanyIsNull"));
                return false;
            }
            boolean arIsStrt = ArClientUtils.arIsStart(cmpnyOrgUntInf);
            if (!arIsStrt) {
                String message = ArClientUtils.getArStringResource("UnFinishInitOrCurrentPeriodErr");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
            PeriodInfo startPeriod = ArClientUtils.getArStartPeriod(cmpnyOrgUntInf);
            PeriodInfo currentPeriod = ArClientUtils.getArCurrentPeriod(cmpnyOrgUntInf);
            if (startPeriod == null || currentPeriod == null || PeriodUtils.PeriodCompare((String)startPeriod.getId().toString(), (String)currentPeriod.getId().toString()) != 0) {
                String message = ArClientUtils.getArStringResource("UnFinishInitOrCurrentPeriodErr");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
            boolean arIsRelatedAccount = ArClientUtils.arIsRelatedAccount(cmpnyOrgUntInf);
            if (arIsRelatedAccount) {
                PeriodInfo relatedPeriod = ArClientUtils.getArRelatedPeriod(cmpnyOrgUntInf);
                int result = PeriodUtils.PeriodCompare((String)startPeriod.getId().toString(), (String)relatedPeriod.getId().toString());
                if (result == 0) {
                    String message = ArClientUtils.getArStringResource("CurrentPeriodIsRelatedPeriod");
                    MsgBox.showInfo((Component)((Object)this), (String)message);
                    return false;
                }
            }
            return true;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    private void finishArInit() {
        if (!this.checkConditin_FinishArInit()) {
            return;
        }
        try {
            FinishArInitFacadeFactory.getRemoteInstance().finishArInit(null);
            String message = ArClientUtils.getArStringResource("FinishInitHaveFinished");
            MsgBox.showInfo((Component)((Object)this), (String)message);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void reverseArInit() {
        if (!this.checkConditin_UnFinishArInit()) {
            return;
        }
        try {
            FinishArInitFacadeFactory.getRemoteInstance().reverseFinishArInit(null);
            String message = ArClientUtils.getArStringResource("ReverseInitSuccess");
            MsgBox.showInfo((Component)((Object)this), (String)message);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private boolean checkConditin_FinishApInit() {
        try {
            PeriodInfo strtPrd;
            CompanyOrgUnitInfo cmpnyOrgUntInf = CommonClientUtils.getCurrentCompany();
            if (cmpnyOrgUntInf == null || cmpnyOrgUntInf.isIsOnlyUnion()) {
                String message = ArClientUtils.getArStringResource("CompanyIsNull");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
            boolean apIsStrt = ApClientUtils.apIsStart(cmpnyOrgUntInf);
            if (apIsStrt) {
                String message = ArClientUtils.getArStringResource("InitHasFinished");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
            boolean glIsStart = CommonClientUtils.glIsStart(cmpnyOrgUntInf);
            boolean apIsRltdAccunt = ApClientUtils.apIsRelatedAccount(cmpnyOrgUntInf);
            if (!apIsRltdAccunt || glIsStart) {
                // empty if block
            }
            if ((strtPrd = ApClientUtils.getApStartPeriod(cmpnyOrgUntInf)) == null) {
                String message = ArClientUtils.getArStringResource("StartPeriodIsNull");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
            return true;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    private boolean checkConditin_UnFinishApInit() {
        try {
            CompanyOrgUnitInfo cmpnyOrgUntInf;
            boolean apIsStrt;
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            if (company == null || company.isIsOnlyUnion()) {
                String message = ArClientUtils.getArStringResource("CompanyIsNull");
                MsgBox.showInfo((Component)((Object)this), (String)message);
            }
            if (!(apIsStrt = ApClientUtils.apIsStart(cmpnyOrgUntInf = CommonClientUtils.getCurrentCompany()))) {
                String message = ArClientUtils.getArStringResource("UnFinishInitOrCurrentPeriodErr");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
            PeriodInfo startPeriod = ApClientUtils.getApStartPeriod(cmpnyOrgUntInf);
            PeriodInfo currentPeriod = ApClientUtils.getApCurrentPeriod(cmpnyOrgUntInf);
            if (startPeriod == null || currentPeriod == null || PeriodUtils.PeriodCompare((String)startPeriod.getId().toString(), (String)currentPeriod.getId().toString()) != 0) {
                String message = ArClientUtils.getArStringResource("UnFinishInitOrCurrentPeriodErr");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                return false;
            }
            boolean apIsRelatedAccount = ApClientUtils.apIsRelatedAccount(cmpnyOrgUntInf);
            if (apIsRelatedAccount) {
                PeriodInfo relatedPeriod = ApClientUtils.getApRelatedPeriod(cmpnyOrgUntInf);
                int result = PeriodUtils.PeriodCompare((String)startPeriod.getId().toString(), (String)relatedPeriod.getId().toString());
                if (result == 0) {
                    String message = ArClientUtils.getArStringResource("CurrentPeriodIsRelatedPeriod");
                    MsgBox.showInfo((Component)((Object)this), (String)message);
                    return false;
                }
            }
            return true;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    private void finishApInit() {
        if (!this.checkConditin_FinishApInit()) {
            return;
        }
        try {
            FinishApInitFacadeFactory.getRemoteInstance().finishApInit(null);
            String message = ArClientUtils.getArStringResource("FinishInitHaveFinished");
            MsgBox.showInfo((Component)((Object)this), (String)message);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void reverseApInit() {
        if (!this.checkConditin_UnFinishApInit()) {
            return;
        }
        try {
            FinishApInitFacadeFactory.getRemoteInstance().reverseFinishApInit(null);
            String message = ArClientUtils.getArStringResource("ReverseInitSuccess");
            MsgBox.showInfo((Component)((Object)this), (String)message);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

