/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.ArInvoiceCollection;
import com.kingdee.eas.fi.ar.ArInvoiceFactory;
import com.kingdee.eas.fi.ar.client.AbstractArInvoiceListUI;
import com.kingdee.eas.fi.ar.client.ArApBillContext;
import com.kingdee.eas.fi.arap.InvoiceException;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.util.GTaxHelper;
import com.kingdee.eas.fi.arap_tax.GTaxImportLog;
import com.kingdee.eas.fi.arap_tax.SaleInvoiceExporter;
import com.kingdee.eas.fi.arap_tax.TaxBillTypeEnum;
import com.kingdee.eas.fi.arap_tax.TaxRelationInfo;
import com.kingdee.eas.fi.arap_tax.TaxRelationTypeEnum;
import com.kingdee.eas.fi.arap_tax.client.GTaxDataLogUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArInvoiceListUI
extends AbstractArInvoiceListUI {
    private static final Logger logger = CoreUIObject.getLogger(ArInvoiceListUI.class);
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    @Override
    protected String[] getVisibleFields() {
        return new String[]{"number", "billDate", "billStatus", "billType", "asstActType.name", "asstAcct", "material", "material.model", "expenseItem.number", "expenseItem.name", "measureUnit.name", "entries.quantity", "entries.unitPrice", "entries.amount", "entries.taxRate", "entries.taxAmount", "entries.actualamount"};
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    @Override
    protected String getVATEditUIName() {
        return "com.kingdee.eas.fi.ar.client.ArInvoiceVATEditUI";
    }

    @Override
    protected String getNormalEditUIName() {
        return "com.kingdee.eas.fi.ar.client.ArInvoiceNormalEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ArInvoiceFactory.getRemoteInstance();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billDate", "billType", "billStatus", "asstActType.name", "asstAcct", "totalAmount", "cussAddress", "cussPhone", "cussBank", "cussAcctBank", "taxRegisterNo", "accountBank", "description", "drawer", "auditPerson", "invPerson"};
    }

    @Override
    protected TaxRelationInfo getTaxRelationInfo(TaxRelationTypeEnum type) throws BOSException {
        TaxBillTypeEnum invType = InvoiceTypeEnum.GENERAL.equals((Object)this.getSelectedInvType()) ? TaxBillTypeEnum.GeneralInvoice : TaxBillTypeEnum.SaleInvoice;
        return GTaxHelper.getDefaultRelation(type, invType, this.companyInfo.getId());
    }

    @Override
    public void actionGTaxExport_actionPerformed(ActionEvent e) throws Exception {
        TaxRelationInfo rInfo;
        this.checkSelected();
        if (this.hasDiffInvType()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.arap.InvResource", (String)"HasDiffInvType"));
            SysUtil.abort();
        }
        if ((rInfo = this.getTaxRelationInfo(TaxRelationTypeEnum.Export)) == null) {
            throw new InvoiceException(InvoiceException.GTAXRELATION_NOTFOUND);
        }
        logger.info((Object)("TaxRelation.Number" + rInfo.getNumber()));
        File lastFile = ArApBillContext.getArApBillContext().getGTaxLastFile();
        File file = GTaxHelper.getExportFile((Object)this, rInfo.getFiletype(), lastFile);
        if (file == null) {
            return;
        }
        ArApBillContext.getArApBillContext().setGTaxLastFile(file);
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet();
        Iterator itr = idList.iterator();
        while (itr.hasNext()) {
            idSet.add(itr.next());
        }
        Date beginDate = new Date();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.getSelector().add("*");
        ev.getSelector().add("currency.*");
        ev.getSelector().add("accountBank.*");
        ev.getSelector().add("asstActType.*");
        ev.getSelector().add("auditPerson.*");
        ev.getSelector().add("invPerson.*");
        ev.getSelector().add("company.*");
        ev.getSelector().add("auditor.*");
        ev.getSelector().add("handler.*");
        ev.getSelector().add("creator.*");
        ev.getSelector().add("lastUpdateUser.*");
        ev.getSelector().add("entries.*");
        ev.getSelector().add("entries.material.*");
        ev.getSelector().add("entries.measureUnit.*");
        ev.getSelector().add("entries.expenseItem.*");
        ArInvoiceCollection collection = ArInvoiceFactory.getRemoteInstance().getArInvoiceCollection(ev);
        SaleInvoiceExporter exporter = new SaleInvoiceExporter(rInfo);
        GTaxImportLog log = exporter.export(collection, file);
        log.startTime = beginDate;
        UIContext logCtx = new UIContext((Object)this);
        logCtx.put((Object)"exportLog", (Object)log);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GTaxDataLogUI.class.getName(), (Map)logCtx);
        uiWindow.show();
    }

    @Override
    protected boolean isAR() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return super.getDefaultFilterForQuery();
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi.supportSingleMainOrg((OrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }
}

