/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArInvoiceCollection;
import com.kingdee.eas.fi.ar.ArInvoiceEntryInfo;
import com.kingdee.eas.fi.ar.ArInvoiceFactory;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IArApBillEntryBase;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillentryFactory;
import com.kingdee.eas.fi.ar.client.AbstractArInvoiceVATEditUI;
import com.kingdee.eas.fi.ar.client.ArApBillContext;
import com.kingdee.eas.fi.arap.InvoiceException;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.GTaxHelper;
import com.kingdee.eas.fi.arap_tax.SaleInvoiceExporter;
import com.kingdee.eas.fi.arap_tax.TaxBillTypeEnum;
import com.kingdee.eas.fi.arap_tax.TaxRelationInfo;
import com.kingdee.eas.fi.arap_tax.TaxRelationTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;

public class ArInvoiceVATEditUI
extends AbstractArInvoiceVATEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ArInvoiceVATEditUI.class);

    public ArInvoiceVATEditUI() throws Exception {
        this.txtAreaRemark.setMaxLength(255);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    @Override
    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "fi_ar_InvoiceAddNew";
        }
        if ("VIEW".equals(status)) {
            return "fi_ar_InvoiceQuery";
        }
        return null;
    }

    @Override
    public void onLoad() throws Exception {
        this.companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.companyInfo);
        super.onLoad();
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
        this.actionSave.setEnabled(false);
    }

    protected IObjectValue createNewData() {
        ArInvoiceInfo info = new ArInvoiceInfo();
        info.setCompany(this.companyInfo);
        info.setCU(this.companyInfo.getCU());
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        PersonInfo currPerson = currentUser.getPerson();
        info.setInvPerson(currPerson);
        info.setAuditPerson(currPerson);
        info.setDrawer(currPerson);
        info.setCurrency(this.companyInfo.getBaseCurrency());
        info.setType(InvoiceTypeEnum.VAT);
        info.setBillDate((Date)this.pkbillDate.getValue());
        info.setBillStatus(BillStatusEnum.SAVE);
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        ArInvoiceEntryInfo info = new ArInvoiceEntryInfo();
        return info;
    }

    @Override
    public void loadFields() {
        super.beforeLoadFields();
        super.loadFields();
        try {
            this.initFetchData();
            this.startPeriod = this.fetchData.getStartPeriod();
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.companyInfo.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.pkbillDate.setMinimumDate(this.startPeriod.getBeginDate());
        this.editData.setSyncOldValue(true);
        this.setPrmtCompAcctBank();
        this.afterLoadFields();
        this.editData.setSyncOldValue(false);
        this.setNumCtrlStatus();
    }

    @Override
    protected void setDefaultPerson2Info(InvoiceInfo info) {
        super.setDefaultPerson2Info(info);
        ArInvoiceInfo arInvInfo = (ArInvoiceInfo)info;
        if (arInvInfo.getDrawer() == null) {
            UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
            PersonInfo currPerson = currUser.getPerson();
            arInvInfo.setDrawer(currPerson);
            this.prmtDrawer.setValue((Object)currPerson);
        } else {
            this.prmtDrawer.setValue((Object)arInvInfo.getDrawer());
        }
    }

    @Override
    protected void setCustomerData2UI(CustomerInfo cussAcctInfo, boolean isChange) {
        super.setCustomerData2UI(cussAcctInfo, isChange);
        try {
            if (this.prmtCussType.getData() != null) {
                AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.prmtCussType.getData();
                String companyId = this.companyInfo.getId().toString();
                ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCusAcct, typeInfo, companyId, false);
                ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCusAcct, typeInfo, this.companyInfo, false, this.fetchData.getF7DisplayMode());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void setSupplierData2UI(SupplierInfo cussAcctInfo, boolean isChange) {
        super.setSupplierData2UI(cussAcctInfo, isChange);
        try {
            if (this.prmtCussType.getData() != null) {
                AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.prmtCussType.getData();
                ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCusAcct, typeInfo, this.companyInfo, false, this.fetchData.getF7DisplayMode());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("type");
        sic.add("billStatus");
        sic.add("asstActName");
        sic.add("currency.precision");
        sic.add("cussAcctBank");
        return sic;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setSyncOldValue(true);
        ArInvoiceInfo info = (ArInvoiceInfo)this.getEditData();
        info.setType(InvoiceTypeEnum.VAT);
        this.storeAssActData(info);
        this.setDataObject((IObjectValue)info);
        this.editData.setSyncOldValue(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ArInvoiceFactory.getRemoteInstance();
    }

    @Override
    protected TaxRelationInfo getTaxRelationInfo(TaxRelationTypeEnum type) throws BOSException {
        return GTaxHelper.getDefaultRelation(type, TaxBillTypeEnum.SaleInvoice, this.companyInfo.getId());
    }

    @Override
    public void actionGTaxExport_actionPerformed(ActionEvent e) throws Exception {
        TaxRelationInfo rInfo = this.getTaxRelationInfo(TaxRelationTypeEnum.Export);
        if (rInfo == null) {
            throw new InvoiceException(InvoiceException.GTAXRELATION_NOTFOUND);
        }
        logger.info((Object)("TaxRelation.Number" + rInfo.getNumber()));
        this.lastFile = ArApBillContext.getArApBillContext().getGTaxLastFile();
        File file = GTaxHelper.getExportFile((Object)this, rInfo.getFiletype(), this.lastFile);
        if (file == null) {
            return;
        }
        ArApBillContext.getArApBillContext().setGTaxLastFile(file);
        ArInvoiceCollection collection = new ArInvoiceCollection();
        collection.add(this.editData);
        SaleInvoiceExporter exporter = new SaleInvoiceExporter(rInfo);
        exporter.export(collection, file);
        super.actionGTaxExport_actionPerformed(e);
    }

    @Override
    protected IArApBillEntryBase getSourceEntryInterface() throws BOSException {
        return OtherBillentryFactory.getRemoteInstance();
    }

    @Override
    protected IMetaDataPK getPrintQueryPK() {
        return ARPRINT_QRY;
    }

    @Override
    protected String getPrintMetaPath() {
        return "/FI/AR/ArInvoice";
    }

    @Override
    protected void setEditComponentsStatus(boolean fEdit) {
        super.setEditComponentsStatus(fEdit);
        this.prmtCusAcct.setEnabled(fEdit);
        this.prmtCusAcct.setEditable(fEdit);
        this.prmtDrawer.setEnabled(fEdit);
        this.prmtDrawer.setEditable(fEdit);
    }

    @Override
    protected void setPersonPrmtQuery(String personQry) {
        super.setPersonPrmtQuery(personQry);
        this.prmtDrawer.setQueryInfo(personQry);
    }

    @Override
    protected void verifyInfo(InvoiceInfo invInfo) throws Exception {
        super.verifyInfo(invInfo);
        ArInvoiceInfo info = (ArInvoiceInfo)invInfo;
        if (info.getDrawer() == null) {
            this.prmtDrawer.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{this.lblcontDrawer.getBoundLabelText()});
        }
    }

    private void setPrmtCompAcctBank() {
        this.prmtCompAcctBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        this.prmtCompAcctBank.setVisible(true);
        this.prmtCompAcctBank.setEditable(true);
        this.prmtCompAcctBank.setDisplayFormat("$number$");
        this.prmtCompAcctBank.setEditFormat("$number$");
        this.prmtCompAcctBank.setCommitFormat("$number$");
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmptCompany.getValue();
        String companyId = companyOrgUnitInfo != null ? companyOrgUnitInfo.getId().toString() : "";
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        eview.setFilter(fi);
        this.prmtCompAcctBank.setEntityViewInfo(eview);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (Exception e2) {
            this.setNumCtrlStatus();
            if (e2.getMessage() != null && !"".equals(e2.getMessage())) {
                MsgBox.showWarning((Component)((Object)this), (String)e2.getMessage());
            }
            SysUtil.abort();
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        this.companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.companyInfo);
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            request.put("companyInfo", (Object)this.companyInfo);
            request.put("systemEnum", (Object)this.getSystemEnumForOA());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    public boolean isPrepareActionCreateFrom() {
        return true;
    }

    public RequestContext prepareActionCreateFrom(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionCreateFrom(itemAction);
        request.put("destBosType", (Object)this.getBillInterface().getType());
        return request;
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }
}

