/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.client.AbstractArOtherBillReportQueryUI;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ArOtherBillReportQueryUI
extends AbstractArOtherBillReportQueryUI {
    private static final long serialVersionUID = -1443233279255986998L;
    private static final String COMPANY_IS_NULL = "CompanyIsNull";
    private static final String ARRESOURCE = "com.kingdee.eas.fi.ar.client.ArResource";
    private static final Logger logger = CoreUIObject.getLogger(ArOtherBillReportQueryUI.class);
    protected transient ArApSysParamInfo sysInfo = null;
    protected transient HashMap map = new HashMap();
    protected transient IArApBillFacade iBillFacade = null;
    private int comboAsstActTypeSelectedIndex = 0;
    protected transient CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private ItemListener chkIsCentralBalanceListener = null;

    public ArOtherBillReportQueryUI() throws Exception {
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
        String companyId = this.getCompanyId();
        this.map.put("isSCM", Boolean.FALSE);
        this.map.put("sysEnum", SystemEnum.ACCOUNTSRECEIVABLE);
        this.sysInfo = this.iBillFacade.getSysParams(this.currentCompany, this.map);
        this.setCurrentCompany();
        this.setBillTypeItem();
        this.setAsstActType();
        ArApBillUIUtil.setNewSaleF7CU(this.prmtSaleOrgFrom, false);
        ArApBillUIUtil.setNewSaleF7CU(this.prmtSaleOrgTo, false);
        ArApBillUIUtil.setOrgUnitF7(this.prmtSaleOrgFrom, this.prmtSaleOrgTo, OrgType.Sale, companyId);
        String filter = "SELECT a.FFromUnitID FROM T_ORG_UnitRelation A INNER JOIN T_ORG_TypeRelation B ON a.FTypeRelationID = b.FID WHERE a.FToUnitID = {0} AND b.FToType = 1 AND b.FFromType = 2";
        String companyIdStr = "'" + companyId + "'";
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("unit.id", (Object)MessageFormat.format(filter, companyIdStr), CompareType.INCLUDE));
        FilterInfo fi2 = new FilterInfo();
        fi2.getFilterItems().add(new FilterItemInfo("unit.id", (Object)companyId));
        fi.mergeFilter(fi2, "OR");
        ((NewSaleF7)this.prmtSaleOrgFrom.getSelector()).setOuterFilterInfo(fi);
        ((NewSaleF7)this.prmtSaleOrgTo.getSelector()).setOuterFilterInfo(fi);
        this.prmtSaleOrgFrom.setEnabledMultiSelection(false);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgFrom, false, true, false);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgTo, false, true, false);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonFrom);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonTo);
        this.setCUForBillNumber();
        this.rbAuditSelect.setSelected(true);
        this.rbVoucherSelect.setSelected(true);
        this.rbVeirfySome.setSelected(true);
        this.rbVerified.setSelected(true);
        this.rbNotVerify.setSelected(true);
        this.removeControlListener();
        this.addListen();
    }

    private void removeControlListener() {
        if (null != this.chkIsCentralBalanceListener) {
            this.bizcheckBox.removeItemListener(this.chkIsCentralBalanceListener);
        }
    }

    private void addListen() {
        this.chkIsCentralBalanceListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    ArOtherBillReportQueryUI.this.chkIsCentralBalanceChanged(arg0);
                }
                catch (Exception e) {
                    ArOtherBillReportQueryUI.this.handUIException(e);
                }
            }
        };
        this.bizcheckBox.addItemListener(this.chkIsCentralBalanceListener);
    }

    protected void chkIsCentralBalanceChanged(ItemEvent arg0) throws Exception {
        boolean ischeckBox = this.bizcheckBox.isSelected();
        if (ischeckBox) {
            this.contPaymentType.setEnabled(true);
        } else {
            this.contPaymentType.setEnabled(false);
        }
    }

    private void setCurrentCompany() {
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.prmtCompany.setEnabled(false);
    }

    private void setBillTypeItem() {
        this.comboBillType.addItem((Object)OtherBillTypeEnum.InvoiceBill);
        this.comboBillType.addItem((Object)OtherBillTypeEnum.ExpenseInvoice);
        this.comboBillType.addItem((Object)OtherBillTypeEnum.OtherReceivable);
        this.comboBillType.addItem((Object)OtherBillTypeEnum.DebitAdjust);
        this.comboBillType.addItem((Object)ComBoxInfo.ITEM_ALL);
        this.comboBillType.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
    }

    private void setCUForBillNumber() throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyId(), CompareType.EQUALS));
        filter.setMaskString(" #0");
        viewInfo.setFilter(filter);
        this.prmtBillNumberFrom.setEntityViewInfo(viewInfo);
        this.prmtBillNumberTo.setEntityViewInfo(viewInfo);
        this.prmtBillNumberFrom.setEditable(true);
        this.prmtBillNumberTo.setEditable(true);
    }

    public RptParams getCustomCondition() {
        DataBaseInfo sendOrgUnit;
        DataBaseInfo person;
        DataBaseInfo adminorg;
        DataBaseInfo saleorg;
        OtherBillInfo otherBillInfo;
        Object obj;
        CurrencyInfo currency;
        RptParams params = new RptParams();
        params.setString("company", this.getCompanyId());
        Object billTypeEnum = this.comboBillType.getSelectedItem();
        if (!ComBoxInfo.ITEM_ALL.equals(billTypeEnum)) {
            params.setString("billType", "" + ((OtherBillTypeEnum)billTypeEnum).getValue());
        }
        if ((currency = (CurrencyInfo)this.prmtCurrency.getData()) != null) {
            params.setString("currency", "" + currency.getId());
            params.setString("currencyNumber", currency.getNumber());
            params.setString("currencyName", currency.getName());
        }
        if (!ComBoxInfo.ITEM_ALL.equals(obj = this.combAsstActType.getSelectedItem())) {
            params.setString("asstActType", ((AsstActTypeInfo)obj).getId().toString());
        }
        params.setInt("asstActTypeSelectedIndex", this.combAsstActType.getSelectedIndex());
        DataBaseInfo asstActPayer = (DataBaseInfo)this.prmtAsstActPayerFrom.getData();
        if (asstActPayer != null) {
            params.setString("asstActNumberFrom", asstActPayer.getNumber());
            params.setString("asstActNumberFromID", "" + asstActPayer.getId());
        }
        if ((asstActPayer = (DataBaseInfo)this.prmtAsstActPayerTo.getData()) != null) {
            params.setString("asstActNumberTo", asstActPayer.getNumber());
            params.setString("asstActNumberToID", "" + asstActPayer.getId());
        }
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date billDate = (Date)this.kddBillStartDate.getValue();
        if (billDate != null) {
            params.setString("billDateFrom", dtFormat.format(billDate));
        }
        if ((billDate = (Date)this.kddBillEndDate.getValue()) != null) {
            params.setString("billDateTo", dtFormat.format(billDate));
        }
        if ((otherBillInfo = (OtherBillInfo)this.prmtBillNumberFrom.getData()) != null) {
            params.setString("numberFrom", otherBillInfo.getNumber());
        }
        if ((otherBillInfo = (OtherBillInfo)this.prmtBillNumberTo.getData()) != null) {
            params.setString("numberTo", otherBillInfo.getNumber());
        }
        if ((saleorg = (DataBaseInfo)this.prmtSaleOrgFrom.getData()) != null) {
            params.setString("saleOrgNumberFrom", saleorg.getNumber());
            params.setString("saleOrgNameFrom", saleorg.getName());
        }
        if ((saleorg = (DataBaseInfo)this.prmtSaleOrgTo.getData()) != null) {
            params.setString("saleOrgNumberTo", saleorg.getNumber());
            params.setString("saleOrgNameTo", saleorg.getName());
        }
        if ((adminorg = (DataBaseInfo)this.prmtAdminOrgFrom.getData()) != null) {
            params.setString("adminOrgNumberFrom", adminorg.getNumber());
            params.setString("adminOrgNameFrom", adminorg.getName());
        }
        if ((adminorg = (DataBaseInfo)this.prmtAdminOrgTo.getData()) != null) {
            params.setString("adminOrgNumberTo", adminorg.getNumber());
            params.setString("adminOrgNameTo", adminorg.getName());
        }
        if ((person = (DataBaseInfo)this.prmtPersonFrom.getData()) != null) {
            params.setString("personNumberFrom", person.getNumber());
            params.setString("personNameFrom", person.getName());
        }
        if ((person = (DataBaseInfo)this.prmtPersonTo.getData()) != null) {
            params.setString("personNumberTo", person.getNumber());
            params.setString("personNameTo", person.getName());
        }
        if ((sendOrgUnit = (DataBaseInfo)this.prmtSendOrgUnitFrom.getData()) != null) {
            params.setString("sendOrgUnitNumberFrom", sendOrgUnit.getNumber());
            params.setString("sendOrgUnitNameFrom", sendOrgUnit.getName());
        }
        if ((sendOrgUnit = (DataBaseInfo)this.prmtSendOrgUnitTO.getData()) != null) {
            params.setString("sendOrgUnitNumberTo", sendOrgUnit.getNumber());
            params.setString("sendOrgUnitNameTo", sendOrgUnit.getName());
        }
        if (this.rbNotAudit.isSelected()) {
            params.setString("audit", "no");
        }
        if (this.rbAudited.isSelected()) {
            params.setString("audit", "yes");
        }
        if (this.rbNotVerify.isSelected()) {
            params.setString("verify", "no");
        }
        if (this.rbVeirfySome.isSelected()) {
            params.setString("verify", "some");
        }
        if (this.rbVerified.isSelected()) {
            params.setString("verify", "all");
        }
        if (this.rbNotVerify.isSelected() && this.rbVeirfySome.isSelected()) {
            params.setString("verify", "no_some");
        }
        if (this.rbVerified.isSelected() && this.rbVeirfySome.isSelected()) {
            params.setString("verify", "all_some");
        }
        if (this.rbVerified.isSelected() && this.rbNotVerify.isSelected()) {
            params.setString("verify", "no_all");
        }
        if (this.rbVerified.isSelected() && this.rbVeirfySome.isSelected() && this.rbNotVerify.isSelected()) {
            params.setString("verify", "no_some_all");
        }
        if (!(this.rbVerified.isSelected() || this.rbVeirfySome.isSelected() || this.rbNotVerify.isSelected())) {
            params.setString("verify", "none");
        }
        if (this.rbNotVoucher.isSelected()) {
            params.setString("voucher", "no");
        }
        if (this.rbVouchered.isSelected()) {
            params.setString("voucher", "yes");
        }
        if (this.cbSumAdminOrg.isSelected()) {
            params.setString("sumAdminorg", "yes");
        }
        if (this.cbSumAsstActPayer.isSelected()) {
            params.setString("sumAsstact", "yes");
        }
        if (this.cbSumPerson.isSelected()) {
            params.setString("sumPerson", "yes");
        }
        if (this.chkIncludeBizBill.isSelected()) {
            params.setString("includeBizBill", "yes");
        }
        if (!this.bizcheckBox.isSelected()) {
            params.setString("includeNowPay", "no");
        } else {
            if (this.comboPaymentType.getSelectedIndex() == 0) {
                params.setString("includeNowPay", "yes");
            }
            if (this.comboPaymentType.getSelectedIndex() == 1) {
                params.setString("includeNowPay", "only");
            }
        }
        return params;
    }

    public void setCustomCondition(RptParams params) {
        StorageOrgUnitInfo storageOrgUnitInfo;
        PersonInfo personInfo;
        AdminOrgUnitInfo adminOrgInfo;
        SaleOrgUnitInfo saleOrgInfo;
        OtherBillInfo otherBillInfo;
        this.resetValue();
        if (UIRuleUtil.isNotNull((String)params.getString("billType"))) {
            int billTypeNumber = Integer.parseInt(params.getString("billType"));
            this.comboBillType.setSelectedItem((Object)OtherBillTypeEnum.getEnum((int)billTypeNumber));
        } else {
            this.comboBillType.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("currency"))) {
            CurrencyInfo curInfo = new CurrencyInfo();
            curInfo.setId(BOSUuid.read((String)params.getString("currency")));
            curInfo.setName(params.getString("currencyName"));
            curInfo.setNumber(params.getString("currencyNumber"));
            this.prmtCurrency.setData((Object)curInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("asstActType"))) {
            this.combAsstActType.setSelectedIndex(params.getInt("asstActTypeSelectedIndex"));
            if (!this.combAsstActType.getSelectedItem().equals(ComBoxInfo.ITEM_ALL)) {
                this.prmtAsstActPayerFrom.setEnabled(true);
                this.prmtAsstActPayerTo.setEnabled(true);
            } else {
                this.prmtAsstActPayerFrom.setEnabled(false);
                this.prmtAsstActPayerTo.setEnabled(false);
            }
        }
        if (UIRuleUtil.isNotNull((String)params.getString("asstActNumberFrom"))) {
            this.setBizPromptData(this.prmtAsstActPayerFrom, params.getString("asstActNumberFromID"));
        }
        if (UIRuleUtil.isNotNull((String)params.getString("asstActNumberTo"))) {
            this.setBizPromptData(this.prmtAsstActPayerTo, params.getString("asstActNumberToID"));
        }
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (UIRuleUtil.isNotNull((String)params.getString("billDateFrom"))) {
            try {
                this.kddBillStartDate.setValue((Object)dtFormat.parse(params.getString("billDateFrom")));
            }
            catch (ParseException e) {
                this.kddBillStartDate.setValue((Object)new Date());
            }
        }
        if (UIRuleUtil.isNotNull((String)params.getString("billDateTo"))) {
            try {
                this.kddBillEndDate.setValue((Object)dtFormat.parse(params.getString("billDateTo")));
            }
            catch (ParseException e) {
                this.kddBillEndDate.setValue((Object)new Date());
            }
        }
        if (UIRuleUtil.isNotNull((String)params.getString("numberFrom"))) {
            otherBillInfo = new OtherBillInfo();
            otherBillInfo.setNumber(params.getString("numberFrom"));
            this.prmtBillNumberFrom.setData((Object)otherBillInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("numberTo"))) {
            otherBillInfo = new OtherBillInfo();
            otherBillInfo.setNumber(params.getString("numberTo"));
            this.prmtBillNumberTo.setData((Object)otherBillInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("saleOrgNumberFrom"))) {
            saleOrgInfo = new SaleOrgUnitInfo();
            saleOrgInfo.setNumber(params.getString("saleOrgNumberFrom"));
            saleOrgInfo.setName(params.getString("saleOrgNameFrom"));
            this.prmtSaleOrgFrom.setDisplayFormat("$name$");
            this.prmtSaleOrgFrom.setData((Object)saleOrgInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("saleOrgNumberTo"))) {
            saleOrgInfo = new SaleOrgUnitInfo();
            saleOrgInfo.setNumber(params.getString("saleOrgNumberTo"));
            saleOrgInfo.setName(params.getString("saleOrgNameTo"));
            this.prmtSaleOrgTo.setDisplayFormat("$name$");
            this.prmtSaleOrgTo.setData((Object)saleOrgInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("adminOrgNumberFrom"))) {
            adminOrgInfo = new AdminOrgUnitInfo();
            adminOrgInfo.setNumber(params.getString("adminOrgNumberFrom"));
            adminOrgInfo.setName(params.getString("adminOrgNameFrom"));
            this.prmtAdminOrgFrom.setDisplayFormat("$name$");
            this.prmtAdminOrgFrom.setData((Object)adminOrgInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("adminOrgNumberTo"))) {
            adminOrgInfo = new AdminOrgUnitInfo();
            adminOrgInfo.setNumber(params.getString("adminOrgNumberTo"));
            adminOrgInfo.setName(params.getString("adminOrgNameTo"));
            this.prmtAdminOrgTo.setDisplayFormat("$name$");
            this.prmtAdminOrgTo.setData((Object)adminOrgInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("personNumberFrom"))) {
            personInfo = new PersonInfo();
            personInfo.setNumber(params.getString("personNumberFrom"));
            personInfo.setName(params.getString("personNameFrom"));
            this.prmtPersonFrom.setDisplayFormat("$name$");
            this.prmtPersonFrom.setData((Object)personInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("personNumberTo"))) {
            personInfo = new PersonInfo();
            personInfo.setNumber(params.getString("personNumberTo"));
            personInfo.setName(params.getString("personNameTo"));
            this.prmtPersonTo.setDisplayFormat("$name$");
            this.prmtPersonTo.setData((Object)personInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("sendOrgUnitNumberFrom"))) {
            storageOrgUnitInfo = new StorageOrgUnitInfo();
            storageOrgUnitInfo.setNumber(params.getString("sendOrgUnitNumberFrom"));
            storageOrgUnitInfo.setName(params.getString("sendOrgUnitNameFrom"));
            this.prmtSendOrgUnitFrom.setDisplayFormat("$number$");
            this.prmtSendOrgUnitFrom.setData((Object)storageOrgUnitInfo);
        }
        if (UIRuleUtil.isNotNull((String)params.getString("sendOrgUnitNumberTo"))) {
            storageOrgUnitInfo = new StorageOrgUnitInfo();
            storageOrgUnitInfo.setNumber(params.getString("sendOrgUnitNumberTo"));
            storageOrgUnitInfo.setName(params.getString("sendOrgUnitNameTo"));
            this.prmtSendOrgUnitTO.setDisplayFormat("$number$");
            this.prmtSendOrgUnitTO.setData((Object)storageOrgUnitInfo);
        }
        this.rbAuditSelect.setSelected(true);
        if ("yes".equals(params.getString("audit"))) {
            this.rbAudited.setSelected(true);
        } else if ("no".equals(params.getString("audit"))) {
            this.rbNotAudit.setSelected(true);
        }
        if ("all".equals(params.getString("verify"))) {
            this.rbVerified.setSelected(true);
            this.rbNotVerify.setSelected(false);
            this.rbVeirfySome.setSelected(false);
        } else if ("some".equals(params.getString("verify"))) {
            this.rbVeirfySome.setSelected(true);
            this.rbVerified.setSelected(false);
            this.rbNotVerify.setSelected(false);
        } else if ("no".equals(params.getString("verify"))) {
            this.rbNotVerify.setSelected(true);
            this.rbVeirfySome.setSelected(false);
            this.rbVerified.setSelected(false);
        } else if ("no_some".equals(params.getString("verify"))) {
            this.rbNotVerify.setSelected(true);
            this.rbVeirfySome.setSelected(true);
            this.rbVerified.setSelected(false);
        } else if ("all_some".equals(params.getString("verify"))) {
            this.rbVerified.setSelected(true);
            this.rbVeirfySome.setSelected(true);
            this.rbNotVerify.setSelected(false);
        } else if ("no_all".equals(params.getString("verify"))) {
            this.rbVerified.setSelected(true);
            this.rbVeirfySome.setSelected(false);
            this.rbNotVerify.setSelected(true);
        } else if ("no_some_all".equals(params.getString("verify"))) {
            this.rbVerified.setSelected(true);
            this.rbVeirfySome.setSelected(true);
            this.rbNotVerify.setSelected(true);
        } else if ("none".equals(params.getString("verify"))) {
            this.rbVerified.setSelected(false);
            this.rbVeirfySome.setSelected(false);
            this.rbNotVerify.setSelected(false);
        }
        this.rbVoucherSelect.setSelected(true);
        if ("yes".equals(params.getString("voucher"))) {
            this.rbVouchered.setSelected(true);
        } else if ("no".equals(params.getString("voucher"))) {
            this.rbNotVoucher.setSelected(true);
        }
        if ("yes".equals(params.getString("sumAdminorg"))) {
            this.cbSumAdminOrg.setSelected(true);
        }
        if ("yes".equals(params.getString("sumPerson"))) {
            this.cbSumPerson.setSelected(true);
        }
        if ("yes".equals(params.getString("sumAsstact"))) {
            this.cbSumAsstActPayer.setSelected(true);
        }
        if ("yes".equals(params.getString("includeBizBill"))) {
            this.chkIncludeBizBill.setSelected(true);
        }
    }

    private void setAsstActType() {
        ArApBillUIUtil.makeAsstActType(this.combAsstActType, this.sysInfo, true);
        this.comboAsstActTypeSelectedIndex = this.combAsstActType.getSelectedIndex();
    }

    @Override
    protected void combAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        String queryInfo;
        if (e.getStateChange() != 1 || this.combAsstActType.getItemCount() == 0 || this.combAsstActType.getSelectedItem() == null) {
            return;
        }
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)currentCompany);
        String companyId = currentCompany.getId().toString();
        this.prmtAsstActPayerFrom.setValue(null);
        this.prmtAsstActPayerTo.setValue(null);
        Object obj = this.combAsstActType.getSelectedItem();
        if (this.combAsstActType.getItemCount() == 0 || obj == null || ComBoxInfo.ITEM_ALL.equals(obj)) {
            this.prmtAsstActPayerFrom.setEnabled(false);
            this.prmtAsstActPayerTo.setEnabled(false);
            return;
        }
        AsstActTypeInfo asstActType = (AsstActTypeInfo)obj;
        if (!ComBoxInfo.ITEM_ALL.equals(obj) && !UIRuleUtil.isNull((String)(queryInfo = asstActType.getDefaultQueryName()))) {
            GeneralKDPromptSelectorAdaptor selector;
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAsstActPayerFrom, this.prmtAsstActPayerTo, asstActType, companyId, this.sysInfo, true);
            this.prmtAsstActPayerFrom.setEnabled(true);
            this.prmtAsstActPayerTo.setEnabled(true);
            this.prmtAsstActPayerFrom.setEnabledMultiSelection(false);
            this.prmtAsstActPayerTo.setEnabledMultiSelection(false);
            if (this.prmtAsstActPayerFrom.getSelector() instanceof GeneralKDPromptSelectorAdaptor) {
                selector = (GeneralKDPromptSelectorAdaptor)this.prmtAsstActPayerFrom.getSelector();
                selector.setIsMultiSelect(false);
            }
            if (this.prmtAsstActPayerTo.getSelector() instanceof GeneralKDPromptSelectorAdaptor) {
                selector = (GeneralKDPromptSelectorAdaptor)this.prmtAsstActPayerTo.getSelector();
                selector.setIsMultiSelect(false);
            }
        }
    }

    private String getCompanyId() {
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (currentCompany.isIsOnlyUnion()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)ARRESOURCE, (String)COMPANY_IS_NULL));
            SysUtil.abort();
        }
        return currentCompany.getId().toString();
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    public void clear() {
        this.resetValue();
    }

    private void resetValue() {
        this.comboBillType.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
        this.prmtCurrency.setData(null);
        this.combAsstActType.setSelectedIndex(this.comboAsstActTypeSelectedIndex);
        this.prmtAsstActPayerFrom.setData(null);
        this.prmtAsstActPayerFrom.setEnabled(false);
        this.prmtAsstActPayerTo.setData(null);
        this.prmtAsstActPayerTo.setEditable(false);
        this.prmtBillNumberFrom.setData(null);
        this.prmtBillNumberTo.setData(null);
        this.kddBillStartDate.setValue(null);
        this.kddBillEndDate.setValue(null);
        this.prmtSaleOrgFrom.setData(null);
        this.prmtSaleOrgTo.setData(null);
        this.prmtAdminOrgFrom.setData(null);
        this.prmtAdminOrgTo.setData(null);
        this.prmtPersonFrom.setData(null);
        this.prmtPersonTo.setData(null);
        this.rbAuditSelect.setSelected(true);
        this.rbVoucherSelect.setSelected(true);
        this.rbNotVerify.setSelected(true);
        this.rbVerified.setSelected(true);
        this.rbVeirfySome.setSelected(true);
        this.cbSumAdminOrg.setSelected(false);
        this.cbSumAsstActPayer.setSelected(false);
        this.cbSumPerson.setSelected(false);
        this.chkIncludeBizBill.setSelected(false);
    }

    @Override
    protected void comboBillType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        OtherBillTypeEnum billType = null;
        this.prmtSaleOrgTo.setEnabled(true);
        this.prmtSaleOrgFrom.setEnabled(true);
        if (!e.getItem().equals(ComBoxInfo.ITEM_ALL) && (billType = (OtherBillTypeEnum)e.getItem()).getValue() == 101) {
            this.prmtSaleOrgTo.setEnabled(false);
            this.prmtSaleOrgFrom.setEnabled(false);
        }
    }
}

