/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.ArApSwapFacadeFactory;
import com.kingdee.eas.fi.ar.client.AbstractArSwapUI;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.framework.report.client.ProgressBarDialogAdapter;
import com.kingdee.eas.framework.report.client.ProgressBarRptDialog;
import com.kingdee.eas.framework.report.util.WindowMessage;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextField;
import oracle.sql.TIMESTAMP;
import org.apache.log4j.Logger;

public class ArSwapUI
extends AbstractArSwapUI {
    private static final Logger logger = CoreUIObject.getLogger(ArSwapUI.class);
    protected PeriodInfo periodInfo = null;
    String companyOrgUnitIDs = new String();
    private static ProgressBarRptDialog progressDialog = ProgressBarRptDialog.getDialogInstance(null);
    private boolean isLoading = true;
    protected boolean isFirstLoad = true;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initialize();
    }

    private void initialize() throws Exception {
        this.setUITitle(this.getResourceStr("ArSysEndTiaohui"));
        this.labWizardImg.setIcon(EASResource.getIcon((String)"imgGuide_pic338"));
        this.actionConfirm.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.kDSwapTable.checkParsed();
        OrgUnitFilterInfoProducer iProducer = (OrgUnitFilterInfoProducer)FilterInfoProducerFactory.getOrgUnitFilterInfoProducer((OrgType)OrgType.Company);
        iProducer.getModel().setPermissionItem(this.getPermissionItem());
        this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                ArSwapUI.this.getData();
                HashSet<Object> onlyDataSet = new HashSet<Object>();
                for (int i = 0; i < ArSwapUI.this.kDSwapTable.getRowCount(); ++i) {
                    IRow row = ArSwapUI.this.kDSwapTable.getRow(i);
                    Object currencyNoObj = row.getCell("currencyNo").getValue();
                    if (onlyDataSet.contains(currencyNoObj)) {
                        ArSwapUI.this.kDSwapTable.removeRow(i);
                        --i;
                        continue;
                    }
                    onlyDataSet.add(currencyNoObj);
                }
            }
        });
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        this.prmtCompany.setValue((Object)currentCompany);
        KDFormattedTextField kdtEntry_curExchangeRate_TextField = new KDFormattedTextField();
        KDTDefaultCellEditor kdtEntry_curExchangeRate_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntry_curExchangeRate_TextField);
        this.kDSwapTable.getColumn("curExchangeRate").setEditor((ICellEditor)kdtEntry_curExchangeRate_CellEditor);
        KDFormattedTextField kdtEntry_swapExchangeRate_TextField = new KDFormattedTextField();
        KDTDefaultCellEditor kdtEntry_swapExchangeRate_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntry_swapExchangeRate_TextField);
        this.kDSwapTable.getColumn("swapExchangeRate").setEditor((ICellEditor)kdtEntry_swapExchangeRate_CellEditor);
        KDTableUtils.setBigDecimalColumnPrecision(this.kDSwapTable, new String[]{"curExchangeRate", "swapExchangeRate"}, 9);
    }

    protected String getPermissionItem() {
        return "fi_ar_SwapRate";
    }

    private PeriodInfo getPeriodInfo(String companyID) {
        PeriodInfo periodInfo = null;
        try {
            SystemStatusCtrolCollection systemStatusCtrolCol;
            if (!"".equals(companyID) && (systemStatusCtrolCol = SystemStatusCtrolFactory.getRemoteInstance().getSystemStatusCtrolCollection("WHERE company.id='" + companyID + "' AND isStart='1' AND systemStatus.id='e45c1988-00fd-1000-e000-35d8c0a8200d02A5514C'")).size() > 0) {
                String periodID = UIRuleUtil.getString((Object)systemStatusCtrolCol.get(0).getCurrentPeriod().getId());
                periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(periodID));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return periodInfo;
    }

    public Map getValidCompanys() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String baseCurrencyId = "";
        String periodID = "";
        StringBuffer strBuf = new StringBuffer();
        Object companyObj = this.prmtCompany.getValue();
        IObjectValue baseCurrencyObj = null;
        if (companyObj instanceof Object && companyObj instanceof Object[]) {
            Object[] companys = (Object[])companyObj;
            if (companys != null && companys[0] != null) {
                int len = companys.length;
                for (int i = 0; i < len; ++i) {
                    String messagere;
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys[i];
                    String tempCurrencyID = UIRuleUtil.getString((Object)company.getBaseCurrency().getId());
                    PeriodInfo tempPeriodInfo = this.getPeriodInfo(UIRuleUtil.getString((Object)company.getId()));
                    String tempPeriodID = "";
                    if (tempPeriodInfo != null) {
                        tempPeriodID = UIRuleUtil.getString((Object)tempPeriodInfo.getId());
                    }
                    if (i == 0) {
                        baseCurrencyId = tempCurrencyID;
                        baseCurrencyObj = this.getBizObject(baseCurrencyId);
                        this.periodInfo = tempPeriodInfo;
                        periodID = tempPeriodID;
                    }
                    if (i > 0 && !baseCurrencyId.equals(tempCurrencyID)) {
                        messagere = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"DifferentBaseCurrency");
                        MsgBox.showInfo((Component)((Object)this), (String)messagere);
                        this.prmtCompany.setValue(null);
                        this.prmtPeriod.setValue(null);
                        this.prmtBaseCurrency.setValue(null);
                        this.kDSwapTable.removeRows();
                        SysUtil.abort();
                    } else if (!(i <= 0 || periodID.equals(tempPeriodID) && tempPeriodInfo != null)) {
                        messagere = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"DifferentAccountPeriod");
                        MsgBox.showInfo((Component)((Object)this), (String)messagere);
                        this.prmtCompany.setValue(null);
                        this.prmtPeriod.setValue(null);
                        this.prmtBaseCurrency.setValue(null);
                        this.kDSwapTable.removeRows();
                        SysUtil.abort();
                    }
                    strBuf.append("'" + company.getId() + "',");
                }
                if (strBuf.length() > 0) {
                    strBuf.deleteCharAt(strBuf.length() - 1);
                }
            }
        } else if (companyObj != null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyObj;
            baseCurrencyId = UIRuleUtil.getString((Object)company.getBaseCurrency().getId());
            baseCurrencyObj = this.getBizObject(baseCurrencyId);
            this.periodInfo = this.getPeriodInfo(UIRuleUtil.getString((Object)company.getId()));
            strBuf.append("'" + company.getId() + "'");
        }
        this.prmtBaseCurrency.setValue(baseCurrencyObj);
        this.prmtPeriod.setValue((Object)this.periodInfo);
        this.companyOrgUnitIDs = strBuf.toString();
        params.put("companyIDs", this.companyOrgUnitIDs);
        params.put("baseCurrencyId", baseCurrencyId);
        if (this.periodInfo != null) {
            params.put("periodBeginDate", this.periodInfo.getBeginDate());
            params.put("periodEndDate", this.periodInfo.getEndDate());
        }
        return params;
    }

    private void verify() {
        boolean isNull = false;
        Object companyObj = this.prmtCompany.getValue();
        if (companyObj instanceof Object && companyObj instanceof Object[]) {
            Object[] companys = (Object[])companyObj;
            if (companys == null || companys[0] == null) {
                isNull = true;
            }
        } else if (companyObj == null) {
            isNull = true;
        }
        if (isNull) {
            String messagere = EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"nullCompany");
            MsgBox.showInfo((Component)((Object)this), (String)messagere);
            SysUtil.abort();
        }
        for (int i = 0; i < this.kDSwapTable.getRowCount(); ++i) {
            BigDecimal swapRate;
            String messagere;
            IRow row = this.kDSwapTable.getRow(i);
            Object curRateObj = row.getCell("curExchangeRate").getValue();
            Object swapRateObj = row.getCell("swapExchangeRate").getValue();
            if (curRateObj == null) {
                messagere = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"curRateNotNull");
                MsgBox.showInfo((Component)((Object)this), (String)messagere);
                this.kDSwapTable.getSelectManager().select(i, 0, 2);
                SysUtil.abort();
            }
            if (swapRateObj == null) {
                messagere = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"SwapRateNotNull");
                MsgBox.showInfo((Component)((Object)this), (String)messagere);
                this.kDSwapTable.getSelectManager().select(i, 0, 2);
                SysUtil.abort();
            }
            if ((swapRate = UIRuleUtil.getBigDecimal((Object)swapRateObj)).compareTo(BigDecimal.ZERO) > 0) continue;
            String messagere2 = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"SwapRateNotZero");
            MsgBox.showInfo((Component)((Object)this), (String)messagere2);
            this.kDSwapTable.getSelectManager().select(i, 0, 2);
            SysUtil.abort();
        }
    }

    public void getData() {
        try {
            IRowSet rs = ArApSwapFacadeFactory.getRemoteInstance().getExchangeRateData(this.getValidCompanys());
            if (rs != null && rs.size() > 0) {
                HashMap params = new HashMap();
                String[][] tableColumns = new String[][]{{"currencyID", "sourceCurrencyID", this.getResourceStr("CurrencyId")}, {"currencyNo", "sourceCurrencyNo", this.getResourceStr("CurrencyNumber")}, {"currencyName", "sourceCurrencyName", this.getResourceStr("CurrencyName")}, {"curExchangeRate", "convertRate", this.getResourceStr("CurrentExchange")}, {"swapExchangeRate", "swapRate", this.getResourceStr("ChangeExchange")}};
                this.kDSwapTable.removeRows(false);
                while (rs.next()) {
                    IRow row = this.kDSwapTable.addRow();
                    int rowIndex = row.getRowIndex();
                    int cSize = tableColumns.length;
                    for (int cIndex = 0; cIndex < cSize; ++cIndex) {
                        Object value = rs.getObject(tableColumns[cIndex][1]);
                        if (value instanceof TIMESTAMP) {
                            value = ((TIMESTAMP)value).dateValue();
                        }
                        KDTableUtils.setFieldValue(this.kDSwapTable, rowIndex, tableColumns[cIndex][0], value);
                    }
                }
            } else {
                this.kDSwapTable.removeRows();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        if (this.prmtPeriod.getValue() == null) {
            this.abort();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isRec", true);
        int rowCount = this.kDSwapTable.getRowCount();
        Object[][] currencyGroup = new Object[rowCount][2];
        this.periodInfo = (PeriodInfo)this.prmtPeriod.getValue();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kDSwapTable.getRow(i);
            BigDecimal swapExchangeRate = UIRuleUtil.getBigDecimal((Object)row.getCell("swapExchangeRate").getValue());
            currencyGroup[i][0] = row.getCell("currencyID").getValue();
            currencyGroup[i][1] = swapExchangeRate;
        }
        params.put("currencyGroup", currencyGroup);
        params.put("period", this.prmtPeriod.getValue());
        params.put("companyIDs", this.companyOrgUnitIDs);
        String messageStr = ArApSwapFacadeFactory.getRemoteInstance().checkBill(params);
        if (messageStr.length() > 0) {
            MsgBox.showConfirm3a((Component)((Object)this), (String)this.getResourceStr("TiaohuiChaeckTotal"), (String)messageStr);
            this.abort();
        } else {
            this.actionSwapRate(params);
        }
    }

    private void actionSwapRate(Map paramsMap) throws Exception {
        final MonitorInfo info = new MonitorInfo(this.getUITitle(), null, (Object)this, false);
        final Map params = paramsMap;
        progressDialog = ProgressBarRptDialog.getDialogInstance((Object)((Object)this));
        final SwingWorker worker = new SwingWorker(){
            private boolean stop = false;

            public Object construct() {
                while (ArSwapUI.this.isLoading) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return null;
            }

            public void finished() {
                if (!this.stop) {
                    String title = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"has_finished"), ArSwapUI.this.getUITitle());
                    new WindowMessage("250", "150", ArSwapUI.this.getResourceStr("ArSysEndTiaohui"), title, info);
                    ThreadPool.destroyMonitor((MonitorInfo)info);
                    info.setTitle(title);
                    ThreadPool.addActionThread((MonitorInfo)info);
                }
            }

            public void finishedLater() {
                ThreadPool.destroyMonitor((MonitorInfo)info);
                if (ArSwapUI.this.isLoading) {
                    this.stop = true;
                    IMainUIObject mainUI = ArSwapUI.this.getMainUIObject();
                    IUIObject[] uiObjects = mainUI.getUiManager().findUIObject(ArSwapUI.this.getUIFullName());
                    if (uiObjects != null && uiObjects.length > 0) {
                        mainUI.getUiManager().closeTab(uiObjects[0]);
                    }
                    ArSwapUI.this.close();
                }
                if (progressDialog != null && progressDialog.isShowing()) {
                    progressDialog.dispose();
                }
                try {
                    UIContext uiContext = new UIContext((Object)this);
                    IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.ar.client.SwapRateBillListUI", (Map)uiContext, null, OprtState.VIEW);
                    ArSwapUI.this.addTabOnMainUI(popUI.getUIObject());
                    ArSwapUI.this.onShow();
                }
                catch (Exception e) {
                    ArSwapUI.this.handUIException(e);
                }
            }
        };
        SwingWorker dataWorker = new SwingWorker(){
            boolean isSuccess = false;

            public Object construct() {
                try {
                    ArApSwapFacadeFactory.getRemoteInstance().swapRate(params);
                    this.isSuccess = true;
                }
                catch (Exception e) {
                    ArSwapUI.this.handUIException(e);
                }
                ArSwapUI.this.isLoading = false;
                ArSwapUI.this.isFirstLoad = false;
                return null;
            }

            public void finished() {
                if (progressDialog != null && progressDialog.isShowing()) {
                    progressDialog.dispose();
                }
                if (this.isSuccess) {
                    MsgBox.showInfo((String)ArSwapUI.this.getResourceStr("EndTiaohuiFinish"));
                    ArSwapUI.this.destroyWindow();
                }
            }
        };
        dataWorker.start();
        SwingWorker processBarWorker = new SwingWorker(){

            public Object construct() {
                if (progressDialog != null) {
                    progressDialog.setTitle(ArSwapUI.this.getUITitle());
                    if (ProgressBarDialogAdapter.show((ProgressBarRptDialog)progressDialog)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            ArSwapUI.this.handleException(e);
                        }
                        ArSwapUI.this.removeTabOnMainUI((IUIObject)info.getUi());
                        info.setWorker(worker);
                        ThreadPool.addActionThread((MonitorInfo)info);
                    }
                }
                return null;
            }
        };
        processBarWorker.start();
    }

    protected void removeTabOnMainUI(IUIObject object) {
        IMainUIObject mainUI = this.getMainUIObject();
        mainUI.getUiManager().removeTab(object);
    }

    protected void removeTabOnMainUI() {
        IMainUIObject mainUI = this.getMainUIObject();
        IUIObject[] uiObjects = mainUI.getUiManager().findUIObject(this.getUIFullName());
        if (uiObjects != null && uiObjects.length > 0) {
            mainUI.getUiManager().removeTab(uiObjects[0]);
        }
    }

    protected void addTabOnMainUI(IUIObject object) {
        IMainUIObject mainUI = this.getMainUIObject();
        IUIObject[] uiObjects = mainUI.getUiManager().findUIObject(this.getUIFullName());
        boolean hasOnloadUI = false;
        if (uiObjects != null && uiObjects.length > 0) {
            int length = uiObjects.length;
            for (int i = 0; i < length; ++i) {
                if (!uiObjects[i].equals(object)) continue;
                hasOnloadUI = true;
                break;
            }
        }
        if (!hasOnloadUI) {
            mainUI.getUiManager().addTab(object);
            mainUI.getUiManager().changeTab(object);
        }
    }

    protected void close() {
        SysUtil.abort();
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.fi.ar.client.SwapRateBillListUI";
    }

    protected IMainUIObject getMainUIObject() {
        Object mainUI = null;
        try {
            Frame frame = UIFactoryHelper.getMainFrame((Map)this.getUIContext());
            mainUI = frame instanceof NewMainFrame ? ((NewMainFrame)frame).getMainUI() : UIFactoryHelper.getMainUIObject((Map)this.getUIContext());
        }
        catch (UIException e) {
            this.handleException((Exception)((Object)e));
        }
        return mainUI;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private IObjectValue getBizObject(String id) {
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk, sic);
            return objVal;
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
            return null;
        }
    }

    private String getResourceStr(String key) {
        String resClassName = "com.kingdee.eas.fi.ar.ArAllResource";
        return EASResource.getString((String)resClassName, (String)key);
    }
}

