/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractArVirtualAgingQueryUI;
import com.kingdee.eas.fi.arap.DateFieldEnum;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.AccountAgeRptParamConvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.IRptParamConvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.RptParamConvertorFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class ArVirtualAgingQueryUI
extends AbstractArVirtualAgingQueryUI {
    private static final long serialVersionUID = -5241576447429323908L;
    private static final Logger logger = CoreUIObject.getLogger(ArVirtualAgingQueryUI.class);
    private ItemListener chkIsCentralBalanceListener = null;
    private AccountAgeQueryParam rptParam = null;
    private ItemListener chkIsChoosePaymentTypeListener = null;
    private ItemListener comboCurrency_itemStateChangedListener = null;
    protected boolean isBaseCurrency = false;

    @Override
    protected String getPermissionItem() {
        return "fi_arap_ArAgesReport";
    }

    @Override
    protected void initCtrls() throws Exception {
        this.removeControlListener();
        super.initCtrls();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboCurrency.getModel();
        CurrencyInfo baseCurr = new CurrencyInfo();
        baseCurr.put("id", (Object)"base");
        baseCurr.put("number", (Object)"base");
        baseCurr.put("name", (Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Currency_BaseCurrency"));
        model.insertElementAt(baseCurr, model.getSize() - 1);
        this.chkIncludeBizBill.setEnabled(false);
        this.initComboAgingDateFld();
        this.comboAnalyseDir.removeAllItems();
        this.comboAnalyseDir.addItems((Object[])this.getDirections());
        this.chkIncludeBizBill.addItems((Object[])this.getBizTypetions());
        this.prmtAdminOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtPerson.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrg, false, true, false);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPerson, true);
        this.prmtRecPayBillType.setCommitFormat("$number$");
        this.prmtRecPayBillType.setDisplayFormat("$name$");
        this.prmtRecPayBillType.setEditFormat("$number$");
        this.initBillType();
        this.addListen();
    }

    protected void initComboAgingDateFld() {
        this.comboAgingDateFld.removeItem((Object)DateFieldEnum.AP_DATE);
    }

    protected void chkIsChoosePaymentTypeChanged(ItemEvent arg0) throws Exception {
        boolean ischeckBox = this.bizcheckPaymentTypeBox.isSelected();
        if (ischeckBox) {
            this.contPaymentType.setEnabled(true);
        } else {
            this.contPaymentType.setEnabled(false);
        }
    }

    protected String[] getDirections() {
        String[] dirLbls = new String[]{EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"Dir_Receivable"), EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"Dir_Receiving"), EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"Dir_All")};
        return dirLbls;
    }

    protected String[] getBizTypetions() {
        String[] bizTypeLbls = new String[]{EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"arIncludeBizType"), EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"arOnlyBizType")};
        return bizTypeLbls;
    }

    protected void initBillType() {
        this.prmtRecPayBillType.setQueryInfo("com.kingdee.eas.fi.cas.ReceivingBillTypeQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("sourceSysType", (Object)new Integer(100)));
        this.prmtRecPayBillType.setEntityViewInfo(view);
    }

    private void removeControlListener() {
        if (null != this.chkIsCentralBalanceListener) {
            this.bizcheckBox.removeItemListener(this.chkIsCentralBalanceListener);
        }
        if (null != this.chkIsChoosePaymentTypeListener) {
            this.bizcheckPaymentTypeBox.removeItemListener(this.chkIsChoosePaymentTypeListener);
        }
        if (null != this.comboCurrency_itemStateChangedListener) {
            this.comboCurrency.removeItemListener(this.comboCurrency_itemStateChangedListener);
        }
    }

    private void addListen() {
        this.chkIsCentralBalanceListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    ArVirtualAgingQueryUI.this.chkIsCentralBalanceChanged(arg0);
                }
                catch (Exception e) {
                    ArVirtualAgingQueryUI.this.handUIException(e);
                }
            }
        };
        this.bizcheckBox.addItemListener(this.chkIsCentralBalanceListener);
        this.chkIsChoosePaymentTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    ArVirtualAgingQueryUI.this.chkIsChoosePaymentTypeChanged(arg0);
                }
                catch (Exception e) {
                    ArVirtualAgingQueryUI.this.handUIException(e);
                }
            }
        };
        this.bizcheckPaymentTypeBox.addItemListener(this.chkIsChoosePaymentTypeListener);
        if (null == this.comboCurrency_itemStateChangedListener) {
            this.comboCurrency_itemStateChangedListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        if ("base".equals(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)ArVirtualAgingQueryUI.this.comboCurrency.getSelectedItem()), (String)"id"))) {
                            ArVirtualAgingQueryUI.this.isBaseCurrency = true;
                            ArVirtualAgingQueryUI.this.chkLocAmt.setSelected(false);
                            ArVirtualAgingQueryUI.this.chkLocAmt.setEnabled(false);
                        } else {
                            ArVirtualAgingQueryUI.this.isBaseCurrency = false;
                            ArVirtualAgingQueryUI.this.chkLocAmt.setEnabled(true);
                        }
                    }
                    catch (Exception ex) {
                        ArVirtualAgingQueryUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.comboCurrency.addItemListener(this.comboCurrency_itemStateChangedListener);
    }

    protected void chkIsCentralBalanceChanged(ItemEvent arg0) throws Exception {
        boolean ischeckBox = this.bizcheckBox.isSelected();
        if (ischeckBox) {
            this.chkIncludeBizBill.setEnabled(true);
        } else {
            this.chkIncludeBizBill.setEnabled(false);
        }
    }

    @Override
    protected void comboAnalyseDir_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        boolean fArAp = this.comboAnalyseDir.getSelectedIndex() == 0;
        boolean fRecPay = this.comboAnalyseDir.getSelectedIndex() == 1;
        this.chkInvType.setSelected(fArAp);
        this.chkExpenseInvType.setSelected(fArAp);
        this.chkOtherType.setSelected(fArAp);
        this.chkDebitadjust.setSelected(fArAp);
        this.chkInvType.setEnabled(fArAp);
        this.chkExpenseInvType.setEnabled(fArAp);
        this.chkOtherType.setEnabled(fArAp);
        this.chkDebitadjust.setEnabled(fArAp);
        this.prmtRecPayBillType.setEnabled(fRecPay);
        if (!fRecPay) {
            this.prmtRecPayBillType.setValue(null);
        }
    }

    @Override
    public RptParams getCustomCondition() {
        RptParams biRptParam = new RptParams();
        biRptParam.setObject("qryParam", (Object)this.getRptParam());
        return biRptParam;
    }

    public CustomerParams getCustomerParams() {
        IRptParamConvertor convertor = RptParamConvertorFactory.getConvertor(this.getRptParam());
        return convertor.convertClient();
    }

    public void setCustomerParams(CustomerParams cp) {
        this.rptParam = new AccountAgeQueryParam();
        this.rptParam.setIsArRpt(this.isArRpt());
        AccountAgeRptParamConvertor convertor = new AccountAgeRptParamConvertor();
        convertor.setRptParam((IReportQueryParam)this.rptParam);
        try {
            convertor.read(null, cp);
        }
        catch (Exception e) {
            logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
        }
    }

    public void loadData(EntityViewInfo view) {
        this.loadRptParam(this.rptParam);
    }

    private void loadRptParam(AccountAgeQueryParam param) {
        this.clear();
        if (param == null) {
            return;
        }
        this.loadCompanysData(param.getCompanyIds());
        this.loadCurrCussAcctData(param);
        this.pkDateFrom.setValue((Object)param.getBeginDate());
        this.pkDateTo.setValue((Object)param.getEndDate());
        this.comboAnalyseDir.setSelectedIndex(param.getDirIndex());
        this.chkIncludeBizBill.setSelectedIndex(param.getBizeIndex());
        this.comboAnalyseObj.setSelectedIndex(param.getAnalyseObjIndex());
        this.comboAgingDateFld.setSelectedIndex(param.getDateFldIndex());
        this.pkAgingCompareDate.setValue((Object)param.getAgingCompareDate());
        this.bizcheckBox.setSelected(param.isBizeCheckBox());
        this.comboGroupType.setSelectedIndex(param.getGroupTypeIndex());
        this.comboPaymentType.setSelectedIndex(param.getPaymentTypeIndex());
        if (param.getAdminOrgId() != null) {
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            adminInfo.put("id", (Object)param.getAdminOrgId());
            adminInfo.setName(param.getAdminOrgName());
            adminInfo.setNumber(param.getAdminOrgNum());
            this.prmtAdminOrg.setValue((Object)adminInfo);
        }
        if (param.getSalesId() != null) {
            PersonInfo salesInfo = new PersonInfo();
            salesInfo.put("id", (Object)param.getSalesId());
            salesInfo.setName(param.getSalesName());
            salesInfo.setNumber(param.getSalesNum());
            this.prmtPerson.setValue((Object)salesInfo);
        }
        ArApQueryUIUtil.loadInfos((IUIObject)this, this.prmtAdminOrg, param.getAdminOrgIds());
        ArApQueryUIUtil.loadInfos((IUIObject)this, this.prmtPerson, param.getPersonIds());
        ArApQueryUIUtil.loadInfos((IUIObject)this, this.prmtRecPayBillType, param.getRecpayBillTypes());
        List recpayTypes = param.getRecpayBillTypes();
        this.loadRecpayTypes(recpayTypes);
        List arapTypes = param.getArapBillTypes();
        this.loadArapTypes(arapTypes);
        this.chkEndDateBal.setSelected(param.isEndDateBal());
        this.chkLocAmt.setSelected(param.hasLocAmt());
    }

    private void loadRecpayTypes(List recpayTypes) {
        if (recpayTypes == null || recpayTypes.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        FilterInfo filter = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(recpayTypes);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            DataBaseCollection types = this.getRecpayTypeInterface().getDataBaseCollection(view);
            this.prmtRecPayBillType.setValue((Object)types.toArray());
        }
        catch (Exception e) {
            logger.error((Object)"load recpay types", (Throwable)e);
            this.handUIException(e);
        }
    }

    protected IDataBase getRecpayTypeInterface() throws BOSException {
        return ReceivingBillTypeFactory.getRemoteInstance();
    }

    protected void loadArapTypes(List arapTypes) {
        if (arapTypes == null || arapTypes.size() == 0) {
            return;
        }
        this.chkInvType.setSelected(false);
        this.chkExpenseInvType.setSelected(false);
        this.chkOtherType.setSelected(false);
        this.chkDebitadjust.setSelected(false);
        int n = arapTypes.size();
        for (int i = 0; i < n; ++i) {
            int iType = Integer.parseInt(arapTypes.get(i).toString());
            if (iType == 102) {
                this.chkInvType.setSelected(true);
                continue;
            }
            if (iType == 103) {
                this.chkExpenseInvType.setSelected(true);
                continue;
            }
            if (iType == 101) {
                this.chkOtherType.setSelected(true);
                continue;
            }
            if (iType != 104) continue;
            this.chkDebitadjust.setSelected(true);
        }
    }

    public IReportQueryParam getRptParam() {
        AccountAgeQueryParam param = new AccountAgeQueryParam();
        param.setCompanyId(this.companyId);
        param.setCompanyIds(this.getQueryCompanyIds());
        param.setCuIds(this.getQueryCompanyCuIds());
        param.setCuId(this.currentCompany.getCU().getString("id"));
        param.setIsArRpt(this.isArRpt());
        this.setCurrCussAcct2RptParam(param);
        Date sqlDate = new Date(DateTimeUtils.truncateDate((java.util.Date)this.pkDateFrom.getSqlDate()).getTime());
        param.setBeginDate(sqlDate);
        sqlDate = new Date(DateTimeUtils.truncateDate((java.util.Date)this.pkDateTo.getSqlDate()).getTime());
        param.setEndDate(sqlDate);
        sqlDate = new Date(DateTimeUtils.truncateDate((java.util.Date)this.pkAgingCompareDate.getSqlDate()).getTime());
        param.setAgingCompareDate(sqlDate);
        param.setAnalyseObjIndex(this.comboAnalyseObj.getSelectedIndex());
        param.setDirIndex(this.comboAnalyseDir.getSelectedIndex());
        param.setBizeIndex(this.chkIncludeBizBill.getSelectedIndex());
        param.setDateFldIndex(this.comboAgingDateFld.getSelectedIndex());
        param.setBizeCheckBox(this.bizcheckBox.isSelected());
        param.setPaymentTypeIndex(this.comboPaymentType.getSelectedIndex());
        param.setPaymentTypeCheckBox(this.bizcheckPaymentTypeBox.isSelected());
        param.setGroupTypeIndex(this.comboGroupType.getSelectedIndex());
        this.saveAdminOrg(param);
        this.savePerson(param);
        this.saveRecpayTypes(param);
        this.saveArapBillTypes(param);
        param.setEndDateBal(this.chkEndDateBal.isSelected());
        param.setHasLocAmt(this.chkLocAmt.isSelected());
        param.setBaseCurrency(this.isBaseCurrency);
        return param;
    }

    private void saveRecpayTypes(AccountAgeQueryParam param) {
        Object objType = this.prmtRecPayBillType.getValue();
        if (objType != null) {
            Object[] recpayTypeArr = (Object[])objType;
            param.setRecpayBillTypes(ArApQueryUIUtil.getInfoIds(recpayTypeArr));
        }
    }

    protected void saveArapBillTypes(AccountAgeQueryParam param) {
        ArrayList<String> arapTypes = new ArrayList<String>();
        if (this.chkInvType.isSelected()) {
            arapTypes.add(String.valueOf(102));
        }
        if (this.chkExpenseInvType.isSelected()) {
            arapTypes.add(String.valueOf(103));
        }
        if (this.chkOtherType.isSelected()) {
            arapTypes.add(String.valueOf(101));
        }
        if (this.chkDebitadjust.isSelected()) {
            arapTypes.add(String.valueOf(104));
        }
        param.setArapBillTypes(arapTypes);
    }

    private void saveAdminOrg(AccountAgeQueryParam param) {
        Object objBiz = this.prmtAdminOrg.getValue();
        if (objBiz == null) {
            return;
        }
        if (objBiz instanceof DataBaseInfo) {
            DataBaseInfo adminInfo = (DataBaseInfo)objBiz;
            param.setAdminOrgId(adminInfo.getString("id"));
            param.setAdminOrgName(adminInfo.getName());
            param.setAdminOrgNum(adminInfo.getNumber());
        } else {
            Object[] objInfoArr = (Object[])objBiz;
            param.setAdminOrgIds(ArApQueryUIUtil.getInfoIds(objInfoArr));
        }
    }

    private void savePerson(AccountAgeQueryParam param) {
        Object objBiz = this.prmtPerson.getValue();
        if (objBiz == null) {
            return;
        }
        if (objBiz instanceof DataBaseInfo) {
            DataBaseInfo salesInfo = (DataBaseInfo)objBiz;
            param.setSalesId(salesInfo.getString("id"));
            param.setSalesName(salesInfo.getName());
            param.setSalesNum(salesInfo.getNumber());
        } else {
            Object[] objInfoArr = (Object[])objBiz;
            param.setPersonIds(ArApQueryUIUtil.getInfoIds(objInfoArr));
        }
    }

    @Override
    protected List getRequiredCtrls() {
        List lst = super.getRequiredCtrls();
        lst.add(this.pkDateFrom);
        lst.add(this.pkDateTo);
        lst.add(this.pkAgingCompareDate);
        return lst;
    }

    @Override
    public void clear() {
        super.clear();
        java.util.Date curDay = new java.util.Date();
        this.pkDateFrom.setValue((Object)curDay);
        this.pkDateTo.setValue((Object)curDay);
        this.comboAnalyseDir.setSelectedIndex(0);
        this.chkIncludeBizBill.setSelectedIndex(0);
        this.comboAnalyseObj.setSelectedIndex(0);
        this.chkInvType.setSelected(true);
        this.chkExpenseInvType.setSelected(true);
        this.chkOtherType.setSelected(true);
        this.chkDebitadjust.setSelected(true);
        this.comboAgingDateFld.setSelectedIndex(0);
        this.pkAgingCompareDate.setValue((Object)curDay);
        this.prmtAdminOrg.setValue(null);
        this.prmtPerson.setValue(null);
        this.chkEndDateBal.setSelected(false);
        this.bizcheckBox.setSelected(false);
        this.chkLocAmt.setSelected(false);
    }

    @Override
    protected String getPermissionRes() {
        return "ForbidenArAgingRptQry";
    }

    @Override
    public boolean verify() {
        boolean fVerify = super.verify();
        if (!(this.comboAnalyseDir.getSelectedIndex() != 0 || this.chkInvType.isSelected() || this.chkExpenseInvType.isSelected() || this.chkOtherType.isSelected() || this.chkDebitadjust.isSelected())) {
            String msgPattern = EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"QryUI_MustHave");
            String sBillDir = this.lblArApBillType.getText();
            String msg = MessageFormat.format(msgPattern, sBillDir);
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return false;
        }
        return fVerify;
    }

    public AccountAgeQueryParam getAccountAgeQueryParam() {
        return this.rptParam;
    }
}

