/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.ArVirtualSumRptFacadeFactory;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.SummaryRptQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractArVirtualSumRptUI;
import com.kingdee.eas.fi.ar.client.ArAgingRptExportManager;
import com.kingdee.eas.fi.ar.client.ArItemRptUI;
import com.kingdee.eas.fi.arap.client.ArApBiSumRptClntHelper;
import com.kingdee.eas.fi.arap.client.ArApVirtualSumRptQueryUI;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.client.util.SummRptTablePrintUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.ObjectUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArVirtualSumRptUI
extends AbstractArVirtualSumRptUI {
    private static final Logger logger = CoreUIObject.getLogger(ArVirtualSumRptUI.class);
    private ArAgingRptExportManager exportManager;

    public ArVirtualSumRptUI() throws Exception {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.exportManager = new ArAgingRptExportManager(this.tblMain);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.enableExportExcel(this.tblMain);
        this.actionJoinQuery.setEnabled(true);
        this.actionJoinQuery.setVisible(true);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fFirstLoad = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        boolean oldValue = this.fFirstLoad;
        int oldRowCount = this.insertRowCount;
        this.fFirstLoad = true;
        this.insertRowCount = 0;
        if (!this.showQueryDialog(false)) {
            this.fFirstLoad = oldValue;
            this.insertRowCount = oldRowCount;
        }
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return ArVirtualSumRptFacadeFactory.getRemoteInstance();
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return ArVirtualSumRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.getTable();
    }

    protected KDTable getTableForPrintSetting() {
        return this.getTable();
    }

    protected CustomerQueryPanel[] getCustomerQueryPanels() throws Exception {
        CustomerQueryPanel[] panels = new CustomerQueryPanel[]{new ArApVirtualSumRptQueryUI(true)};
        return panels;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    @Override
    protected String getPrintPermItem() {
        return "fi_arap_ArSumReport_Print";
    }

    @Override
    protected List getQueryCompanys() {
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
        if (param != null) {
            return param.getCompanyIds();
        }
        return null;
    }

    @Override
    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        ItemRptQueryParam itemRptParam = this.getItemRptParam();
        if (itemRptParam == null) {
            return;
        }
        boolean flag = true;
        Set threadSet = ThreadPool.getCurrentThread();
        if (threadSet != null) {
            MonitorInfo info2 = null;
            for (MonitorInfo info2 : threadSet) {
                if (info2 == null || info2.getUi() == null || !info2.getUi().getClass().getName().equals(ArItemRptUI.class.getName())) continue;
                flag = info2.getWorker() == null || !info2.getWorker().isIsFinished();
                break;
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"RPTFilter", (Object)itemRptParam);
        if (!flag) {
            uiContext.put((Object)"operator", (Object)"actionJoinQuery");
        }
        IUIWindow itemRptUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ArItemRptUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        itemRptUI.show();
    }

    protected ItemRptQueryParam getItemRptParam() throws Exception {
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
        return ArApBiSumRptClntHelper.getItemRptParam(ArApReportUIUtil.getSelectedRow(this.getTable()), this, param);
    }

    public void tblDoubleClicked(int row, int column, int x, int y) {
        try {
            this.actionJoinQuery_actionPerformed(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        RptParams pp = new RptParams();
        IRow row = this.getTable().getRow(rowIndex);
        pp.setString("FAsstActId", String.valueOf(row.getCell("FAsstActId").getValue()));
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
        pp.setString("paramCurrency", UIRuleUtil.getString((Object)param.getCurrencyId()));
        pp.setString("isBaseCurrency", UIRuleUtil.getString((Object)param.isBaseCurrency()));
        if ("base".equals(param.getCurrencyId())) {
            pp.setString("FBaseCurrencyId", row.getCell("FBaseCurrencyId").getValue().toString());
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            pp.setString("FCurrencyId", row.getCell("FCurrencyId").getValue().toString());
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            pp.setString("FCurrencyId", row.getCell("FCurrencyId").getValue().toString());
            pp.setString("FBaseCurrencyId", row.getCell("FBaseCurrencyId").getValue().toString());
        }
        pp.setString("FPeriodId", row.getCell("FPeriodId").getValue().toString());
        pp.setString("FParentId", companyUserObject.getCompanyId());
        pp.setString("tempTable", this.getTempTable());
        RptParams result = this.getVirtualRemoteInstance().findData(pp, 0, -1, this.getTempTable(), (Object)companyUserObject);
        return result;
    }

    protected void query() {
        this.tblMain.removeColumns();
        try {
            this.tblMain.removeRows();
            super.query();
        }
        catch (Exception e) {
            logger.error((Object)"sumRpt query", (Throwable)e);
        }
    }

    public void getData(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        try {
            SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
            IVirtualRptBaseFacade iRpt = this.getVirtualRemoteInstance();
            if (this.fFirstLoad) {
                RptParams rptRslt = null;
                if (!this.exportManager.isFirstLoad()) {
                    rptRslt = iRpt.createTempTable(this.params);
                    this.exportManager.setInitRptParams((RptParams)ObjectUtils.createCopy((Object)rptRslt));
                } else {
                    rptRslt = this.exportManager.getInitRptParams();
                    this.exportManager.finishFirstLoad();
                }
                String tmpTable = rptRslt.getString("tempTable");
                param.setTempTable(tmpTable);
                this.setTempTable(tmpTable);
                this.initTableHeader(rptRslt);
                this.params.setBoolean("fFirstLoad", true);
                rptRslt = iRpt.query(this.params, start, length);
                if (rptRslt == null) {
                    return;
                }
                RptRowSet rs = (RptRowSet)rptRslt.getObject("rowset");
                this.tblMain.setRowCount(rptRslt.getInt("totalRowCount"));
                param.setTotalRowCount(rptRslt.getInt("totalRowCount"));
                this.isDoExpand = false;
                this.insertRows(rs, start, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                this.initUserConfig();
                this.isDoExpand = true;
                this.fFirstLoad = false;
                if (param.isMultiCompanys()) {
                    this.tblMain.getGroupManager().setGroup(false);
                    this.innerStart = this.tblMain.getDataRequestManager().getPageRowCount();
                    this.innerLength = this.innerStart + this.tblMain.getDataRequestManager().getPageRowCount() > param.getTotalRowCount() ? param.getTotalRowCount() - this.innerStart : this.tblMain.getDataRequestManager().getPageRowCount();
                }
            } else {
                this.params.setBoolean("fFirstLoad", false);
                if (param.isMultiCompanys()) {
                    RptParams rpt = iRpt.query(this.params, this.innerStart, this.innerLength);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.isDoExpand = false;
                    this.insertRows(rs, this.innerStart, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
                    this.isDoExpand = true;
                    this.innerStart += this.tblMain.getDataRequestManager().getPageRowCount();
                    this.innerLength = this.innerStart + this.tblMain.getDataRequestManager().getPageRowCount() > param.getTotalRowCount() ? param.getTotalRowCount() - this.innerStart : this.tblMain.getDataRequestManager().getPageRowCount();
                } else {
                    RptParams rpt = iRpt.query(this.params, start, length);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.isDoExpand = false;
                    this.insertRows(rs, start, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
                    this.isDoExpand = true;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ui loadRpt", (Throwable)ex);
            this.processException(ex);
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        if (rs.getRowCount() == 0) {
            return;
        }
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
        String rangeDesc = null;
        if (!param.isByPeriod()) {
            Date beginDate = param.getBeginDate();
            Date endDate = param.getEndDate();
            DateFormat dtFormat = BOSLocaleUtil.getDateFormat();
            rangeDesc = EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"dateRangeDesc");
            rangeDesc = MessageFormat.format(rangeDesc, dtFormat.format(beginDate), dtFormat.format(endDate));
        }
        int currPrecision = 2;
        int currBasePrecision = 2;
        int rowIndex = insertRowIndex + insertRowCount;
        int cols = table.getColumnCount();
        SimpleCompanyUserObject companyUserObject = null;
        this.tblMain.setRefresh(false);
        while (rs.next()) {
            int rowType = rs.getInt("FIsSum");
            IRow row = this.isDoExpand ? table.addRow(rowIndex++) : table.setRow(rowIndex++);
            String str = "";
            String baseStr = "";
            if ("base".equals(param.getCurrencyId())) {
                currBasePrecision = rs.getInt("FBaseCurrPrecision");
                baseStr = PrecisionFormatUtils.getFormatString(currBasePrecision);
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                currPrecision = rs.getInt("FCurrPrecision");
                str = PrecisionFormatUtils.getFormatString(currPrecision);
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                currPrecision = rs.getInt("FCurrPrecision");
                str = PrecisionFormatUtils.getFormatString(currPrecision);
                currBasePrecision = rs.getInt("FBaseCurrPrecision");
                baseStr = PrecisionFormatUtils.getFormatString(currBasePrecision);
            }
            Object cellVal = null;
            for (int i = 0; i < cols; ++i) {
                String key = this.tblMain.getColumn(i).getKey();
                if (!"FPeriod".equals(key)) {
                    cellVal = rs.getObject(key);
                }
                if (cellVal instanceof BigDecimal) {
                    BigDecimal amt = (BigDecimal)cellVal;
                    if (key.endsWith("Local")) {
                        row.getCell(i).getStyleAttributes().setNumberFormat(baseStr);
                    } else {
                        row.getCell(i).getStyleAttributes().setNumberFormat(str);
                    }
                    row.getCell(i).setValue((Object)amt);
                    continue;
                }
                if ("FPeriod".equals(key)) {
                    if (param.isByPeriod()) {
                        row.getCell(i).setValue((Object)(rs.getInt("FPeriodYear") + "-" + rs.getInt("FPeriodNumber")));
                        continue;
                    }
                    row.getCell(i).setValue((Object)rangeDesc);
                    continue;
                }
                if ("FCussAcct".equals(key) && rowType == 0) {
                    row.getCell(i).setValue((Object)(rs.getString("FAsstActNumber") + " " + rs.getString("FCussAcct")));
                    continue;
                }
                row.getCell(i).setValue(cellVal);
            }
            if (rowType == 1) {
                row.getStyleAttributes().setBackground(Color.decode("#F5F5E6"));
            }
            ICell cell = row.getCell(this.getTreeCol());
            companyUserObject = this.getCompanyUserObject(rs);
            if (cell == null || companyUserObject == null) continue;
            cell.setValue((Object)companyUserObject);
            cell.setUserObject((Object)companyUserObject);
        }
        if (!this.exportManager.isExportStarted()) {
            String[] mergeCols = null;
            if ("base".equals(param.getCurrencyId())) {
                mergeCols = this.getNewMergeColumnKeys(true);
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                mergeCols = this.getMergeColumnKeys();
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                mergeCols = this.getNewMergeColumnKeys(false);
            }
            if (mergeCols != null) {
                int len = mergeCols.length;
                for (int i = 0; i < len; ++i) {
                    if (i == 0) {
                        this.mergeBlock(insertRowIndex + insertRowCount, null, mergeCols[i]);
                        continue;
                    }
                    this.mergeBlock(insertRowIndex + insertRowCount, mergeCols[i - 1], mergeCols[i]);
                }
            }
        }
        this.tblMain.setRefresh(true);
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
        this.setCellTreeRenderer();
    }

    public String[] getNewMergeColumnKeys(boolean isAllBase) {
        if (isAllBase) {
            return new String[]{"FBaseCurrency", "FPeriod", "FAsstActType", "FCussAcct"};
        }
        return new String[]{"FCurrency", "FBaseCurrency", "FPeriod", "FAsstActType", "FCussAcct"};
    }

    @Override
    protected void initTableHeader(RptParams rptRslt) {
        RptTableHeader header = (RptTableHeader)rptRslt.getObject("header");
        KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
        SummaryRptQueryParam qryParam = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
        this.tblMain.getGroupManager().setGroup(true);
        String[] mergeColumnKeys = null;
        mergeColumnKeys = "base".equals(qryParam.getCurrencyId()) ? this.getNewMergeColumnKeys(true) : (qryParam.isBaseCurrency() ? this.getNewMergeColumnKeys(false) : this.getMergeColumnKeys());
        if (mergeColumnKeys != null) {
            int size = mergeColumnKeys.length;
            for (int i = 0; i < size; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    private SimpleCompanyUserObject getCompanyUserObject(RptRowSet rs) {
        SimpleCompanyUserObject companyUserObject = null;
        String companyId = rs.getString("fcompanyid");
        companyUserObject = new SimpleCompanyUserObject();
        companyUserObject.setCompanyId(companyId == null ? "null" : companyId);
        companyUserObject.setName(rs.getString("fcompany"));
        companyUserObject.setExpanded(false);
        companyUserObject.setBlockId(rs.getString("FAsstActId"));
        if (companyId == null || rs.getInt("fissum") == 1) {
            companyUserObject.setLeaf(true);
            companyUserObject.setisIconEmpty(true);
        } else {
            int leaf = rs.getInt("FIsCompLeaf");
            companyUserObject.setLeaf(leaf == 1);
            companyUserObject.setLevel(rs.getInt("fcomplevel"));
            companyUserObject.setExpanded(true);
            companyUserObject.setHasExpanded(true);
        }
        return companyUserObject;
    }

    public String getTreeCol() {
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
        return param.isMultiCompanys() ? "FCompany" : "FCompanyID";
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
        SummRptTablePrintUtil.preparePrintPageHeader(headerModel, param);
    }

    protected Map preparePrintVariantMap() {
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
        return SummRptTablePrintUtil.preparePrintVarMap(param);
    }

    public boolean isAsynchronism() {
        return true;
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.fi.ar.client.ArVirtualSumRptUI";
    }

    @Override
    protected void prepareParamForQuery(QueryPanelCollection queryPanelInfo) throws Exception {
        CustomerQueryPanel[] panels = this.getCustomerQueryPanels();
        panels[0].setCustomerParams(CustomerParams.getCustomerParams2((String)queryPanelInfo.get(0).getCustomerParams()));
        this.params = new RptParams();
        this.params.setObject("qryParam", (Object)((ArApVirtualSumRptQueryUI)panels[0]).getSummaryRptQueryParam());
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"FCurrency", "FPeriod", "FAsstActType", "FCussAcct"};
    }

    public Object getTablePreferenceSchemaKey() {
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)this.params.getObject("qryParam"));
        return param.getRptPreferenceSchemaKey();
    }

    @Override
    protected void initQueryDialog(CommonQueryDialog queryDialog) {
        super.initQueryDialog(queryDialog);
        queryDialog.setWidth(525);
        queryDialog.setHeight(340);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        this.exportManager.startExport();
        super.actionExport_actionPerformed(e);
        this.fFirstLoad = true;
        this.exportManager.stopExport();
    }
}

