/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.client.AbstractAtTermCreditRightConditionUI;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AtTermCreditRightConditionUI
extends AbstractAtTermCreditRightConditionUI {
    private static final long serialVersionUID = 3531633271300861578L;
    private static final Logger logger = CoreUIObject.getLogger(AtTermCreditRightConditionUI.class);
    private CompanyOrgUnitInfo currentCompany = null;
    private boolean isFirstLoad = true;
    private boolean isAR;
    private int defaultAsstTypeIndex = -1;
    private int defaultCurrentyIndex = -1;
    private int allCurrencyIndex = -1;
    private int allAsstTypeIndex = -1;
    private ItemListener chkIsCentralBalanceListener = null;
    private DataChangeListener prmtCsspGrpDateChangeListener = null;
    private Map formatMap = new HashMap();
    protected transient ArApSysParamInfo sysInfo = null;
    protected transient HashMap map = new HashMap();
    protected transient IArApBillFacade iBillFacade = null;

    public AtTermCreditRightConditionUI(boolean isAR) throws Exception {
        this.isAR = isAR;
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
        if (this.currentCompany == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"companyFail"));
            logger.error((Object)"has not default company!");
            SysUtil.abort();
        }
        if (!isAR) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"AtTermDeptRptQuery"));
            this.chkIncludeBizBill.setText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"Lbl_includeBizAP"));
        }
    }

    protected void prmtCsspGrp_dataChanged(DataChangeEvent e) throws Exception {
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        String companyId = this.currentCompany.getId().toString();
        ArApQueryUIUtil.csspGrpValueChangeProcess((CoreUIObject)this, companyId, asstActTypeInfo, this.prmtCsspGrp, this.prmtCussFrom, this.prmtCussTo);
    }

    @Override
    protected void prmtCussFrom_dataChanged(DataChangeEvent e) throws Exception {
        ArApQueryUIUtil.objFromChanged((IUIObject)this, this.prmtCussFrom, this.prmtCussTo);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        params.setObject("billDateFrom", (Object)this.getData(this.pkDateFrom));
        params.setObject("billDateTo", (Object)this.getData(this.pkDateTo));
        params.setObject("calDate", (Object)this.getData(this.pkCalDate));
        params.setObject("aheadDays", this.spAheadDays.getValue());
        if (this.comboCussType.getSelectedIndex() != this.allAsstTypeIndex) {
            params.setObject("asstType", (Object)this.getData(this.comboCussType));
            params.setObject("asstTypeName", (Object)this.comboCussType.getSelectedItem().toString());
        } else {
            params.setObject("asstType", null);
        }
        if (this.comboCurrency.getSelectedIndex() != this.allCurrencyIndex) {
            params.setObject("currency", (Object)this.getData(this.comboCurrency));
            params.setObject("currencyName", (Object)this.comboCurrency.getSelectedItem().toString());
        } else {
            params.setObject("currency", null);
            params.setObject("currencyName", null);
        }
        params.setObject("currencyFormat", (Object)this.formatMap);
        params.setObject("csspGrp", (Object)this.getData(this.prmtCsspGrp));
        params.setObject("asstFrom", (Object)this.getData(this.prmtCussFrom));
        params.setObject("asstTo", (Object)this.getData(this.prmtCussTo));
        params.setObject("deptFrom", (Object)this.getData(this.prmtDeptFrom));
        params.setObject("deptTo", (Object)this.getData(this.prmtDeptTo));
        params.setObject("personFrom", (Object)this.getData(this.prmtPersonFrom));
        params.setObject("personTo", (Object)this.getData(this.prmtPersonTo));
        params.setObject("billNumFrom", (Object)this.getData(this.prmtBillNumFrom));
        params.setObject("billNumTo", (Object)this.getData(this.prmtBillNumTo));
        params.setObject("csspGrpNumber", (Object)this.getDataNumber(this.prmtCsspGrp));
        params.setObject("asstFromNumber", (Object)this.getDataNumber(this.prmtCussFrom));
        params.setObject("asstToNumber", (Object)this.getDataNumber(this.prmtCussTo));
        params.setObject("deptFromNumber", (Object)this.getDataNumber(this.prmtDeptFrom));
        params.setObject("deptToNumber", (Object)this.getDataNumber(this.prmtDeptTo));
        params.setObject("asstFromName", (Object)this.getDataName(this.prmtCussFrom));
        params.setObject("asstToName", (Object)this.getDataName(this.prmtCussTo));
        params.setObject("personFromNumber", (Object)this.getDataNumber(this.prmtPersonFrom));
        params.setObject("personToNumber", (Object)this.getDataNumber(this.prmtPersonTo));
        params.setObject("billNumFromNumber", (Object)this.getDataNumber(this.prmtBillNumFrom));
        params.setObject("billNumToNumber", (Object)this.getDataNumber(this.prmtBillNumTo));
        params.setString("company", this.currentCompany.getId().toString());
        params.setString("cu", this.currentCompany.getCU().getId().toString());
        params.setBoolean("isIncludeNegtive", this.chkIncludeNegtive.isSelected());
        params.setBoolean("isIncludeUndue", this.chkIncludeUndue.isSelected());
        params.setBoolean("isIncludeBizBill", this.chkIncludeBizBill.isSelected());
        params.setObject("asstFromIds", (Object)this.getAsstFromIds(this.prmtCussFrom));
        params.setObject("asstFromInfos", this.prmtCussFrom.getValue());
        if (!this.bizcheckBox.isSelected()) {
            params.setString("includeNowPay", "no");
        } else {
            if (this.comboPaymentType.getSelectedIndex() == 0) {
                params.setString("includeNowPay", "yes");
            }
            if (this.comboPaymentType.getSelectedIndex() == 1) {
                params.setString("includeNowPay", "only");
            }
        }
        return params;
    }

    private String getData(KDDatePicker datePicker) {
        if (datePicker.getValue() != null) {
            return datePicker.getTimestamp().toString();
        }
        return null;
    }

    private String getData(KDComboBox combo) {
        if (combo.getSelectedItem() instanceof DataBaseInfo) {
            DataBaseInfo dataInfo = (DataBaseInfo)combo.getSelectedItem();
            return dataInfo.getId().toString();
        }
        return null;
    }

    private List getAsstFromIds(KDBizPromptBox biz) {
        if (biz.getValue() instanceof Object[]) {
            Object[] objs = (Object[])biz.getValue();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof DataBaseInfo)) continue;
                DataBaseInfo asstActInfo = (DataBaseInfo)objs[i];
                list.add(asstActInfo.getId().toString());
            }
            if (list.size() > 1) {
                return list;
            }
        }
        return null;
    }

    private String getData(KDBizPromptBox biz) {
        if (biz.getValue() instanceof DataBaseInfo) {
            DataBaseInfo dbInfo = (DataBaseInfo)biz.getValue();
            return dbInfo.getId().toString();
        }
        if (biz.getValue() instanceof Object[]) {
            DataBaseInfo dbInfo = (DataBaseInfo)((Object[])biz.getValue())[0];
            return dbInfo.getId().toString();
        }
        if (biz.getValue() instanceof CoreBillBaseInfo) {
            CoreBillBaseInfo dbInfo = (CoreBillBaseInfo)biz.getValue();
            return dbInfo.getId().toString();
        }
        return null;
    }

    private String getDataNumber(KDBizPromptBox biz) {
        if (biz.getValue() instanceof DataBaseInfo) {
            DataBaseInfo dbInfo = (DataBaseInfo)biz.getValue();
            return dbInfo.getNumber();
        }
        if (biz.getValue() instanceof CoreBillBaseInfo) {
            CoreBillBaseInfo dbInfo = (CoreBillBaseInfo)biz.getValue();
            return dbInfo.getNumber();
        }
        if (biz.getValue() instanceof BillBaseInfo) {
            BillBaseInfo dbInfo = (BillBaseInfo)biz.getValue();
            return dbInfo.getNumber();
        }
        if (biz.getValue() instanceof Object[]) {
            DataBaseInfo dbInfo = (DataBaseInfo)((Object[])biz.getValue())[0];
            return dbInfo.getNumber();
        }
        return null;
    }

    private String getDataName(KDBizPromptBox biz) {
        if (biz.getValue() instanceof DataBaseInfo) {
            DataBaseInfo dbInfo = (DataBaseInfo)biz.getValue();
            return dbInfo.getName();
        }
        if (biz.getValue() instanceof Object[]) {
            Object[] objs = (Object[])biz.getValue();
            StringBuffer sb = new StringBuffer();
            int j = objs.length;
            for (int i = 0; i < j; ++i) {
                if (!(objs[i] instanceof DataBaseInfo)) continue;
                DataBaseInfo asstActInfo = (DataBaseInfo)objs[i];
                sb.append(asstActInfo.getNumber());
                sb.append(" ");
                sb.append(asstActInfo.getName());
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        return null;
    }

    private void setData(KDDatePicker datePicker, Object data) {
        if (data instanceof String) {
            datePicker.setValue((Object)Timestamp.valueOf(data.toString()));
        }
    }

    private void setData(KDComboBox combo, Object data) {
        if (data instanceof String) {
            int size = combo.getItemCount();
            for (int i = 0; i < size; ++i) {
                DataBaseInfo dataInfo;
                Object obj = combo.getItemAt(i);
                if (!(obj instanceof DataBaseInfo) || !(dataInfo = (DataBaseInfo)obj).getId().toString().equals(data.toString())) continue;
                combo.setSelectedIndex(i);
                break;
            }
        }
    }

    private void setData(KDBizPromptBox biz, Object data) throws BOSException {
        if (data instanceof String) {
            biz.setValue((Object)this.getValue(data.toString()));
        }
    }

    private IObjectValue getValue(String id) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk, sic);
        return objVal;
    }

    public void setCustomCondition(RptParams params) {
        this.removeControlListener();
        this.setData(this.pkDateFrom, params.getObject("billDateFrom"));
        this.setData(this.pkDateTo, params.getObject("billDateTo"));
        this.setData(this.pkCalDate, params.getObject("calDate"));
        if (params.getObject("asstType") != null) {
            this.setData(this.comboCussType, params.getObject("asstType"));
        } else {
            this.comboCussType.setSelectedIndex(this.allAsstTypeIndex);
        }
        if (params.getObject("currency") != null) {
            this.setData(this.comboCurrency, params.getObject("currency"));
        } else {
            this.comboCurrency.setSelectedIndex(this.allCurrencyIndex);
        }
        try {
            this.setData(this.prmtCsspGrp, params.getObject("csspGrp"));
            this.setData(this.prmtCussFrom, params.getObject("asstFrom"));
            this.setData(this.prmtCussTo, params.getObject("asstTo"));
            this.setData(this.prmtDeptFrom, params.getObject("deptFrom"));
            this.setData(this.prmtDeptTo, params.getObject("deptTo"));
            this.setData(this.prmtPersonFrom, params.getObject("personFrom"));
            this.setData(this.prmtPersonTo, params.getObject("personTo"));
            this.setData(this.prmtBillNumFrom, params.getObject("billNumFrom"));
            this.setData(this.prmtBillNumTo, params.getObject("billNumTo"));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.chkIncludeNegtive.setSelected(params.getBoolean("isIncludeNegtive"));
        this.chkIncludeUndue.setSelected(params.getBoolean("isIncludeUndue"));
        this.chkIncludeBizBill.setSelected(params.getBoolean("isIncludeBizBill"));
        if (params.getBoolean("isIncludeUndue")) {
            this.spAheadDays.setEnabled(true);
        } else {
            this.spAheadDays.setValue((Object)new Integer(0));
        }
        this.spAheadDays.setValue(params.getObject("aheadDays"));
        this.addListen();
    }

    public void clear() {
        this.chkIncludeNegtive.setSelected(false);
        this.chkIncludeUndue.setSelected(false);
        this.chkIncludeBizBill.setSelected(false);
        this.comboCussType.setSelectedIndex(this.defaultAsstTypeIndex);
        this.comboCurrency.setSelectedIndex(this.defaultCurrentyIndex);
        this.prmtCsspGrp.setValue(null);
        this.prmtCussFrom.setValue(null);
        this.prmtCussTo.setValue(null);
        this.prmtDeptFrom.setValue(null);
        this.prmtDeptTo.setValue(null);
        this.prmtPersonFrom.setValue(null);
        this.prmtPersonTo.setValue(null);
        this.prmtBillNumFrom.setValue(null);
        this.prmtBillNumTo.setValue(null);
        this.spAheadDays.setValue((Object)new Integer(0));
        Date today = new Date();
        this.pkDateFrom.setValue((Object)today);
        this.pkDateTo.setValue((Object)today);
        this.pkCalDate.setValue((Object)today);
    }

    protected void getSysParams() throws EASBizException, BOSException {
        this.map.put("isSCM", Boolean.FALSE);
        this.map.put("sysEnum", this.isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE);
        this.sysInfo = this.iBillFacade.getSysParams(null, this.map);
    }

    private void setAsstActType() throws EASBizException, BOSException {
        this.getSysParams();
        ArApBillUIUtil.makeAsstActType(this.comboCussType, this.sysInfo, false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isFirstLoad) {
            this.chkIncludeUndue.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Object source = e.getSource();
                    if (source.equals(AtTermCreditRightConditionUI.this.chkIncludeUndue)) {
                        AtTermCreditRightConditionUI.this.spAheadDays.setValue((Object)new Integer(0));
                        if (AtTermCreditRightConditionUI.this.chkIncludeUndue.isSelected()) {
                            AtTermCreditRightConditionUI.this.spAheadDays.setEnabled(true);
                        } else {
                            AtTermCreditRightConditionUI.this.spAheadDays.setEnabled(false);
                        }
                    }
                }
            });
            SpinnerModel spModel = this.spAheadDays.getModel();
            if (spModel instanceof SpinnerNumberModel) {
                ((SpinnerNumberModel)spModel).setMinimum(new Integer(0));
                ((SpinnerNumberModel)spModel).setMaximum(new Integer(200000));
            }
            ClientUtils.setCurrencyList((KDComboBox)this.comboCurrency, (boolean)true);
            ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)this.currentCompany.getBaseCurrency().getId().toString());
            this.defaultCurrentyIndex = this.comboCurrency.getSelectedIndex();
            this.allCurrencyIndex = this.comboCurrency.getItemCount() - 1;
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add("id");
            view.getSelector().add("number");
            view.getSelector().add("name");
            view.getSelector().add("precision");
            CurrencyCollection collection = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view, true);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                this.formatMap.put(collection.get(i).getName(), this.getNumberFormat(collection.get(i).getPrecision()));
            }
            EventListener eventListerner = new EventListener(this);
            this.comboCussType.addItemListener((ItemListener)eventListerner);
            this.prmtCussFrom.setEnabledMultiSelection(true);
            this.prmtCussTo.setEnabledMultiSelection(false);
            this.setAsstActType();
            AsstActTypeInfo allAsstActType = new AsstActTypeInfo();
            allAsstActType.put("id", (Object)"all");
            allAsstActType.put("number", (Object)"all");
            allAsstActType.put("name", (Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Currency_All"));
            this.comboCussType.addItem((Object)allAsstActType);
            this.allAsstTypeIndex = this.comboCussType.getItemCount() - 1;
            this.defaultAsstTypeIndex = this.comboCussType.getSelectedIndex();
            if (!allAsstActType.equals(this.comboCussType.getSelectedItem())) {
                this.prmtCussFrom.setEnabled(true);
                this.prmtCussTo.setEnabled(true);
            }
            ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtDeptFrom, false, true, false);
            ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtDeptTo, false, true, false);
            ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonFrom);
            ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonTo);
            this.initBillFilter(this.prmtBillNumFrom);
            this.initBillFilter(this.prmtBillNumTo);
            this.isFirstLoad = false;
            this.removeControlListener();
            this.addListen();
        }
    }

    private void removeControlListener() {
        if (null != this.chkIsCentralBalanceListener) {
            this.bizcheckBox.removeItemListener(this.chkIsCentralBalanceListener);
        }
        if (null != this.prmtCsspGrpDateChangeListener) {
            this.prmtCsspGrp.removeDataChangeListener(this.prmtCsspGrpDateChangeListener);
        }
    }

    private void addListen() {
        this.chkIsCentralBalanceListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    AtTermCreditRightConditionUI.this.chkIsCentralBalanceChanged(arg0);
                }
                catch (Exception e) {
                    AtTermCreditRightConditionUI.this.handUIException(e);
                }
            }
        };
        this.bizcheckBox.addItemListener(this.chkIsCentralBalanceListener);
        this.prmtCsspGrpDateChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    AtTermCreditRightConditionUI.this.prmtCsspGrp_dataChanged(e);
                }
                catch (Exception exc) {
                    AtTermCreditRightConditionUI.this.handUIException(exc);
                }
            }
        };
        this.prmtCsspGrp.addDataChangeListener(this.prmtCsspGrpDateChangeListener);
    }

    protected void chkIsCentralBalanceChanged(ItemEvent arg0) throws Exception {
        boolean ischeckBox = this.bizcheckBox.isSelected();
        if (ischeckBox) {
            this.contPaymentType.setEnabled(true);
        } else {
            this.contPaymentType.setEnabled(false);
        }
    }

    private void initBillFilter(KDBizPromptBox prmtBill) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String companyId = this.currentCompany.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(3)));
        viewInfo.setFilter(filter);
        prmtBill.setEntityViewInfo(viewInfo);
        prmtBill.setVisible(true);
        prmtBill.setEditFormat("$number$");
        prmtBill.setDisplayFormat("$number$");
        prmtBill.setCommitFormat("$number$");
        String queryInfo = null;
        queryInfo = this.isAR ? "com.kingdee.eas.fi.ar.app.F7OtherBillQuery" : "com.kingdee.eas.fi.ap.app.F7OtherBillQuery";
        prmtBill.setQueryInfo(queryInfo);
    }

    public boolean verify() {
        boolean retVal = super.verify();
        String msgPattern = EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"QryUI_MustHave");
        retVal = ArApQueryUIUtil.validDateRange((CoreUIObject)this, this.pkDateFrom, this.pkDateTo);
        if (!retVal) {
            return false;
        }
        if (this.pkCalDate.getValue() == null) {
            String msg = MessageFormat.format(msgPattern, this.contCalDate.getBoundLabelText());
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            retVal = false;
        }
        return retVal;
    }

    protected String getNumberFormat(int scale) {
        StringBuffer fmt = new StringBuffer("");
        fmt.append("#,##0").append(scale > 0 ? "." : "");
        for (int i = 0; i < scale; ++i) {
            fmt.append("0");
        }
        return fmt.toString();
    }

    private class EventListener
    implements ItemListener,
    DataChangeListener {
        private AtTermCreditRightConditionUI parentui = null;

        public EventListener(AtTermCreditRightConditionUI parentui) {
            this.parentui = parentui;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1 || AtTermCreditRightConditionUI.this.comboCussType.getItemCount() == 0 || AtTermCreditRightConditionUI.this.comboCussType.getSelectedItem() == null) {
                return;
            }
            AsstActTypeInfo typeInfo = (AsstActTypeInfo)AtTermCreditRightConditionUI.this.comboCussType.getSelectedItem();
            AtTermCreditRightConditionUI.this.prmtCussFrom.removeDataChangeListener((DataChangeListener)this);
            if (typeInfo != null && typeInfo.getDefaultQueryName() != null) {
                AtTermCreditRightConditionUI.this.prmtCussFrom.setEnabled(true);
                AtTermCreditRightConditionUI.this.prmtCussTo.setEnabled(true);
                try {
                    ArApBillUIUtil.setAsstActSelector((CoreUIObject)this.parentui, AtTermCreditRightConditionUI.this.prmtCussFrom, AtTermCreditRightConditionUI.this.prmtCussTo, typeInfo, AtTermCreditRightConditionUI.this.currentCompany.getString("id"), AtTermCreditRightConditionUI.this.sysInfo, true);
                    ArApQueryUIUtil.setCsspGrpF7((IUIObject)this.parentui, AtTermCreditRightConditionUI.this.prmtCsspGrp, typeInfo);
                }
                catch (Exception e1) {
                    AtTermCreditRightConditionUI.this.handUIException(e1);
                }
            } else {
                AtTermCreditRightConditionUI.this.prmtCsspGrp.setEnabled(false);
                AtTermCreditRightConditionUI.this.prmtCussFrom.setEnabled(false);
                AtTermCreditRightConditionUI.this.prmtCussTo.setEnabled(false);
            }
            AtTermCreditRightConditionUI.this.prmtCsspGrp.setValue(null);
            AtTermCreditRightConditionUI.this.prmtCussFrom.setValue(null);
            AtTermCreditRightConditionUI.this.prmtCussTo.setValue(null);
        }

        public void dataChanged(DataChangeEvent e) {
        }
    }
}

