/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.BadAcctStatisticObjectEnum;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.ar.client.AbstractBadAcctStatisticReportQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.ar.util.AsstActTypeUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Timestamp;

public class BadAcctStatisticReportQueryUI
extends AbstractBadAcctStatisticReportQueryUI {
    private static final long serialVersionUID = -8548168676275143654L;
    private static final BigDecimal ZERO = new BigDecimal("0.0");
    private static final String resClassName = "com.kingdee.eas.fi.ar.ArReport";
    private CompanyOrgUnitInfo currentCompany = null;
    private CurrencyInfo integrateLocalCurrency = null;
    private int statisticObjectValue = 0;
    private AsstActTypeUtils currency = null;
    private boolean isPrepareCurrency = false;
    private IBadAccountFacade iBadAccountFacade = null;

    public BadAcctStatisticReportQueryUI() throws Exception {
        this.setSize(410, 185);
        this.isPrepareCurrency = !CommonClientUtils.isDisplayLocalCurrency();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.bizPrCompany.setData((Object)this.currentCompany);
        this.bizPrCompany.setEnabled(false);
        this.integrateLocalCurrency = ArClientUtils.getIntegrateLocalCurrency();
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.adminOrgUnitNumberFrom, false, true, false);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.adminOrgUnitNumberTo, false, true, false);
        this.iBadAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
        String accuralParam = this.iBadAccountFacade.getAccuralParam(this.currentCompany);
        boolean isCustomerAnalysis = accuralParam.equalsIgnoreCase(String.valueOf(5));
        if (isCustomerAnalysis) {
            int n = this.cmbStatisticObject.getItemCount();
            for (int i = 0; i < n; ++i) {
                BadAcctStatisticObjectEnum statisticObject = (BadAcctStatisticObjectEnum)((Object)this.cmbStatisticObject.getItemAt(i));
                if (statisticObject.equals((Object)BadAcctStatisticObjectEnum.AdminOrgUnit)) {
                    this.cmbStatisticObject.removeItemAt(i);
                }
                this.cmbStatisticObject.setEditable(false);
                this.adminOrgUnitNumberFrom.setEnabled(false);
                this.adminOrgUnitNumberTo.setEnabled(false);
            }
        }
        if (this.isPrepareCurrency()) {
            this.setCurrency();
        } else {
            this.bizCurrency.setEnabled(false);
            this.bizCurrency.addItem((Object)new AsstActTypeUtils(this.integrateLocalCurrency.getName(), this.integrateLocalCurrency.getId().toString(), ""));
        }
        this.setAsstActSelector(this.customerFrom);
        this.setAsstActSelector(this.customerTo);
        this.chkPrepareCurrency.setSelected(this.isPrepareCurrency());
        String cuID = SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString();
        this.txtCuID.setText(cuID);
    }

    private void setAsstActSelector(KDBizPromptBox bizPromptBox) throws Exception {
        String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(0), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        bizPromptBox.setCommitFormat("$number$;$mnemonicCode$");
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
        String groupStandardId = cSSPGroupStandard.getBasicStandardId("1");
        filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        GeneralKDPromptSelectorAdaptor selectorLisenterCustomer = null;
        selectorLisenterCustomer = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7CustomerTreeDetailListUI(), (Object)this.ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id");
        BadAcctStatisticReportQueryUI.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selectorLisenterCustomer);
        bizPromptBox.addSelectorListener((SelectorListener)selectorLisenterCustomer);
    }

    private static void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    private void setCurrency() {
        this.bizCurrency.setEnabled(true);
        ICurrency iCurrency = null;
        CurrencyCollection con = null;
        try {
            iCurrency = CurrencyFactory.getRemoteInstance();
            con = iCurrency.getCurrencyCollection(true);
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"currencyFail"));
            SysUtil.abort();
        }
        if (con != null) {
            Object[] typeValue = new Object[con.size()];
            int j = 0;
            for (int i = 0; i < con.size(); ++i) {
                CurrencyInfo currencyInfo = con.get(i);
                String typeName = currencyInfo.getName();
                String typeId = currencyInfo.getId().toString();
                String typeQueryName = "";
                this.currency = new AsstActTypeUtils(typeName, typeId, typeQueryName);
                if (this.currency == null) continue;
                typeValue[i] = this.currency;
                if (!typeId.equalsIgnoreCase(this.currentCompany.getBaseCurrency().getId().toString())) continue;
                j = i;
            }
            this.bizCurrency.removeAllItems();
            this.bizCurrency.addItems(typeValue);
            this.bizCurrency.setSelectedIndex(j);
            String allType = EASResource.getString((String)resClassName, (String)"allType");
            this.bizCurrency.addItem((Object)new AsstActTypeUtils(allType, null, null));
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"currencyFail"));
            SysUtil.abort();
        }
    }

    public int getstatisticObjectValue() {
        return this.statisticObjectValue;
    }

    private boolean isPrepareCurrency() {
        return this.isPrepareCurrency;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams rptParams = new RptParams();
        if (this.isPrepareCurrency()) {
            if (this.bizCurrency.getSelectedItem() != null) {
                if (((AsstActTypeUtils)this.bizCurrency.getSelectedItem()).typeId == null) {
                    rptParams.setObject("bizCurrency", (Object)"");
                } else {
                    rptParams.setObject("bizCurrency", (Object)((AsstActTypeUtils)this.bizCurrency.getSelectedItem()).typeId);
                }
            } else {
                rptParams.setObject("bizCurrency", (Object)"");
            }
        } else {
            rptParams.setObject("bizCurrency", (Object)"");
        }
        if (this.cmbStatisticObject.getSelectedItem() != null) {
            rptParams.setObject("statisticObject", (Object)String.valueOf(((BadAcctStatisticObjectEnum)((Object)this.cmbStatisticObject.getSelectedItem())).getValue()));
        } else {
            rptParams.setObject("statisticObject", null);
        }
        if (this.adminOrgUnitNumberFrom.getData() != null) {
            rptParams.setObject("adminOrgUnitNumberFrom", (Object)((AdminOrgUnitInfo)this.adminOrgUnitNumberFrom.getData()));
        } else {
            rptParams.setObject("adminOrgUnitNumberFrom", null);
        }
        if (this.adminOrgUnitNumberTo.getData() != null) {
            rptParams.setObject("adminOrgUnitNumberTo", (Object)((AdminOrgUnitInfo)this.adminOrgUnitNumberTo.getData()));
        } else {
            rptParams.setObject("adminOrgUnitNumberTo", null);
        }
        if (this.customerFrom.getData() != null) {
            rptParams.setObject("customerFrom", (Object)((DataBaseInfo)this.customerFrom.getData()));
        } else {
            rptParams.setObject("customerFrom", null);
        }
        if (this.customerTo.getData() != null) {
            rptParams.setObject("customerTo", (Object)((DataBaseInfo)this.customerTo.getData()));
        } else {
            rptParams.setObject("customerTo", null);
        }
        rptParams.setObject("isPrepareCurrency", (Object)this.chkPrepareCurrency.isSelected());
        rptParams.setObject("billDateFrom", (Object)this.billDateFrom.getTimestamp());
        rptParams.setObject("billDateTo", (Object)this.billDateTo.getTimestamp());
        rptParams.setObject("cuid", (Object)this.txtCuID.getText());
        return rptParams;
    }

    public void setCustomCondition(RptParams params) {
        String bizCurrencyID = null;
        if (params.getObject("bizCurrency") != null) {
            bizCurrencyID = params.getObject("bizCurrency").toString();
        }
        int itemCount = this.bizCurrency.getItemCount();
        for (int index = 0; index < itemCount; ++index) {
            String currencyID = null;
            if (this.bizCurrency.getItemAt(index) != null) {
                currencyID = ((AsstActTypeUtils)this.bizCurrency.getItemAt((int)index)).typeId == null ? "" : ((AsstActTypeUtils)this.bizCurrency.getItemAt((int)index)).typeId;
            }
            if (bizCurrencyID == null && currencyID == null) {
                this.bizCurrency.setSelectedIndex(index);
                continue;
            }
            if (currencyID == null || !currencyID.equals(bizCurrencyID)) continue;
            this.bizCurrency.setSelectedIndex(index);
        }
        this.chkPrepareCurrency.setSelected(this.isPrepareCurrency());
        if (params.getObject("cuid") != null) {
            String cuID = params.getObject("cuid").toString();
            this.txtCuID.setText(cuID);
        }
        int itemSize = this.cmbStatisticObject.getItemCount();
        for (int index = 0; index < itemSize; ++index) {
            String selectStatistic;
            String StatisticObject = String.valueOf(((BadAcctStatisticObjectEnum)((Object)this.cmbStatisticObject.getItemAt(index))).getValue());
            if (!StatisticObject.equals(selectStatistic = params.getObject("statisticObject").toString())) continue;
            this.cmbStatisticObject.setSelectedIndex(index);
            break;
        }
        this.adminOrgUnitNumberFrom.setValue((Object)((AdminOrgUnitInfo)params.getObject("adminOrgUnitNumberFrom")));
        this.adminOrgUnitNumberTo.setValue((Object)((AdminOrgUnitInfo)params.getObject("adminOrgUnitNumberTo")));
        this.customerFrom.setData((Object)((DataBaseInfo)params.getObject("customerFrom")));
        this.customerTo.setData((Object)((DataBaseInfo)params.getObject("customerTo")));
        this.billDateFrom.setValue((Object)((Timestamp)params.getObject("billDateFrom")));
        this.billDateTo.setValue((Object)((Timestamp)params.getObject("billDateTo")));
    }
}

