/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.fi.ar.CAStmtQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractCAStmtQueryUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.CAStmtRptParamConvertor;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import org.apache.log4j.Logger;

public class CAStmtQueryUI
extends AbstractCAStmtQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(CAStmtQueryUI.class);
    private boolean isForItem = false;
    private PeriodInfo startPeriod = null;
    private CAStmtQueryParam filterParam = null;
    private ItemListener chkIsCentralBalanceListener = null;

    public CAStmtQueryUI() throws Exception {
    }

    public CAStmtQueryUI(boolean isItem, boolean isAR) throws Exception {
        if (!isAR) {
            this.setAp();
            this.chkIncludeBizBill.setText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"Lbl_includeBizAP"));
        }
        this.isForItem = isItem;
    }

    @Override
    protected void initUICtrls() throws Exception {
        super.initUICtrls();
        ClientUtils.setCurrencyListCopy((KDComboBox)this.comboCurrency, (boolean)true);
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)this.currentCompany.getBaseCurrency().getId().toString());
        this.startPeriod = this.arApSysParamInfo.getStartPeriod(this.getSystemEnum());
        this.pkDateFrom.setRequired(true);
        this.pkDateTo.setRequired(true);
        this.pkDateFrom.setMinimumDate(this.startPeriod.getBeginDate());
        this.pkDateTo.setMinimumDate(this.startPeriod.getBeginDate());
        Date fromDate = this.getDefaultBeginDate();
        this.pkDateFrom.setValue((Object)fromDate);
        this.prmptAdminOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmptAdminOrgTo.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmptAdminOrg, false, true, false);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmptAdminOrgTo, false, true, false);
        this.removeControlListener();
        this.addListen();
    }

    private void removeControlListener() {
        if (null != this.chkIsCentralBalanceListener) {
            this.bizcheckBox.removeItemListener(this.chkIsCentralBalanceListener);
        }
    }

    private void addListen() {
        this.chkIsCentralBalanceListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    CAStmtQueryUI.this.chkIsCentralBalanceChanged(arg0);
                }
                catch (Exception e) {
                    CAStmtQueryUI.this.handUIException(e);
                }
            }
        };
        this.bizcheckBox.addItemListener(this.chkIsCentralBalanceListener);
    }

    protected void chkIsCentralBalanceChanged(ItemEvent arg0) throws Exception {
        boolean ischeckBox = this.bizcheckBox.isSelected();
        if (ischeckBox) {
            this.contPaymentType.setEnabled(true);
        } else {
            this.contPaymentType.setEnabled(false);
        }
    }

    private Date getDefaultBeginDate() {
        Date fromDate = new Date(System.currentTimeMillis() - 2592000000L);
        if (fromDate.before(this.startPeriod.getBeginDate())) {
            fromDate.setTime(this.startPeriod.getBeginDate().getTime());
        }
        return fromDate;
    }

    @Override
    protected void pkDateFrom_dataChanged(DataChangeEvent e) throws Exception {
        this.validDateRange();
    }

    @Override
    protected void pkDateTo_dataChanged(DataChangeEvent e) throws Exception {
        this.validDateRange();
    }

    private void validDateRange() {
        Date beginDate = this.pkDateFrom.getSqlDate();
        Date endDate = this.pkDateTo.getSqlDate();
        if (beginDate == null || endDate == null) {
            return;
        }
        if (beginDate.before(this.startPeriod.getBeginDate())) {
            this.pkDateFrom.setValue((Object)this.startPeriod.getBeginDate());
            return;
        }
        if (endDate.before(this.startPeriod.getBeginDate())) {
            this.pkDateTo.setValue((Object)this.startPeriod.getBeginDate());
            return;
        }
        if (beginDate.after(endDate)) {
            this.pkDateFrom.setValue((Object)endDate);
        }
    }

    public void setParam(Object obj) {
        this.filterParam = (CAStmtQueryParam)((Object)obj);
        this.setParamToUI(this.filterParam);
    }

    public void setCustomerParams(CustomerParams cp) {
        this.filterParam = new CAStmtQueryParam();
        CAStmtRptParamConvertor convertor = new CAStmtRptParamConvertor();
        convertor.setRptParam((IReportQueryParam)this.filterParam);
        try {
            convertor.read(null, cp);
        }
        catch (Exception e) {
            logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
        }
    }

    @Override
    public IReportQueryParam getRptParam() {
        CAStmtQueryParam param = new CAStmtQueryParam();
        param.setCompanyId(this.currentCompany.getId().toString());
        param.setCuId(this.currentCompany.getCU().getId().toString());
        param.setIsItemRpt(this.isForItem);
        param.setIsArRpt(this.isArRpt());
        java.util.Date date = (java.util.Date)this.pkDateFrom.getValue();
        Date beginDate = new Date(DateTimeUtils.truncateDate((java.util.Date)date).getTime());
        date = (java.util.Date)this.pkDateTo.getValue();
        Date endDate = new Date(DateTimeUtils.truncateDate((java.util.Date)date).getTime());
        param.setBeginDate(beginDate);
        param.setEndDate(endDate);
        this.setCurrCussAcct2RptParamCopy(param);
        CAStmtQueryUI.selectSaveCurrency(this.comboCurrency, param);
        DataBaseInfo bizObjInfo = null;
        if (this.prmptAdminOrg.getValue() != null) {
            bizObjInfo = (DataBaseInfo)this.prmptAdminOrg.getValue();
            param.setAdminOrgFromId(bizObjInfo.getString("id"));
            param.setAdminOrgFromName(bizObjInfo.getName());
            param.setAdminOrgFromNum(bizObjInfo.getNumber());
        }
        if (this.prmptAdminOrgTo.getValue() != null) {
            bizObjInfo = (DataBaseInfo)this.prmptAdminOrgTo.getValue();
            param.setAdminOrgToId(bizObjInfo.getString("id"));
            param.setAdminOrgToName(bizObjInfo.getName());
            param.setAdminOrgToNum(bizObjInfo.getNumber());
        }
        param.setIsBizZero(this.chkBizZero.isSelected());
        param.setIsBalZero(this.chkBalZero.isSelected());
        param.setIsOrderbyBizNum(this.chkOrderby.isSelected());
        param.setHasBadAcct(this.chkBadAcct.isSelected());
        param.setIncludeBizBill(this.chkIncludeBizBill.isSelected());
        param.setBizeIndex(this.comboPaymentType.getSelectedIndex());
        param.setBizeCheckBox(this.bizcheckBox.isSelected());
        param.setBizeIndex(this.comboPaymentType.getSelectedIndex());
        param.setAmtLocal(this.chkLocAmt.isSelected());
        return param;
    }

    public static void selectSaveCurrency(KDComboBox comboCurrency, CAStmtQueryParam param) {
        CurrencyInfo currInfo = (CurrencyInfo)comboCurrency.getSelectedItem();
        param.setCurrencyId(currInfo.getString("id"));
        if ("base".equals(currInfo.getString("id"))) {
            param.setAllAmtLoc(1);
        } else if ("all".equals(currInfo.getString("id"))) {
            param.setAllAmtLoc(2);
        } else {
            param.setAllAmtLoc(0);
            param.setCurrencyInfo(currInfo);
        }
    }

    private void setParamToUI(CAStmtQueryParam param) {
        AdminOrgUnitInfo info;
        if (param == null) {
            return;
        }
        this.clear();
        this.pkDateFrom.setValue((Object)param.getBeginDate());
        this.pkDateTo.setValue((Object)param.getEndDate());
        this.loadCurrCussAcctData(param);
        if (this.filterParam.getAdminOrgFromId() != null) {
            info = new AdminOrgUnitInfo();
            info.put("id", (Object)this.filterParam.getAdminOrgFromId());
            info.setNumber(this.filterParam.getAdminOrgFromNum());
            info.setName(this.filterParam.getAdminOrgFromName());
            this.prmptAdminOrg.setValue((Object)info);
        }
        if (this.filterParam.getAdminOrgToId() != null) {
            info = new AdminOrgUnitInfo();
            info.put("id", (Object)this.filterParam.getAdminOrgToId());
            info.setNumber(this.filterParam.getAdminOrgToNum());
            info.setName(this.filterParam.getAdminOrgToName());
            this.prmptAdminOrgTo.setValue((Object)info);
        }
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)param.getCurrencyId());
        this.chkBizZero.setSelected(param.isBizZero());
        this.chkBalZero.setSelected(param.isBalZero());
        this.chkOrderby.setSelected(param.isOrderbyBizNum());
        this.chkBadAcct.setSelected(param.hasBadAcct());
        this.chkIncludeBizBill.setSelected(param.isIncludeBizBill());
        this.bizcheckBox.setSelected(param.isBizeCheckBox());
        this.comboPaymentType.setSelectedIndex(param.getBizeIndex());
        this.chkLocAmt.setSelected(param.isAmtLocal());
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.setParamToUI(this.filterParam);
    }

    public boolean verify() {
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        if (typeInfo == null || StringUtils.isEmpty((String)typeInfo.getRealtionDataObject()) || StringUtils.isEmpty((String)typeInfo.getDefaultQueryName())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"NoAsstActType"));
            return false;
        }
        if (this.pkDateFrom.getValue() == null || this.pkDateTo.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"bill_date_not_null"));
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        java.util.Date curDay = new Date(System.currentTimeMillis());
        curDay = DateTimeUtils.truncateDate((java.util.Date)curDay);
        this.pkDateFrom.setValue((Object)this.getDefaultBeginDate());
        this.pkDateTo.setValue((Object)curDay);
        this.prmptAdminOrg.setValue(null);
        this.prmptAdminOrgTo.setValue(null);
        this.chkBizZero.setSelected(false);
        this.chkBalZero.setSelected(false);
        this.chkOrderby.setSelected(false);
        this.chkLocAmt.setSelected(false);
        this.chkIncludeBizBill.setSelected(false);
        this.chkBadAcct.setSelected(false);
    }
}

