/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.CAStmtQueryParam;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.IReportFacade;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.ReportFacadeFactory;
import com.kingdee.eas.fi.ar.client.AbstractCAStmtRptUI;
import com.kingdee.eas.fi.ar.client.CAStmtItemRptUI;
import com.kingdee.eas.fi.ar.client.CAStmtQueryUI;
import com.kingdee.eas.fi.ar.client.CAStmtRptDelegate;
import com.kingdee.eas.fi.ar.client.RptBaseQueryUI;
import com.kingdee.eas.fi.arap.client.util.CAStmt_ItemRptPrintUtil;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CAStmtRptUI
extends AbstractCAStmtRptUI {
    private static final Logger logger = CoreUIObject.getLogger(CAStmtRptUI.class);
    private CAStmtQueryUI queryUI = null;

    @Override
    protected void initUI() {
        super.initUI();
        this.actionView.setVisible(true);
        this.seprtPrint.setVisible(true);
        this.actionFormulPrint.setVisible(true);
        this.actionFormulPrintPreview.setVisible(true);
    }

    @Override
    protected RptBaseQueryUI getQueryPanel() throws Exception {
        if (this.queryUI == null) {
            this.queryUI = new CAStmtQueryUI();
        }
        return this.queryUI;
    }

    @Override
    protected CommonQueryDialog getQueryDialog() throws Exception {
        this.dialog = super.getQueryDialog();
        this.dialog.setWidth(548);
        this.dialog.setHeight(280);
        return this.dialog;
    }

    @Override
    protected IReportData getReport() throws BOSException, EASBizException {
        IReportFacade iReport = ReportFacadeFactory.getRemoteInstance();
        IReportData rptData = null;
        rptData = iReport.getARCAStmtReport((IReportQueryParam)this.filterParam);
        return rptData;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.viewItemRpt();
    }

    @Override
    protected void prepareParamForQuery(ArApQueryParam filterParam) {
        this.setReportHead(filterParam.getReportHead());
    }

    private void viewItemRpt() throws Exception {
        if (this.getSelectedRow() == null) {
            return;
        }
        CAStmtQueryParam itemQryParam = this.getItemQryParam();
        if (itemQryParam == null) {
            return;
        }
        boolean flag = true;
        Set threadSet = ThreadPool.getCurrentThread();
        if (threadSet != null) {
            MonitorInfo info2 = null;
            for (MonitorInfo info2 : threadSet) {
                if (info2 == null || info2.getUi() == null || !info2.getUi().getClass().getName().equals(this.getItemUI())) continue;
                flag = info2.getWorker() == null || !info2.getWorker().isIsFinished();
                break;
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)itemQryParam);
        if (!flag) {
            uiContext.put((Object)"operator", (Object)"actionJoinQuery");
        }
        IUIWindow itemRptUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getItemUI(), (Map)uiContext, null, OprtState.VIEW);
        itemRptUI.show();
    }

    protected String getItemUI() {
        return CAStmtItemRptUI.class.getName();
    }

    protected CAStmtQueryParam getItemQryParam() throws BOSException, EASBizException {
        IRow row = this.getSelectedRow();
        if (row.getCell("FCussAcctId") == null || row.getCell("FCussNum") == null) {
            logger.error((Object)"has not the FCussAcctId, FCussNum cols");
            return null;
        }
        String cussAcctId = (String)row.getCell("FCussAcctId").getValue();
        String cussAcctNum = (String)row.getCell("FCussNum").getValue();
        if (cussAcctId == null || cussAcctId.length() == 0) {
            return null;
        }
        CAStmtQueryParam param = (CAStmtQueryParam)this.filterParam;
        CAStmtQueryParam itemParam = new CAStmtQueryParam();
        itemParam.setCussAcctId(cussAcctId);
        itemParam.setCussAcctFromNum(cussAcctNum);
        itemParam.setCussAcctToNum(cussAcctNum);
        itemParam.setIsArRpt(true);
        itemParam.setIsItemRpt(true);
        itemParam.setCompanyId(param.getCompanyId());
        itemParam.setBeginDate(param.getBeginDate());
        itemParam.setEndDate(param.getEndDate());
        itemParam.setIsBizZero(param.isBizZero());
        itemParam.setIsBalZero(param.isBalZero());
        itemParam.setHasBadAcct(param.hasBadAcct());
        itemParam.setIsOrderbyBizNum(param.isOrderbyBizNum());
        itemParam.setCuId(param.getCuId());
        itemParam.setIsItemRpt(true);
        itemParam.setLinkSum(true);
        itemParam.setAdminOrgFromNum(param.getAdminOrgFromNum());
        itemParam.setAdminOrgToNum(param.getAdminOrgToNum());
        itemParam.setIncludeBizBill(param.isIncludeBizBill());
        itemParam.setBizeCheckBox(param.isBizeCheckBox());
        itemParam.setBizeIndex(param.getBizeIndex());
        AsstActTypeInfo cussTypeInfo = new AsstActTypeInfo();
        cussTypeInfo.setName(row.getCell("FCussType").getValue().toString());
        String cussTypeId = row.getCell("FCussTypeId").getValue().toString();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("defaultQueryName"));
        selectors.add(new SelectorItemInfo("realtionDataObject"));
        selectors.add(new SelectorItemInfo("glAsstActTypeGrp"));
        IAsstActType iCussType = AsstActTypeFactory.getRemoteInstance();
        cussTypeInfo = iCussType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(cussTypeId), selectors);
        itemParam.setCussAcctTypeInfo(cussTypeInfo);
        itemParam.setCussTypeId(cussTypeId);
        itemParam.setCussTable(cussTypeInfo.getRealtionDataObject());
        String currencyId = row.getCell("FCurrencyId").getValue().toString();
        itemParam.setCurrencyId(currencyId);
        ICurrency iCurr = CurrencyFactory.getRemoteInstance();
        CurrencyInfo currInfo = iCurr.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        itemParam.setCurrencyInfo(currInfo);
        return itemParam;
    }

    private IRow getSelectedRow() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return null;
        }
        int rowInd = selectBlock.getTop();
        return this.tblMain.getRow(rowInd);
    }

    @Override
    protected boolean isViewEnabled() {
        return true;
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        CAStmt_ItemRptPrintUtil.preparePrintPageHeader(headerModel);
    }

    @Override
    protected Map preparePrintVariantMap() {
        String compName = SysContext.getSysContext().getCurrentFIUnit().getName();
        CAStmtQueryParam param = (CAStmtQueryParam)this.filterParam;
        return CAStmt_ItemRptPrintUtil.preparePrintVariantMap(param, compName);
    }

    @Override
    public BOSQueryDelegate getPrintProvider() {
        return new CAStmtRptDelegate(this.filterParam);
    }

    @Override
    public String getPrintTemplatePath() {
        return "/FI/AR/ArCAStmtRpt";
    }

    @Override
    public boolean isAsynchronism() {
        return true;
    }

    @Override
    protected String getUIFullName() {
        return "com.kingdee.eas.fi.ar.client.CAStmtRptUI";
    }
}

