/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.client.util.ApPeriodHelper;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.ContrastGLFacadeFactory;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.IContrastGLFacade;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractContrastGLQueryUI;
import com.kingdee.eas.fi.ar.client.util.AccountUtils;
import com.kingdee.eas.fi.ar.client.util.ArPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.BizSysPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.ContrastGLRptParamConvertor;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class ContrastGLQueryUI
extends AbstractContrastGLQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(ContrastGLQueryUI.class);
    protected static final String RES = "com.kingdee.eas.fi.ar.client.ArResource";
    private ContrastGLQueryParam filterParam = null;
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private BizSysPeriodHelper periodHelper = null;
    private String cussTypeDefaultId;
    protected KDBizPromptBox prmptSumAcct;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    protected HashMap uiParam = null;
    IContrastGLFacade iContrast = null;
    AsstActTypeInfo allInfo = null;
    private Boolean isContrastNew = false;
    private int newContrastPeriodNumber = 999999;
    private IContrastAccountView iContrastAccountView = null;
    private AccountViewCollection accountViewColl = new AccountViewCollection();
    private static final String COL_ACCOUNT = "account";
    private static final String COL_OPERATOR = "operator";
    private String rdBtnBySumTxt = "";

    public ContrastGLQueryUI() throws Exception {
    }

    public ContrastGLQueryUI(boolean fAr, HashMap map) throws Exception {
        if (!fAr) {
            this.setAp();
        }
        this.chkIncludeBizBill.setVisible(false);
        this.uiParam = map;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.iContrast = ContrastGLFacadeFactory.getRemoteInstance();
        this.allInfo = new AsstActTypeInfo();
        this.allInfo.put("id", (Object)"all");
        this.allInfo.setName(EASResource.getString((String)RES, (String)"CussType_All"));
        this.chkUnvoucheredBills.setVisible(false);
        this.rdBtnByBillSum.setVisible(true);
        this.iContrastAccountView = ContrastAccountViewFactory.getRemoteInstance();
        this.newContrastPeriodNumber = ArApBillUIUtil.getNewContrastPeriodNumber(this.currentCompany.getId().toString(), this.isArRpt());
        if (this.currentPeriod != null) {
            int system = this.isArRpt() ? 1 : 2;
            this.accountViewColl = (AccountViewCollection)this.iContrastAccountView.getContrastAccount(system, this.currentCompany, this.getAccountTableID(this.currentPeriod), this.currentPeriod.getPeriodYear(), this.currentPeriod.getPeriodNumber(), false);
        }
        this.setUIByNewContrast();
    }

    protected void setUIByNewContrast() {
        int year = (Integer)this.spPeriodYear.getValue();
        int num = (Integer)this.spPeriodNum.getValue();
        this.resetIsContrastNew(year, num);
        this.isDefaultSolution.setVisible(this.isContrastNew == false);
        this.rdBtnByAcct.setVisible(this.isContrastNew == false);
        this.rdBtnByBillSum.setVisible(this.isContrastNew == false);
        if (this.isContrastNew.booleanValue()) {
            this.isDefaultSolution.setSelected(false);
            this.rdBtnBySum.setSelected(true);
            if (StringUtils.isEmpty((String)this.rdBtnBySumTxt)) {
                this.rdBtnBySumTxt = this.rdBtnBySum.getText();
            }
            this.rdBtnBySum.setText(EASResource.getString((String)RES, (String)"CONTRAST_BY_ACCOUNT_BILL"));
        } else if (!StringUtils.isEmpty((String)this.rdBtnBySumTxt)) {
            this.rdBtnBySum.setText(this.rdBtnBySumTxt);
        }
    }

    @Override
    protected void initUICtrls() throws Exception {
        this.initSysParamInfo();
        this.resetCussAcct();
        this.initTable();
        this.initCtrlsData();
    }

    private void initTable() throws Exception {
        this.tblAcctFormula.checkParsed();
        this.tblAcctFormula.setActiveCellStatus(1);
        this.tblAcctFormula.addRow();
        this.tblAcctFormula.getRow(0).getCell(1).setValue((Object)"+");
        this.setAccountEditor();
        KDComboBox comboOperator = new KDComboBox();
        String[] opArr = new String[]{"+", "-"};
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(opArr);
        comboOperator.setModel(comboModel);
        KDTDefaultCellEditor opEditor = new KDTDefaultCellEditor((JComboBox)comboOperator);
        this.tblAcctFormula.getColumn(1).setEditor((ICellEditor)opEditor);
        this.tblAcctFormula.getStyleAttributes().setBackground(ArApConstants.REQUIRED_COLOR);
        this.tblAcctFormula.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                ContrastGLQueryUI.this.kdtEditStopped(e);
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    private void kdtEditStopped(KDTEditEvent e) {
        if (e.getValue() == null || e.getValue().equals(e.getOldValue())) {
            return;
        }
        Object[] accounts = null;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String key = this.tblAcctFormula.getColumnKey(colIndex);
        Object obj = e.getValue();
        if (COL_ACCOUNT.equalsIgnoreCase(key)) {
            if (obj instanceof AccountViewInfo) {
                accounts = new AccountViewInfo[]{(AccountViewInfo)obj};
            } else if (obj instanceof Object[]) {
                accounts = (Object[])obj;
            } else {
                return;
            }
            int length = accounts.length;
            AccountViewInfo account = null;
            for (int i = 0; i < length; ++i) {
                account = (AccountViewInfo)accounts[i];
                if (account == null) continue;
                IRow curRow2 = this.tblAcctFormula.getRow(rowIndex + i);
                curRow2.getCell(colIndex).setValue(null);
                curRow2.getCell(colIndex).setValue((Object)account);
                if (i >= length - 1) continue;
                this.insertLine(rowIndex + i + 1);
            }
        }
    }

    protected void insertLine(int row) {
        KDTable kdtEntry = this.tblAcctFormula;
        if (this.tblAcctFormula.getRow(0).getCell(1).getValue() == null) {
            this.tblAcctFormula.getRow(0).getCell(1).setValue((Object)"+");
        }
        IRow irow = null;
        irow = kdtEntry.addRow(row);
        irow.getCell(1).setValue((Object)"+");
    }

    private void setAccountEditor() throws Exception {
        if (this.spPeriodYear.getValue() == null || this.spPeriodNum.getValue() == null) {
            this.tblAcctFormula.removeRows();
            this.btnAddRow.setEnabled(false);
            this.btnDelRow.setEnabled(false);
        } else {
            this.btnAddRow.setEnabled(true);
            this.btnDelRow.setEnabled(true);
        }
        int pYear = (Integer)this.spPeriodYear.getValue();
        int pNum = (Integer)this.spPeriodNum.getValue();
        PeriodInfo periodInfo = new PeriodInfo();
        periodInfo.setPeriodYear(pYear);
        periodInfo.setPeriodNumber(pNum);
        if (this.prmptSumAcct == null) {
            this.prmptSumAcct = new KDBizPromptBox();
        }
        CommonClientUtils.setContrastAccountF7((IUIObject)this, this.prmptSumAcct, this.currentCompany, this.isArRpt(), periodInfo, null, null);
        this.prmptSumAcct.setEnabledMultiSelection(true);
        KDTDefaultCellEditor acctEditor = new KDTDefaultCellEditor((IKDEditor)this.prmptSumAcct);
        this.tblAcctFormula.getColumn(0).setEditor((ICellEditor)acctEditor);
        this.setUIByNewContrast();
    }

    private void initCtrlsData() throws BOSException, EASBizException {
        ClientUtils.setCurrencyList((KDComboBox)this.comboCurrency, (boolean)true);
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)this.currentCompany.getBaseCurrency().getId().toString());
        this.prmtCsspGrp.setEnabled(false);
        this.prmtCussFrom.setEnabled(false);
        this.prmtCussTo.setEnabled(false);
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        if (this.arApSysParamInfo.getDefaultAsstActType() != null && this.arApSysParamInfo.getDefaultAsstActType().getId() != null) {
            this.cussTypeDefaultId = this.arApSysParamInfo.getDefaultAsstActType().getId().toString();
        }
        this.initPeriods();
    }

    private void initPeriods() throws BOSException, EASBizException {
        this.periodHelper = this.isArRpt() ? ArPeriodHelper.getInstance(true) : ApPeriodHelper.getInstance(true);
        this.currentPeriod = this.arApSysParamInfo.getCurrentPeriod(this.getSystemEnum());
        this.startPeriod = this.arApSysParamInfo.getStartPeriod(this.getSystemEnum());
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.spPeriodYear, this.spPeriodNum, this.arApSysParamInfo);
    }

    public void setParam(Object obj) {
        this.filterParam = (ContrastGLQueryParam)((Object)obj);
        this.setParamToUI();
    }

    public void setCustomerParams(CustomerParams cp) {
        this.filterParam = new ContrastGLQueryParam();
        ContrastGLRptParamConvertor convertor = new ContrastGLRptParamConvertor();
        convertor.setRptParam((IReportQueryParam)this.filterParam);
        try {
            convertor.read(null, cp);
            String currentCompanyId = this.currentCompany.getId().toString();
            if (!this.filterParam.getCompanyId().equals(currentCompanyId)) {
                this.filterParam.setCompanyId(currentCompanyId);
            }
            if (this.startPeriod != null) {
                int solution_year = this.filterParam.getPeriodYear();
                int solution_num = this.filterParam.getPeriodNum();
                if (solution_year < this.startPeriod.getPeriodYear() || solution_year == this.startPeriod.getPeriodYear() && solution_num < this.startPeriod.getPeriodNumber()) {
                    this.filterParam.setPeriodYear(this.currentPeriod.getPeriodYear());
                    this.filterParam.setPeriodNum(this.currentPeriod.getPeriodNumber());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
        }
    }

    public static boolean isEmpty(Collection<?> collection) {
        return null == collection || collection.size() == 0;
    }

    protected void resetIsContrastNew(int periodYear, int periodNum) {
        if (periodYear == 0 || periodNum == 0) {
            return;
        }
        String periodNumStr = "";
        periodNumStr = periodNum >= 0 && periodNum < 10 ? "0" + periodNum : String.valueOf(periodNum);
        int queryPeriod = Integer.valueOf(periodYear + periodNumStr);
        this.isContrastNew = this.newContrastPeriodNumber <= queryPeriod;
    }

    @Override
    public IReportQueryParam getRptParam() {
        IRow row;
        AccountViewInfo accountInfo;
        ContrastGLQueryParam param = new ContrastGLQueryParam();
        param.setCompanyId(this.currentCompany.getId().toString());
        param.setCuId(this.currentCompany.getCU().getString("id"));
        int year = (Integer)this.spPeriodYear.getValue();
        int num = (Integer)this.spPeriodNum.getValue();
        param.setPeriodYear(year);
        param.setPeriodNum(num);
        this.resetIsContrastNew(year, num);
        boolean fBySum = this.isContrastNew != false ? false : this.rdBtnBySum.isSelected();
        boolean fByBillSum = this.rdBtnByBillSum.isSelected();
        param.setContrastByBillAccount(this.isContrastNew);
        param.setBySum(fBySum);
        param.setByBillSum(fByBillSum);
        param.setRedRecNegative(this.comboRedRec.getSelectedIndex() == 0);
        ArrayList<Object> idFormula = new ArrayList<Object>();
        ArrayList<Object> nameFormula = new ArrayList<Object>();
        int iValidAccts = 0;
        int n = this.tblAcctFormula.getRowCount();
        for (int i = 0; i < n && (accountInfo = (AccountViewInfo)(row = this.tblAcctFormula.getRow(i)).getCell(0).getValue()) != null; ++i) {
            if (idFormula.contains(accountInfo.getId())) continue;
            idFormula.add(accountInfo.getId());
            String nameStr = accountInfo.getName() + ";" + accountInfo.getNumber();
            if (accountInfo.getCAA() != null) {
                nameStr = nameStr + ";" + accountInfo.getCAA().getString("id");
            }
            nameFormula.add(nameStr);
            if ((fBySum || fByBillSum || this.isContrastNew.booleanValue()) && i < n - 1) {
                Object op = row.getCell(1).getValue();
                idFormula.add(op);
                nameFormula.add(op);
            }
            ++iValidAccts;
        }
        if ((fBySum || fByBillSum || this.isContrastNew.booleanValue()) && idFormula.size() == iValidAccts * 2 && idFormula.size() != 0) {
            idFormula.remove(idFormula.size() - 1);
            nameFormula.remove(nameFormula.size() - 1);
        }
        param.setAcctFormula(idFormula);
        param.setAcctNameFormula(nameFormula);
        this.setCurrCussAcct2RptParam(param);
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        if (typeInfo != null) {
            param.setCussMappingFld(typeInfo.getMappingFieldName());
        }
        try {
            Set oppositeAccountIdSet = ContrastGLFacadeFactory.getRemoteInstance().getOppositeAccountIdSet(new HashSet(idFormula), year, num, this.isArRpt());
            boolean isEmpty = null == oppositeAccountIdSet || oppositeAccountIdSet.size() == 0;
            param.setQueryAll(!isEmpty);
            param.setOppositeAccountIdSet(oppositeAccountIdSet);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        param.setHasItem(this.chkCussItem.isSelected());
        param.setHasUnRegVoucher(this.chkUnRegVoucher.isSelected());
        param.setOnlyUnBalance(this.chkOnlyUnBalance.isSelected());
        param.setIsIncludeUnvoucheredBills(this.chkUnvoucheredBills.isSelected());
        param.setIncludeBizBill(this.chkIncludeBizBill.isSelected());
        param.setIsDefaultSolution(this.isDefaultSolution.isSelected());
        return param;
    }

    public static void saveCurrencyCopy(KDComboBox comboCurrency, ContrastGLQueryParam param) {
        CurrencyInfo currInfo = (CurrencyInfo)comboCurrency.getSelectedItem();
        param.setCurrencyId(currInfo.getString("id"));
        if ("base".equals(currInfo.getString("id"))) {
            param.setAllAmountLocal(1);
        } else if ("all".equals(currInfo.getString("id"))) {
            param.setAllAmountLocal(2);
        } else {
            param.setAllAmountLocal(0);
            param.setCurrencyInfo(currInfo);
        }
    }

    public void loadData(EntityViewInfo viewInfo) {
        this.setParamToUI();
    }

    public void fixSolution() {
        String currentCompanyId = this.currentCompany.getId().toString();
        if (!this.filterParam.getCompanyId().equals(currentCompanyId)) {
            this.filterParam.setCompanyId(currentCompanyId);
        }
        if (this.filterParam.getPeriodYear() != -1 && this.filterParam.getPeriodNum() != -1) {
            int year = new Integer(this.filterParam.getPeriodYear());
            int num = new Integer(this.filterParam.getPeriodNum());
            if (year > this.currentPeriod.getPeriodYear() || year == this.currentPeriod.getPeriodYear() && num > this.currentPeriod.getPeriodNumber()) {
                year = this.currentPeriod.getPeriodYear();
                num = this.currentPeriod.getPeriodNumber();
            }
            if (year < this.startPeriod.getPeriodYear() || year == this.startPeriod.getPeriodYear() && num < this.startPeriod.getPeriodNumber()) {
                year = this.currentPeriod.getPeriodYear();
                num = this.currentPeriod.getPeriodNumber();
            }
            this.filterParam.setPeriodYear(year);
            this.filterParam.setPeriodNum(num);
        }
        try {
            this.filterParam = ContrastGLFacadeFactory.getRemoteInstance().convertContrastAccount(this.filterParam, this.isArRpt());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setParamToUI() {
        if (this.filterParam == null) {
            return;
        }
        this.fixSolution();
        if (this.filterParam.isContrastByBillAccount() && this.newContrastPeriodNumber == 999999) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"AR_045_DISABLED"));
            ArApBillUIUtil.addThreadObject("AR_045_DISABLED");
            return;
        }
        this.clear();
        this.isDefaultSolution.setSelected(this.filterParam.getIsDefaultSolution());
        if (this.filterParam.getPeriodYear() != -1 && this.filterParam.getPeriodNum() != -1) {
            int year = new Integer(this.filterParam.getPeriodYear());
            int num = new Integer(this.filterParam.getPeriodNum());
            this.spPeriodYear.setValue((Object)new Integer(year));
            this.spPeriodNum.setValue((Object)new Integer(num), false);
            this.resetIsContrastNew(year, num);
        }
        this.rdBtnByAcct.setSelected(!this.filterParam.isBySum() && !this.filterParam.isByBillSum());
        this.rdBtnByBillSum.setSelected(this.filterParam.isByBillSum());
        this.rdBtnBySum.setSelected(this.filterParam.isBySum());
        this.setUIByNewContrast();
        this.comboRedRec.setSelectedIndex(this.filterParam.isRedRecNegative() ? 0 : 1);
        this.tblAcctFormula.getColumn(1).getStyleAttributes().setHided(this.rdBtnByAcct.isSelected());
        this.loadAccounts(this.filterParam.isBySum() || this.filterParam.isByBillSum());
        try {
            this.accountViewsChanged();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.loadCurrCussAcctData(this.filterParam);
        try {
            this.accountViewsChanged();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.chkCussItem.setSelected(this.filterParam.isHasItem());
        this.chkUnRegVoucher.setSelected(this.filterParam.isHasUnRegVoucher());
        this.chkOnlyUnBalance.setSelected(this.filterParam.isOnlyUnBalance());
        this.chkUnvoucheredBills.setSelected(this.filterParam.isIncludeUnvoucheredBills());
        this.chkIncludeBizBill.setSelected(this.filterParam.isIncludeBizBill());
    }

    private void loadAccounts(boolean fFormula) {
        this.tblAcctFormula.removeRows();
        List idFormula = this.filterParam.getAcctFormula();
        List nameFormula = this.filterParam.getAcctNameFormula();
        if (idFormula == null || idFormula.size() == 0) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        AccountViewInfo accountInfo = null;
        String id = null;
        String name = null;
        IRow row = null;
        int n = idFormula.size();
        for (int i = 0; i < n; ++i) {
            AsstAccountInfo accInfo;
            String[] descArr;
            id = idFormula.get(i).toString();
            if (this.isOperator(id)) {
                row.getCell(1).setValue((Object)id);
                continue;
            }
            ids.add(id);
            name = nameFormula.get(i).toString();
            if (fFormula) {
                if (!this.isOperator(id)) {
                    row = this.tblAcctFormula.addRow();
                    descArr = name.split(";");
                    accountInfo = new AccountViewInfo();
                    accountInfo.put("id", (Object)id);
                    accountInfo.setName(descArr[0]);
                    accountInfo.setNumber(descArr[1]);
                    row.getCell(0).setValue((Object)accountInfo);
                    if (descArr.length != 3 || StringUtils.isEmpty((String)descArr[2])) continue;
                    accInfo = new AsstAccountInfo();
                    accInfo.put("id", (Object)descArr[2]);
                    accountInfo.setCAA(accInfo);
                    continue;
                }
                row.getCell(1).setValue((Object)id);
                continue;
            }
            row = this.tblAcctFormula.addRow();
            descArr = name.split(";");
            accountInfo = new AccountViewInfo();
            accountInfo.put("id", (Object)id);
            accountInfo.setName(descArr[0]);
            accountInfo.setNumber(descArr[1]);
            row.getCell(0).setValue((Object)accountInfo);
            if (descArr.length != 3 || descArr[2] == null || descArr[2].length() <= 0) continue;
            accInfo = new AsstAccountInfo();
            accInfo.put("id", (Object)descArr[2]);
            accountInfo.setCAA(accInfo);
        }
        try {
            this.setAcctRelateCussType(ids);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private boolean isOperator(String val) {
        return "+".equals(val) || "-".equals(val);
    }

    public boolean verify() {
        boolean fBySum = this.isContrastNew != false ? false : this.rdBtnBySum.isSelected();
        boolean fByBillSum = this.rdBtnByBillSum.isSelected();
        String noAcctMsg = EASResource.getString((String)RES, (String)"ContrastGLCheck_NoAcct");
        String duplAcctMsg = EASResource.getString((String)RES, (String)"CTGL_HasSameAcct");
        String formulaMsg = EASResource.getString((String)RES, (String)"CTGL_FormulaError");
        ArrayList<String> ids = new ArrayList<String>();
        String acctId = null;
        int n = this.tblAcctFormula.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblAcctFormula.getRow(i);
            AccountViewInfo accountInfo = (AccountViewInfo)row.getCell(0).getValue();
            if (accountInfo == null || accountInfo.getId() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)noAcctMsg);
                this.tblAcctFormula.getEditManager().editCellAt(i, 0);
                return false;
            }
            acctId = accountInfo.getId().toString();
            if (ids.contains(acctId)) {
                MsgBox.showWarning((Component)((Object)this), (String)duplAcctMsg);
                this.tblAcctFormula.getEditManager().editCellAt(i, 0);
                return false;
            }
            ids.add(acctId);
            if (!fBySum && !fByBillSum && !this.isContrastNew.booleanValue()) continue;
            String op = (String)row.getCell(1).getValue();
            if (i >= n - 1 || (accountInfo == null || op != null) && (accountInfo != null || op == null)) continue;
            this.tblAcctFormula.getSelectManager().set(i, accountInfo == null ? 0 : 1);
            MsgBox.showWarning((Component)((Object)this), (String)formulaMsg);
            return false;
        }
        return true;
    }

    @Override
    protected void rdBtnBySum_itemStateChanged(ItemEvent e) throws Exception {
        this.tblAcctFormula.getColumn(1).getStyleAttributes().setHided(false);
        this.contRedRec.setVisible(false);
        this.comboRedRec.setVisible(false);
        this.accountViewsChanged();
        if (this.isContrastNew.booleanValue()) {
            int n = this.tblAcctFormula.getRowCount();
            for (int i = 0; i < n; ++i) {
                String op = (String)this.tblAcctFormula.getRow(i).getCell(1).getValue();
                if (!StringUtils.isEmpty((String)op)) continue;
                this.tblAcctFormula.getRow(i).getCell(1).setValue((Object)"+");
            }
        }
    }

    @Override
    protected void rdBtnByAcct_itemStateChanged(ItemEvent e) throws Exception {
        this.tblAcctFormula.getColumn(1).getStyleAttributes().setHided(true);
        this.contRedRec.setVisible(false);
        this.comboRedRec.setVisible(false);
        this.accountViewsChanged();
    }

    @Override
    protected void rdBtnByBiSum_itemStateChanged(ItemEvent e) throws Exception {
        this.tblAcctFormula.getColumn(1).getStyleAttributes().setHided(false);
        this.contRedRec.setVisible(true);
        this.comboRedRec.setVisible(true);
        this.accountViewsChanged();
    }

    @Override
    protected void tblAcctFormula_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == 1) {
            return;
        }
        Object oldVal = e.getOldValue();
        Object val = e.getValue();
        if (oldVal == null && val == null) {
            return;
        }
        if (oldVal != null && val != null && oldVal.equals(val)) {
            return;
        }
        this.accountViewsChanged();
    }

    private void accountViewsChanged() throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        boolean fByBillSum = this.rdBtnByBillSum.isSelected();
        int n = this.tblAcctFormula.getRowCount();
        for (int i = 0; i < n; ++i) {
            AccountViewInfo accountInfo = (AccountViewInfo)this.tblAcctFormula.getRow(i).getCell(0).getValue();
            if (accountInfo != null && accountInfo.getCAA() != null) {
                ids.add(accountInfo.getString("id"));
                continue;
            }
            if (!fByBillSum) continue;
            ids.clear();
            break;
        }
        this.setAcctRelateCussType(ids);
    }

    private void setAcctRelateCussType(List ids) throws Exception {
        if (ids == null || ids.isEmpty()) {
            this.resetCussAcct();
            return;
        }
        AsstActTypeCollection asstActTypes = this.iContrast.getAsstActType(this.currentCompany.getId(), ids);
        if (asstActTypes == null || asstActTypes.size() == 0) {
            this.resetCussAcct();
            return;
        }
        this.comboCussType.setEnabled(true);
        this.chkCussItem.setEnabled(true);
        this.chkCussItem.setSelected(true);
        AsstActTypeInfo typeInfo1 = null;
        if (this.comboCussType.getSelectedItem() != null) {
            typeInfo1 = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        }
        asstActTypes.add(this.allInfo);
        int typeSize = asstActTypes.size();
        AsstActTypeInfo[] asstArr = new AsstActTypeInfo[typeSize];
        int m = 1;
        AsstActTypeInfo typeInfo = null;
        for (int i = 0; i < typeSize; ++i) {
            asstArr[i] = typeInfo = asstActTypes.get(i);
            if (!"all".equals(typeInfo.get("id").toString())) continue;
            m = i;
        }
        this.comboCussType.setModel(new DefaultComboBoxModel<AsstActTypeInfo>(asstArr));
        if (typeSize > 2) {
            this.comboCussType.setSelectedIndex(m);
        } else {
            this.comboCussType.setSelectedIndex(1 == m ? 0 : 1);
            ClientUtils.setSelectedItem((KDComboBox)this.comboCussType, (String)this.cussTypeDefaultId);
            if (this.comboCussType.getItemCount() == 0 || this.comboCussType.getSelectedItem() == null) {
                return;
            }
            AsstActTypeInfo typeInfo2 = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
            if (typeInfo2 != null && typeInfo2.getDefaultQueryName() != null) {
                this.prmtCussFrom.setEnabled(true);
                this.prmtCussTo.setEnabled(true);
                String sCompanyId = this.currentCompany.getString("id");
                ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCussFrom, this.prmtCussTo, typeInfo2, sCompanyId, this.arApSysParamInfo, true);
                ArApQueryUIUtil.setCsspGrpF7((IUIObject)this, this.prmtCsspGrp, typeInfo2);
            } else {
                this.prmtCsspGrp.setEnabled(false);
                this.prmtCussFrom.setEnabled(false);
                this.prmtCussTo.setEnabled(false);
            }
            if (!typeInfo2.equals((Object)typeInfo1)) {
                this.prmtCsspGrp.setValue(null);
                this.prmtCussFrom.setValue(null);
                this.prmtCussTo.setValue(null);
            }
        }
    }

    @Override
    protected void comboCussType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.comboCussType.getItemCount() == 0 || this.comboCussType.getSelectedItem() == null) {
            return;
        }
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        if (typeInfo != null && typeInfo.getDefaultQueryName() != null) {
            this.prmtCussFrom.setEnabled(true);
            this.prmtCussTo.setEnabled(true);
            String sCompanyId = this.currentCompany.getString("id");
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCussFrom, this.prmtCussTo, typeInfo, sCompanyId, this.arApSysParamInfo, true);
            ArApQueryUIUtil.setCsspGrpF7((IUIObject)this, this.prmtCsspGrp, typeInfo);
        } else {
            this.prmtCsspGrp.setEnabled(false);
            this.prmtCussFrom.setEnabled(false);
            this.prmtCussTo.setEnabled(false);
        }
        this.prmtCsspGrp.setValue(null);
        this.prmtCussFrom.setValue(null);
        this.prmtCussTo.setValue(null);
    }

    private void resetCussAcct() {
        this.comboCussType.removeAllItems();
        this.comboCussType.setEnabled(false);
        this.prmtCsspGrp.setValue(null);
        this.prmtCsspGrp.setEnabled(false);
        this.prmtCussFrom.setValue(null);
        this.prmtCussFrom.setEnabled(false);
        this.prmtCussTo.setValue(null);
        this.prmtCussTo.setEnabled(false);
        this.chkCussItem.setSelected(false);
        this.chkCussItem.setEnabled(false);
    }

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblAcctFormula.getRow(0).getCell(1).getValue() == null) {
            this.tblAcctFormula.getRow(0).getCell(1).setValue((Object)"+");
        }
        this.tblAcctFormula.addRow();
        int rows = this.tblAcctFormula.getRowCount();
        if (rows > 0) {
            this.tblAcctFormula.getRow(rows - 1).getCell(1).setValue((Object)"+");
        }
    }

    @Override
    protected void btnDelRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblAcctFormula.getRowCount() <= 1) {
            return;
        }
        if (this.tblAcctFormula.getSelectManager().size() > 0) {
            KDTSelectBlock block = this.tblAcctFormula.getSelectManager().get();
            if (block != null) {
                this.tblAcctFormula.removeRow(block.getTop());
            }
        } else if (this.tblAcctFormula.getRowCount() > 1) {
            this.tblAcctFormula.removeRow(this.tblAcctFormula.getRowCount() - 1);
        }
        this.accountViewsChanged();
    }

    @Override
    protected void spPeriodNum_stateChanged(ChangeEvent e) throws Exception {
        this.setAccountEditor();
    }

    @Override
    protected void spPeriodYear_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.setPeriodNum(this.currentCompany, this.spPeriodNum, this.spPeriodYear);
        this.setAccountEditor();
    }

    @Override
    public void clear() {
        if (this.currentPeriod != null) {
            this.spPeriodYear.setValue((Object)new Integer(this.currentPeriod.getPeriodYear()));
            this.spPeriodNum.setValue((Object)new Integer(this.currentPeriod.getPeriodNumber()));
        }
        if (this.isContrastNew.booleanValue()) {
            try {
                this.fillAcctFormula();
                if (this.comboCussType.getItemCount() == 0) {
                    this.chkCussItem.setSelected(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.rdBtnBySum.setSelected(true);
            this.tblAcctFormula.removeRows();
            this.tblAcctFormula.addRow();
            this.chkCussItem.setSelected(true);
            this.comboCussType.removeAllItems();
            this.comboCussType.setEnabled(false);
            this.prmtCsspGrp.setEnabled(false);
            this.prmtCussFrom.setEnabled(false);
            this.prmtCussTo.setEnabled(false);
        }
        this.prmtCsspGrp.setValue(null);
        this.prmtCussFrom.setValue(null);
        this.prmtCussTo.setValue(null);
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)this.currentCompany.getBaseCurrency().getId().toString());
        this.chkUnRegVoucher.setSelected(true);
        this.chkUnvoucheredBills.setSelected(false);
        this.chkIncludeBizBill.setSelected(false);
        this.chkShowCurrency.setSelected(false);
    }

    private void fillAcctFormula() throws Exception {
        IRow row = null;
        if (this.accountViewColl.size() > 0) {
            this.tblAcctFormula.removeRows();
        }
        for (int i = 0; i < this.accountViewColl.size(); ++i) {
            row = this.tblAcctFormula.addRow();
            row.getCell(COL_ACCOUNT).setValue((Object)this.accountViewColl.get(i));
            row.getCell(COL_OPERATOR).setValue((Object)"+");
        }
        this.accountViewsChanged();
    }

    private String getAccountTableID(PeriodInfo period) throws EASBizException, BOSException {
        if (this.currentCompany.getAccountTable() == null) {
            return null;
        }
        return AccountUtils.getCurrentAcctTable(this.currentCompany.getId().toString(), this.currentCompany.getAccountTable().getId().toString(), period);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = (RequestContext)handler.getRequestContext();
        this.initCompany();
        request.put("uiParam", (Object)this.uiParam);
        request.put("currentCompany", (Object)this.currentCompany);
        request.put("isArRpt", (Object)true);
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

