/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.IImpInitDataGLFacade;
import com.kingdee.eas.fi.ar.ImpInitDataGLFacadeFactory;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.AbstractImportBalanceFromGLUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ImportBalanceFromGLUI
extends AbstractImportBalanceFromGLUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportBalanceFromGLUI.class);
    private CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
    private IImpInitDataGLFacade iImpInitDataGLFacade = null;

    public ImportBalanceFromGLUI() throws Exception {
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.curCompany);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (ArClientUtils.getArStartPeriod(this.curCompany) == null) {
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.curCompany.getName() + this.getSystemEnumForOA().getAlias()});
        }
        this.iImpInitDataGLFacade = ImpInitDataGLFacadeFactory.getRemoteInstance();
        this.initialize();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    private void initialize() {
        this.labWizardImg.setIcon(EASResource.getIcon((String)"imgGuide_pic338"));
        this.windowTitle = ArClientUtils.getArStringResource("ImportGuideTitle");
        StringBuffer text = new StringBuffer();
        text.append(ArClientUtils.getArStringResource("ImportGuideInfo_0")).append("\r\n");
        text.append(ArClientUtils.getArStringResource("ImportGuideInfo_1")).append("\r\n");
        text.append(ArClientUtils.getArStringResource("ImportGuideInfo_2")).append("\r\n");
        text.append(ArClientUtils.getArStringResource("ImportGuideInfo_3"));
        this.descriptionTextArea.setText(text.toString());
    }

    @Override
    protected void btnNext_actionPerformed(ActionEvent e) throws Exception {
        if (!ArClientUtils.arIsStart(this.curCompany)) {
            MsgBox.showInfo((Component)((Object)this), (String)(ArClientUtils.getArStringResource("ArHasNotFinished") + ArClientUtils.getArStringResource("PleaseUseInitDataImport")));
            this.abort();
        }
        PeriodInfo arCurrentPeriod = ArClientUtils.getArCurrentPeriod(this.curCompany);
        PeriodInfo glCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.curCompany);
        if (arCurrentPeriod == null || glCurrentPeriod == null || PeriodUtils.PeriodCompare((String)glCurrentPeriod.getId().toString(), (String)arCurrentPeriod.getId().toString()) != 0) {
            this.descriptionTextArea.setText(new MessageFormat(ArClientUtils.getArStringResource("ImportGuideAlert")).format(new String[]{"\n"}));
            this.btnNext.setVisible(false);
        } else {
            String s = this.getStrResource("periodInfo");
            MessageFormat mf = new MessageFormat(s);
            String message = mf.format(new String[]{arCurrentPeriod.getPeriodYear() + "", arCurrentPeriod.getPeriodNumber() + ""});
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)new MessageFormat(ArClientUtils.getArStringResource("ImportConfirm")).format(new String[]{message}));
            if (2 == result) {
                return;
            }
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("isAR", Boolean.TRUE);
            params.put("company", (Boolean)this.curCompany);
            params.put("period", (Boolean)arCurrentPeriod);
            this.iImpInitDataGLFacade.importBalanceFromGL(params);
            this.descriptionTextArea.setText(ArClientUtils.getArStringResource("ImportSuccess"));
            this.btnNext.setVisible(false);
            this.btnCancel.setText(ArClientUtils.getArStringResource("Finish"));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }
}

