/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IIncomeConfimBill;
import com.kingdee.eas.fi.ar.IncomeConfimBillFactory;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.client.AbstractIncomeConfirmListUI;
import com.kingdee.eas.fi.ar.client.ArAppointmentSubjectUI;
import com.kingdee.eas.fi.ar.client.ArApreverseEditUI;
import com.kingdee.eas.fi.ar.client.IncomeConfimBillCommonQueryProcessor;
import com.kingdee.eas.fi.ar.client.IncomeConfimEditUI;
import com.kingdee.eas.fi.ar.client.IncomeConfirmBillQueryUI;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.BosTypeEnum;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.ArApBillListUI;
import com.kingdee.eas.fi.arap.client.CancelAppointmentSubjectIUI;
import com.kingdee.eas.fi.arap.client.util.ArApBatchUtil;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.client.BillOptionsHelper;
import com.kingdee.eas.scm.common.client.CCRelationBillListImpl;
import com.kingdee.eas.scm.common.client.PrecisionConfigUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.bizflow.client.BizFlowClientHelper;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IncomeConfirmListUI
extends AbstractIncomeConfirmListUI {
    private static final Logger logger = CoreUIObject.getLogger(IncomeConfirmListUI.class);
    private final QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public IncomeConfirmListUI() throws Exception {
        this.actionAudit.setBindWorkFlow(false);
        this.actionVoucher.setDaemonRun(true);
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.actionViewBudget.setEnabled(false);
        this.actionViewBudget.setVisible(false);
        this.actionViewWriteOffRecords.setEnabled(true);
        this.actionVoucher.setEnabled(true);
        this.actionDelVoucher.setEnabled(true);
        this.actionCopyTo.setVisible(false);
        this.actionCreateTo.setVisible(true);
        this.actionAttachment.setVisible(true);
        this.menuItemSetZeroNotDisplay.setEnabled(true);
        this.menuItemChangeDataFormat.setEnabled(true);
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
    }

    @Override
    public void onLoad() throws Exception {
        this.getMenuParam();
        this.initBillConfig();
        super.onLoad();
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex("billStatus") + 1);
        this.tblMain.setColumnMoveable(true);
        this.setZeroDisplay();
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
    }

    @Override
    protected void setZeroDisplay() throws Exception {
        this.setCollumnFormat(new String[]{"qty"}, SCMClientUtils.getFormatPattern((int)this.qtyPrecision, (boolean)this.isZeroNotDisplay));
        this.setCollumnFormat(this.PRICE_FIELDS, SCMClientUtils.getFormatPattern((int)this.pricePrecision, (boolean)this.isZeroNotDisplay));
        this.setCollumnFormat(new String[]{"exchangeRate"}, SCMClientUtils.getFormatPattern((int)this.exPrecision, (boolean)this.isZeroNotDisplay));
        this.setCollumnFormat(new String[]{"taxRate"}, SCMClientUtils.getFormatPattern((int)this.taxRatePrecision, (boolean)this.isZeroNotDisplay));
    }

    @Override
    protected String[] getAmountFields() {
        String[] fieldArr = new String[]{"totalConfirmAmount", "totalConfirmAmountLocal"};
        return ArApBillHelper.stringArrayAppend(super.getAmountFields(), fieldArr);
    }

    @Override
    protected String[] getNewAmountFields() {
        String[] fieldArr = new String[]{"totalTaxAmount", "confirmAmount", "confirmAmountLoc"};
        return ArApBillHelper.stringArrayAppend(super.getNewAmountFields(), fieldArr);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setShowFilter(true);
        dialog.setShowSorter(true);
        dialog.setHeight(500);
        dialog.setWidth(500);
        IncomeConfimBillCommonQueryProcessor processor = new IncomeConfimBillCommonQueryProcessor();
        processor.set("isArSys", Boolean.TRUE);
        processor.set("isInit", Boolean.FALSE);
        AsstActTypeCollection asstActTypes = this.cache.getAsstActTypeColl();
        if (asstActTypes != null) {
            int n = asstActTypes.size();
            HashSet<BOSUuid> asstActTypeIds = new HashSet<BOSUuid>(n);
            for (int i = 0; i < n; ++i) {
                asstActTypeIds.add(asstActTypes.get(i).getId());
            }
            processor.set("asstActTypeIds", asstActTypeIds);
        }
        processor.setCompanyInfo(this.cache.getCompany());
        dialog.setTitle(ArApBillUIUtil.getStrResource("incomeConfirmBillQueryTitle"));
        dialog.setProcessor((IProcessor)processor);
        try {
            dialog.addUserPanel((KDPanel)this.getUserPanel());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return dialog;
    }

    protected IncomeConfirmBillQueryUI getUserPanel() throws Exception {
        return new IncomeConfirmBillQueryUI(this.getUIParam());
    }

    public boolean isAutoIgnoreZero() {
        return false;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEditVouchers_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("VoucherCannotEdit"));
            SysUtil.abort();
        }
        IIncomeConfimBill confirmBill = (IIncomeConfimBill)this.getBizInterface();
        ObjectStringPK pk = new ObjectStringPK(billId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.number"));
        IncomeConfimBillInfo billInfo = confirmBill.getIncomeConfimBillInfo((IObjectPK)pk, sic);
        if (CreateJobFacadeFactory.getRemoteInstance().checkDuplicateTask("SCM_FI_AR_001" + billInfo.getCompany().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        this.setOprtState("userCustomerStatus");
        ArApBatchUtil.requestMutex(billId);
        try {
            IIDList voucherIDList = this.arrayList2IIDList(voucherColl);
            String voucherId = voucherColl.get(0).toString();
            boolean hasPermission = BaseDataUtil.checkEditVoucherPermission((IObjectPK)new ObjectUuidPK(this.currentUser.getId()), (IObjectPK)new ObjectUuidPK(this.cache.getCompanyId()), "", (IObjectPK)new ObjectUuidPK(voucherId));
            if (!hasPermission) {
                MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("NoPermissionCannotEdit"));
                SysUtil.abort();
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)voucherId);
            uiContext.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
            uiContext.put((Object)"IDList", (Object)voucherIDList);
            String uiClass = "com.kingdee.eas.fi.gl.client.VoucherEditUI";
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        finally {
            ArApBatchUtil.releaseMutex(billId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.prepareBatchOperation(null).callHandler();
        ArrayList idList = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(idList);
        try {
            BizFlowClientHelper helper = new BizFlowClientHelper((CoreUI)this, new LinkedHashSet(idList), this.getBillEntryName());
            this.getMainOrgContext().put((Object)"beforeBizFlowSelect", (Object)helper.getBatchBizFlowMap());
            Class[] clz = new Class[]{Set.class};
            ArApBatchUtil.batchOperaction((CoreUI)this, this.getSelectedIdValues(), this.getBizInterface(), this.getBOSEntity().getAlias(), this.menuItemBatchSubmit.getText(), "batchSubmit", clz);
            RequestContext request = new RequestContext();
            String[] selectedListId = new String[idList.size()];
            request.put("selectedListId", (Object)idList.toArray(selectedListId));
            if (UtilRequest.isPrepare((String)"ActionBatchSubmit", (CoreUIObject)this) && UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
                IUIActionPostman postman = this.prepareRefresh(request);
                this.prepareActionAfter((RequestContext)postman.getRequestContext()).callHandler();
            }
        }
        finally {
            ArApBatchUtil.releasePureMutex(idList);
        }
        this.refreshList();
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!ArApBillListUI.isSameStatus(this.tblMain, BillStatusEnum.AUDITED)) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("billIsUnAudited"));
            SysUtil.abort();
        }
        super.actionCreateTo_actionPerformed(e);
    }

    @Override
    public void actionAppointmentSubject_actionPerformed(ActionEvent e) throws Exception {
        String[] billIdlist = this.getSelectedListId();
        ICoreBase iCoreBase = this.getBizInterface();
        this.setOprtState("userCustomerStatus");
        try {
            int num = billIdlist.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(billIdlist[i]);
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        ObjectUuidPK[] pk = new ObjectUuidPK[billIdlist.length];
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        HashSet<Object> currencySet = new HashSet<Object>();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell currencyCell = this.tblMain.getRow(rowIndex).getCell("currency");
                if (currencySet.contains(currencyCell.getValue())) continue;
                currencySet.add(currencyCell.getValue());
            }
        }
        if (currencySet.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getArApBillResourceBy("point_subject_difCurrency_not"));
            return;
        }
        for (int i = 0; i < billIdlist.length; ++i) {
            pk[i] = new ObjectUuidPK(billIdlist[i]);
        }
        ArApBillBaseInfo baseInfo = (ArApBillBaseInfo)iCoreBase.getValue((IObjectPK)pk[0]);
        CurrencyInfo tmpCurrencyInfo = baseInfo.getCurrency();
        HashMap<String, Object> uiCtx = new HashMap<String, Object>();
        uiCtx.put("Owner", (Object)this);
        uiCtx.put("ArApSysParamInfo", this.cache);
        uiCtx.put("currencyInfo", tmpCurrencyInfo);
        uiCtx.put("pk", pk);
        uiCtx.put("iCoreBase", iCoreBase);
        uiCtx.put("alia", this.getBOSEntity().getAlias());
        uiCtx.put("isTransBill", false);
        if (this.isDisplayEntries()) {
            uiCtx.put("selectedIdValues", this.getSelectedEntryIdValues());
        } else {
            uiCtx.put("selectedIdValues", this.getSelectedIdValues());
        }
        uiCtx.put("isDisplayEntries", this.isDisplayEntries());
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ArAppointmentSubjectUI.class.getName(), uiCtx, null, OprtState.EDIT);
        uiWin.show();
        this.setOprtState("RELEASEALL");
        try {
            int num = billIdlist.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(billIdlist[i]);
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCancelAppointmentSubject_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(idList);
        try {
            ICoreBase iCoreBase = this.getBizInterface();
            HashMap<String, Object> uiCtx = new HashMap<String, Object>();
            uiCtx.put("Owner", (Object)this);
            uiCtx.put("accountName", "AR_ACCOUNT");
            uiCtx.put("iCoreBase", iCoreBase);
            uiCtx.put("alia", this.getBOSEntity().getAlias());
            uiCtx.put("selectedIdValues", this.getSelectedIdValues());
            IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CancelAppointmentSubjectIUI.class.getName(), uiCtx, null, OprtState.EDIT);
            uiWin.show();
        }
        finally {
            ArApBatchUtil.releasePureMutex(idList);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionIgnore_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String confirmMsg = EASResource.getString((String)"com.kingdee.eas.fi.ar.IncomeConfimResource", (String)"BILL_IGNORE_CONFIRM_MSG");
        if (MsgBox.showConfirm2((Component)((Object)this), (String)confirmMsg) == 2) {
            return;
        }
        ArrayList idList = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(idList);
        try {
            Class[] clz = new Class[]{IObjectPK.class};
            ArApBatchUtil.batchOperaction((CoreUI)this, this.getSelectedIdValues(), this.getBizInterface(), this.getBOSEntity().getAlias(), EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"IGNORE"), "ignore", clz);
        }
        finally {
            ArApBatchUtil.releasePureMutex(idList);
        }
        this.refreshList();
    }

    @Override
    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(true);
    }

    @Override
    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(false);
    }

    protected void invokeMultiPrintFunction(boolean isPrint) {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        this.invokeMultiPrintFunction(idList, isPrint);
    }

    @Override
    protected String getTDFileName() {
        return "/FI/AR/IncomeConfirmBill";
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.fi.ar.app.IncomeConfirmBillPrintQuery");
    }

    protected int getShowMessagePolicy() {
        return 1;
    }

    @Override
    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            boolean isDisplayEntries = this.isDisplayEntries();
            rowSet.beforeFirst();
            Map colMap = null;
            while (rowSet.next()) {
                boolean isExpenseItem;
                if (!isDisplayEntries) {
                    rowSet.updateObject("entry.id", null);
                }
                BizEnumValueInfo billType = (BizEnumValueInfo)rowSet.getObject("billType");
                List<Integer> expenseTypeList = Arrays.asList(302, 303);
                boolean bl = isExpenseItem = null == billType ? false : expenseTypeList.contains(billType.getInt());
                if (isExpenseItem) {
                    if (rowSet.getObject("expenseItem.number") != null) {
                        rowSet.updateObject("material.number", rowSet.getObject("expenseItem.number"));
                    }
                    if (rowSet.getObject("expenseItem.name") != null) {
                        rowSet.updateObject("material.name", rowSet.getObject("expenseItem.name"));
                    }
                }
                if (colMap == null) {
                    colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
                }
                SCMClientUtils.iniColumnsPrecision((int)rowSet.getInt("currency.precision"), (String[])this.getNewAmountFields(), (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev == null || ev.getFilter() == null) {
            return;
        }
        FilterInfo hideFilter = ev.getFilter();
        for (FilterItemInfo filterItem : hideFilter.getFilterItems()) {
            Object obj;
            if (filterItem == null || filterItem.getPropertyName() == null || !"entry.seq".equals(filterItem.getPropertyName()) || !((obj = filterItem.getCompareValue()) instanceof Integer)) continue;
            Integer cpInte = (Integer)obj;
            if (cpInte == 1) {
                this.setDisplayEntries(false);
                this.isPullIngoreEntry = true;
                continue;
            }
            if (cpInte != 0) continue;
            this.setDisplayEntries(true);
            this.isPullIngoreEntry = false;
        }
        super.beforeExcutQuery(super.beforeExcutQueryCommon(ev));
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    protected String getEditUIName() {
        return IncomeConfimEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IncomeConfimBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    @Override
    protected String getPermissionItem() {
        return "fi_ar_IncomeConfirmBill_View";
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    public boolean isSupportDynQuery() {
        return true;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.supportExecutionWithoutFilters();
        if (this.cache == null || this.cache.getCompany() == null) {
            try {
                IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
                this.cache = iBillFacade.getSysParams(null, this.getUIParam());
                return this.qfsi.supportSingleMainOrg((OrgUnitInfo)this.cache.getCompany());
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return this.qfsi;
    }

    @Override
    protected void setDateDisplay() {
        String fmt = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(fmt);
    }

    protected void prepareMutexParameter(ActionEvent e, MutexParameter param) {
        param.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
        super.prepareMutexParameter(e, param);
    }

    @Override
    protected void prepareHandlerParam(RequestContext request) {
        super.prepareHandlerParam(request);
        try {
            request.setBosType(this.getBizType());
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
    }

    @Override
    public String[] getMergeColumnKeys() {
        String[] mergeCols = new String[]{"id", "company.name", "number", "billStatus", "billDate", "bizDate", "billType", "bizType", "sourceBillType", "asstActType", "asstActNumber", "asstActName", "currency", "exchangeRate", "adminOrg", "costCenter", "saleOrg", "saleGroup", "person", "paymentType", "payCondition", "cashDiscount", "abstractName", "totalConfirmAmount", "totalConfirmAmountLocal", "processNode", "totalAmount", "totalAmountLocal", "totalTaxAmount", "totalTaxAmountLocal", "fivouchered", "voucherType", "voucherNumber", "isInitBill", "isImportBill", "isReversed", "isReverseBill", "creator", "createTime", "lastUpdateUser", "lastUpdateTime", "auditor", "auditDate", "accountant"};
        return mergeCols;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entry.amountLocal"));
        sic.add(new SelectorItemInfo("entry.lockVerifyAmtLocal"));
        sic.add(new SelectorItemInfo("entry.lockUnVerifyAmtLocal"));
        sic.add(new SelectorItemInfo("entry.localWrittenOffAmount"));
        sic.add(new SelectorItemInfo("entry.localUnwriteOffAmount"));
        sic.add(new SelectorItemInfo("BillDate_SourceBill"));
        sic.add(new SelectorItemInfo("AsstActTypeID_SourceBill"));
        sic.add(new SelectorItemInfo("AsstActID_SourceBill"));
        sic.add(new SelectorItemInfo("PersonID_SourceBill"));
        sic.add(new SelectorItemInfo("AdminOrgUnitId_SourceBill"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        return sic;
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "IncomeConfirmBill";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"AR_ImportIncomeConfirmBill");
        param.getContextParam().put("isSCMBill", this.isSCMBill);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "IncomeConfirmBill";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"AR_ImportIncomeConfirmBill");
        param.varList = new ArrayList();
        HashMap<String, FilterInfo> map = new HashMap<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        if (!selectIds.isEmpty()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
            map.put("filter", filter);
        } else if (this.mainQuery != null) {
            map.put("filter", this.mainQuery.getFilter());
        }
        param.setContextParam(map);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.isEmpty()) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    @Override
    public void actionViewWriteOffRecords_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String selectId = this.getSelectedKeyValue();
        IIncomeConfimBill incomeConfimBill = (IIncomeConfimBill)this.getBizInterface();
        IncomeConfimBillInfo billInfo = incomeConfimBill.getIncomeConfimBillInfo((IObjectPK)new ObjectUuidPK(selectId));
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add((CoreBillBaseInfo)billInfo);
        CCRelationBillListImpl billList = new CCRelationBillListImpl((CoreBillListUI)this);
        Map uiContext = this.getUIContext();
        billList.traceDown(sourceBillCollection, this.getEntriesPKName(), uiContext);
    }

    @Override
    public void actionChangeDataFormat_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow precisionConfigWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.common.client.PrecisionConfigUI", (Map)uiContext, null, OprtState.EDIT);
        PrecisionConfigUI precisionConfigUI = (PrecisionConfigUI)precisionConfigWindow.getUIObject();
        precisionConfigUI.setDefaultValue(this.qtyPrecision, this.pricePrecision, this.exPrecision, this.taxRatePrecision);
        precisionConfigWindow.show();
        if (!precisionConfigUI.isCancel()) {
            this.qtyPrecision = precisionConfigUI.getQtyPrecision();
            this.pricePrecision = precisionConfigUI.getPricePrecision();
            this.exPrecision = precisionConfigUI.getExPrecision();
            this.taxRatePrecision = precisionConfigUI.getTaxRatePrecision();
            this.setZeroDisplay();
            String userPrecisionTemp = this.qtyPrecision + "," + this.pricePrecision + "," + this.exPrecision + "," + this.taxRatePrecision;
            BillOptionsHelper.putConfigTypeByUI((IUIObject)this, (String)"userPrecision", (String)userPrecisionTemp);
        }
    }

    @Override
    public void actionSetZeroNotDisplay_actionPerformed(ActionEvent e) throws Exception {
        this.isZeroNotDisplay = this.menuItemSetZeroNotDisplay.isSelected();
        BillOptionsHelper.putConfigTypeByUI((IUIObject)this, (String)"noZeroShow", (boolean)this.isZeroNotDisplay);
        this.setZeroDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionReverse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ICoreBase iCoreBase = this.getBizInterface();
        ArApBatchUtil.requestPureMutex(idList);
        try {
            ObjectUuidPK[] pks = new ObjectUuidPK[idList.size()];
            for (int i = 0; i < idList.size(); ++i) {
                pks[i] = new ObjectUuidPK((String)idList.get(i));
            }
            HashMap<String, Object> uiCtx = new HashMap<String, Object>();
            uiCtx.put("Owner", (Object)this);
            uiCtx.put("ArApSysParamInfo", this.cache);
            uiCtx.put("pk", pks);
            uiCtx.put("iCoreBase", iCoreBase);
            uiCtx.put("alia", this.getBOSEntity().getAlias());
            uiCtx.put("selectedIdValues", this.getSelectedIdValues());
            uiCtx.put("isIncomeConfirmBill", true);
            IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ArApreverseEditUI.class.getName(), uiCtx, null, OprtState.EDIT);
            uiWin.show();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Exception t) {
            this.handUIException(t);
        }
        finally {
            ArApBatchUtil.releasePureMutex(idList);
        }
        this.refreshList();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    private void changeButtonStatus() {
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        if (row == null) {
            return;
        }
        boolean isinit = false;
        if (row.getCell("isInitBill").getValue() instanceof Boolean) {
            isinit = (Boolean)row.getCell("isInitBill").getValue();
        }
        if (isinit) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionEditVouchers.setEnabled(false);
        } else {
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(true);
            this.actionEditVouchers.setEnabled(true);
        }
        if (row.getCell("billStatus").getValue() instanceof BizEnumValueInfo) {
            int billStatus = ((BizEnumValueInfo)row.getCell("billStatus").getValue()).getInt();
            this.actionEdit.setEnabled(billStatus != 3 && billStatus != -1);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.changeButtonStatus();
    }

    private void initBillConfig() throws BOSException {
        boolean noZeroShow;
        Map billOptionsMap = BillOptionsHelper.takeConfigType((IUIObject)this);
        String userPrecision = BillOptionsHelper.takeConfigTypeByUI((Map)billOptionsMap, (IUIObject)this, (String)"userPrecision");
        if (!StringUtil.isEmpty((String)userPrecision) && !"null".equalsIgnoreCase(userPrecision)) {
            String[] userPrecisions = userPrecision.split(",");
            try {
                if (userPrecisions.length == 4) {
                    this.qtyPrecision = Integer.parseInt(userPrecisions[0]);
                    this.pricePrecision = Integer.parseInt(userPrecisions[1]);
                    this.exPrecision = Integer.parseInt(userPrecisions[2]);
                    this.taxRatePrecision = Integer.parseInt(userPrecisions[3]);
                }
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
            }
        }
        this.isZeroNotDisplay = noZeroShow = BillOptionsHelper.takeConfigType((Map)billOptionsMap, (IUIObject)this, (String)"noZeroShow", (boolean)true);
        this.menuItemSetZeroNotDisplay.setSelected(noZeroShow);
    }

    public void releaseMutex(String[] billIdlist) {
        if (billIdlist == null) {
            return;
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        for (int j = 0; j < billIdlist.length; ++j) {
            mutex.releaseObjIDForUpdate(billIdlist[j]);
        }
    }

    private String[] removeBillIdList(String[] billIdlist, String billId) {
        List<String> idList = Arrays.asList(billIdlist);
        idList.remove(billId);
        return idList.toArray(new String[0]);
    }

    private IIDList arrayList2IIDList(List<String> list) {
        RealModeIDList List2 = RealModeIDList.getEmptyIDList();
        if (list != null && list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                List2.add(i, list.get(i));
            }
        }
        return List2;
    }

    @Override
    protected HashMap getUIParam() {
        HashMap params = super.getUIParam();
        IncomeConfimBillInfo billInfo = new IncomeConfimBillInfo();
        params.put("billInfo", billInfo);
        return params;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        ArrayList tempList = new ArrayList(destBosTypeList);
        destBosTypeList.clear();
        if (tempList.contains(BosTypeEnum.AR_OTHER_BILL.getValue())) {
            destBosTypeList.add(BosTypeEnum.AR_OTHER_BILL.getValue());
        }
        return destBosTypeList;
    }

    protected String[] getQueryHideField() {
        return new String[]{"billType", "expenseItem.number", "expenseItem.name", "material.number", "material.name", "currency.precision", "isInitBill", "paymentType", "company.id", "sourceBillType"};
    }
}

