/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.BadAcctCause;
import com.kingdee.eas.fi.ar.IInitBadAccount;
import com.kingdee.eas.fi.ar.InitBadAccountFactory;
import com.kingdee.eas.fi.ar.InitBadAccountInfo;
import com.kingdee.eas.fi.ar.client.AbstractInitBadAccountEditUI;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InitBadAccountEditUI
extends AbstractInitBadAccountEditUI {
    private UserInfo defaultUserInfo = null;
    private CompanyOrgUnitInfo currentCompany = null;
    private AsstActTypeInfo asstActTypeInfo = null;
    private PeriodInfo rPeriod = null;
    private LogUtil logUtil = new LogUtil();
    private DataChangeListener badAccountDateListener;
    protected transient ArApSysParamInfo sysInfo = null;
    protected transient HashMap map = new HashMap();
    protected transient IArApBillFacade iBillFacade = null;
    private boolean isSubmitedAddNew = false;

    public InitBadAccountEditUI() throws Exception {
        if (this.defaultUserInfo == null) {
            this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
        }
        catch (Exception ex) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_currentCompanyIsNull"));
        }
        if (this.currentCompany == null || this.currentCompany.isIsOnlyUnion()) {
            SysUtil.abort();
        }
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    }

    protected void getSysParams() throws EASBizException, BOSException {
        this.map.put("isSCM", Boolean.FALSE);
        this.map.put("sysEnum", SystemEnum.ACCOUNTSRECEIVABLE);
        this.sysInfo = this.iBillFacade.getSysParams(null, this.map);
    }

    private void setAsstActType() throws EASBizException, BOSException {
        this.getSysParams();
        ArApBillUIUtil.setAsstActType(this.cmbAsstActType, this.sysInfo, false);
    }

    public void onLoad() throws Exception {
        this.setAsstActType();
        NewSaleF7 purOrg = new NewSaleF7((IUIObject)this);
        purOrg.setTitle(this.getStrResource("orgUnit"));
        this.bizPromptOrgUnit.setSelector((KDPromptSelector)purOrg);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.bizPromptBizMan);
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)this.bizPromptAdmin);
        this.formatTxtAmounts.getNumberFeatureMode().setRemoveingZeroInDispaly(false);
        this.formatTxtExchangeRate.getNumberFeatureMode().setRemoveingZeroInDispaly(false);
        this.formatTxtAmounts.setHorizontalAlignment(4);
        this.formatTxtExchangeRate.setHorizontalAlignment(4);
        this.rPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionSave.setVisible(false);
        this.menuView.setVisible(true);
        this.menuItemAddNew.setVisible(true);
        super.onLoad();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.initTxtExchangeRatePre();
    }

    private void initTxtExchangeRatePre() throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.bizPromptCurrency.getValue();
        Date badAcctDate = this.dateBadAccountDate.getSqlDate();
        if (currencyInfo == null) {
            return;
        }
        if (badAcctDate == null) {
            this.formatTxtExchangeRate.setValue(null);
            return;
        }
        int precision = currencyInfo.getPrecision();
        if (precision == 0) {
            precision = 2;
        }
        this.formatTxtAmounts.setPrecision(precision);
        if (currencyInfo.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
            this.formatTxtExchangeRate.setPrecision(0);
            this.formatTxtExchangeRate.setText("1");
            this.formatTxtExchangeRate.setEnabled(false);
        } else {
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(this.currentCompany, currencyInfo, badAcctDate);
            if (rateInfo != null) {
                this.formatTxtExchangeRate.setPrecision(rateInfo.getPrecision());
                this.formatTxtExchangeRate.setValue((Object)rateInfo.getConvertRate());
                if (rateInfo.getExchangeAux() != null) {
                    this.formatTxtExchangeRate.setPrecision(rateInfo.getExchangeAux().getPrecision());
                }
            } else {
                this.formatTxtExchangeRate.setPrecision(0);
            }
            this.formatTxtExchangeRate.setEnabled(true);
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void loadFields() {
        ComBoxInfo comBoxInfo;
        int i;
        int n;
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.cmbAsstActType.getSelectedItem() != null) {
                n = this.cmbAsstActType.getItemCount();
                for (i = 0; i < n; ++i) {
                    comBoxInfo = (ComBoxInfo)this.cmbAsstActType.getItemAt(i);
                    if (!comBoxInfo.getobjInfo().getString("asstHGAttribute").equalsIgnoreCase("customer")) continue;
                    this.cmbAsstActType.setSelectedIndex(i);
                    break;
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("asstacttype_null"));
                SysUtil.abort();
            }
        } else {
            n = this.cmbAsstActType.getItemCount();
            for (i = 0; i < n; ++i) {
                comBoxInfo = (ComBoxInfo)this.cmbAsstActType.getItemAt(i);
                if (!comBoxInfo.getobjInfo().getString("id").equals(this.editData.getAsstActType().getString("id"))) continue;
                this.cmbAsstActType.setSelectedIndex(i);
                break;
            }
        }
        if (this.editData.getAcctCussent() != null) {
            BOSUuid uuid = this.editData.getAcctCussent();
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            BOSObjectType objType = uuid.getType();
            try {
                IDynamicObject dynamicObject = DynamicObjectFactory.getRemoteInstance();
                IObjectValue objectValue = dynamicObject.getValue(objType, (IObjectPK)pk);
                this.bizPromptAcctCussent.setData((Object)objectValue);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (this.badAccountDateListener != null) {
            this.dateBadAccountDate.removeDataChangeListener(this.badAccountDateListener);
        }
        for (i = 0; i < this.bizPromptCurrency.getChangeListeners().length; ++i) {
            this.bizPromptCurrency.removeChangeListener(this.bizPromptCurrency.getChangeListeners()[i]);
        }
        super.loadFields();
        this.bizPromptCurrency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InitBadAccountEditUI.this.bizPromptCurrency_stateChanged(e);
                }
                catch (Exception exc) {
                    InitBadAccountEditUI.this.handUIException(exc);
                }
            }
        });
        if (this.badAccountDateListener == null) {
            this.badAccountDateListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        InitBadAccountEditUI.this.kdBadAccountDate_dataChanged(e);
                    }
                    catch (Exception exc) {
                        InitBadAccountEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.dateBadAccountDate.addDataChangeListener(this.badAccountDateListener);
        this.setNumberEnabled();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.asstActTypeInfo != null) {
            this.editData.setAsstActType(this.asstActTypeInfo);
        }
        if (this.bizPromptOrgUnit.getData() != null) {
            this.editData.setOrgUnit((SaleOrgUnitInfo)this.bizPromptOrgUnit.getData());
        }
        if (this.formatTxtAmounts.getBigDecimalValue() != null) {
            this.editData.setAmounts(this.formatTxtAmounts.getBigDecimalValue());
        }
        if (this.bizPromptBizMan.getValue() != null) {
            this.editData.setBizMan((PersonInfo)this.bizPromptBizMan.getValue());
        }
        if (this.cmbBadAcctNote.getSelectedIndex() != -1) {
            this.editData.setBadAcctNote((BadAcctCause)((Object)this.cmbBadAcctNote.getSelectedItem()));
        }
    }

    protected void kdBadAccountDate_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.bizPromptCurrency.getValue();
        Date badAcctDate = this.dateBadAccountDate.getSqlDate();
        if (currencyInfo == null || badAcctDate == null) {
            return;
        }
        int precision = currencyInfo.getPrecision();
        if (precision == 0) {
            precision = 2;
        }
        this.formatTxtAmounts.setPrecision(precision);
        if (currencyInfo.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
            this.formatTxtExchangeRate.setPrecision(0);
            this.formatTxtExchangeRate.setText("1");
            this.formatTxtExchangeRate.setEnabled(false);
        } else {
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(this.currentCompany, currencyInfo, badAcctDate);
            if (rateInfo != null) {
                this.formatTxtExchangeRate.setPrecision(rateInfo.getPrecision());
                this.formatTxtExchangeRate.setValue((Object)rateInfo.getConvertRate());
                if (rateInfo.getExchangeAux() != null) {
                    this.formatTxtExchangeRate.setPrecision(rateInfo.getExchangeAux().getPrecision());
                }
            } else {
                this.formatTxtExchangeRate.setPrecision(0);
                this.formatTxtExchangeRate.setValue(null);
            }
            this.formatTxtExchangeRate.setEnabled(true);
            this.formatTxtExchangeRate.setEnabled(true);
        }
    }

    public void setNumberEnabled() {
        if (this.editData == null) {
            return;
        }
        try {
            boolean isAddView;
            boolean isAutoNumber = this.isAutoNumber();
            if (this.getOprtState().equals("ADDNEW") && isAutoNumber && (isAddView = this.isAddView()) && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.setText(BaseDataUtil.getCodeRuleClient(this.editData));
                this.editData.setNumber(this.txtNumber.getText());
                this.initOldData((IObjectValue)this.editData);
            }
            this.txtNumber.setEditable(!isAutoNumber);
            this.txtNumber.setRequired(!isAutoNumber);
            if (isAutoNumber) {
                this.cmbAsstActType.requestFocus();
            } else {
                this.txtNumber.requestFocus();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean isAddView() throws CodingRuleException, EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isAddView((IObjectValue)this.editData, strCompanyID);
    }

    protected boolean isAutoNumber() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isExist((IObjectValue)this.editData, this.currentCompany.getId().toString());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setNumberEnabled();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        int tempAsstActType = this.cmbAsstActType.getSelectedIndex();
        super.actionCopy_actionPerformed(e);
        this.txtNumber.setText("");
        this.cmbAsstActType.setSelectedIndex(tempAsstActType);
        this.setNumberEnabled();
        if (this.asstActTypeInfo != null) {
            String relationDataObject = this.asstActTypeInfo.getRealtionDataObject();
            boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
            boolean fPerson = relationDataObject.equalsIgnoreCase("T_BD_Person");
            if (fSupp && this.editData.getAcctCussent() != null) {
                SupplierInfo supply = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(this.editData.getAcctCussent()));
                this.bizPromptAcctCussent.setValue((Object)supply);
            }
            if (fPerson && this.editData.getAcctCussent() != null) {
                PersonInfo person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(this.editData.getAcctCussent()));
                this.bizPromptAcctCussent.setValue((Object)person);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo;
        super.actionEdit_actionPerformed(e);
        this.setNumberEnabled();
        if (this.bizPromptCurrency.getValue() != null && (currencyInfo = (CurrencyInfo)this.bizPromptCurrency.getValue()) != null && currencyInfo.getId().toString().equalsIgnoreCase(this.currentCompany.getBaseCurrency().getId().toString())) {
            this.formatTxtExchangeRate.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        InitBadAccountInfo initBadAccountInfo = new InitBadAccountInfo();
        java.util.Date now = new java.util.Date();
        if (initBadAccountInfo.getCompany() == null) {
            initBadAccountInfo.setCompany(this.currentCompany);
        }
        if (initBadAccountInfo.getCreator() == null) {
            initBadAccountInfo.setCreator(this.defaultUserInfo);
        }
        initBadAccountInfo.setAmounts(null);
        initBadAccountInfo.setAmountsLocal(null);
        initBadAccountInfo.setBizMan(null);
        initBadAccountInfo.setBadAcctNote(BadAcctCause.getEnum("500"));
        GregorianCalendar cal = new GregorianCalendar();
        if (this.rPeriod != null) {
            cal.setTimeInMillis(this.rPeriod.getBeginDate().getTime());
            ((Calendar)cal).add(6, -1);
            initBadAccountInfo.setBadAccountDate(cal.getTime());
        }
        initBadAccountInfo.setCreateTime(new Timestamp(now.getTime()));
        if (initBadAccountInfo.getBadAccountDate() == null) {
            initBadAccountInfo.setBadAccountDate(now);
        }
        if (initBadAccountInfo.getCurrency() == null) {
            initBadAccountInfo.setCurrency(this.currentCompany.getBaseCurrency());
        }
        if (initBadAccountInfo.getExchangeRate() == null) {
            initBadAccountInfo.setExchangeRate(new BigDecimal("1"));
        }
        initBadAccountInfo.setAsstActType(this.asstActTypeInfo);
        return initBadAccountInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InitBadAccountFactory.getRemoteInstance();
    }

    private boolean isCheckNumber() throws CodingRuleException, EASBizException, BOSException {
        return !this.isAutoNumber() || this.isAddView();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("asstActType"));
        sic.add(new SelectorItemInfo("acctCussent"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("user"));
        return sic;
    }

    private String getStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Date badAcctDate;
        super.verifyInput(e);
        if (this.bizPromptCompany.getData() == null) {
            this.bizPromptCompany.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_currentCompanyIsNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtNumber.getText()) && this.isCheckNumber()) {
            MsgBox.showError((Component)((Object)this), (String)this.getStrResource("initbadaccount_number_null"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.cmbAsstActType.getSelectedItem() == null) {
            this.cmbAsstActType.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_acctCussentTypeIsNull"));
            SysUtil.abort();
        }
        if (this.bizPromptAcctCussent.getText() == null || "".equals(this.bizPromptAcctCussent.getText().trim()) || this.bizPromptAcctCussent.getData() == null) {
            this.bizPromptAcctCussent.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_acctCussentIsNull"));
            SysUtil.abort();
        }
        if ((badAcctDate = this.dateBadAccountDate.getSqlDate()) == null) {
            this.dateBadAccountDate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_badAccountDateIsNull"));
            SysUtil.abort();
        }
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        cal.setTimeInMillis(this.rPeriod.getBeginDate().getTime());
        String sInitStartPeriod = df.format(cal.getTime());
        String sBadAccountDate = df.format(badAcctDate);
        if (sBadAccountDate.compareTo(sInitStartPeriod) >= 0) {
            this.dateBadAccountDate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bad_date_smaller_begin_date_of_init_period"));
            SysUtil.abort();
        }
        if (this.bizPromptCurrency.getData() == null) {
            this.bizPromptCurrency.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_currencyIsNull"));
            SysUtil.abort();
        }
        if (this.formatTxtExchangeRate.getBigDecimalValue() == null) {
            this.formatTxtExchangeRate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_exchangeRateIsNull"));
            SysUtil.abort();
        }
        if (this.formatTxtAmounts.getBigDecimalValue() == null || this.formatTxtAmounts.getText() == null || this.formatTxtAmounts.getText().trim().equals("")) {
            this.formatTxtAmounts.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_BadAccountsAmountIsNull"));
            SysUtil.abort();
        }
        if (this.formatTxtAmounts.getBigDecimalValue().compareTo(new BigDecimal("999999999999999999.0")) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("bad_amt_invalidate"));
            SysUtil.abort();
        }
        if (this.formatTxtAmounts.getBigDecimalValue().compareTo(new BigDecimal("0.0")) <= 0) {
            this.formatTxtAmounts.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bad_amout_bigger_zero"));
            SysUtil.abort();
        }
        if (this.cmbBadAcctNote.getSelectedIndex() == -1) {
            this.cmbBadAcctNote.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_InitBadAccount_BadAcctNoteIsNull"));
            SysUtil.abort();
        }
    }

    @Override
    protected void cmbAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.cmbAsstActType.getItemCount() == 0 || this.cmbAsstActType.getSelectedItem() == null) {
            return;
        }
        this.asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.cmbAsstActType.getSelectedItem()).getobjInfo();
        if (this.asstActTypeInfo == null) {
            this.bizPromptAcctCussent.setEnabled(false);
            return;
        }
        if (this.asstActTypeInfo.getDefaultQueryName() != null) {
            this.bizPromptAcctCussent.setEnabled(true);
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.bizPromptAcctCussent, this.asstActTypeInfo, this.currentCompany.getId().toString(), false);
        }
        this.bizPromptAcctCussent.setData(null);
        super.cmbAsstActType_itemStateChanged(e);
    }

    @Override
    protected void bizPromptCurrency_stateChanged(ChangeEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.bizPromptCurrency.getValue();
        Date badAcctDate = this.dateBadAccountDate.getSqlDate();
        if (currencyInfo == null) {
            return;
        }
        if (badAcctDate == null) {
            this.formatTxtExchangeRate.setValue(null);
            return;
        }
        int precision = currencyInfo.getPrecision();
        if (precision == 0) {
            precision = 2;
        }
        this.formatTxtAmounts.setPrecision(precision);
        if (currencyInfo.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
            this.formatTxtExchangeRate.setPrecision(0);
            this.formatTxtExchangeRate.setText("1");
            this.formatTxtExchangeRate.setEnabled(false);
        } else {
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(this.currentCompany, currencyInfo, badAcctDate);
            if (rateInfo != null) {
                this.formatTxtExchangeRate.setPrecision(rateInfo.getPrecision());
                this.formatTxtExchangeRate.setValue((Object)rateInfo.getConvertRate());
                if (rateInfo.getExchangeAux() != null) {
                    this.formatTxtExchangeRate.setPrecision(rateInfo.getExchangeAux().getPrecision());
                }
            } else {
                this.formatTxtExchangeRate.setPrecision(0);
                this.formatTxtExchangeRate.setValue(null);
            }
            this.formatTxtExchangeRate.setEnabled(true);
        }
    }

    public void formatTxtExchangeRate_focusLost(FocusEvent e) throws Exception {
        if (this.formatTxtExchangeRate.getText() == null || this.formatTxtExchangeRate.getText().trim().equals("")) {
            return;
        }
        BigDecimal exchangeRate = new BigDecimal(this.formatTxtExchangeRate.getText().toString());
        CurrencyInfo currency = (CurrencyInfo)this.bizPromptCurrency.getValue();
        int DEF_SCALE = 0;
        if (currency.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
            this.formatTxtExchangeRate.setValue((Object)"1");
        } else {
            exchangeRate = exchangeRate.setScale(DEF_SCALE, 4);
            this.formatTxtExchangeRate.setValue((Object)exchangeRate);
        }
    }

    @Override
    public void formatTxtAmounts_focusLost(FocusEvent e) {
        try {
            if (this.formatTxtAmounts.getText() == null || this.formatTxtAmounts.getText().trim().equals("")) {
                return;
            }
            CurrencyInfo currency = (CurrencyInfo)this.bizPromptCurrency.getValue();
            int DEF_SCALE = currency != null ? currency.getPrecision() : 4;
            Number txtAmounts = BOSLocaleUtil.getNumberFormat().parse(this.formatTxtAmounts.getText());
            BigDecimal amount = new BigDecimal(txtAmounts.toString());
            amount = amount.setScale(DEF_SCALE, 4);
            this.formatTxtAmounts.setValue((Object)amount);
        }
        catch (ParseException e1) {
            this.handleException(e1);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (this.formatTxtAmounts.getBigDecimalValue() != null && this.formatTxtExchangeRate.getBigDecimalValue() != null) {
            int percision = this.currentCompany.getBaseCurrency().getPrecision();
            boolean isDirectExchange = true;
            CurrencyInfo currencyInfo = (CurrencyInfo)this.bizPromptCurrency.getValue();
            ExchangeRateInfo exgRateInfo = null;
            BigDecimal amountsLocal = null;
            if (!ArApBillHelper.idEquals((CoreBaseInfo)currencyInfo, (CoreBaseInfo)this.currentCompany.getBaseCurrency())) {
                exgRateInfo = BaseDataUtil.getExchangeRate(this.currentCompany, currencyInfo);
            }
            if (exgRateInfo != null) {
                isDirectExchange = exgRateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)exgRateInfo.getExchangeAux().getConvertMode());
            }
            if (isDirectExchange) {
                amountsLocal = this.formatTxtAmounts.getBigDecimalValue().multiply(this.formatTxtExchangeRate.getBigDecimalValue());
                amountsLocal = amountsLocal.setScale(percision, 4);
            } else {
                amountsLocal = this.formatTxtAmounts.getBigDecimalValue().divide(this.formatTxtExchangeRate.getBigDecimalValue(), percision, 4);
            }
            this.editData.setAmountsLocal(amountsLocal);
        }
        if (this.editData.getCU() == null) {
            this.editData.setCU(this.currentCompany.getCU());
        }
        if (this.bizPromptAcctCussent.getValue() != null) {
            IObjectValue ov = (IObjectValue)this.bizPromptAcctCussent.getValue();
            BOSUuid uuid = BOSUuid.read((String)((IObjectValue)this.bizPromptAcctCussent.getValue()).getString("id"));
            this.editData.setAcctCussent(uuid);
            this.editData.setAcctCussentName(ArApBillUIUtil.getAsstActName(ov, ArApBillUIUtil.L1), ArApBillUIUtil.L1);
            this.editData.setAcctCussentName(ArApBillUIUtil.getAsstActName(ov, ArApBillUIUtil.L2), ArApBillUIUtil.L2);
            this.editData.setAcctCussentName(ArApBillUIUtil.getAsstActName(ov, ArApBillUIUtil.L3), ArApBillUIUtil.L3);
        }
        IObjectPK logObjectPK = null;
        if (this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
            IInitBadAccount iInitBadAccount = InitBadAccountFactory.getRemoteInstance();
            InitBadAccountInfo initBadAccountInfo = iInitBadAccount.getInitBadAccountInfo((IObjectPK)pk);
            if (initBadAccountInfo != null && initBadAccountInfo.getTakeBackAmounts() != null) {
                if (initBadAccountInfo.getTakeBackAmounts().compareTo(new BigDecimal("0.0")) > 0) {
                    MsgBox.showInfo((String)this.getStrResource("init_acct_bad_take_back_modify"));
                    SysUtil.abort();
                }
                logObjectPK = this.beginLog((IObjectPK)pk, (CoreBillBaseInfo)initBadAccountInfo, "update_log", "fi_ar_badacct_update");
            }
        }
        super.actionSubmit_actionPerformed(e);
        if (logObjectPK != null) {
            this.afterLog(logObjectPK);
        }
    }

    protected void afterSubmitAddNew() {
        this.isSubmitedAddNew = true;
        this.initOldData((IObjectValue)this.editData);
        super.afterSubmitAddNew();
    }

    public boolean isModify() {
        if (this.isSubmitedAddNew) {
            return false;
        }
        return super.isModify();
    }

    private IObjectPK beginLog(IObjectPK pk, CoreBillBaseInfo coreBillBaseInfo, String method, String methodDes) throws BOSException, EASBizException {
        String methodName = this.getStrResource(method);
        String instanceDeatil = coreBillBaseInfo.getNumber();
        return LogUtil.beginLog(null, (String)methodName, (BOSObjectType)coreBillBaseInfo.getBOSType(), (IObjectPK)pk, (String)instanceDeatil, (String)methodDes);
    }

    private void afterLog(IObjectPK pk) {
        LogUtil.afterLog(null, (IObjectPK)pk);
    }
}

