/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.client.util.ApPeriodHelper;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractItemRptQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.BizSysPeriodHelper;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.ItemRptQueryParamConvertor;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class ItemRptQueryUI
extends AbstractItemRptQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemRptQueryUI.class);
    private static final String RES = "com.kingdee.eas.fi.ar.ArReport";
    private BizSysPeriodHelper periodHelper = null;
    private PeriodInfo startPeriod = null;
    private PeriodInfo currentPeriod = null;
    private ItemRptQueryParam filterParam = null;
    private ItemListener chkIsCentralBalanceListener = null;
    private ItemListener chkIncludeBizBillListener = null;

    public ItemRptQueryUI() throws Exception {
    }

    public ItemRptQueryUI(boolean fIsAr) throws Exception {
        if (!fIsAr) {
            this.setAp();
            this.contBizBill.setBoundLabelText(EASResource.getString((String)RES, (String)"Lbl_BizAP"));
            this.comboBizBill.removeAllItems();
            this.comboBizBill.addItems((Object[])new String[]{EASResource.getString((String)RES, (String)"incloud_BizAP"), EASResource.getString((String)RES, (String)"only_BizAP")});
        }
    }

    @Override
    protected void initUICtrls() throws Exception {
        super.initUICtrls();
        this.prmtCompany.setData((Object)this.currentCompany);
        this.chkAllCuAdminPerson.setSelected(true);
        SystemEnum sys = this.getSystemEnum();
        this.startPeriod = this.arApSysParamInfo.getStartPeriod(sys);
        this.currentPeriod = this.arApSysParamInfo.getCurrentPeriod(sys);
        this.pkDateFrom.setMinimumDate(this.startPeriod.getBeginDate());
        this.pkDateTo.setMinimumDate(this.startPeriod.getBeginDate());
        this.pkDateFrom.setValue((Object)this.currentPeriod.getBeginDate());
        this.pkDateTo.setValue((Object)this.currentPeriod.getEndDate());
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgFrom, false, true, false);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgTo, false, true, false);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonFrom);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonTo);
        this.chkAllCuAdminPerson.setSelected(true);
        this.ckBxMShortName.setSelected(false);
        this.ckBxMShortName.setEnabled(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameFrom.setEditable(false);
        this.txtMShortNameTo.setText(null);
        this.txtMShortNameTo.setEditable(false);
        this.chkIncludeBizBill.setSelected(false);
        this.initPeriod();
        this.removeControlListener();
        this.addListen();
        ClientUtils.setCurrencyListCopy((KDComboBox)this.comboCurrency, (boolean)true);
    }

    private void removeControlListener() {
        if (null != this.chkIsCentralBalanceListener) {
            this.bizcheckBox.removeItemListener(this.chkIsCentralBalanceListener);
        }
        if (null != this.chkIncludeBizBillListener) {
            this.chkIncludeBizBill.removeItemListener(this.chkIncludeBizBillListener);
        }
    }

    private void addListen() {
        this.chkIsCentralBalanceListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    ItemRptQueryUI.this.chkIsCentralBalanceChanged(arg0);
                }
                catch (Exception e) {
                    ItemRptQueryUI.this.handUIException(e);
                }
            }
        };
        this.bizcheckBox.addItemListener(this.chkIsCentralBalanceListener);
        this.chkIncludeBizBillListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    ItemRptQueryUI.this.chkIncludeBizBillChanged(arg0);
                }
                catch (Exception e) {
                    ItemRptQueryUI.this.handUIException(e);
                }
            }
        };
        this.chkIncludeBizBill.addItemListener(this.chkIncludeBizBillListener);
        this.comboCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if ("base".equals(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)ItemRptQueryUI.this.comboCurrency.getSelectedItem()), (String)"id"))) {
                        ItemRptQueryUI.this.chkBaseCurrency.setSelected(false);
                        ItemRptQueryUI.this.chkBaseCurrency.setEnabled(false);
                    } else {
                        ItemRptQueryUI.this.chkBaseCurrency.setEnabled(true);
                    }
                }
                catch (DataAccessException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    protected void chkIncludeBizBillChanged(ItemEvent arg0) throws Exception {
        boolean ischeckBox = this.chkIncludeBizBill.isSelected();
        if (ischeckBox) {
            this.contBizBill.setEnabled(true);
        } else {
            this.contBizBill.setEnabled(false);
        }
    }

    protected void chkIsCentralBalanceChanged(ItemEvent arg0) throws Exception {
        boolean ischeckBox = this.bizcheckBox.isSelected();
        if (ischeckBox) {
            this.contPaymentType.setEnabled(true);
        } else {
            this.contPaymentType.setEnabled(false);
        }
    }

    private void initPeriod() {
        this.periodHelper = this.isArRpt() ? ArPeriodHelper.getInstance(false) : ApPeriodHelper.getInstance(false);
        try {
            this.periodHelper.initPeriodSpinner(this.currentCompany, this.spYearFrom, this.spNumFrom, this.spYearTo, this.spNumberTo, this.arApSysParamInfo);
        }
        catch (EASBizException e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"periodFail"));
            SysUtil.abort();
        }
        catch (BOSException e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"periodFail"));
            SysUtil.abort();
        }
    }

    @Override
    protected void rdBtnPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.setAccordingPeriod(true);
    }

    @Override
    protected void rdBtnDate_stateChanged(ChangeEvent e) throws Exception {
        this.setAccordingPeriod(false);
    }

    private void setAccordingPeriod(boolean fPeriod) {
        this.panelPeriod.setVisible(fPeriod);
        this.panelDate.setVisible(!fPeriod);
    }

    @Override
    protected void spYearFrom_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spYearFrom, this.spNumFrom, this.spYearTo, this.spNumberTo, false);
        this.periodHelper.setPeriodNum(this.currentCompany, this.spNumFrom, this.spYearFrom);
    }

    @Override
    protected void spYearTo_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spYearFrom, this.spNumFrom, this.spYearTo, this.spNumberTo, false);
        this.periodHelper.setPeriodNum(this.currentCompany, this.spNumberTo, this.spYearTo);
    }

    @Override
    protected void spNumFrom_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spYearFrom, this.spNumFrom, this.spYearTo, this.spNumberTo, true);
    }

    @Override
    protected void spNumberTo_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spYearFrom, this.spNumFrom, this.spYearTo, this.spNumberTo, true);
    }

    private void setSumOption(ItemEvent e) {
        KDCheckBox chkSumOpt = (KDCheckBox)e.getSource();
        if (!chkSumOpt.isSelected()) {
            return;
        }
        if ("chkSumAdminOrg".equals(chkSumOpt.getName())) {
            if (this.chkSumPerson.isSelected()) {
                this.chkSumPerson.setSelected(false);
            }
        } else if (this.chkSumAdminOrg.isSelected()) {
            this.chkSumAdminOrg.setSelected(false);
        }
    }

    @Override
    protected void chkSumAdminOrg_itemStateChanged(ItemEvent e) throws Exception {
        this.setSumOption(e);
    }

    @Override
    protected void chkSumPerson_itemStateChanged(ItemEvent e) throws Exception {
        this.setSumOption(e);
    }

    public void loadData(EntityViewInfo view) {
        this.setParamToUI(this.filterParam);
    }

    public void setCustomerParams(CustomerParams cp) {
        this.filterParam = new ItemRptQueryParam();
        ItemRptQueryParamConvertor convertor = new ItemRptQueryParamConvertor();
        convertor.setRptParam((IReportQueryParam)this.filterParam);
        try {
            convertor.read(null, cp);
        }
        catch (Exception e) {
            logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
        }
    }

    @Override
    public IReportQueryParam getRptParam() {
        ItemRptQueryParam param = new ItemRptQueryParam();
        param.setCompanyId(this.currentCompany.getId().toString());
        param.setCuId(this.currentCompany.getCU().getId().toString());
        param.setIsArRpt(this.isArRpt());
        param.setCkBxMShortName(this.ckBxMShortName.isSelected());
        param.setTxtMShortNameFrom(this.txtMShortNameFrom.getText().trim().replaceAll("'", "''"));
        param.setTxtMShortNameTo(this.txtMShortNameTo.getText().trim().replaceAll("'", "''"));
        param.setByPeriod(this.rdBtnPeriod.isSelected());
        if (this.rdBtnPeriod.isSelected()) {
            int periodYearFrom = (Integer)this.spYearFrom.getValue();
            int periodYearTo = (Integer)this.spYearTo.getValue();
            int periodNumFrom = (Integer)this.spNumFrom.getValue();
            int periodNumTo = (Integer)this.spNumberTo.getValue();
            param.setStartPeriodYear(periodYearFrom);
            param.setStartPeriodNum(periodNumFrom);
            param.setEndPeriodYear(periodYearTo);
            param.setEndPeriodNum(periodNumTo);
            try {
                PeriodInfo periodFrom = this.periodHelper.getPeriodInfo(periodYearFrom, periodNumFrom, this.currentCompany);
                PeriodInfo periodTo = this.periodHelper.getPeriodInfo(periodYearTo, periodNumTo, this.currentCompany);
                param.setBeginDate(periodFrom.getBeginDate());
                param.setEndDate((java.util.Date)periodTo.getEndDate());
            }
            catch (Exception e) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"periodFail"));
                SysUtil.abort();
            }
        } else {
            java.util.Date date = (java.util.Date)this.pkDateFrom.getValue();
            Date beginDate = new Date(DateTimeUtils.truncateDate((java.util.Date)date).getTime());
            date = (java.util.Date)this.pkDateTo.getValue();
            Date endDate = new Date(DateTimeUtils.truncateDate((java.util.Date)date).getTime());
            param.setBeginDate(beginDate);
            param.setEndDate(endDate);
        }
        this.setCurrCussAcct2RptParam((ArApQueryParam)param);
        DataBaseInfo bizObjInfo = null;
        if (this.prmtAdminOrgFrom.getValue() != null) {
            bizObjInfo = (DataBaseInfo)this.prmtAdminOrgFrom.getValue();
            param.setAdminOrgFromId(bizObjInfo.getString("id"));
            param.setAdminOrgFromName(bizObjInfo.getName());
            param.setAdminOrgFromNum(bizObjInfo.getNumber());
        }
        if (this.prmtAdminOrgTo.getValue() != null) {
            bizObjInfo = (DataBaseInfo)this.prmtAdminOrgTo.getValue();
            param.setAdminOrgToId(bizObjInfo.getString("id"));
            param.setAdminOrgToName(bizObjInfo.getName());
            param.setAdminOrgToNum(bizObjInfo.getNumber());
        }
        if (this.prmtPersonFrom.getValue() != null) {
            bizObjInfo = (DataBaseInfo)this.prmtPersonFrom.getValue();
            param.setPersonFromId(bizObjInfo.getString("id"));
            param.setPersonFromName(bizObjInfo.getName());
            param.setPersonFromNum(bizObjInfo.getNumber());
        }
        if (this.prmtPersonTo.getValue() != null) {
            bizObjInfo = (DataBaseInfo)this.prmtPersonTo.getValue();
            param.setPersonToId(bizObjInfo.getString("id"));
            param.setPersonToName(bizObjInfo.getName());
            param.setPersonToNum(bizObjInfo.getNumber());
        }
        param.setIsBalZero(this.chkBalZero.isSelected());
        param.setIsBizZero(this.chkBizZero.isSelected());
        param.setIsSumByDept(this.chkSumAdminOrg.isSelected());
        param.setIsSumByPerson(this.chkSumPerson.isSelected());
        param.setIsAllCuAdminPerson(this.chkAllCuAdminPerson.isSelected());
        param.setShowMaterialItem(this.chkMaterialItem.isSelected());
        param.setIncludeBizBill(this.chkIncludeBizBill.isSelected());
        param.setIncludeBizIndex(this.comboBizBill.getSelectedIndex());
        param.setBizeIndex(this.comboPaymentType.getSelectedIndex());
        param.setBizeCheckBox(this.bizcheckBox.isSelected());
        param.setBaseCurrency(this.chkBaseCurrency.isSelected());
        return param;
    }

    private void setParamToUI(ItemRptQueryParam param) {
        AdminOrgUnitInfo info;
        if (param == null) {
            return;
        }
        this.clear();
        this.rdBtnPeriod.setSelected(param.isByPeriod());
        this.rdBtnDate.setSelected(!param.isByPeriod());
        this.ckBxMShortName.setSelected(param.isCkBxMShortName());
        String shortNameFrom = param.getTxtMShortNameFrom();
        if (shortNameFrom != null) {
            this.txtMShortNameFrom.setText(shortNameFrom.replaceAll("''", "'"));
        } else {
            this.txtMShortNameFrom.setText("");
        }
        String shortNameTo = param.getTxtMShortNameTo();
        if (shortNameTo != null) {
            this.txtMShortNameTo.setText(shortNameTo.replaceAll("''", "'"));
        } else {
            this.txtMShortNameTo.setText("");
        }
        if (param.isByPeriod()) {
            Integer oInt = new Integer(param.getStartPeriodYear());
            this.spYearFrom.setValue((Object)oInt);
            oInt = new Integer(param.getStartPeriodNum());
            this.spNumFrom.setValue((Object)oInt);
            oInt = new Integer(param.getEndPeriodYear());
            this.spYearTo.setValue((Object)oInt);
            oInt = new Integer(param.getEndPeriodNum());
            this.spNumberTo.setValue((Object)oInt);
        } else {
            this.pkDateFrom.setValue((Object)param.getBeginDate());
            this.pkDateTo.setValue((Object)param.getEndDate());
        }
        this.loadCurrCussAcctData((ArApQueryParam)param);
        if (param.getAdminOrgFromId() != null) {
            info = new AdminOrgUnitInfo();
            info.put("id", (Object)param.getAdminOrgFromId());
            info.setNumber(param.getAdminOrgFromNum());
            info.setName(param.getAdminOrgFromName());
            this.prmtAdminOrgFrom.setValue((Object)info);
        }
        if (param.getAdminOrgToId() != null) {
            info = new AdminOrgUnitInfo();
            info.put("id", (Object)param.getAdminOrgToId());
            info.setNumber(param.getAdminOrgToNum());
            info.setName(param.getAdminOrgToName());
            this.prmtAdminOrgTo.setValue((Object)info);
        }
        if (param.getPersonFromId() != null) {
            info = new PersonInfo();
            info.put("id", (Object)param.getPersonFromId());
            info.setNumber(param.getPersonFromNum());
            info.setName(param.getPersonFromName());
            this.prmtPersonFrom.setValue((Object)info);
        }
        if (param.getPersonToId() != null) {
            info = new PersonInfo();
            info.put("id", (Object)param.getPersonToId());
            info.setNumber(param.getPersonToNum());
            info.setName(param.getPersonToName());
            this.prmtPersonTo.setValue((Object)info);
        }
        this.chkBizZero.setSelected(param.isBizZero());
        this.chkBalZero.setSelected(param.isBalZero());
        this.chkSumAdminOrg.setSelected(param.isSumByDept());
        this.chkSumPerson.setSelected(param.isSumByPerson());
        this.chkAllCuAdminPerson.setSelected(param.isAllCuAdminPerson());
        this.chkMaterialItem.setSelected(param.isShowMaterialItem());
        this.chkIncludeBizBill.setSelected(param.isIncludeBizBill());
        this.comboBizBill.setSelectedIndex(param.getIncludeBizIndex());
        if (this.chkIncludeBizBill.isSelected()) {
            this.contBizBill.setEnabled(true);
        } else {
            this.contBizBill.setEnabled(false);
        }
        this.chkBaseCurrency.setSelected(param.isBaseCurrency());
    }

    public boolean verify() {
        boolean fValid;
        if (this.prmtCompany.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"companyFail"));
            return false;
        }
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        if (typeInfo == null || StringUtils.isEmpty((String)typeInfo.getRealtionDataObject()) || StringUtils.isEmpty((String)typeInfo.getDefaultQueryName())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"asstActTypeFail"));
            return false;
        }
        if (this.rdBtnDate.isSelected() && !(fValid = ArApQueryUIUtil.validDateRange((CoreUIObject)this, this.pkDateFrom, this.pkDateTo))) {
            return false;
        }
        if (this.comboCurrency.getItemCount() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"currencyFail"));
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.chkBaseCurrency.setSelected(false);
        this.rdBtnPeriod.setSelected(true);
        this.rdBtnDate.setSelected(false);
        this.prmtAdminOrgFrom.setData(null);
        this.prmtAdminOrgTo.setData(null);
        this.prmtPersonFrom.setData(null);
        this.prmtPersonTo.setData(null);
        this.chkBizZero.setSelected(false);
        this.chkBalZero.setSelected(false);
        this.chkSumAdminOrg.setSelected(false);
        this.chkSumPerson.setSelected(false);
        this.chkMaterialItem.setSelected(false);
        this.chkAllCuAdminPerson.setSelected(true);
        this.chkIncludeBizBill.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.ckBxMShortName.setSelected(false);
        Integer currYear = new Integer(this.currentPeriod.getPeriodYear());
        Integer currNum = new Integer(this.currentPeriod.getPeriodNumber());
        this.spYearFrom.setValue((Object)currYear);
        this.spYearTo.setValue((Object)currYear);
        this.spNumFrom.setValue((Object)currNum);
        this.spNumberTo.setValue((Object)currNum);
        this.pkDateFrom.setValue((Object)this.currentPeriod.getBeginDate());
        this.pkDateTo.setValue((Object)this.currentPeriod.getEndDate());
    }

    @Override
    protected void ckBxMShortName_stateChanged(ChangeEvent e) throws Exception {
        if (this.ckBxMShortName.isSelected() && this.chkMaterialItem.isSelected()) {
            this.txtMShortNameFrom.setEditable(true);
            this.txtMShortNameTo.setEditable(true);
        } else {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameFrom.setEditable(false);
            this.txtMShortNameTo.setEditable(false);
        }
    }

    @Override
    protected void chkMaterialItem_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkMaterialItem.isSelected()) {
            this.ckBxMShortName.setEnabled(true);
        } else {
            this.ckBxMShortName.setEnabled(false);
            this.ckBxMShortName.setSelected(false);
        }
        this.ckBxMShortName_stateChanged(e);
    }
}

