/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ar.client.AbstractReceiveForBadQueryUI;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.util.SysUtil;
import java.math.BigDecimal;

public class ReceiveForBadQueryUI
extends AbstractReceiveForBadQueryUI {
    private CompanyOrgUnitInfo currentCompany = null;

    public ReceiveForBadQueryUI() throws Exception {
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
        }
        catch (Exception ex) {
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDBizPrCompany.setData((Object)this.currentCompany);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.kDBizPrCompany.getData() != null) {
            String companyId = ((CompanyOrgUnitInfo)this.kDBizPrCompany.getData()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", null, CompareType.EQUALS));
            filter.setMaskString(" #0 or #1");
            viewInfo.setFilter(filter);
        }
        this.bizPromptReceiveNoFrom.setEntityViewInfo(viewInfo);
        this.bizPromptReceiveNoTo.setEntityViewInfo(viewInfo);
        this.bizPromptReceiveNoFrom.setVisible(true);
        this.bizPromptReceiveNoFrom.setEditFormat("$number$");
        this.bizPromptReceiveNoFrom.setDisplayFormat("$number$");
        this.bizPromptReceiveNoFrom.setCommitFormat("$number$");
        this.bizPromptReceiveNoFrom.setQueryInfo("com.kingdee.eas.fi.ar.app.ReceivingBillQuery");
        this.bizPromptReceiveNoTo.setVisible(true);
        this.bizPromptReceiveNoTo.setEditFormat("$number$");
        this.bizPromptReceiveNoTo.setDisplayFormat("$number$");
        this.bizPromptReceiveNoTo.setCommitFormat("$number$");
        this.bizPromptReceiveNoTo.setQueryInfo("com.kingdee.eas.fi.ar.app.ReceivingBillQuery");
    }

    public FilterInfo getFilterInfo() {
        String strNumber;
        if (this.kDBizPrCompany.getData() != null) {
            String companyId = this.currentCompany.getId().toString();
            FilterItemInfo companyFilter = new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(companyFilter);
        }
        if (this.dateBillFrom.getTimestamp() != null) {
            FilterItemInfo fromBillDateFilter = new FilterItemInfo("billDate", (Object)BaseDataUtil.downTimestamp(this.dateBillFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromBillDateFilter);
        }
        if (this.dateBillTo.getTimestamp() != null) {
            FilterItemInfo toBillDateFilter = new FilterItemInfo("billDate", (Object)BaseDataUtil.downTimestamp(this.dateBillTo.getTimestamp()), CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(toBillDateFilter);
        }
        if (this.bizPromptReceiveNoFrom.getData() != null) {
            strNumber = this.bizPromptReceiveNoFrom.getText();
            FilterItemInfo fromNumberFilter = new FilterItemInfo("number", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.bizPromptReceiveNoTo.getData() != null) {
            strNumber = this.bizPromptReceiveNoTo.getText();
            FilterItemInfo toNumberFilter = new FilterItemInfo("number", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(toNumberFilter);
        }
        FilterItemInfo unVerificateAmtFilter = new FilterItemInfo("entrys.unVerificateAmt", (Object)new BigDecimal("0.0"), CompareType.NOTEQUALS);
        this.filterInfo.getFilterItems().add(unVerificateAmtFilter);
        StringBuffer sbFormula = new StringBuffer();
        if (this.filterInfo.getFilterItems() != null && this.filterInfo.getFilterItems().size() > 0) {
            sbFormula.append("(").append(" ").append("#").append(0).append(" ").append(")").append(" ");
            int size = this.filterInfo.getFilterItems().size();
            for (int i = 1; i < size; ++i) {
                sbFormula.append("and").append(" ").append("(").append(" ").append("#").append(i).append(" ").append(")").append(" ");
            }
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        String propName = "";
        Object compVal = null;
        CompareType comp = null;
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            propName = currentFilterItemCollection.get(i).getPropertyName();
            compVal = currentFilterItemCollection.get(i).getCompareValue();
            comp = currentFilterItemCollection.get(i).getCompareType();
            if ("company.id".equalsIgnoreCase(propName)) {
                this.kDBizPrCompany.setData((Object)this.currentCompany);
                continue;
            }
            if ("billDate".equalsIgnoreCase(propName) && comp.equals((Object)CompareType.GREATER_EQUALS)) {
                this.dateBillFrom.setValue(compVal);
                continue;
            }
            if ("billDate".equalsIgnoreCase(propName) && comp.equals((Object)CompareType.LESS_EQUALS)) {
                this.dateBillTo.setValue(compVal);
                continue;
            }
            if ("number".equalsIgnoreCase(propName) && comp.equals((Object)CompareType.GREATER_EQUALS)) {
                this.bizPromptReceiveNoFrom.setValue(compVal);
                continue;
            }
            if (!"number".equalsIgnoreCase(propName) || !comp.equals((Object)CompareType.LESS_EQUALS)) continue;
            this.bizPromptReceiveNoTo.setValue(compVal);
        }
    }

    public void clear() {
        this.kDBizPrCompany.setData((Object)this.currentCompany);
        this.bizPromptReceiveNoFrom.setValue(null);
        this.bizPromptReceiveNoTo.setValue(null);
        this.dateBillFrom.setValue(null);
        this.dateBillTo.setValue(null);
    }
}

