/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.IReportFacade;
import com.kingdee.eas.fi.ar.IReportHead;
import com.kingdee.eas.fi.ar.IReportHeadCell;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.ReportFacadeFactory;
import com.kingdee.eas.fi.ar.ReportInfo;
import com.kingdee.eas.fi.ar.client.AbstractReportUI;
import com.kingdee.eas.fi.ar.client.PrintExtVarProvider;
import com.kingdee.eas.fi.ar.client.RptBaseQueryUI;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.arap.util.paramconvertor.IRptParamConvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.RptParamConvertorFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.report.client.ProgressBarDialogAdapter;
import com.kingdee.eas.framework.report.client.ProgressBarRptDialog;
import com.kingdee.eas.framework.report.util.WindowMessage;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class ReportUI
extends AbstractReportUI
implements KDTDataRequestListener {
    private static final long serialVersionUID = 6032619660714088769L;
    private static final Logger logger = CoreUIObject.getLogger(ReportUI.class);
    protected CommonQueryDialog dialog = null;
    protected ArApQueryParam filterParam = null;
    protected CurrencyCollection currencyColls = null;
    protected int curIndex = -1;
    public static MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.fi.ar.app", "ReportQuery");
    protected boolean bLoaded = false;
    private ExtVarProvider printVarProvider = null;
    protected CompanyOrgUnitInfo companyInfo = null;
    protected CurrencyInfo baseCurrency = null;
    protected IReportFacade iRptFacade = ReportFacadeFactory.getRemoteInstance();
    protected ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
    protected IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
    private boolean isLoading = false;
    private static ProgressBarRptDialog progressDialog = ProgressBarRptDialog.getDialogInstance(null);
    private boolean isReportTree = false;
    protected boolean isFirstLoad = true;
    protected HashMap uiParam = this.getUIParam();
    protected int currRow = -1;
    protected int currCol = -1;

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected Object getLastEntityViewInfo() {
        return this.filterParam;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    public Object getTablePreferenceSchemaKey() {
        String tbPk = null;
        if (this.filterParam != null) {
            tbPk = this.filterParam.getRptPreferenceSchemaKey();
        }
        return tbPk;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.menuItemView.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnChart.setIcon(EASResource.getIcon((String)"imgTbtn_planchart"));
        this.menuItemChart.setIcon(EASResource.getIcon((String)"imgTbtn_planchart"));
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPreview);
        this.setButtonDefaultStyl(this.btnChart);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("baseCurrency.*");
        CompanyOrgUnitInfo tempCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.companyInfo.getId()), sic);
        this.baseCurrency = tempCompany.getBaseCurrency();
        if (!this.getUIContext().containsKey("operator") && this.isRunBack()) {
            this.close();
        }
        this.initUI();
        if (this.isLinkQuery()) {
            this.execLinkQuery();
        } else {
            this.checkBeforeLoad();
            this.actionQuery_actionPerformed(null);
        }
        this.bLoaded = true;
        this.setCurrPeriod2Status();
    }

    protected PeriodInfo getCurrentPeriod() {
        return null;
    }

    protected void setCurrPeriod2Status() throws Exception {
        if (this.companyInfo == null) {
            return;
        }
        PeriodInfo currPeriod = this.getCurrentPeriod();
        if (currPeriod == null) {
            currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)this.getSystemEnumForOA(), (CompanyOrgUnitInfo)this.companyInfo);
        }
        if (currPeriod != null) {
            String msg = EASResource.getString((String)this.getResource(), (String)"StatusCurrPeriod");
            msg = MessageFormat.format(msg, String.valueOf(currPeriod.getPeriodYear()), String.valueOf(currPeriod.getPeriodNumber()));
            this.getMainStatusBar().setPerTitle(msg);
        }
    }

    private boolean isLinkQuery() {
        Map uiCtx = this.getUIContext();
        Object linkParam = uiCtx.get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS");
        if (linkParam != null) {
            this.filterParam = (ArApQueryParam)linkParam;
            return true;
        }
        if (uiCtx.get("RPTFilter") != null) {
            this.filterParam = (ArApQueryParam)uiCtx.get("RPTFilter");
            return true;
        }
        if (uiCtx.get("conGlParam") != null) {
            this.filterParam = (ArApQueryParam)uiCtx.get("conGlParam");
            return true;
        }
        return false;
    }

    private void execLinkQuery() throws BOSException, EASBizException {
        if (this.filterParam.isAllCurrency()) {
            this.currencyColls = this.iCurrency.getCurrencyCollection(true);
        } else {
            this.setParamCurrencyInfo(this.filterParam);
        }
        this.actionQuery.setVisible(false);
        this.setReportHead(this.filterParam.getReportHead());
        this.prepareParamForQuery(this.filterParam);
        ActionEvent getEvt = new ActionEvent(this.btnRefresh, 1001, this.btnRefresh.getActionCommand());
        this.actionRefresh.actionPerformed(getEvt);
        if (this.actionRefresh.isInvokeFailed()) {
            SysUtil.abort();
        }
    }

    protected void disposeUIWindow() {
        try {
            this.releaseTempTable();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        super.disposeUIWindow();
    }

    protected void releaseTempTable() throws BOSException {
        if (this.filterParam == null) {
            return;
        }
        if (this.filterParam.getTempTable() != null && this.getUIContext().get("conGlParam") == null) {
            this.iRptFacade.releaseTempTable(this.filterParam.getTempTable());
            this.filterParam.setTempTable(null);
        }
        if (this.filterParam.getCussAcctTempTable() != null) {
            this.iRptFacade.releaseTempTable(this.filterParam.getCussAcctTempTable());
            this.filterParam.setCussAcctTempTable(null);
        }
        if (this.filterParam.getOtherTempTables() != null && this.filterParam.getOtherTempTables().size() != 0) {
            for (int i = 0; i < this.filterParam.getOtherTempTables().size(); ++i) {
                this.iRptFacade.releaseTempTable((String)this.filterParam.getOtherTempTables().get(i));
            }
            this.filterParam.setOtherTempTables(null);
        }
        this.filterParam.setTotalRowCount(0);
    }

    protected void checkBeforeLoad() throws Exception {
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.companyInfo);
        SystemStatusCtrolInfo cachedSysStatus = ArApBillHelper.getSysStatusCtrolInfo(null, this.companyInfo, this.getSystemEnumForOA());
        if (cachedSysStatus == null || cachedSysStatus.getStartPeriod() == null || cachedSysStatus.getCurrentPeriod() == null) {
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.companyInfo.getName() + this.getSystemEnumForOA().getAlias()});
        }
        if (!SystemStatusCtrolUtils.isStart(null, (SystemEnum)this.getSystemEnumForOA(), (CompanyOrgUnitInfo)this.companyInfo)) {
            logger.error((Object)("the " + this.getSystemEnumForOA() + " system has not been initialized!"));
            throw new OtherBillBizException(OtherBillBizException.COMPANYSNOTSTARTED, new Object[]{this.getSystemEnumForOA().getAlias(), this.companyInfo.getName()});
        }
    }

    protected void initUI() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        KDTableHelper.releaseEnterAndTab((JComponent)this.tblMain);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.enableExportExcel(this.tblMain);
        this.actionView.setVisible(false);
        this.actionChart.setVisible(false);
        this.actionFormulPrint.setVisible(false);
        this.actionFormulPrintPreview.setVisible(false);
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        if (this.isAsynchronism() && !this.isReportTree() && e.getFirstRow() == 0) {
            final MonitorInfo info = new MonitorInfo(this.getUITitle(), null, (Object)this, false);
            final KDTDataRequestEvent ee = e;
            progressDialog = ProgressBarRptDialog.getDialogInstance((Object)((Object)this));
            final SwingWorker worker = new SwingWorker(){
                private boolean stop = false;

                public Object construct() {
                    while (ReportUI.this.isLoading) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return null;
                }

                public void finished() {
                    if (!this.stop) {
                        String title = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"has_finished"), ReportUI.this.getUITitle());
                        new WindowMessage("250", "150", ReportUI.getResourceString("runinbackground"), title, info);
                        ThreadPool.destroyMonitor((MonitorInfo)info);
                        info.setTitle(title);
                        ThreadPool.addActionThread((MonitorInfo)info);
                    }
                }

                public void finishedLater() {
                    ThreadPool.destroyMonitor((MonitorInfo)info);
                    if (ReportUI.this.isLoading) {
                        this.stop = true;
                        IMainUIObject mainUI = ReportUI.this.getMainUIObject();
                        IUIObject[] uiObjects = mainUI.getUiManager().findUIObject(ReportUI.this.getUIFullName());
                        if (uiObjects != null && uiObjects.length > 0) {
                            mainUI.getUiManager().closeTab(uiObjects[0]);
                        }
                        ReportUI.this.close();
                    }
                    if (progressDialog != null && progressDialog.isShowing()) {
                        progressDialog.dispose();
                    }
                    try {
                        ReportUI.this.addTabOnMainUI((IUIObject)info.getUi());
                        ReportUI.this.onShow();
                    }
                    catch (Exception e) {
                        ReportUI.this.handUIException(e);
                    }
                }
            };
            SwingWorker dataWorker = new SwingWorker(){

                public Object construct() {
                    ReportUI.this.getPartDataAndLoadIt(ee);
                    ReportUI.this.isLoading = false;
                    ReportUI.this.isFirstLoad = false;
                    return null;
                }

                public void finished() {
                    if (progressDialog != null && progressDialog.isShowing()) {
                        progressDialog.dispose();
                    }
                }
            };
            dataWorker.start();
            if (e.getFirstRow() == 0) {
                SwingWorker processBarWorker = new SwingWorker(){

                    public Object construct() {
                        if (progressDialog != null) {
                            progressDialog.setTitle(ReportUI.this.getUITitle());
                            if (ProgressBarDialogAdapter.show((ProgressBarRptDialog)progressDialog)) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    ReportUI.this.handleException(e);
                                }
                                ReportUI.this.removeTabOnMainUI((IUIObject)info.getUi());
                                info.setWorker(worker);
                                ThreadPool.addActionThread((MonitorInfo)info);
                            }
                        }
                        return null;
                    }
                };
                processBarWorker.start();
            }
        } else {
            this.isLoading = true;
            this.getPartDataAndLoadIt(e);
            this.isLoading = false;
        }
    }

    protected void close() {
        SysUtil.abort();
    }

    protected boolean isQueryChangeTable() {
        return false;
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getPrintManager().pageSetup();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (this.isAsynchronism() && this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.isFirstLoad = true;
        this.saveCurrentLocation();
        this.releaseTempTable();
        this.tblMain.removeRows();
        this.restoreCurrentLocation();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        ArApReportUIUtil.checkCompanysPrintPermission(this, this.getQueryCompanys(), this.getPrintPermItem(), this.getMainBizOrgType());
        this.printTbl(false);
    }

    protected String getPrintPermItem() {
        return null;
    }

    protected List getQueryCompanys() {
        return null;
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        ArApReportUIUtil.checkCompanysPrintPermission(this, this.getQueryCompanys(), this.getPrintPermItem(), this.getMainBizOrgType());
        this.printTbl(true);
    }

    protected void printTbl(boolean preview) throws Exception {
        if (this.tblMain == null) {
            return;
        }
        String logMsg = ArApReportUIUtil.getPrintLogMsg(this.getUITitle(), preview);
        IObjectPK pkOut = LogUtil.beginLog(null, (String)logMsg, (BOSObjectType)this.iRptFacade.getType(), null, (String)logMsg);
        this.preparePrintPage(this.tblMain);
        if (preview) {
            this.tblMain.getPrintManager().printPreview();
        } else {
            this.tblMain.getPrintManager().print();
        }
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    protected Map preparePrintVariantMap() {
        return null;
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        if (this.printVarProvider == null) {
            this.printVarProvider = new PrintExtVarProvider();
        }
        ((PrintExtVarProvider)this.printVarProvider).setExtVarMap(this.preparePrintVariantMap());
        return this.printVarProvider;
    }

    @Override
    public void actionFormulPrint_actionPerformed(ActionEvent e) throws Exception {
        this.printRpt(true);
    }

    @Override
    public void actionFormulPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.printRpt(false);
    }

    protected void printRpt(boolean fPrint) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        BOSQueryDelegate printProvider = this.getPrintProvider();
        String printTemplatePath = this.getPrintTemplatePath();
        if (printProvider == null || StringUtils.isEmpty((String)printTemplatePath)) {
            return;
        }
        String logMsg = ArApReportUIUtil.getPrintLogMsg(this.getUITitle(), !fPrint);
        IObjectPK pkOut = LogUtil.beginLog(null, (String)logMsg, (BOSObjectType)this.iRptFacade.getType(), null, (String)logMsg);
        KDNoteHelper appHlp = new KDNoteHelper();
        if (fPrint) {
            appHlp.print(printTemplatePath, (Object)printProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(printTemplatePath, (Object)printProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    @Override
    public void actionChart_actionPerformed(ActionEvent e) throws Exception {
        List charts = this.getChart();
        if (charts == null || charts.size() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"chartDatas", (Object)charts);
        String chartUICls = "com.kingdee.eas.framework.report.client.CommRptChartUI";
        IUIWindow chartUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(chartUICls, (Map)uiContext, null, OprtState.VIEW);
        chartUI.show();
    }

    protected ArApQueryParam getDefaultQueryParam() throws Exception {
        String queryName = queryPK.getFullName();
        String clsName = this.getMetaDataPK().getFullName();
        QuerySolutionInfo solution = this.iQuery.getDefaultSolution(clsName, queryName);
        if (solution == null || solution.getQueryPanelInfo() == null || solution.getQueryPanelInfo().size() <= 0) {
            return null;
        }
        String custParamStr = solution.getQueryPanelInfo().get(0).getCustomerParams();
        if (StringUtils.isEmpty((String)custParamStr)) {
            return null;
        }
        CustomerParams custParam = XMLBean.TransStrToCustParams((String)custParamStr);
        String paramCls = custParam.getCustomerParam("class");
        if (StringUtils.isEmpty((String)paramCls)) {
            return null;
        }
        ArApQueryParam param = (ArApQueryParam)Class.forName(paramCls).newInstance();
        IRptParamConvertor convertor = RptParamConvertorFactory.getConvertor((IReportQueryParam)param);
        convertor.read(null, custParam);
        this.setParamCurrencyInfo(param);
        return param;
    }

    private void setParamCurrencyInfo(ArApQueryParam param) throws BOSException, EASBizException {
        if (!param.isAllCurrency() && param.getCurrencyInfo() == null) {
            String currencyId = param.getCurrencyId();
            CurrencyInfo currencyInfo = (CurrencyInfo)this.iCurrency.getObjectBaseInfo("select id, name, number, precision where id = '" + currencyId + "'");
            param.setCurrencyInfo(currencyInfo);
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.curIndex = 0;
        if (!this.bLoaded) {
            this.filterParam = this.getDefaultQueryParam();
            if (this.filterParam == null) {
                if (!this.getQueryDialog().show()) {
                    SysUtil.abort();
                }
                this.filterParam = (ArApQueryParam)this.getQueryPanel().getRptParam();
            }
        } else {
            if (!this.getQueryDialog().show()) {
                SysUtil.abort();
            }
            this.filterParam = (ArApQueryParam)this.getQueryPanel().getRptParam();
        }
        if (this.filterParam == null) {
            logger.warn((Object)"the query param is null");
            SysUtil.abort();
        }
        this.prepareGetReport(null).callHandler();
        if (!this.bLoaded || this.isQueryChangeTable()) {
            this.setReportHead(this.filterParam.getReportHead());
        }
        if (this.filterParam.isAllCurrency() && this.currencyColls == null) {
            this.currencyColls = this.iCurrency.getCurrencyCollection(true);
        }
        this.prepareParamForQuery(this.filterParam);
        ActionEvent getEvt = new ActionEvent(this.btnRefresh, 1001, this.btnRefresh.getActionCommand());
        this.actionRefresh.actionPerformed(getEvt);
    }

    protected void prepareParamForQuery(ArApQueryParam filterParam) {
    }

    protected CommonQueryDialog getQueryDialog() throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setShowFilter(false);
            this.dialog.setShowSorter(false);
            this.dialog.setMaxReturnCountVisible(false);
            this.dialog.setQueryObjectPK((IMetaDataPK)queryPK);
            this.dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            this.dialog.addUserPanel((KDPanel)this.getQueryPanel());
            this.dialog.setUiObject((IUIObject)this);
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        }
        return this.dialog;
    }

    protected RptBaseQueryUI getQueryPanel() throws Exception {
        return null;
    }

    protected final void setReportHead(IReportHead tblHead) {
        int i;
        if (tblHead == null || tblHead.getCellSize() == 0) {
            logger.error((Object)" the head info is invalid.");
            return;
        }
        this.tblMain.removeColumns();
        int n = tblHead.getRows();
        for (int i2 = 0; i2 < n; ++i2) {
            this.tblMain.addHeadRow();
        }
        IReportHeadCell headCell = null;
        IRow row = null;
        IColumn col = null;
        String key = null;
        int n2 = tblHead.getCellSize();
        for (i = 0; i < n2; ++i) {
            headCell = tblHead.getCell(i);
            row = this.tblMain.getHeadRow(headCell.getRow());
            col = this.tblMain.getColumn(headCell.getCol());
            if (col == null) {
                col = this.tblMain.addColumn(headCell.getCol());
            }
            key = headCell.getKey();
            col.setKey(key);
            col.setWidth(headCell.getWidth());
            if (key != null && key.toUpperCase().indexOf("DATE") > 0) {
                String formatString = CtrlFormatUtilities.getDateFormatString();
                col.getStyleAttributes().setNumberFormat(formatString);
            } else {
                col.getStyleAttributes().setNumberFormat(headCell.getDisplayFormat());
            }
            col.getStyleAttributes().setHorizontalAlign(headCell.getHAlign());
            String title = this.getColTitle(key);
            title = title == null ? key : title;
            row.getCell(headCell.getCol()).setValue((Object)title);
        }
        this.tblMain.getGroupManager().setGroup(true);
        n2 = tblHead.getCellSize();
        for (i = 0; i < n2; ++i) {
            headCell = tblHead.getCell(i);
            key = headCell.getKey();
            if (headCell.isHide()) {
                this.tblMain.getColumn(key).getStyleAttributes().setHided(true);
                this.tblMain.getColumn(key).setWidth(-1);
            }
            if (headCell.isMergeable()) {
                this.tblMain.getColumn(key).setGroup(true);
                this.tblMain.getColumn(key).setMergeable(true);
            }
            this.mergeBlock(headCell);
        }
        this.customizeReportHead();
        if (this.isQueryChangeTable() && this.bLoaded) {
            this.tHelper.init();
        }
    }

    protected void mergeBlock(IReportHeadCell headCell) {
        if (headCell.getSpan() <= 0) {
            return;
        }
        if (headCell.getSpan() == 1) {
            this.tblMain.getHeadMergeManager().mergeBlock(headCell.getRow(), headCell.getCol(), 1, headCell.getCol());
        } else {
            this.tblMain.getHeadMergeManager().mergeBlock(headCell.getRow(), headCell.getCol(), headCell.getRow(), headCell.getCol() + headCell.getSpan() - 1);
        }
    }

    protected String getColTitle(String key) {
        return EASResource.getString((String)this.getResource(), (String)("Lbl_" + key));
    }

    protected void customizeReportHead() {
    }

    protected String getResource() {
        return "com.kingdee.eas.fi.ar.client.ArResource";
    }

    protected final void getPartDataAndLoadIt(KDTDataRequestEvent e) {
        if (this.filterParam == null) {
            return;
        }
        int start = e.getFirstRow() + 1;
        int end = e.getLastRow() + 1;
        this.filterParam.setStartIndex(start);
        this.filterParam.setEndIndex(end);
        try {
            logger.debug((Object)("refresh " + e));
            long timeBegin = System.currentTimeMillis();
            this.loadData(this.getReport(), e.getFirstRow());
            logger.debug((Object)("time expense::" + (System.currentTimeMillis() - timeBegin)));
        }
        catch (Exception ex) {
            logger.error((Object)"error happend while get the report ", (Throwable)ex);
            this.processException(ex);
        }
    }

    private void processException(Exception ex) {
        String errMsg = this.getExceptionMessage(ex);
        if (errMsg != null && errMsg.length() > 0) {
            this.setShowMessagePolicy(2);
            this.setMessageText(errMsg);
            this.setIsShowTextOnly(false);
            this.setMessageBgcolor(SHOW_MESSAGE_BG_ERROR);
            this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
            this.showMessage();
        }
    }

    private String getExceptionMessage(Exception exc) {
        if (exc instanceof AbortException) {
            return null;
        }
        if (exc instanceof NumericException) {
            return exc.getMessage();
        }
        return exc.getMessage();
    }

    protected void loadData(IReportData data, int start) {
        if (data == null) {
            return;
        }
        this.putAssistDataInParam(data);
        if (data.size() == 0) {
            return;
        }
        this.tblMain.setRowCount(data.getTotalRowCount());
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.setRefresh(false);
        int iCols = this.tblMain.getColumnCount();
        IRow row = null;
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.setRow(start++);
            ReportInfo rptRowInfo = (ReportInfo)data.getReportRowInfo(i);
            this.loadRow(row, (IObjectValue)rptRowInfo);
            if (rptRowInfo.isSumLine()) {
                this.setRowColor(row, ArApConstants.PERIOD_SUM_COLOR, iCols);
            }
            if (!rptRowInfo.isTotalLine()) continue;
            this.setRowColor(row, Color.decode("#F6F6BF"), iCols);
        }
        this.tblMain.setRefresh(true);
        if (this.isReportTree() || data.size() == 0) {
            this.tblMain.repaint();
        } else {
            this.tblMain.reLayoutAndPaint();
        }
        if (this.isFirstLoad) {
            this.tblMain.gerGroupManager().group();
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    protected void putAssistDataInParam(IReportData data) {
        this.filterParam.setTempTable(data.getTempTable());
        this.filterParam.setTotalRowCount(data.getTotalRowCount());
        this.filterParam.setOtherTempTables(data.getOtherTempTables());
    }

    protected void loadRow(IRow row, IObjectValue rowInfo) {
        if (rowInfo == null) {
            return;
        }
        ReportInfo rptRowInfo = (ReportInfo)rowInfo;
        boolean fNotSumTotal = !rptRowInfo.isSumLine() && !rptRowInfo.isTotalLine();
        String key = null;
        Object cellVal = null;
        ICell cell = null;
        String summaryKey = this.getSummaryColumnKey();
        ArrayList<String> linkedColumns = this.getLinkedColumnKeys();
        int n = this.tblMain.getColumnCount();
        for (int j = 0; j < n; ++j) {
            key = this.tblMain.getColumn(j).getKey();
            cellVal = rowInfo.get(key);
            if (cellVal != null) {
                if (cellVal instanceof BigDecimal) {
                    BigDecimal amtVal = (BigDecimal)cellVal;
                    if (amtVal.signum() == 0 && fNotSumTotal) {
                        cellVal = null;
                    }
                } else if (cellVal instanceof Timestamp) {
                    cellVal = TypeConversionUtils.objToDate((Object)cellVal);
                }
            } else if (!StringUtils.isEmpty((String)summaryKey) && key.equals(summaryKey)) {
                if (rptRowInfo.isSumLine()) {
                    cellVal = ReportUI.getResourceString("subtotal");
                } else if (rptRowInfo.isTotalLine()) {
                    cellVal = ReportUI.getResourceString("total");
                }
            }
            cell = row.getCell(j);
            cell.setValue(cellVal);
            if (null != linkedColumns && null != cellVal && linkedColumns.contains(key) && !rptRowInfo.isSumLine() && !rptRowInfo.isTotalLine()) {
                cell.getStyleAttributes().setFontColor(Color.BLUE);
            }
            cell = null;
        }
        this.setAllCurrencyAmtFormat(row);
    }

    protected void setAllCurrencyAmtFormat(IRow row) {
        if (!this.filterParam.isAllCurrency()) {
            return;
        }
        CurrencyInfo currInfo = this.getCurrencyofRow(row);
        int scale = currInfo == null ? 4 : currInfo.getPrecision();
        String numFmt = PrecisionFormatUtils.getFormatString(scale);
        Object cellVal = null;
        int n = this.tblMain.getColumnCount();
        for (int j = 0; j < n; ++j) {
            cellVal = row.getCell(j).getValue();
            if (cellVal == null || !(cellVal instanceof BigDecimal)) continue;
            row.getCell(j).getStyleAttributes().setNumberFormat(numFmt);
        }
    }

    private CurrencyInfo getCurrencyofRow(IRow row) {
        CurrencyInfo currInfo = null;
        String currKey = this.currencyColumn();
        currKey = currKey == null ? "FCurrency" : currKey;
        ICell currencyCell = row.getCell(currKey);
        if (currencyCell != null && currencyCell.getValue() != null) {
            String currency = (String)currencyCell.getValue();
            int n = this.currencyColls.size();
            for (int i = 0; i < n; ++i) {
                if (!currency.equals(this.currencyColls.get(i).getName())) continue;
                currInfo = this.currencyColls.get(i);
                logger.debug((Object)("currencyInfo: " + currInfo));
                break;
            }
        }
        return currInfo;
    }

    protected String currencyColumn() {
        return "FCurrency";
    }

    protected void setRowColor(IRow row, Color color, int iCols) {
        for (int i = 0; i < iCols; ++i) {
            if (this.tblMain.getColumn(i).isMergeable() && this.tblMain.getColumn(i).isGroup()) continue;
            row.getCell(i).getStyleAttributes().setBackground(color);
        }
    }

    protected IReportData getReport() throws BOSException, EASBizException {
        return null;
    }

    protected List getChart() throws BOSException, EASBizException {
        return null;
    }

    protected void saveCurrentLocation() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            this.curIndex = selectBlock.getTop();
            this.curIndex = this.curIndex > 500 ? 0 : this.curIndex;
        } else {
            this.curIndex = 0;
        }
    }

    protected void restoreCurrentLocation() {
        if (this.tblMain.getRow(this.curIndex) != null) {
            this.tblMain.getSelectManager().select(this.curIndex, 0);
        }
    }

    public BOSQueryDelegate getPrintProvider() {
        return null;
    }

    public String getPrintTemplatePath() {
        return null;
    }

    protected boolean isViewEnabled() {
        return false;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.currRow = e.getRowIndex();
        this.currCol = e.getColIndex();
        if (e.getClickCount() == 2 && this.isViewEnabled() && e.getType() != 0) {
            ActionEvent evt = new ActionEvent(this.btnView, 1001, "Double Clicked");
            this.actionView.actionPerformed(evt);
        }
    }

    protected HashMap getUIParam() {
        LinkedHashMap<String, SystemEnum> map = new LinkedHashMap<String, SystemEnum>();
        map.put("sysEnum", this.getSystemEnumForOA());
        return map;
    }

    @Override
    public boolean isPrepareInit() {
        return super.isPrepareInit();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = (RequestContext)handler.getRequestContext();
        String queryName = queryPK.getFullName();
        String clsName = this.getMetaDataPK().getFullName();
        Map uiCtx = this.getUIContext();
        if (uiCtx.get("conGlParam") != null) {
            request.put("conGlParam", uiCtx.get("conGlParam"));
        }
        request.put("queryName", (Object)queryName);
        request.put("clsName", (Object)clsName);
        request.put("uiParam", (Object)this.uiParam);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public IUIActionPostman prepareGetReport(RequestContext request) {
        if (request == null) {
            request = new RequestContext();
        }
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("handleQuery");
        request.put("filterParam", (Object)this.filterParam);
        request.put("uiParam", (Object)this.uiParam);
        handler.setRequestContext((Serializable)request);
        handler.setAvailabe(false);
        return handler;
    }

    protected IMainUIObject getMainUIObject() {
        Object mainUI = null;
        try {
            Frame frame = UIFactoryHelper.getMainFrame((Map)this.getUIContext());
            mainUI = frame instanceof NewMainFrame ? ((NewMainFrame)frame).getMainUI() : UIFactoryHelper.getMainUIObject((Map)this.getUIContext());
        }
        catch (UIException e) {
            this.handleException((Exception)((Object)e));
        }
        return mainUI;
    }

    protected void addTabOnMainUI(IUIObject object) {
        IMainUIObject mainUI = this.getMainUIObject();
        IUIObject[] uiObjects = mainUI.getUiManager().findUIObject(this.getUIFullName());
        boolean hasOnloadUI = false;
        if (uiObjects != null && uiObjects.length > 0) {
            int length = uiObjects.length;
            for (int i = 0; i < length; ++i) {
                if (!uiObjects[i].equals(object)) continue;
                hasOnloadUI = true;
                break;
            }
        }
        if (!hasOnloadUI) {
            mainUI.getUiManager().addTab(object);
            mainUI.getUiManager().changeTab(object);
        }
    }

    protected void removeTabOnMainUI() {
        IMainUIObject mainUI = this.getMainUIObject();
        IUIObject[] uiObjects = mainUI.getUiManager().findUIObject(this.getUIFullName());
        if (uiObjects != null && uiObjects.length > 0) {
            mainUI.getUiManager().removeTab(uiObjects[0]);
        }
    }

    protected void removeTabOnMainUI(IUIObject object) {
        IMainUIObject mainUI = this.getMainUIObject();
        mainUI.getUiManager().removeTab(object);
    }

    protected String getUIFullName() {
        return null;
    }

    protected boolean isIsLoading() {
        return this.isLoading;
    }

    public boolean isAsynchronism() {
        return false;
    }

    protected static String getResourceString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.framework.report.CommRptResource", (String)key);
    }

    protected boolean isReportTree() {
        return this.isReportTree;
    }

    public boolean isRunBack() {
        boolean flag = false;
        Set threadSet = ThreadPool.getCurrentThread();
        if (threadSet != null) {
            MonitorInfo info2 = null;
            for (MonitorInfo info2 : threadSet) {
                if (info2 == null || info2.getUi() == null || !info2.getUi().getClass().getName().equals(this.getUIFullName())) continue;
                if (info2.getWorker() != null && info2.getWorker().isIsFinished()) {
                    ThreadPool.destroyMonitor((MonitorInfo)info2);
                    this.addTabOnMainUI((IUIObject)info2.getUi());
                    try {
                        this.onShow();
                    }
                    catch (Exception e) {
                        this.handUIException(e);
                    }
                } else {
                    MsgBox.showInfo((String)MessageFormat.format(ReportUI.getResourceString("searching"), this.getUITitle()));
                }
                flag = true;
                break;
            }
        }
        return flag;
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected int[] getSelectedRows() {
        this.checkSelected();
        return KDTableUtil.getSelectedRows((KDTable)this.tblMain);
    }

    protected String getCellValue(IRow row, String key) {
        if (null == row || StringUtils.isEmpty((String)key)) {
            return null;
        }
        ICell cell = row.getCell(key);
        return null == cell ? null : (null == cell.getValue() ? null : cell.getValue().toString());
    }

    protected String getSummaryColumnKey() {
        return null;
    }

    protected ArrayList<String> getLinkedColumnKeys() {
        return null;
    }
}

