/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractRptBaseQueryUI;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.IRptParamConvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.RptParamConvertorFactory;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class RptBaseQueryUI
extends AbstractRptBaseQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(RptBaseQueryUI.class);
    protected transient ArApSysParamInfo arApSysParamInfo = null;
    protected transient IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    private int defaultCussTypeInd = 0;
    private int defaultCurrencyInd = 0;
    private boolean fAR = true;
    protected transient CompanyOrgUnitInfo currentCompany = null;

    protected void setAp() {
        this.fAR = false;
    }

    protected boolean isArRpt() {
        return this.fAR;
    }

    protected final SystemEnum getSystemEnum() {
        return this.isArRpt() ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
    }

    public IReportQueryParam getRptParam() {
        return null;
    }

    public CustomerParams getCustomerParams() {
        IRptParamConvertor convertor = RptParamConvertorFactory.getConvertor(this.getRptParam());
        return convertor.convertClient();
    }

    public void clear() {
        if (this.comboCussType.getItemCount() > 0 && this.defaultCussTypeInd > -1) {
            this.comboCussType.setSelectedIndex(this.defaultCussTypeInd);
        }
        if (this.comboCurrency.getItemCount() > 0 && this.defaultCurrencyInd > -1) {
            this.comboCurrency.setSelectedIndex(this.defaultCurrencyInd);
        }
        this.prmtCsspGrp.setValue(null);
        this.prmtCussFrom.setData(null);
        this.prmtCussTo.setData(null);
    }

    public void onLoad() throws Exception {
        this.initCompany();
        this.initUICtrls();
        super.onLoad();
    }

    protected void initCompany() {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
    }

    protected void initSysParamInfo() throws Exception {
        this.arApSysParamInfo = this.iBillFacade.getSysParams(this.currentCompany, this.getUIParam());
        this.currentCompany = this.arApSysParamInfo.getCompany();
    }

    protected HashMap getUIParam() {
        LinkedHashMap<String, SystemEnum> map = new LinkedHashMap<String, SystemEnum>();
        map.put("sysEnum", this.getSystemEnum());
        return map;
    }

    protected void initUICtrls() throws Exception {
        this.initSysParamInfo();
        ClientUtils.setCurrencyList((KDComboBox)this.comboCurrency, (boolean)true);
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)this.currentCompany.getBaseCurrency().getId().toString());
        this.defaultCurrencyInd = this.comboCurrency.getSelectedIndex();
        this.comboCussType.setRequired(true);
        ArApBillUIUtil.makeAsstActType(this.comboCussType, this.arApSysParamInfo, false);
        this.defaultCussTypeInd = this.comboCussType.getSelectedIndex();
        this.prmtCussFrom.setEnabledMultiSelection(true);
    }

    @Override
    protected void comboCussType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.comboCussType.getItemCount() == 0 || this.comboCussType.getSelectedItem() == null) {
            return;
        }
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        if (typeInfo != null && typeInfo.getDefaultQueryName() != null) {
            this.prmtCussFrom.setEnabled(true);
            this.prmtCussTo.setEnabled(true);
            String sCompanyId = this.currentCompany.getString("id");
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCussFrom, this.prmtCussTo, typeInfo, sCompanyId, this.arApSysParamInfo, true);
            ArApQueryUIUtil.setCsspGrpF7((IUIObject)this, this.prmtCsspGrp, typeInfo);
        } else {
            this.prmtCsspGrp.setEnabled(false);
            this.prmtCussFrom.setEnabled(false);
            this.prmtCussTo.setEnabled(false);
        }
        this.prmtCsspGrp.setValue(null);
        this.prmtCussFrom.setValue(null);
        this.prmtCussTo.setValue(null);
    }

    @Override
    protected void prmtCsspGrp_dataChanged(DataChangeEvent e) throws Exception {
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        String companyId = this.currentCompany.getId().toString();
        ArApQueryUIUtil.csspGrpValueChangeProcess((CoreUIObject)this, companyId, typeInfo, this.prmtCsspGrp, this.prmtCussFrom, this.prmtCussTo);
    }

    @Override
    protected void prmtCussFrom_dataChanged(DataChangeEvent e) throws Exception {
        ArApQueryUIUtil.objFromChanged((IUIObject)this, this.prmtCussFrom, this.prmtCussTo);
    }

    protected void setCurrCussAcct2RptParam(ArApQueryParam param) {
        ArApQueryUIUtil.saveCurrency(this.comboCurrency, param);
        ArApQueryUIUtil.saveCussType(this.comboCussType, param);
        ArApQueryUIUtil.saveCsspGrp(this.prmtCsspGrp, param);
        ArApQueryUIUtil.saveCussAcctRange(this.prmtCussFrom, this.prmtCussTo, param);
    }

    protected void setCurrCussAcct2RptParamCopy(ArApQueryParam param) {
        ArApQueryUIUtil.saveCussType(this.comboCussType, param);
        ArApQueryUIUtil.saveCsspGrp(this.prmtCsspGrp, param);
        ArApQueryUIUtil.saveCussAcctRange(this.prmtCussFrom, this.prmtCussTo, param);
    }

    protected void loadCurrCussAcctData(ArApQueryParam param) {
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)param.getCurrencyId());
        ClientUtils.setSelectedItem((KDComboBox)this.comboCussType, (String)param.getCussTypeId());
        ArApQueryUIUtil.loadCsspGrp(this.prmtCsspGrp, param);
        ArApQueryUIUtil.loadCussAcctRange((IUIObject)this, this.prmtCussFrom, this.prmtCussTo, param);
    }
}

