/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.fi.ar.client.ExcelFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class TableExportAction {
    private KDTable tblMain = null;
    private KDFileChooser fileChooser;

    public TableExportAction(KDTable tbl) {
        this.tblMain = tbl;
    }

    public void export() throws Exception {
        block6: {
            File tempFile = this.createTempFile(this.getTempFile());
            if (tempFile == null) {
                return;
            }
            String tempFileName = tempFile.getAbsolutePath();
            ExportManager man = new ExportManager();
            KDSBook book = null;
            book = new KDSBook("kdtable export");
            book.addSheet(null, this.getKDSSheet(book));
            man.exportToExcel(book, tempFileName);
            try {
                this.openFileInExcel(tempFileName);
            }
            catch (IOException e2) {
                int result = this.getFileChooser().showSaveDialog((Component)this.tblMain);
                if (result != 0) break block6;
                File dest = this.getSelectedFile(this.getFileChooser());
                File src = new File(tempFileName);
                if (dest.exists()) {
                    dest.delete();
                }
                src.renameTo(dest);
            }
        }
    }

    private String getTempFile() {
        String path = System.getProperty("user.dir") + File.separator + "eastmp.xls";
        path = FilenameUtils.normalize((String)path);
        return path;
    }

    private File createTempFile(String filePath) {
        File file = new File(filePath);
        if (file.isFile()) {
            file = file.getParentFile();
        }
        try {
            file = File.createTempFile("tmp", ".xls", file);
        }
        catch (IOException e) {
            try {
                file = File.createTempFile("tmp", ".xls");
            }
            catch (IOException e1) {
                file = null;
            }
        }
        return file;
    }

    private KDSSheet getKDSSheet(KDSBook book) {
        return this.tblMain.getIOManager().saveToKDSSheet(book, true, false, false, "sheet1");
    }

    private void openFileInExcel(String file) throws IOException {
        File f = GlobalLocator.getInstance().locateResourceFile("/client/LanchFile.bat");
        if (f == null) {
            throw new IOException();
        }
        Runtime.getRuntime().exec("\"" + f.getAbsolutePath() + "\" \"excel\" \"" + file + "\"");
    }

    private KDFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            String title = LanguageManager.getLangMessage((String)"FileChooserTitle", KDTMenuManager.class, (String)"Save As...");
            this.fileChooser = new KDFileChooser();
            this.fileChooser.setDialogTitle(title);
            this.fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        }
        return this.fileChooser;
    }

    private File getSelectedFile(KDFileChooser fileChooser) {
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            String path = file.getAbsolutePath();
            FileFilter ext = fileChooser.getFileFilter();
            if (ext != null && !ext.accept(file)) {
                if (ext instanceof ExcelFileFilter) {
                    path = path + ".xls";
                }
                file = new File(path);
            }
        }
        return file;
    }
}

