/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.dap.client.DAPFromMultiBillTypeEditUI;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.VersionUtil;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.VerificationBillInfo;
import com.kingdee.eas.fi.ap.client.VerificationBillQueryUI;
import com.kingdee.eas.fi.ap.client.util.MultiObjectsLockHelper;
import com.kingdee.eas.fi.ar.ArVerificationFacadeFactory;
import com.kingdee.eas.fi.ar.IArVerificationFacade;
import com.kingdee.eas.fi.ar.ImportLog;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.VerificationBillFactory;
import com.kingdee.eas.fi.ar.client.AbstractVerificationBillListUI;
import com.kingdee.eas.fi.ar.client.ArApVerificationCommonQueryProcessor;
import com.kingdee.eas.fi.ar.client.VerificationImporter;
import com.kingdee.eas.fi.ar.client.VerifyDataFileUI;
import com.kingdee.eas.fi.ar.client.VerifyDataLogUI;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.ListShowModeEnum;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.VerificationBillReverseUI;
import com.kingdee.eas.fi.arap.client.util.ArApBatchUtil;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.DefinitionNewDataProvider;
import com.kingdee.eas.fi.arap.util.ListShowModelUtil;
import com.kingdee.eas.fi.arap.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.cas.client.PaymentBillUI;
import com.kingdee.eas.fi.cas.client.ReceivingBillUI;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMSlaveCommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class VerificationBillListUI
extends AbstractVerificationBillListUI {
    private static final long serialVersionUID = 2030721691909581724L;
    private static final Logger logger = CoreUIObject.getLogger(VerificationBillListUI.class);
    private String sysType = "";
    private CompanyOrgUnitInfo currentCompany = null;
    private UserInfo defaultUserInfo = null;
    private Vector selectedBill = new Vector();
    private Vector selectedBillDate = new Vector();
    private CommonQueryDialog dialog;
    private File importDataFile = null;
    private List lockObjs = new ArrayList();
    private boolean isDisplayEntries = false;
    protected ArApSysParamInfo cache = new ArApSysParamInfo();
    protected IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    protected Boolean isUseOldShowHead = false;
    public static final String COL_ENTRYS_VERIRECPAYTYPENAME = "entrys.veriRecPayTypeName";
    public static final String COL_ENTRYS_BILLSUBTYPE = "entrys.billSubType";
    public static final String COL_ENTRYS_RECEIVINGBILLTYPE_NAME = "receivingBillType.name";
    public static final String COL_ENTRYS_THISVERIFICATEAMT = "entrys.thisVerificateAmt";
    public static final String COL_PRECISION = "currency.precision";
    public static final String COL_ENTRYS_BILLNUMBER = "entrys.billNumber";
    public static final String COL_SELECTED = "selected";

    public VerificationBillListUI() throws Exception {
        this.actionVoucher.setDaemonRun(true);
    }

    public void onLoad() throws Exception {
        this.isUseOldShowHead = ArApBillUtil.isUseOldShowHead(null);
        ArApReportUIUtil.checkCompany((Component)((Object)this), SysContext.getSysContext().getCurrentFIUnit());
        if (this.defaultUserInfo == null) {
            this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        if ((String)this.getUIContext().get("UIClassParam") != null) {
            this.sysType = (String)this.getUIContext().get("UIClassParam");
        }
        String entryBillID = (String)this.getUIContext().get("EntryBillID");
        String needDefaultFilter = (String)this.getUIContext().get("needDefaultFilter");
        if (entryBillID != null && !"".equals(entryBillID) || needDefaultFilter != null && !"".equals(needDefaultFilter)) {
            this.setIsNeedDefaultFilter(false);
            this.actionQuery.setVisible(false);
        }
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                VerificationBillListUI.this.tbl_afterDataFill(e);
            }
        });
        super.onLoad();
        this.tblMain.getColumn(COL_ENTRYS_BILLNUMBER).getStyleAttributes().setFontColor(Color.BLUE);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionView.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionLocate.setEnabled(false);
        this.actionMakeVoucher.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
        this.actionWorkFlowG.setVisible(false);
        this.menuBiz.setVisible(false);
        this.actionMakeVoucher.setVisible(false);
        this.menuEdit.setVisible(false);
        this.btnQuery.setText(this.getStrResource("ap_label_filter"));
        this.btnQuery.setTextIconDisStyle((short)3);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNone.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnUnVerification.setIcon(EASResource.getIcon((String)"imgTbtn_fcancelverification"));
        this.btnMakeVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnDelVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.btnViewVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        if (entryBillID != null && !"".equals(entryBillID)) {
            FilterInfo filter = new FilterInfo();
            FilterItemInfo idItem = new FilterItemInfo("id", (Object)("SELECT FParentID FROM T_AR_VerificationBillEntry WHERE FBillID = '" + entryBillID + "'"), CompareType.INNER);
            filter.getFilterItems().add(idItem);
            this.mainQuery.setFilter(filter);
            this.refreshList();
        }
        this.formatTable();
        this.actionEditVouchers.setEnabled(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        KDTableUtils.setBigDecimalColumnPrecision(this.tblMain, new String[]{"lastExhangeRate"}, 9);
        this.refreshEntry();
    }

    public void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.getUIContext().get("Owner") instanceof DAPFromMultiBillTypeEditUI) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("company.id", (Object)this.currentCompany.getId(), CompareType.EQUALS);
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(filterItemInfo);
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
        super.tblMain_doRequestRowSet(e);
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysEnum", this.getSysEnum());
        map.put("isSCM", Boolean.FALSE);
        map.put("permissionItem", this.getPermissionItem());
        return map;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        ListShowModeEnum showMode;
        if (ev == null) {
            return;
        }
        Collection billIDS = (Collection)this.getUIContext().get("billId");
        if (billIDS != null && billIDS.size() > 0) {
            this.btnQuery.setVisible(false);
            Iterator iters = billIDS.iterator();
            StringBuffer ids = new StringBuffer();
            while (iters.hasNext()) {
                ids.append("'");
                ids.append(iters.next());
                ids.append("',");
            }
            ids.deleteCharAt(ids.length() - 1);
            LinkedHashSet idSet = new LinkedHashSet();
            idSet.addAll(billIDS);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo idItem = new FilterItemInfo("id", idSet, CompareType.INCLUDE);
            filter.getFilterItems().add(idItem);
            ev.setFilter(filter);
        }
        this.setListSorter(ev);
        FilterInfo oldFilter = ev.getFilter();
        if (oldFilter == null) {
            oldFilter = new FilterInfo();
        }
        this.setDisplayEntries(ListShowModeEnum.ENTRY == (showMode = ListShowModelUtil.getListShowModeFromFilters(oldFilter.getFilterItems())));
        if (this.isUseOldShowHead.booleanValue()) {
            this.menuItemSwitchView.setVisible(false);
            this.menuItemSwitchView.setEnabled(false);
            this.menuItemSwitchView.setSelected(false);
            if (!this.isDisplayEntries()) {
                FilterItemInfo filterItemInfo = new FilterItemInfo("entrys.seq", (Object)1, CompareType.EQUALS);
                FilterInfo newFilterInfo = new FilterInfo();
                newFilterInfo.getFilterItems().add(filterItemInfo);
                try {
                    oldFilter.mergeFilter(newFilterInfo, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        } else {
            this.menuItemSwitchView.setVisible(!this.isDisplayEntries());
            this.menuItemSwitchView.setEnabled(!this.isDisplayEntries());
            this.menuItemSwitchView.setSelected(!this.isDisplayEntries());
        }
        this.actionViewBill.setEnabled(this.isDisplayEntries());
        for (int i = 0; i < oldFilter.getFilterItems().size(); ++i) {
            FilterItemInfo filterItem = oldFilter.getFilterItems().get(i);
            if (!COL_ENTRYS_BILLSUBTYPE.equals(filterItem.getPropertyName())) continue;
            if (BOSUuid.isValid((String)filterItem.getCompareValue().toString(), (boolean)true)) {
                filterItem.setPropertyName("entrys.veriRecPayTypeId");
                continue;
            }
            FilterItemInfo billSubTypeFilter = new FilterItemInfo("entrys.veriRecPayTypeId is null");
            oldFilter = ArApBillUtil.addFilter(oldFilter, billSubTypeFilter, i, "and");
            FilterItemInfo sillSubTypeFilter = new FilterItemInfo("entrys.veriRecPayTypeNumber = '" + filterItem.getCompareValue() + "'");
            oldFilter = ArApBillUtil.addFilter(oldFilter, sillSubTypeFilter, i, "or");
            i += 2;
        }
        super.beforeExcutQuery(ev);
    }

    protected EntityViewInfo setListSorter(EntityViewInfo ev) {
        SorterItemCollection sorters = ev.getSorter();
        int sorterSize = sorters.size();
        boolean isBizDateSorted = false;
        boolean isNumberSorted = false;
        boolean isSeqSorted = false;
        for (int i = 0; i < sorterSize; ++i) {
            if (sorters.get(i).getPropertyName().equals("bizDate")) {
                isBizDateSorted = true;
                continue;
            }
            if (sorters.get(i).getPropertyName().equals("number")) {
                isNumberSorted = true;
                continue;
            }
            if (!sorters.get(i).getPropertyName().equals("entrys.seq")) continue;
            isSeqSorted = true;
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        if (!isBizDateSorted) {
            sorterItemInfo.setPropertyName("bizDate");
            sorterItemInfo.setSortType(SortType.DESCEND);
            ev.getSorter().add(sorterItemInfo);
        }
        if (!isNumberSorted) {
            sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName("number");
            sorterItemInfo.setSortType(SortType.DESCEND);
            ev.getSorter().add(sorterItemInfo);
        }
        if (!isSeqSorted) {
            sorterItemInfo = new SorterItemInfo("entrys.seq");
            sorterItemInfo.setSortType(SortType.ASCEND);
            ev.getSorter().add(sorterItemInfo);
        }
        return ev;
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.checkRows(true);
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        this.checkRows(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VerificationBillFactory.getRemoteInstance();
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (!this.isDisplayEntries()) {
            this.menuItemSwitchView.setEnabled(true);
        }
        try {
            super.refresh(e);
        }
        finally {
            this.selectedBill.removeAllElements();
            this.selectedBillDate.removeAllElements();
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        if (this.menuItemSwitchView.isVisible()) {
            // empty if block
        }
        if (!this.isDisplayEntries()) {
            int selectIndex = this.tblMain.getColumnIndex(COL_SELECTED);
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (this.tblMain.getCell(i, selectIndex).getValue() != null) continue;
                this.tblMain.getCell(i, selectIndex).setValue((Object)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnVerification_actionPerformed(ActionEvent e) throws Exception {
        int iCount = this.selectedBill.size();
        if (iCount <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ap_verify_norecode"));
            return;
        }
        String[] billIDs = new String[iCount];
        PeriodInfo currentPeriod = this.cache.getCurrentPeriod(this.getSysEnum());
        for (int i = 0; i < this.selectedBill.size(); ++i) {
            billIDs[i] = this.selectedBill.get(i).toString();
            java.sql.Date billDate = (java.sql.Date)this.selectedBillDate.get(i);
            if (!billDate.before(currentPeriod.getBeginDate())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("verifyDateBeforeCurrentDate"));
            return;
        }
        HashSet billIdSet = new HashSet(this.selectedBill);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList<String> requestIdList = new ArrayList<String>();
        try {
            String billId = null;
            boolean isLocked = false;
            Map result = iMutex.batchRequestBizObjIDForUpdate(new ArrayList(billIdSet));
            Iterator it = billIdSet.iterator();
            while (it.hasNext()) {
                billId = it.next().toString();
                if (result.get(billId) != null && ((Boolean)result.get(billId)).booleanValue()) {
                    requestIdList.add(billId);
                    continue;
                }
                isLocked = true;
            }
            if (isLocked) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new String[]{ArApBillUIUtil.getStrResource("DataMutex")});
            }
            ArVerificationFacadeFactory.getRemoteInstance().unVerification(billIDs);
            this.execQuery();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        finally {
            if (requestIdList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(requestIdList);
            }
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(true);
            this.dialog.setQueryObjectPK(this.mainQueryPK);
            this.dialog.addUserPanel((KDPanel)new VerificationBillQueryUI(this.sysType, this.cache));
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setHeight(410);
            this.dialog.setWidth(590);
            this.dialog.setTitle(this.getStrResource("ap_label_conditionquery"));
            ArApVerificationCommonQueryProcessor processor = new ArApVerificationCommonQueryProcessor();
            processor.set("isArSys", Boolean.TRUE);
            processor.set("ARAP_COMPANY_KEY", this.currentCompany.getId().toString());
            this.dialog.setProcessor((IProcessor)processor);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.dialog;
    }

    protected void initWorkButton() {
        try {
            if (this.cache.getCompany() == null) {
                this.cache = this.iBillFacade.getSysParams(SysContext.getSysContext().getCurrentFIUnit(), this.getUIParam());
            }
            this.currentCompany = this.cache.getCompany();
            PeriodInfo arStartPeriod = this.cache.getStartPeriod(this.getSysEnum());
            if (arStartPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        super.initWorkButton();
        this.btnEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
        this.menuItemEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
        KDMenuItem menuItemUnReverse = new KDMenuItem();
        menuItemUnReverse.setAction((Action)((Object)this.actionUnReverse));
        menuItemUnReverse.setText(this.btnUnReverse.getText());
        menuItemUnReverse.setToolTipText(this.btnUnReverse.getToolTipText());
        menuItemUnReverse.setIcon(this.btnUnReverse.getIcon());
        this.btnReverse.addAssistMenuItem((JMenuItem)menuItemUnReverse);
        this.btnUnReverse.setVisible(false);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("isFromWriteOff") == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list;
        String cashflag;
        this.checkSelected();
        HashMap paramap = this.cache.getParamValueMap();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        Boolean isCashSalePur = (Boolean)row.getCell("isCashSalePur").getValue();
        if (Boolean.TRUE.equals(isCashSalePur) && paramap.containsKey("AR_RECVOUCHER_BILLTYPE_CASH") && (cashflag = paramap.get("AR_RECVOUCHER_BILLTYPE_CASH").toString()).equals("1")) {
            throw new OtherBillBizException(OtherBillBizException.CASH_RE_FORBIDENN_BILL);
        }
        if (!this.cache.isRelationGL()) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("isNotRelateGL", new Object[]{this.cache.getSysEnum().getAlias()}));
            SysUtil.abort();
        } else if (!this.cache.isGLStart()) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("GLIsNotStarted"));
            SysUtil.abort();
        }
        boolean flag = this.selectMethod();
        if (flag) {
            this.checkRows(false);
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("errorSelectMethod"));
            SysUtil.abort();
        }
        if ((list = this.getSelectedIdValues()).size() > 0) {
            IArVerificationFacade iArVerificationFacade = ArVerificationFacadeFactory.getRemoteInstance();
            iArVerificationFacade.isGenVoucher(true, list);
        }
        if (CreateJobFacadeFactory.getRemoteInstance().checkDuplicateTask("SCM_FI_AR_001" + this.cache.getCompany().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        HashSet billIdSet = new HashSet(this.getSelectedIdValues());
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList<String> requestIdList = new ArrayList<String>();
        try {
            String billId = null;
            boolean isLocked = false;
            Map result = iMutex.batchRequestBizObjIDForUpdate(new ArrayList(billIdSet));
            Iterator it = billIdSet.iterator();
            while (it.hasNext()) {
                billId = it.next().toString();
                if (result.get(billId) != null && ((Boolean)result.get(billId)).booleanValue()) {
                    requestIdList.add(billId);
                    continue;
                }
                isLocked = true;
            }
            if (isLocked) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new String[]{ArApBillUIUtil.getStrResource("DataMutex")});
            }
            super.actionVoucher_actionPerformed(e);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        finally {
            if (requestIdList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(requestIdList);
            }
        }
    }

    public void afterDAPTrans(BOTMappingInfo mappingInfo, BOTRelationCollection relationCollection) {
        ArrayList<String> requestIdList = new ArrayList<String>();
        int size = relationCollection.size();
        for (int i = 0; i < size; ++i) {
            requestIdList.add(relationCollection.get(i).getSrcObjectID());
        }
        MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(requestIdList);
    }

    @Override
    public void actionEditVouchers_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell("id").getValue().toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("VoucherCannotEdit"));
            SysUtil.abort();
        }
        IIDList voucherIDList = this.arrayList2IIDList(voucherColl);
        String voucherId = voucherColl.get(0).toString();
        boolean hasPermission = false;
        if (this.defaultUserInfo != null) {
            hasPermission = BaseDataUtil.checkEditVoucherPermission((IObjectPK)new ObjectUuidPK(this.defaultUserInfo.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), "", (IObjectPK)new ObjectUuidPK(voucherId));
        }
        if (!hasPermission) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("NoPermissionCannotEdit"));
            SysUtil.abort();
        }
        if (CreateJobFacadeFactory.getRemoteInstance().checkDuplicateTask("SCM_FI_AR_001" + this.cache.getCompany().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)voucherId);
        uiContext.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        uiContext.put((Object)"IDList", (Object)voucherIDList);
        String uiClass = "com.kingdee.eas.fi.gl.client.VoucherEditUI";
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private boolean selectMethod() {
        int iCount = this.tblMain.getRowCount();
        boolean flag = false;
        for (int i = 0; i < iCount; ++i) {
            Boolean isSelected = (Boolean)this.tblMain.getRow(i).getCell(COL_SELECTED).getValue();
            if (!Boolean.TRUE.equals(isSelected)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private IIDList arrayList2IIDList(ArrayList al) {
        RealModeIDList List2 = RealModeIDList.getEmptyIDList();
        if (al != null && al.size() != 0) {
            for (int i = 0; i < al.size(); ++i) {
                List2.add(i, (String)al.get(i));
            }
        }
        return List2;
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (CreateJobFacadeFactory.getRemoteInstance().checkDuplicateTask("SCM_FI_AR_001" + this.cache.getCompany().getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArClosrAccountIsInQueue"));
            SysUtil.abort();
        }
        ArrayList list = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(list);
        try {
            super.actionDelVoucher_actionPerformed(e);
        }
        finally {
            ArApBatchUtil.releasePureMutex(list);
        }
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        int billType = ((BizEnumValueInfo)row.getCell("billType").getValue()).getInt("value");
        String billId = row.getCell("billId").getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)billId);
        String uiClass = "";
        switch (billType) {
            case 6: {
                uiClass = ReceivingBillUI.class.getName();
                break;
            }
            case 4: {
                uiClass = PaymentBillUI.class.getName();
                break;
            }
            case 9: {
                uiClass = "com.kingdee.eas.fi.ap.client.OtherBillEditUI";
                break;
            }
            case 8: {
                uiClass = "com.kingdee.eas.fi.ar.client.OtherBillEditUI";
                break;
            }
            case 15: {
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("System", "com.kingdee.eas.fi.ar");
                hm.put("Module", "verification");
                hm.put("ID", billId);
                uiContext.put((Object)"RelationQueryParameter", hm);
                uiClass = "com.kingdee.eas.fi.ar.client.BadAcctReferListUI";
                break;
            }
            default: {
                return;
            }
        }
        IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClass, (Map)uiContext, null, OprtState.VIEW);
        popUI.show();
    }

    @Override
    public void actionViewVoucher_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell("id").getValue().toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("lab_novoucher_beview"));
            return;
        }
        String voucherId = voucherColl.get(0).toString();
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)voucherId);
        ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        IUIWindow uiVerificationWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.VIEW);
        uiVerificationWindow.show();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            if (e.getColIndex() == this.tblMain.getColumnIndex(COL_ENTRYS_BILLNUMBER)) {
                this.actionViewBill_actionPerformed(null);
            } else {
                this.setSelectedCell(e);
            }
            return;
        }
        super.tblMain_tableClicked(e);
        if (e.getColIndex() == this.tblMain.getColumnIndex(COL_SELECTED)) {
            this.setSelectedCell(e);
        }
    }

    private void setSelectedCell(KDTMouseEvent e) throws Exception {
        String tmpID;
        int i;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        if (row == null) {
            return;
        }
        if (row.getCell(COL_SELECTED).getStyleAttributes().getBackground().equals(ArApConstants.LOCK_COLOR)) {
            return;
        }
        String billID = row.getCell("id").getValue().toString();
        java.sql.Date billDate = (java.sql.Date)row.getCell("bizDate").getValue();
        Boolean isSelected = (Boolean)row.getCell(COL_SELECTED).getValue();
        if (Boolean.TRUE.equals(isSelected)) {
            isSelected = Boolean.FALSE;
            this.selectedBill.remove(billID);
            this.selectedBillDate.remove(billDate);
        } else {
            isSelected = Boolean.TRUE;
            this.selectedBill.add(billID);
            this.selectedBillDate.add(billDate);
        }
        boolean isMatched = false;
        for (i = selectBlock.getTop(); i >= 0; --i) {
            row = this.tblMain.getRow(i);
            tmpID = row.getCell("id").getValue().toString();
            if (tmpID.equals(billID)) {
                isMatched = true;
                row.getCell(COL_SELECTED).setValue((Object)isSelected);
                continue;
            }
            if (!tmpID.equals(billID) && isMatched) break;
        }
        for (i = selectBlock.getTop() + 1; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            tmpID = row.getCell("id").getValue().toString();
            if (tmpID.equals(billID)) {
                isMatched = true;
                row.getCell(COL_SELECTED).setValue((Object)isSelected);
                continue;
            }
            if (!tmpID.equals(billID) && isMatched) break;
        }
    }

    public void setUITitle(String title) {
        super.setUITitle(this.getStrResource("ap_lable_verifylist"));
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        if (!this.isDisplayEntries() && !this.isUseOldShowHead.booleanValue()) {
            return;
        }
        try {
            rowSet.beforeFirst();
            Map colMap = null;
            while (rowSet.next()) {
                if (colMap == null) {
                    colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
                }
                BizEnumValueInfo billType = null;
                if (colMap.containsKey(COL_ENTRYS_BILLSUBTYPE)) {
                    billType = (BizEnumValueInfo)rowSet.getObject(COL_ENTRYS_BILLSUBTYPE);
                }
                String veriRecPayTypeName = null;
                if (colMap.containsKey(COL_ENTRYS_VERIRECPAYTYPENAME)) {
                    veriRecPayTypeName = rowSet.getString(COL_ENTRYS_VERIRECPAYTYPENAME);
                }
                if (veriRecPayTypeName == null && billType != null) {
                    rowSet.updateString(COL_ENTRYS_VERIRECPAYTYPENAME, billType.getAlias());
                }
                String receivingBillTypeName = null;
                if (colMap.containsKey(COL_ENTRYS_RECEIVINGBILLTYPE_NAME)) {
                    receivingBillTypeName = rowSet.getString(COL_ENTRYS_RECEIVINGBILLTYPE_NAME);
                }
                if (receivingBillTypeName == null && billType != null) {
                    rowSet.updateString(COL_ENTRYS_RECEIVINGBILLTYPE_NAME, billType.getAlias());
                }
                if (!colMap.containsKey(COL_PRECISION)) continue;
                SCMClientUtils.iniColumnsPrecision((int)rowSet.getInt(COL_PRECISION), (String[])new String[]{COL_ENTRYS_THISVERIFICATEAMT}, (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)resKey);
    }

    private void checkRows(boolean flag) {
        Boolean check = flag;
        int iCount = this.tblMain.getRowCount();
        for (int i = 0; i < iCount; ++i) {
            if (this.tblMain.getRow(i).getCell(COL_SELECTED).getStyleAttributes().getBackground().equals(ArApConstants.LOCK_COLOR)) continue;
            this.tblMain.getRow(i).getCell(COL_SELECTED).setValue((Object)check);
            String billID = this.tblMain.getRow(i).getCell("id").getValue().toString();
            java.sql.Date billDate = (java.sql.Date)this.tblMain.getRow(i).getCell("bizDate").getValue();
            if (!flag || this.selectedBill.contains(billID)) continue;
            this.selectedBill.add(billID);
            this.selectedBillDate.add(billDate);
        }
        if (!flag) {
            this.selectedBill.removeAllElements();
            this.selectedBillDate.removeAllElements();
        }
    }

    public String getUITitle() {
        String subSys = "";
        if (this.sysType.equalsIgnoreCase("ar")) {
            subSys = this.getStrResource("lable_arsystem") + " - ";
        } else if (this.sysType.equalsIgnoreCase("ap")) {
            subSys = this.getStrResource("label_apsystem") + " - ";
        }
        return subSys + super.getUITitle();
    }

    private void formatTable() throws Exception {
        String formateString = PrecisionFormatUtils.getFormatString(this.currentCompany.getBaseCurrency());
        this.tblMain.getViewManager().setFreezeView(0, 6);
        String dateFormatStr = ArApBillUtil.getDateFormatString();
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        this.tblMain.getColumn("entrys.billDate").getStyleAttributes().setNumberFormat(dateFormatStr);
        this.tblMain.getColumn(COL_ENTRYS_THISVERIFICATEAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entrys.thisVerificateAmtLoc").getStyleAttributes().setNumberFormat(formateString);
        this.tblMain.getColumn("entrys.thisVerificateAmtLoc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entrys.gainAndLoss").getStyleAttributes().setNumberFormat(formateString);
        this.tblMain.getColumn("entrys.gainAndLoss").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.setColumnMoveable(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private File getImportFile() throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"selectedFile", (Object)this.importDataFile);
        IUIWindow selFileUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VerifyDataFileUI.class.getName(), (Map)uiCtx);
        selFileUI.show();
        VerifyDataFileUI fileUI = (VerifyDataFileUI)selFileUI.getUIObject();
        return fileUI.getSelectedFile();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pkIn = LogUtil.beginLog(null, (String)ArApBillUIUtil.getStrResource("log_import"), (BOSObjectType)new VerificationBillInfo().getBOSType(), null, (String)ArApBillUIUtil.getStrResource("log_import"));
        File file = this.getImportFile();
        if (file == null) {
            return;
        }
        this.importDataFile = file;
        VerificationImporter invoiceImporter = new VerificationImporter(this.importDataFile);
        ImportLog log = invoiceImporter.importData(true);
        UIContext param = new UIContext((Object)this);
        param.put((Object)"Log", (Object)log);
        IUIWindow logUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VerifyDataLogUI.class.getName(), (Map)param);
        logUI.show();
        if (log.errList.size() == 0) {
            LogUtil.afterLog(null, (IObjectPK)pkIn);
        }
    }

    public String[] getMergeColumnKeys() {
        String[] mergeCols = new String[]{"id", COL_SELECTED, "company.name", "number", "bizDate", "entrys.veriType", "creator", "verificationType", "isCashSalePur", "fiVouchered", "voucherType", "voucherNum", "isReversed", "isReverseBill"};
        return mergeCols;
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public boolean isDisplayEntries() {
        return this.isDisplayEntries;
    }

    public void setDisplayEntries(boolean isDisplayEntries) {
        this.isDisplayEntries = isDisplayEntries;
    }

    protected void refreshEntry() {
        String[] hideEntryRows = new String[]{"entrys.billDate", COL_ENTRYS_BILLNUMBER, COL_ENTRYS_BILLSUBTYPE, "entrys.acctCussName", "entrys.comment", "person.name", COL_ENTRYS_THISVERIFICATEAMT, "entrys.thisVerificateAmtLoc", "entrys.gainAndLoss", "materialNumber", "materialName", "adminOrgUnit.name"};
        ListShowModelUtil.setTableRowHide(this.tblMain, hideEntryRows, this.isUseOldShowHead, this.isDisplayEntries());
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.refreshEntry();
    }

    public static String getSelectedKeyValue(int[] selectRows, KDTable table, String columnName) {
        StringBuffer numbers = new StringBuffer();
        int size = selectRows.length;
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                Object keyValue;
                int rowIndex = selectRows[i];
                IRow row = table.getRow(rowIndex);
                if (row == null) {
                    return null;
                }
                ICell cell = row.getCell(columnName);
                if (cell == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if ((keyValue = cell.getValue()) == null) continue;
                numbers.append(keyValue.toString());
                numbers.append(" ");
            }
        }
        return numbers.toString();
    }

    public String getSelectedKeyNumber() {
        String keyFiledName = "number";
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        return VerificationBillListUI.getSelectedKeyValue(selectRows, this.tblMain, keyFiledName);
    }

    protected List getSelectID() {
        this.checkSelected();
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                if (list.contains(cell.getValue())) continue;
                list.add(cell.getValue());
            }
        }
        return list;
    }

    protected boolean checkBeforeWindowClosing() {
        MultiObjectsLockHelper.releaseLocks(this.lockObjs);
        return super.checkBeforeWindowClosing();
    }

    public void refreshList() throws Exception {
        super.refreshList();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder;
        if ((String)this.getUIContext().get("UIClassParam") != null) {
            this.sysType = (String)this.getUIContext().get("UIClassParam");
        }
        if ((clientHanlder = super.prepareInit()) != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
            request.setBosType(new VerificationBillInfo().getBOSType());
            request.put("company", null);
            request.put("uiparam", (Object)this.getUIParam());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public IUIActionPostman prepareAfterDataFill(RequestContext request, List requestLockIDList) {
        if (request == null) {
            request = new RequestContext();
        }
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handleAfterDataFill");
        request.setIdList(requestLockIDList);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public IUIActionPostman prepareRefreshList(RequestContext request, List requestLockIDList) {
        if (request == null) {
            request = new RequestContext();
        }
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handleRefreshList");
        request.setIdList(requestLockIDList);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected String getPermissionItem() {
        return null;
    }

    @Override
    public RequestContext prepareActionUnVerification(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionUnVerification(itemAction);
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        request.put("list", (Object)this.getUnverifyList());
        RequestRowSetEvent event = new RequestRowSetEvent((Object)this.tblMain, null, null, null, 0, (Object)new Integer(0), (Object)new Integer(KDTDataRequestManager.defaultPageRow - 1));
        RequestContext requestQuery = this.prepareQueryContext(event);
        request.putAll(requestQuery);
        return request;
    }

    private ArrayList getUnverifyList() {
        this.selectedBill = new Vector();
        this.selectedBillDate = new Vector();
        int iCount = this.tblMain.getRowCount();
        for (int i = 0; i < iCount; ++i) {
            Boolean selected = (Boolean)this.tblMain.getRow(i).getCell(COL_SELECTED).getValue();
            if (!Boolean.TRUE.equals(selected)) continue;
            String billID = this.tblMain.getRow(i).getCell("id").getValue().toString();
            java.sql.Date billDate = (java.sql.Date)this.tblMain.getRow(i).getCell("bizDate").getValue();
            if (this.selectedBill.contains(billID)) continue;
            this.selectedBill.add(billID);
            this.selectedBillDate.add(billDate);
        }
        int iCount1 = this.selectedBill.size();
        if (iCount1 <= 0) {
            return null;
        }
        String[] billIDs = new String[iCount1];
        PeriodInfo currentPeriod = this.cache.getCurrentPeriod(this.getSysEnum());
        for (int i = 0; i < iCount1; ++i) {
            billIDs[i] = this.selectedBill.get(i).toString();
            java.sql.Date billDate = (java.sql.Date)this.selectedBillDate.get(i);
            if (!billDate.before(currentPeriod.getBeginDate())) continue;
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < billIDs.length; ++i) {
            list.add(billIDs[i]);
        }
        return list;
    }

    public RequestContext prepareActionVoucher(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionVoucher(itemAction);
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            request.put("idList", (Object)this.getSelectID());
        }
        return request;
    }

    @Override
    public RequestContext prepareActionViewVoucher(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionViewVoucher(itemAction);
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        request.put("id", (Object)this.getSelectedRowId());
        return request;
    }

    private String getSelectedRowId() {
        String billId = null;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && selectBlock.size() > 0) {
            IRow row = this.tblMain.getRow(selectBlock.getTop());
            billId = row.getCell("id").getValue().toString();
        }
        return billId;
    }

    @Override
    public RequestContext prepareActionEditVouchers(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionEditVouchers(itemAction);
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        request.put("id", (Object)this.getSelectedRowId());
        return request;
    }

    @Override
    public RequestContext prepareActionDelVoucher(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionDelVoucher(itemAction);
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            request.put("Fw_IdList", (Object)this.getSelectID());
        }
        return request;
    }

    @Override
    public boolean isPrepareActionDelVoucher() {
        return true;
    }

    @Override
    public boolean isPrepareActionEditVouchers() {
        return true;
    }

    @Override
    public boolean isPrepareActionMakeVoucher() {
        return true;
    }

    @Override
    public boolean isPrepareActionSelectAll() {
        return true;
    }

    @Override
    public boolean isPrepareActionSelectNone() {
        return true;
    }

    @Override
    public boolean isPrepareActionUnVerification() {
        return true;
    }

    @Override
    public boolean isPrepareActionViewBill() {
        return true;
    }

    @Override
    public boolean isPrepareActionViewVoucher() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public RequestContext prepareActionQuery(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionQuery(itemAction);
        if (request == null) {
            request = new RequestContext();
        }
        return request;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        String[] fields = new String[]{COL_ENTRYS_THISVERIFICATEAMT};
        if (!(fields != null && fields.length != 0 || fields != null && fields.length != 0)) {
            return;
        }
        int from = e.getFirstRow();
        int last = e.getLastRow();
        BigDecimal amout = null;
        for (int i = from; i <= last; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            if (null == row.getCell(COL_SELECTED).getValue()) {
                row.getCell(COL_SELECTED).setValue((Object)false);
            }
            if (fields == null || fields.length <= 0) continue;
            for (int j = 0; j < fields.length; ++j) {
                Object scaleObj;
                if (row.getCell(fields[j]) == null || (scaleObj = row.getCell(fields[j]).getValue()) == null || !(scaleObj instanceof BigDecimal)) continue;
                amout = (BigDecimal)scaleObj;
                row.getCell(fields[j]).getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(amout.scale()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionReverse_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedList();
        if (ids == null || ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("reverse_norecord"));
            return;
        }
        HashSet billIdSet = new HashSet(ids);
        PeriodInfo currentPeriod = this.cache.getCurrentPeriod(this.getSysEnum());
        Date beginDate = currentPeriod.getBeginDate();
        UIContext param = new UIContext((Object)this);
        param.put((Object)"beginDate", (Object)beginDate);
        param.put((Object)"currentDate", (Object)this.cache.getDate());
        IUIWindow uiLog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VerificationBillReverseUI.class.getName(), (Map)param);
        uiLog.show();
        Date verifyDate = ((VerificationBillReverseUI)uiLog.getUIObject()).getVerifyDate();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList<String> requestIdList = new ArrayList<String>();
        try {
            String billId = null;
            boolean isLocked = false;
            Map result = iMutex.batchRequestBizObjIDForUpdate(new ArrayList(billIdSet));
            Iterator it = billIdSet.iterator();
            while (it.hasNext()) {
                billId = it.next().toString();
                if (result.get(billId) != null && ((Boolean)result.get(billId)).booleanValue()) {
                    requestIdList.add(billId);
                    continue;
                }
                isLocked = true;
            }
            if (isLocked) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new String[]{ArApBillUIUtil.getStrResource("DataMutex")});
            }
            if (verifyDate != null) {
                String[] idArr = new String[ids.size()];
                ids.toArray(idArr);
                VerificationBillFactory.getRemoteInstance().reverse(idArr, verifyDate);
                this.refreshList();
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        finally {
            if (requestIdList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(requestIdList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnReverse_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedList();
        if (ids == null || ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("unReverse_norecord"));
            return;
        }
        HashSet billIdSet = new HashSet(ids);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList<String> requestIdList = new ArrayList<String>();
        try {
            String billId = null;
            boolean isLocked = false;
            Map result = iMutex.batchRequestBizObjIDForUpdate(new ArrayList(billIdSet));
            Iterator it = billIdSet.iterator();
            while (it.hasNext()) {
                billId = it.next().toString();
                if (result.get(billId) != null && ((Boolean)result.get(billId)).booleanValue()) {
                    requestIdList.add(billId);
                    continue;
                }
                isLocked = true;
            }
            if (isLocked) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new String[]{ArApBillUIUtil.getStrResource("DataMutex")});
            }
            if (ids != null && ids.size() > 0) {
                String[] idArr = new String[ids.size()];
                ids.toArray(idArr);
                VerificationBillFactory.getRemoteInstance().unReverse(idArr);
                this.refreshList();
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        finally {
            if (requestIdList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(requestIdList);
            }
        }
    }

    private ArrayList getSelectedList() {
        this.selectedBill = new Vector();
        int iCount = this.tblMain.getRowCount();
        for (int i = 0; i < iCount; ++i) {
            String billID;
            Boolean selected = (Boolean)this.tblMain.getRow(i).getCell(COL_SELECTED).getValue();
            if (!Boolean.TRUE.equals(selected) || this.selectedBill.contains(billID = this.tblMain.getRow(i).getCell("id").getValue().toString())) continue;
            this.selectedBill.add(billID);
        }
        int iCount1 = this.selectedBill.size();
        if (iCount1 <= 0) {
            return null;
        }
        String[] billIDs = new String[iCount1];
        for (int i = 0; i < iCount1; ++i) {
            billIDs[i] = this.selectedBill.get(i).toString();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < billIDs.length; ++i) {
            list.add(billIDs[i]);
        }
        return list;
    }

    @Override
    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(true);
    }

    @Override
    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(false);
    }

    @Override
    public void actionViewImage_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            try {
                String navUrl = BillImageFacadeFactory.getRemoteInstance().getImageURL(BOSUuid.getBOSObjectType((String)id, (boolean)false).toString(), id);
                if (navUrl == null) {
                    throw new OtherBillBizException(OtherBillBizException.IMAGENOTREADY);
                }
                VersionUtil.gotoSite((String)navUrl, (boolean)true);
            }
            catch (Exception ex) {
                throw new OtherBillBizException(OtherBillBizException.IMAGENOTREADY);
            }
        }
    }

    protected void invokeMultiPrintFunction(boolean isPrint) {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        this.invokeMultiPrintFunction(idList, isPrint);
    }

    protected void invokeMultiPrintFunction(List idList, boolean isPrint) {
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        DefinitionNewDataProvider mainQueryData = new DefinitionNewDataProvider(idList, this.getTDQueryPK());
        data.putAbstractPrint("MainQuery", (AbstractPrintDataProvider)mainQueryData);
        SCMSlaveCommonDataProvider multiApproveViewQueryData = new SCMSlaveCommonDataProvider(idList, this.getMultiApproveViewQuery(), "billId");
        data.put("MultiApproveViewQuery", (BOSQueryDelegate)multiApproveViewQueryData);
        KDNoteHelper appHlp = new KDNoteHelper();
        BOSObjectType bosType = null;
        try {
            bosType = this.getBizInterface().getType();
            logger.info((Object)("current bostype:>>" + bosType.toString()));
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.remoteerror"));
            SysUtil.abort();
        }
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(bosType.toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)bosType, (List)idList, (String)this.getTDFileName(), (String)"com.kingdee.eas.scm.common.SCMResource", (boolean)false);
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getMultiApproveViewQuery() {
        return new MetaDataPK("com.kingdee.eas.base.multiapprove.app.MultiApproveViewQuery");
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fi.ar.app.ArVerificationBillDefPrintQuery");
    }

    protected String getTDFileName() {
        return "/FI/AR/ArVerificationBill";
    }
}

