/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.ar.client.AbstractVerifyDataFileUI;
import com.kingdee.eas.fi.ar.client.AccountBadDebtCustPrepareListUI;
import com.kingdee.eas.fi.ar.client.OtherBillListUI;
import com.kingdee.eas.fi.ar.client.VerificationBillListUI;
import com.kingdee.eas.fi.arap.client.ProxyBillListUI;
import com.kingdee.eas.tools.datatask.client.ServerTemplateExport;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class VerifyDataFileUI
extends AbstractVerifyDataFileUI {
    private static final Logger logger = CoreUIObject.getLogger(VerifyDataFileUI.class);
    private static final String RES = "com.kingdee.eas.scm.sd.sale.client.GTaxEasResource";
    private int closeType = -1;
    private SimpleFileFilter fileFilter = null;
    private File selectedFile = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnFileChooser.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
        this.btnFileChooser.setText(null);
        this.fileFilter = new SimpleFileFilter(new String[]{"txt", "xls", "csv"});
        Map uiCtx = this.getUIContext();
        this.selectedFile = (File)uiCtx.get("selectedFile");
        if (this.selectedFile != null && this.selectedFile.exists()) {
            this.txtFilePath.setText(this.selectedFile.getPath());
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        String sFile = this.txtFilePath.getText();
        this.selectedFile = new File(sFile);
        if (sFile == null || sFile.trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FileNull"));
            return;
        }
        if (!this.fileFilter.accept(this.selectedFile)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FileTypeWrong"));
            return;
        }
        if (!this.selectedFile.exists()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FileNotExist"));
            return;
        }
        this.closeType = 1;
        this.disposeUIWindow();
    }

    @Override
    protected void btnFileChooser_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter((FileFilter)this.fileFilter);
        if (this.selectedFile != null && this.selectedFile.length() > 0L) {
            fileChooser.setSelectedFile(this.selectedFile);
        }
        if (fileChooser.showOpenDialog((Component)((Object)this)) != 0) {
            return;
        }
        String sFile = fileChooser.getSelectedFile().getPath();
        this.selectedFile = fileChooser.getSelectedFile();
        this.txtFilePath.setText(sFile);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.closeType = -1;
        this.disposeUIWindow();
    }

    public File getSelectedFile() {
        if (this.closeType == -1) {
            return null;
        }
        return this.selectedFile;
    }

    @Override
    protected void btnExpTemplate_actionPerformed(ActionEvent e) throws Exception {
        String templateName = null;
        Object owner = this.getUIContext().get("Owner");
        if (owner != null) {
            if (owner instanceof ProxyBillListUI) {
                templateName = "EAS_5.2_2_ARAP_ProxyBill.xls";
            } else if (owner instanceof com.kingdee.eas.fi.ap.client.VerificationBillListUI || owner instanceof VerificationBillListUI) {
                templateName = "EAS_5.2_2_ARAP_Verification.xls";
            } else if (owner instanceof com.kingdee.eas.fi.ap.client.OtherBillListUI) {
                templateName = "EAS_5.2_2_ARAP_AP_OtherBill.xls";
            } else if (owner instanceof OtherBillListUI) {
                templateName = "EAS_5.2_2_ARAP_AR_OtherBill.xls";
            } else if (owner instanceof AccountBadDebtCustPrepareListUI) {
                templateName = "EAS_5.2_2_ARAP_CustPrepare.xls";
            }
        }
        if (templateName != null) {
            ServerTemplateExport te = new ServerTemplateExport("ARAPTemplate/" + templateName);
            te.setParentComp((Component)((Object)this));
            try {
                te.export();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        return super.getMetaDataPK();
    }
}

