/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.contrastGLDefaultSol;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.PermissionChecker;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.BlankPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.CommonQueryPanel;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.NewSolutionListPanel;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.NewSolutionPromptUI;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.QueryTreePanel;
import com.kingdee.eas.framework.bireport.BireportBaseFacadeFactory;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CommonLeftPanel
extends KDPanel {
    private CommonQueryPanel commonQueryPanel;
    private KDWorkButton deleteButton = new KDWorkButton();
    private static final Logger logger = Logger.getLogger(CommonLeftPanel.class);
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.cqResource";
    private static final String toolBarRes = "com.kingdee.eas.base.commonquery.client.ToolBar";
    KDTabbedPane tabbedPane = new KDTabbedPane();
    KDWorkButton saveButton = new KDWorkButton();
    private static final int MY_SOLUTION_INDEX = 0;
    private static final int QUERY_TREE_PANEL_INDEX = 2;
    private static final int FULL_TABBED_COUNT = 3;
    NewSolutionListPanel mySolutionListPanel;
    private int SPACE = 3;
    private int BUTTON_HEIGHT = 22;
    private QueryTreePanel queryTreePanel = null;

    public CommonQueryPanel getCommonQueryPanel() {
        return this.commonQueryPanel;
    }

    public CommonLeftPanel(CommonQueryPanel commonQueryPanel) {
        this.commonQueryPanel = commonQueryPanel;
        this.init();
    }

    private String getCQResource(String resName) {
        return EASResource.getString((String)commonQueryRes, (String)resName);
    }

    private void init() {
        this.mySolutionListPanel = new NewSolutionListPanel(this.commonQueryPanel, "mysolutionlist");
        this.mySolutionListPanel.setCommonLeftPanel(this);
        this.tabbedPane.add(this.getCQResource("mySolution"), (Component)((Object)this.mySolutionListPanel));
        this.tabbedPane.add(this.getCQResource("sharedSolution"), (Component)new BlankPanel(QueryPanelTypeEnum.SHARED_SOLUTION_PANEL));
        this.tabbedPane.add(this.getCQResource("candidateCondition"), (Component)new BlankPanel(QueryPanelTypeEnum.CANDIDATE_CONDITION_PANEL));
        this.tabbedPane.setForcedHide(true);
        this.tabbedPane.setBounds(this.SPACE, 0, this.getCommonQueryPanel().getLeftPanelWidth() - this.SPACE * 2, this.getCommonQueryPanel().getLeftPanelHeight() - this.SPACE * 3 - this.BUTTON_HEIGHT);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CommonLeftPanel.this.delayLoadPanel();
                Component com = CommonLeftPanel.this.tabbedPane.getSelectedComponent();
                if (com instanceof NewSolutionListPanel) {
                    NewSolutionListPanel selectedSolutionList = (NewSolutionListPanel)((Object)com);
                    QuerySolutionInfo info = CommonLeftPanel.this.getSelectedSolution();
                    if (info == null) {
                        selectedSolutionList.selectDefaultSolution();
                        if (CommonLeftPanel.this.getSelectedSolution() == null) {
                            CommonLeftPanel.this.setDeleteButtonEnable(false);
                        }
                    } else {
                        try {
                            selectedSolutionList.loadSolution(CommonLeftPanel.this.getSelectedSolution());
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                            ExceptionHandler.handle((Throwable)e);
                        }
                    }
                    CommonLeftPanel.this.saveButton.setEnabled(selectedSolutionList.isMySolutionList());
                    CommonLeftPanel.this.getCommonQueryPanel().setDefaultViewVisible(selectedSolutionList.isMySolutionList());
                }
            }
        });
        this.add((Component)this.tabbedPane);
        this.saveButton.setText(this.getCQResource("saveSolution"));
        this.deleteButton.setText(this.getCQResource("deleteSolutin"));
        this.saveButton.setBounds(10, 313, 120, this.BUTTON_HEIGHT);
        this.deleteButton.setBounds(140, 313, 130, this.BUTTON_HEIGHT);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonLeftPanel.this.saveSolution(e);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonLeftPanel.this.deleteSolution(e);
            }
        });
        this.add((Component)this.saveButton);
        this.add((Component)this.deleteButton);
    }

    public void delayLoadPanel() {
        Component com = this.tabbedPane.getSelectedComponent();
        if (com instanceof BlankPanel) {
            QueryTreePanel queryTreePanel;
            BlankPanel blankPanel = (BlankPanel)com;
            if (QueryPanelTypeEnum.SHARED_SOLUTION_PANEL.equals((Object)blankPanel.getQueryPanelType())) {
                NewSolutionListPanel sharedSolutionListPanel = this.getSharedSolutionListPanel();
                this.tabbedPane.setComponentAt(this.tabbedPane.getSelectedIndex(), (Component)((Object)sharedSolutionListPanel));
            } else if (QueryPanelTypeEnum.CANDIDATE_CONDITION_PANEL.equals((Object)blankPanel.getQueryPanelType()) && (queryTreePanel = this.getQueryTreePanel()) != null) {
                this.tabbedPane.setComponentAt(this.tabbedPane.getSelectedIndex(), (Component)((Object)queryTreePanel));
            }
        }
    }

    private QueryTreePanel getQueryTreePanel() {
        if (this.queryTreePanel == null) {
            this.queryTreePanel = QueryTreePanel.createInstance(this.commonQueryPanel);
        }
        return this.queryTreePanel;
    }

    private NewSolutionListPanel getSharedSolutionListPanel() {
        NewSolutionListPanel sharedSolutionListPanel = new NewSolutionListPanel(this.commonQueryPanel, "sharedsolutionlist");
        sharedSolutionListPanel.setCommonLeftPanel(this);
        return sharedSolutionListPanel;
    }

    public void setQueryTreePanelVisible(boolean isVisible) {
        if (isVisible) {
            if (this.tabbedPane.getTabCount() < 3) {
                this.tabbedPane.add(this.getCQResource("candidateCondition"), (Component)new BlankPanel(QueryPanelTypeEnum.CANDIDATE_CONDITION_PANEL));
            }
        } else if (this.tabbedPane.getTabCount() == 3) {
            this.tabbedPane.remove(2);
            if (this.getSelectedSolution() == null) {
                return;
            }
            ShareTypeEnum shareType = this.getSelectedSolution().getShareType();
            if (ShareTypeEnum.USER_LEVEL.equals((Object)shareType) || ShareTypeEnum.USER_NOORG_LEVEL.equals((Object)shareType)) {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
    }

    public void setDeleteButtonEnable(boolean isEnable) {
        this.deleteButton.setEnabled(isEnable);
    }

    public void saveSolution(ActionEvent e) {
        ActionCache.clear();
        if (!this.commonQueryPanel.verify()) {
            return;
        }
        QuerySolutionCollection querySolutionCol = this.getMyQuerySolutions();
        QuerySolutionInfo info = null;
        QuerySolutionInfo defaultSolution = null;
        for (int i = 0; i < querySolutionCol.size(); ++i) {
            info = querySolutionCol.get(i);
            if (!this.isDefaultSoltion(info, false)) continue;
            defaultSolution = info;
            break;
        }
        QuerySolutionInfo querySolutionInfo = this.showSolutionDialog(defaultSolution);
        ShareTypeEnum shareType = this.getSelectedSolution().getShareType();
        String solutionListType = this.getSolutionPanelType(shareType);
        this.refreshSolutionList(solutionListType);
        this.setSelectDefaultSolution(querySolutionInfo);
    }

    protected QuerySolutionCollection getMyQuerySolutions() {
        String queryName = this.commonQueryPanel.getQueryPK().getFullName();
        String parentUI = this.commonQueryPanel.getParentUIClassName();
        QuerySolutionCollection ret = null;
        try {
            ret = QuerySolutionUtils.getUserAndUserOrgQuerySolutions(null, (String)parentUI, (String)queryName);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ret = new QuerySolutionCollection();
            ExceptionHandler.handle((Throwable)e);
        }
        return ret;
    }

    private boolean isDefaultSoltion(QuerySolutionInfo info, boolean isFullQuery) {
        if (!isFullQuery && info.getId() != null && SolutionTypeEnum.SYSTEM_SOLUTION != info.getSolutionType()) {
            try {
                info = QuerySolutionUtils.getFullQuerySolution(null, (String)info.getId().toString());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        QueryPanelCollection queryPanelColl = info.getQueryPanelInfo();
        for (int i = 0; i < queryPanelColl.size(); ++i) {
            QueryPanelInfo queryPanelInfo = queryPanelColl.get(i);
            if (queryPanelInfo == null || queryPanelInfo.getCustomerParams() == null || !queryPanelInfo.getQueryPanelType().equals((Object)QueryPanelTypeEnum.CUSTOMER_PANEL)) continue;
            String customerParams = queryPanelInfo.getCustomerParams();
            CustomerParams cp = new CustomerParams();
            try {
                cp = XMLBean.transStrToCommonCustParams((String)customerParams);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (cp == null) continue;
            boolean isDefaultSolution = cp.getBoolean("isDefaultSolution");
            return isDefaultSolution;
        }
        return false;
    }

    private String getSolutionPanelType(ShareTypeEnum shareType) {
        String solutionListType = "mysolutionlist";
        if (ShareTypeEnum.ORG_LEVEL.equals((Object)shareType)) {
            solutionListType = "sharedsolutionlist";
        }
        return solutionListType;
    }

    public void refreshSolutionList() {
        Component selectedPanel = this.tabbedPane.getSelectedComponent();
        if (selectedPanel instanceof NewSolutionListPanel) {
            ((NewSolutionListPanel)((Object)selectedPanel)).refreshSolutionList();
        }
    }

    public void refreshSolutionList(String solutionListType) {
        int count = this.tabbedPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            NewSolutionListPanel solutionListPanel;
            Component component = this.tabbedPane.getComponentAt(i);
            if (!(component instanceof NewSolutionListPanel) || !solutionListType.equals((solutionListPanel = (NewSolutionListPanel)((Object)component)).getSolutionListType())) continue;
            solutionListPanel.refreshSolutionList();
            break;
        }
    }

    public void deleteSolution(ActionEvent e) {
        int flag;
        boolean hasQueryManagePerm;
        ActionCache.clear();
        QuerySolutionInfo currentSolution = this.getSelectedSolution();
        if (currentSolution == null) {
            this.getCommonQueryPanel().showInfo(this.getCQResource("PleaseSelectSolution"), "warn");
            SysUtil.abort();
        }
        if (!SysContext.getSysContext().getCurrentUserInfo().getId().equals((Object)currentSolution.getOwner()) && !(hasQueryManagePerm = PermissionChecker.hasEditOtherCQSolutionPerm(null))) {
            this.commonQueryPanel.showInfo(this.getCQResource("canNotDeleteOthers"), "warn");
            SysUtil.abort();
        }
        if ((flag = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"delWarning"))) == 0) {
            if (this.delSolution(currentSolution)) {
                this.commonQueryPanel.showInfo(EASResource.getString((String)toolBarRes, (String)"delSolutionSucceed"), "info");
                this.getCommonQueryPanel().setCurrentSolution(null);
                this.refreshSolutionList(this.getSolutionPanelType(currentSolution.getShareType()));
                this.setSelectDefaultSolution(null);
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"delSolutionWarning"));
            }
        }
    }

    private void setSelectDefaultSolution(QuerySolutionInfo selectSolution) {
        Component selectedCom = this.tabbedPane.getSelectedComponent();
        if (selectedCom instanceof NewSolutionListPanel) {
            if (selectSolution == null) {
                ((NewSolutionListPanel)((Object)selectedCom)).selectDefaultSolution();
            } else {
                ((NewSolutionListPanel)((Object)selectedCom)).setSelected(selectSolution);
            }
        }
    }

    private QuerySolutionInfo getSelectedSolution() {
        QuerySolutionInfo ret = null;
        Component selectedPanel = this.tabbedPane.getSelectedComponent();
        if (selectedPanel instanceof NewSolutionListPanel) {
            NewSolutionListPanel solutionListPanel = (NewSolutionListPanel)((Object)selectedPanel);
            ret = solutionListPanel.getSelectedQuerySolutionInfo();
        } else {
            ret = this.getCommonQueryPanel().getCurrentSolution();
        }
        return ret;
    }

    private boolean delSolution(QuerySolutionInfo delSolution) {
        try {
            if (SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)delSolution.getSolutionType())) {
                return false;
            }
            String solutionID = delSolution.getId().toString();
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            ObjectUuidPK iObjectPK = new ObjectUuidPK(solutionID);
            iQuerySolution.delete((IObjectPK)iObjectPK);
            this.deletePrintSolutionInfo(solutionID);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePrintSolutionInfo(String solutionId) {
        StringBuffer sql = new StringBuffer();
        sql.append("IF EXISTS(SELECT * FROM  KSQL_USERTABLES WHERE KSQL_TABNAME='t_bg_bganalyseconfig') delete from t_bg_bganalyseconfig where fid = '");
        sql.append(solutionId);
        sql.append("'");
        try {
            IBireportBaseFacade iBireportBaseFacade = BireportBaseFacadeFactory.getRemoteInstance();
            if (iBireportBaseFacade == null) {
                throw new NullPointerException();
            }
            iBireportBaseFacade.executeUpdate(sql.toString(), null);
        }
        catch (EASBizException ex) {
            logger.info((Object)"error!", (Throwable)ex);
        }
        catch (BOSException e) {
            logger.info((Object)"error!", (Throwable)e);
        }
    }

    private QuerySolutionInfo showSolutionDialog(QuerySolutionInfo defaultSolution) {
        UIContext uiContext = new UIContext((Object)this.getCommonQueryPanel().getParentUI());
        QuerySolutionInfo selectedSolution = this.getSelectedSolution();
        if (selectedSolution == null) {
            this.getCommonQueryPanel().showInfo(this.getCQResource("PleaseSelectSolution"), "warn");
            SysUtil.abort();
        }
        if (selectedSolution.getId() != null) {
            try {
                selectedSolution = QuerySolutionUtils.getFullQuerySolution(null, (String)selectedSolution.getId().toString());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        uiContext.put((Object)"current_solution", (Object)selectedSolution);
        uiContext.put((Object)"commonquerypanel", (Object)this.getCommonQueryPanel());
        uiContext.put((Object)"commonleftpanel", (Object)this);
        uiContext.put((Object)"defaultSolution", (Object)defaultSolution);
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create(NewSolutionPromptUI.class.getName(), (Map)uiContext, null, "");
            window.show();
            QuerySolutionInfo resultQuerySolution = (QuerySolutionInfo)window.getUIObject().getUIContext().get("ResultSolution");
            return resultQuerySolution;
        }
        catch (UIException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public NewSolutionListPanel getMySolutionListPanel() {
        return this.mySolutionListPanel;
    }

    public Component getSelectedPanel() {
        Component selectedPanel = null;
        if (this.tabbedPane != null) {
            selectedPanel = this.tabbedPane.getSelectedComponent();
        }
        return selectedPanel;
    }

    public boolean isMySolutionListPanelSelected() {
        NewSolutionListPanel newSolutionListPanel;
        String solutionListType;
        boolean isSelected = false;
        Component selectedPanel = this.tabbedPane.getSelectedComponent();
        if (selectedPanel != null && selectedPanel instanceof NewSolutionListPanel && "mysolutionlist".equals(solutionListType = (newSolutionListPanel = (NewSolutionListPanel)((Object)selectedPanel)).getSolutionListType())) {
            isSelected = true;
        }
        return isSelected;
    }

    public boolean isShareSolutionListPanelSelected() {
        NewSolutionListPanel newSolutionListPanel;
        String solutionListType;
        boolean isSelected = false;
        Component selectedPanel = this.tabbedPane.getSelectedComponent();
        if (selectedPanel != null && selectedPanel instanceof NewSolutionListPanel && "sharedsolutionlist".equals(solutionListType = (newSolutionListPanel = (NewSolutionListPanel)((Object)selectedPanel)).getSolutionListType())) {
            isSelected = true;
        }
        return isSelected;
    }
}

