/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.ArApCalculateException;
import com.kingdee.eas.fi.arap.client.util.ArApBillUICalculate;
import com.kingdee.eas.fi.arap.client.util.CalculateUICondition;
import com.kingdee.eas.fi.arap.util.CalculateCondition;
import java.math.BigDecimal;

public class ArBillUICalculate
extends ArApBillUICalculate {
    protected BigDecimal badAmount;
    protected BigDecimal badAmountLocal;
    protected BigDecimal preparedBadAmount;
    protected BigDecimal preparedBadAmountLocal;

    public ArBillUICalculate(CalculateUICondition condition) {
        super(condition);
    }

    @Override
    protected void updateData() {
        super.updateData();
        CalculateUICondition cdt = (CalculateUICondition)this.getCondition();
        if (cdt.isPresent()) {
            cdt.getKdtEntry().getCell(cdt.getRowIndex(), "localUnwriteOffAmount").setValue((Object)ZERO);
            cdt.getKdtEntry().getCell(cdt.getRowIndex(), "localWrittenOffAmount").setValue((Object)this.amountLocal);
        } else if (cdt.isTransBill()) {
            IRow row;
            KDTable table = cdt.getKdtEntry();
            if (table != null && (row = cdt.getKdtEntry().getRow(cdt.getRowIndex())) != null) {
                if (row.getCell("localUnwriteOffAmount") != null) {
                    row.getCell("localUnwriteOffAmount").setValue((Object)ZERO);
                }
                if (row.getCell("localWrittenOffAmount") != null) {
                    row.getCell("localWrittenOffAmount").setValue((Object)this.amountLocal);
                }
            }
        } else {
            if (cdt.getKdtEntry().getCell(cdt.getRowIndex(), "localUnwriteOffAmount") != null) {
                cdt.getKdtEntry().getCell(cdt.getRowIndex(), "localUnwriteOffAmount").setValue((Object)this.amountLocal);
            }
            if (cdt.getKdtEntry().getCell(cdt.getRowIndex(), "localWrittenOffAmount") != null) {
                cdt.getKdtEntry().getCell(cdt.getRowIndex(), "localWrittenOffAmount").setValue((Object)ZERO);
            }
        }
        if (this.condition.isAR() && !this.condition.isVerifyAmountChanged()) {
            this.setCellValueByName("badAmount", ZERO);
            this.setCellValueByName("badAmountLocal", ZERO);
            this.setCellValueByName("preparedBadAmount", ZERO);
            this.setCellValueByName("preparedBadAmountLocal", ZERO);
        } else {
            this.setCellValueByName("badAmount", this.badAmount);
            this.setCellValueByName("badAmountLocal", this.badAmountLocal);
            this.setCellValueByName("preparedBadAmount", this.preparedBadAmount);
            this.setCellValueByName("preparedBadAmountLocal", this.preparedBadAmountLocal);
        }
        if (VerificateBillTypeEnum.ApAgentBizBill.equals((Object)cdt.getSourceBillType()) || VerificateBillTypeEnum.ArAgentBizBill.equals((Object)cdt.getSourceBillType())) {
            cdt.getKdtEntry().getCell(cdt.getRowIndex(), "unwriteOffBaseQty").setValue((Object)ZERO);
            cdt.getKdtEntry().getCell(cdt.getRowIndex(), "wittenOffBaseQty").setValue((Object)this.baseQty);
            cdt.getKdtEntry().getCell(cdt.getRowIndex(), "localUnwriteOffAmount").setValue((Object)ZERO);
            cdt.getKdtEntry().getCell(cdt.getRowIndex(), "localWrittenOffAmount").setValue((Object)this.amountLocal);
        }
    }

    @Override
    protected boolean simpleCalculate(CalculateCondition cditn) throws ArApCalculateException {
        if (!super.simpleCalculate(cditn)) {
            return false;
        }
        if (cditn.isBadAmountChanged()) {
            this.badAmountLocal = this.calLocalAmount(this.badAmount);
            if (ArBillUICalculate.isNegative(this.verifyAmount.subtract(this.badAmount)) || ArBillUICalculate.isNegative(this.verifyAmountLocal.subtract(this.badAmountLocal))) {
                this.badAmount = ZERO;
                this.badAmountLocal = ZERO;
                throw new ArApCalculateException(ArApCalculateException.BADAMOUNT_INVALID);
            }
        } else if (cditn.isBadAmountLocalChanged()) {
            if (ArBillUICalculate.isNegative(this.verifyAmountLocal.subtract(this.badAmountLocal))) {
                this.badAmountLocal = ZERO;
                throw new ArApCalculateException(ArApCalculateException.BADAMOUNT_INVALID);
            }
        } else if (cditn.isPreparedBadAmountChanged()) {
            this.preparedBadAmountLocal = this.calLocalAmount(this.preparedBadAmount);
            if (ArBillUICalculate.isNegative(this.unVerifyAmount.subtract(this.preparedBadAmount)) || ArBillUICalculate.isNegative(this.unVerifyAmountLocal.subtract(this.preparedBadAmountLocal))) {
                this.preparedBadAmount = ZERO;
                this.preparedBadAmountLocal = ZERO;
                throw new ArApCalculateException(ArApCalculateException.PREPAREDBADAMOUNT_INVALID);
            }
        } else if (cditn.isPreparedBadAmountLocalChanged()) {
            if (ArBillUICalculate.isNegative(this.unVerifyAmountLocal.subtract(this.preparedBadAmountLocal))) {
                this.preparedBadAmountLocal = ZERO;
                throw new ArApCalculateException(ArApCalculateException.PREPAREDBADAMOUNT_INVALID);
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    protected void initData() {
        super.initData();
        this.badAmount = this.getBigDecimal("badAmount");
        this.badAmountLocal = this.getBigDecimal("badAmountLocal");
        this.preparedBadAmount = this.getBigDecimal("preparedBadAmount");
        this.preparedBadAmountLocal = this.getBigDecimal("preparedBadAmountLocal");
    }
}

