/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public abstract class BizSysPeriodHelper {
    private TreeMap periodCache;
    private boolean fMax2CurrentPeriod = false;

    public BizSysPeriodHelper(boolean fCurrentPeriod) {
        this.fMax2CurrentPeriod = fCurrentPeriod;
    }

    public abstract SystemEnum getSystemEnum();

    public PeriodInfo getStartPeriod(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo startPeriod = null;
        if (!companyInfo.isIsOnlyUnion()) {
            startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)this.getSystemEnum(), (CompanyOrgUnitInfo)companyInfo);
        }
        return startPeriod;
    }

    public PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = null;
        currentPeriod = companyInfo.isIsOnlyUnion() ? PeriodUtils.getPeriodInfo((Date)new Date(), (CompanyOrgUnitInfo)companyInfo) : SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)this.getSystemEnum(), (CompanyOrgUnitInfo)companyInfo);
        return currentPeriod;
    }

    public void periodNumChange(KDSpinner fromSpinner, KDSpinner toSpinner) throws Exception {
        Integer to;
        Integer from = (Integer)fromSpinner.getValue();
        if (from.compareTo(to = (Integer)toSpinner.getValue()) > 0) {
            toSpinner.setValue((Object)from);
        } else if (to.compareTo(from) < 0) {
            fromSpinner.setValue((Object)to);
        }
    }

    public void initPeriodSpinner(KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner) throws NumberFormatException, EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.initPeriodSpinner(companyInfo, beginYearSpinner, beginPeriodSpinner);
    }

    public void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner, ArApSysParamInfo sysInfo) throws EASBizException, BOSException {
        this.initPeriodSpinner(companyInfo, beginYearSpinner, beginPeriodSpinner, sysInfo, false);
    }

    public void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner, ArApSysParamInfo sysInfo, boolean isGreaterCurrentPeriod) throws EASBizException, BOSException {
        PeriodInfo currPeriod;
        PeriodInfo periodInfo = currPeriod = sysInfo != null ? sysInfo.getCurrentPeriod(this.getSystemEnum()) : this.getCurrentPeriod(companyInfo);
        if (currPeriod == null) {
            throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
        }
        if (isGreaterCurrentPeriod) {
            this.initYearSpinner(companyInfo, beginYearSpinner, sysInfo, currPeriod, isGreaterCurrentPeriod);
        } else {
            this.initYearSpinner(companyInfo, beginYearSpinner, sysInfo);
        }
        if (isGreaterCurrentPeriod) {
            this.setPeriodNum(companyInfo, beginPeriodSpinner, beginYearSpinner, currPeriod, isGreaterCurrentPeriod);
        } else {
            this.setPeriodNum(companyInfo, beginPeriodSpinner, beginYearSpinner);
        }
        if (currPeriod != null) {
            beginYearSpinner.setValue((Object)new Integer(currPeriod.getPeriodYear()));
            beginPeriodSpinner.setValue((Object)new Integer(currPeriod.getPeriodNumber()));
        }
    }

    public void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner) throws EASBizException, BOSException {
        this.initPeriodSpinner(companyInfo, beginYearSpinner, beginPeriodSpinner, null);
    }

    public void initPeriodSpinner(KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner, KDSpinner endYearSpinner, KDSpinner endPeriodSpinner) throws NumberFormatException, EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.initPeriodSpinner(companyInfo, beginYearSpinner, beginPeriodSpinner, endYearSpinner, endPeriodSpinner);
    }

    public void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner, KDSpinner endYearSpinner, KDSpinner endPeriodSpinner) throws EASBizException, BOSException {
        this.initPeriodSpinner(companyInfo, beginYearSpinner, beginPeriodSpinner, endYearSpinner, endPeriodSpinner, null);
    }

    public void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner, KDSpinner endYearSpinner, KDSpinner endPeriodSpinner, ArApSysParamInfo sysInfo) throws EASBizException, BOSException {
        PeriodInfo currPeriod = sysInfo != null ? sysInfo.getCurrentPeriod(this.getSystemEnum()) : this.getCurrentPeriod(companyInfo);
        this.initYearSpinner(companyInfo, beginYearSpinner, sysInfo);
        this.initYearSpinner(companyInfo, endYearSpinner, sysInfo);
        this.setPeriodNum(companyInfo, beginPeriodSpinner, beginYearSpinner);
        this.setPeriodNum(companyInfo, endPeriodSpinner, endYearSpinner);
        if (currPeriod != null) {
            beginYearSpinner.setValue((Object)new Integer(currPeriod.getPeriodYear()));
            beginPeriodSpinner.setValue((Object)new Integer(currPeriod.getPeriodNumber()));
            endYearSpinner.setValue((Object)new Integer(currPeriod.getPeriodYear()));
            endPeriodSpinner.setValue((Object)new Integer(currPeriod.getPeriodNumber()));
        }
    }

    private PeriodCollection getPeriodc(CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("accountPeriodType.id"));
            selectors.add(new SelectorItemInfo("isOnlyUnion"));
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), selectors);
        }
        if (this.fMax2CurrentPeriod) {
            return this.getPeriodsMax2Current(companyInfo, sysInfo);
        }
        return this.getCompanyAllPeriods(companyInfo, sysInfo);
    }

    private PeriodCollection getCompanyAllPeriods(CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        boolean fBizUnit = !companyInfo.isIsOnlyUnion();
        PeriodInfo startPeriod = null;
        if (fBizUnit) {
            PeriodInfo periodInfo = startPeriod = sysInfo != null ? sysInfo.getStartPeriod(this.getSystemEnum()) : this.getStartPeriod(companyInfo);
            if (startPeriod == null) {
                throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (fBizUnit) {
            filterItems.add(new FilterItemInfo("beginDate", (Object)startPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo("endDate", (Object)startPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
        }
        filterItems.add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(0)));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    private PeriodCollection getPeriodsMax2Current(CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws BOSException, EASBizException {
        PeriodInfo PeriodTo;
        PeriodInfo PeriodFrom;
        boolean fBizUnit = !companyInfo.isIsOnlyUnion();
        Date dateFrom = null;
        if (fBizUnit) {
            PeriodInfo startPeriod;
            PeriodInfo periodInfo = startPeriod = sysInfo != null ? sysInfo.getStartPeriod(this.getSystemEnum()) : this.getStartPeriod(companyInfo);
            if (startPeriod == null) {
                throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
            }
            dateFrom = startPeriod.getBeginDate();
        } else {
            PeriodInfo compFirstPeriod = this.getFirstPeriodInfo(companyInfo);
            if (compFirstPeriod == null) {
                throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
            }
            dateFrom = compFirstPeriod.getBeginDate();
        }
        PeriodInfo currentPeriod = sysInfo != null ? sysInfo.getCurrentPeriod(this.getSystemEnum()) : this.getCurrentPeriod(companyInfo);
        Timestamp dateTo = currentPeriod.getEndDate();
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (fBizUnit) {
            filterItems.add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateFrom), CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateTo), CompareType.LESS_EQUALS));
            filterItems.add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateFrom), CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateTo), CompareType.LESS_EQUALS));
        }
        filterItems.add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(0)));
        if (fBizUnit) {
            filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 and #5 ");
        } else {
            filter.setMaskString("(#0 and #1) and #2 and #3 ");
        }
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0 && (PeriodFrom = PeriodUtils.getPeriodInfo(null, (Date)dateFrom, (CompanyOrgUnitInfo)companyInfo)).equals((Object)(PeriodTo = PeriodUtils.getPeriodInfo(null, (Date)dateTo, (CompanyOrgUnitInfo)companyInfo)))) {
            periodc.add(PeriodTo);
        }
        return periodc;
    }

    public static boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod == null || periodInfo == null) {
            return false;
        }
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    private void cachePeriod(CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws EASBizException, BOSException {
        if (this.periodCache == null) {
            this.periodCache = new TreeMap();
        }
        TreeMap<Integer, PeriodCollection> result = new TreeMap<Integer, PeriodCollection>();
        PeriodCollection pc = this.getPeriodc(companyInfo, sysInfo);
        for (PeriodInfo pi : pc) {
            PeriodCollection tmpPc;
            Integer year = new Integer(pi.getPeriodYear());
            if (!result.containsKey(year)) {
                tmpPc = new PeriodCollection();
                tmpPc.add(pi);
                result.put(year, tmpPc);
                continue;
            }
            tmpPc = (PeriodCollection)result.get(year);
            tmpPc.add(pi);
        }
        this.periodCache.put(new ObjectUuidPK(companyInfo.getId()), result);
    }

    public void initYearSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner yearSpinner, ArApSysParamInfo sysInfo) throws EASBizException, BOSException {
        this.initYearSpinner(companyInfo, yearSpinner, sysInfo, null, false);
    }

    public void initYearSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner yearSpinner, ArApSysParamInfo sysInfo, PeriodInfo currPeriod, boolean isGreaterCurrentPeriod) throws EASBizException, BOSException {
        TreeMap yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, sysInfo);
        }
        if ((yearMap = (TreeMap)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            yearSpinner.setEnabled(false);
            return;
        }
        int begin = 1;
        if (isGreaterCurrentPeriod) {
            if (currPeriod == null) {
                throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
            }
            begin = currPeriod.getPeriodYear();
        } else {
            begin = (Integer)yearMap.firstKey();
        }
        int end = (Integer)yearMap.lastKey();
        if (begin == end) {
            yearSpinner.setValue((Object)new Integer(begin));
            yearSpinner.setEnabled(false);
            return;
        }
        SpinnerNumberModel model = new SpinnerNumberModel(begin, begin, end, 1);
        yearSpinner.setModel((SpinnerModel)model);
    }

    public SpinnerNumberModel getYearSnm(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, null);
        }
        if ((yearMap = (TreeMap)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        int begin = (Integer)yearMap.firstKey();
        int end = (Integer)yearMap.lastKey();
        begin = !companyInfo.isIsOnlyUnion() ? this.getStartPeriod(companyInfo).getPeriodYear() : this.getFirstPeriodInfo(companyInfo).getPeriodYear();
        SpinnerNumberModel result = null;
        result = new SpinnerNumberModel(begin, begin, end, 1);
        return result;
    }

    public SpinnerNumberModel getMonthSnm(CompanyOrgUnitInfo companyInfo, Integer year) throws EASBizException, BOSException {
        return this.getMonthSnm(companyInfo, year, false);
    }

    public SpinnerNumberModel getMonthSnm(CompanyOrgUnitInfo companyInfo, Integer year, boolean isGreaterCurrentPeriod) throws EASBizException, BOSException {
        TreeMap yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, null);
        }
        if ((yearMap = (TreeMap)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        PeriodCollection pc = (PeriodCollection)yearMap.get(year);
        int begin = 1;
        int end = 1;
        if (pc != null && pc.get(0) != null) {
            if (isGreaterCurrentPeriod) {
                PeriodInfo currPeriodInfo = this.getCurrentPeriod(companyInfo);
                if (currPeriodInfo == null) {
                    throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
                }
                begin = currPeriodInfo.getPeriodYear() == year.intValue() ? currPeriodInfo.getPeriodNumber() : pc.get(0).getPeriodNumber();
            } else {
                begin = pc.get(0).getPeriodNumber();
            }
        }
        if (pc != null && pc.get(pc.size() - 1) != null) {
            end = pc.get(pc.size() - 1).getPeriodNumber();
        }
        SpinnerNumberModel result = new SpinnerNumberModel(begin, begin, end, 1);
        return result;
    }

    public void setPeriodNum(CompanyOrgUnitInfo companyInfo, KDSpinner spMonth, KDSpinner spYear) throws EASBizException, BOSException {
        this.setPeriodNum(companyInfo, spMonth, spYear, null, false);
    }

    public void setPeriodNum(CompanyOrgUnitInfo companyInfo, KDSpinner spMonth, KDSpinner spYear, PeriodInfo currPeriod, boolean isGreaterCurrentPeriod) throws EASBizException, BOSException {
        Integer preYear;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, null);
        }
        int curValue = Integer.parseInt(spMonth.getValue().toString());
        TreeMap yearMap = (TreeMap)this.periodCache.get(companyPK);
        if (yearMap == null || yearMap.isEmpty()) {
            spYear.setEnabled(false);
            spMonth.setEnabled(false);
            return;
        }
        Integer year = spYear.getIntegerVlaue();
        PeriodCollection pc = (PeriodCollection)yearMap.get(year);
        if (pc == null || pc.size() == 0) {
            SysUtil.abort();
        }
        boolean fGtPre = (preYear = (Integer)spYear.getPreviousValue()) == null || preYear.compareTo(year) < 0;
        int begin = 1;
        if (isGreaterCurrentPeriod) {
            if (currPeriod == null) {
                throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
            }
            begin = currPeriod.getPeriodYear() == year.intValue() ? currPeriod.getPeriodNumber() : pc.get(0).getPeriodNumber();
        } else {
            begin = pc.get(0).getPeriodNumber();
        }
        int end = pc.get(pc.size() - 1).getPeriodNumber();
        SpinnerNumberModel model = null;
        spMonth.setEnabled(true);
        if (curValue < begin || curValue > end) {
            curValue = fGtPre ? begin : end;
        }
        model = new SpinnerNumberModel(curValue, begin, end, 1);
        spMonth.setModel((SpinnerModel)model);
    }

    public void periodChange(KDSpinner spYearFrom, KDSpinner spNumberFrom, KDSpinner spYearTo, KDSpinner spNumberTo, boolean fNumberChange) {
        Integer yearFrom = (Integer)spYearFrom.getValue();
        Integer yearTo = (Integer)spYearTo.getValue();
        Integer numberFrom = (Integer)spNumberFrom.getValue();
        Integer numberTo = (Integer)spNumberTo.getValue();
        if (yearFrom.compareTo(yearTo) > 0) {
            spYearTo.setValue((Object)yearFrom);
            spNumberTo.setValue((Object)numberFrom);
            return;
        }
        if (yearFrom.compareTo(yearTo) == 0 && fNumberChange && numberFrom.compareTo(numberTo) > 0) {
            spNumberTo.setValue((Object)numberFrom);
            return;
        }
    }

    public PeriodInfo getPeriodInfo(int year, int periodNumber, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        Map yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, null);
        }
        if ((yearMap = (Map)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(year));
        if (pc == null || pc.size() == 0) {
            return null;
        }
        if (pc.get(periodNumber - 1) != null && pc.get(periodNumber - 1).getPeriodNumber() == periodNumber) {
            return pc.get(periodNumber - 1);
        }
        PeriodInfo info = null;
        for (int i = 0; i < pc.size(); ++i) {
            info = pc.get(i);
            if (info.getPeriodNumber() != periodNumber) continue;
            return info;
        }
        return null;
    }

    public PeriodInfo getFirstPeriodInfo(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, null);
        }
        if ((yearMap = (TreeMap)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        int first = (Integer)yearMap.firstKey();
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(first));
        if (pc == null) {
            return null;
        }
        return pc.get(0);
    }

    public PeriodInfo getPrePeriodInfo(CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        Map yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, null);
        }
        if ((yearMap = (Map)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        PeriodCollection pc = null;
        if (period.getPeriodNumber() == 1) {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() - 1));
            if (pc != null && pc.size() > 0) {
                return pc.get(pc.size() - 1);
            }
        } else {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear()));
        }
        if (pc == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == 0) {
                return null;
            }
            return pc.get(i - 1);
        }
        return null;
    }

    public PeriodInfo getNextPeriodInfo(CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        Map yearMap;
        if (period == null) {
            return null;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, null);
        }
        if ((yearMap = (Map)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear()));
        if (pc == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == pc.size() - 1) {
                pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() + 1));
                if (pc == null) {
                    return null;
                }
                return pc.get(0);
            }
            return pc.get(i + 1);
        }
        return null;
    }

    public PeriodInfo getLastPeriodInfo(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, null);
        }
        if ((yearMap = (TreeMap)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        int end = (Integer)yearMap.lastKey();
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(end));
        if (pc == null) {
            return null;
        }
        return pc.get(pc.size() - 1);
    }

    public PeriodCollection getPeriods(int fromYear, int fromNum, int toYear, int toNum, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        return this.getPeriods(fromYear, fromNum, toYear, toNum, companyInfo, null);
    }

    public PeriodCollection getPeriods(int fromYear, int fromNum, int toYear, int toNum, CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws EASBizException, BOSException {
        Map yearMap;
        if (fromYear > toYear || fromYear == toYear && fromNum > toYear) {
            return null;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(companyInfo, sysInfo);
        }
        if ((yearMap = (Map)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(fromYear));
        if (pc == null || pc.size() == 0) {
            return null;
        }
        PeriodCollection rsltCols = new PeriodCollection();
        PeriodInfo periodInfo = null;
        int index = 0;
        int colSize = 0;
        for (int year = fromYear; year <= toYear; ++year) {
            pc = (PeriodCollection)yearMap.get(new Integer(year));
            colSize = pc.size();
            for (index = 0; index < colSize; ++index) {
                periodInfo = pc.get(index);
                if (!this.isInRange(periodInfo, fromYear, fromNum, toYear, toNum)) continue;
                rsltCols.add(periodInfo);
            }
        }
        return rsltCols;
    }

    private boolean isInRange(PeriodInfo periodInfo, int fromYear, int fromNum, int toYear, int toNum) {
        int year = periodInfo.getPeriodYear();
        boolean fBetween = year > fromYear && year < toYear;
        boolean fStartYear = false;
        boolean fEndYear = false;
        if (fromYear == toYear) {
            fEndYear = fStartYear = year == fromYear && periodInfo.getPeriodNumber() >= fromNum && periodInfo.getPeriodNumber() <= toNum;
        } else {
            fStartYear = year == fromYear && periodInfo.getPeriodNumber() >= fromNum;
            fEndYear = year == toYear && periodInfo.getPeriodNumber() <= toNum;
        }
        return fBetween || fStartYear || fEndYear;
    }

    public PeriodInfo getSPeriod(CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo, PeriodInfo periodInfo) {
        IPeriod iPeriod = null;
        PeriodInfo pi = null;
        try {
            iPeriod = PeriodFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        boolean fBizUnit = !companyInfo.isIsOnlyUnion();
        PeriodInfo startPeriod = null;
        if (fBizUnit) {
            try {
                startPeriod = sysInfo != null ? sysInfo.getStartPeriod(this.getSystemEnum()) : this.getStartPeriod(companyInfo);
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            if (startPeriod == null) {
                return null;
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (fBizUnit) {
            filterItems.add(new FilterItemInfo("beginDate", (Object)startPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo("endDate", (Object)startPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
        }
        filterItems.add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(0)));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection periodc = null;
        try {
            periodc = iPeriod.getPeriodCollection(evi);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (periodc != null && periodInfo != null) {
            for (int i = 0; i < periodc.size(); ++i) {
                if (periodInfo.getPeriodNumber() != periodc.get(i).getPeriodNumber() || periodInfo.getPeriodYear() != periodc.get(i).getPeriodYear()) continue;
                pi = periodInfo;
            }
        }
        return pi;
    }
}

