/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.InvoiceEntryInfo;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SrcBillAutoInvHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.SrcBillAutoInvHelper");
    private static final BOSObjectType CUST_TYPE = new CustomerInfo().getBOSType();
    private static final BOSObjectType SUPP_TYPE = new SupplierInfo().getBOSType();

    private SrcBillAutoInvHelper() {
    }

    public static void setInvoiceInfoFields(Context ctx, InvoiceInfo info) throws BOSException, EASBizException {
        boolean fCussAcctRelatedFldsNull;
        if (info == null) {
            return;
        }
        SrcBillAutoInvHelper.setLoginUserPerson2Info(ctx, info);
        boolean fVatTaxNumNull = info.getType().equals((Object)InvoiceTypeEnum.VAT) && info.getTaxRegisterNo() == null;
        boolean bl = fCussAcctRelatedFldsNull = info.getAsstActName() == null || fVatTaxNumNull;
        if (!StringUtils.isEmpty((String)info.getAsstActID()) && fCussAcctRelatedFldsNull) {
            IObjectValue cussAcctInfo = SrcBillAutoInvHelper.getCussAcctInfo(ctx, info.getAsstActID());
            SrcBillAutoInvHelper.setCussRelatedFields(ctx, info.getCompany(), cussAcctInfo, info);
        }
        SrcBillAutoInvHelper.setTotalAmt(info);
        SrcBillAutoInvHelper.setCU_Number(ctx, info);
        info.setBillStatus(BillStatusEnum.SAVE);
        info.put("AutoTrans", "true");
    }

    private static void setLoginUserPerson2Info(Context ctx, InvoiceInfo info) throws BOSException, EASBizException {
        if (info.getAuditPerson() != null && info.getInvPerson() != null && info instanceof ArInvoiceInfo && ((ArInvoiceInfo)info).getDrawer() != null) {
            return;
        }
        PersonInfo personInfo = null;
        if (ctx == null) {
            UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
            personInfo = currUser.getPerson();
        } else {
            IObjectPK curUserId = ctx.getCaller();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("person.id");
            selectors.add("person.name");
            selectors.add("person.number");
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = iUser.getUserInfo(curUserId, selectors);
            personInfo = userInfo.getPerson();
        }
        if (personInfo == null) {
            return;
        }
        if (info.getAuditPerson() == null) {
            info.setAuditPerson(personInfo);
        }
        if (info instanceof ArInvoiceInfo && ((ArInvoiceInfo)info).getDrawer() == null) {
            ((ArInvoiceInfo)info).setDrawer(personInfo);
        }
    }

    private static void setCU_Number(Context ctx, InvoiceInfo info) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)info.getNumber()) || info.getCompany() == null) {
            return;
        }
        String companyId = info.getCompany().getId().toString();
        ICompanyOrgUnit iComp = null;
        iComp = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = iComp.getCompanyOrgUnitInfo("select id, cu.* where id = '" + companyId + "'");
        info.setCU(companyInfo.getCU());
    }

    private static IObjectValue getCussAcctInfo(Context ctx, String asstActId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)asstActId)) {
            return null;
        }
        IDynamicObject iDynObj = null;
        iDynObj = ctx != null ? DynamicObjectFactory.getLocalInstance((Context)ctx) : DynamicObjectFactory.getRemoteInstance();
        BOSUuid bosId = BOSUuid.read((String)asstActId);
        BOSObjectType bosType = bosId.getType();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("name");
        selectors.add("number");
        if (bosType.equals((Object)CUST_TYPE) || bosType.equals((Object)SUPP_TYPE)) {
            selectors.add("address");
            selectors.add("taxRegisterNo");
        }
        IObjectValue cussAcctInfo = iDynObj.getValue(bosId.getType(), (IObjectPK)new ObjectUuidPK(bosId), selectors);
        return cussAcctInfo;
    }

    private static void setCussRelatedFields(Context ctx, CompanyOrgUnitInfo companyInfo, IObjectValue cussAcctInfo, InvoiceInfo info) throws BOSException, EASBizException {
        if (cussAcctInfo == null || companyInfo == null) {
            return;
        }
        Locale locale = ArApConstants.L1;
        info.setAsstActName((String)cussAcctInfo.get("name", locale), locale);
        locale = ArApConstants.L2;
        info.setAsstActName((String)cussAcctInfo.get("name", locale), locale);
        locale = ArApConstants.L3;
        info.setAsstActName((String)cussAcctInfo.get("name", locale), locale);
        BOSObjectType type = cussAcctInfo.getBOSType();
        if (type.equals((Object)CUST_TYPE)) {
            SrcBillAutoInvHelper.setCustomerInfo(ctx, companyInfo, (CustomerInfo)cussAcctInfo, info);
        } else if (type.equals((Object)SUPP_TYPE)) {
            SrcBillAutoInvHelper.setSupplierInfo(ctx, companyInfo, (SupplierInfo)cussAcctInfo, info);
        }
    }

    private static void setCustomerInfo(Context ctx, CompanyOrgUnitInfo companyInfo, CustomerInfo cussAcctInfo, InvoiceInfo info) throws BOSException, EASBizException {
        String address = cussAcctInfo.getAddress();
        String taxRegNo = cussAcctInfo.getTaxRegisterNo();
        info.setTaxRegisterNo(taxRegNo);
        if (StringUtils.isEmpty((String)info.getCussAddress())) {
            info.setCussAddress(address);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("bank");
        view.getSelector().add("bankAccount");
        view.getSelector().add("phone");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String cussAcctId = cussAcctInfo.getString("id");
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)cussAcctId));
        ICustomerCompanyInfo iCustComp = null;
        iCustComp = ctx != null ? CustomerCompanyInfoFactory.getLocalInstance((Context)ctx) : CustomerCompanyInfoFactory.getRemoteInstance();
        CustomerCompanyInfoCollection infos = iCustComp.getCustomerCompanyInfoCollection(view);
        if (infos != null && infos.size() > 0) {
            CustomerCompanyInfoInfo custCompInfo = infos.get(0);
            if (StringUtils.isEmpty((String)info.getCussBank())) {
                info.setCussBank(custCompInfo.getBank());
            }
            if (StringUtils.isEmpty((String)info.getCussAcctBank())) {
                info.setCussAcctBank(custCompInfo.getBankAccount());
            }
            if (StringUtils.isEmpty((String)info.getCussPhone())) {
                info.setCussPhone(custCompInfo.getPhone());
            }
        }
    }

    private static void setSupplierInfo(Context ctx, CompanyOrgUnitInfo companyInfo, SupplierInfo cussAcctInfo, InvoiceInfo info) throws BOSException, EASBizException {
        String address = cussAcctInfo.getAddress();
        String taxRegNo = cussAcctInfo.getTaxRegisterNo();
        info.setTaxRegisterNo(taxRegNo);
        if (StringUtils.isEmpty((String)info.getCussAddress())) {
            info.setCussAddress(address);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("bankName");
        view.getSelector().add("bankAccount");
        view.getSelector().add("phone");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String cussAcctId = cussAcctInfo.getString("id");
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)cussAcctId));
        ISupplierCompanyInfo iCustComp = null;
        iCustComp = ctx != null ? SupplierCompanyInfoFactory.getLocalInstance((Context)ctx) : SupplierCompanyInfoFactory.getRemoteInstance();
        SupplierCompanyInfoCollection infos = iCustComp.getSupplierCompanyInfoCollection(view);
        if (infos != null && infos.size() > 0) {
            SupplierCompanyInfoInfo cussCompInfo = infos.get(0);
            if (StringUtils.isEmpty((String)info.getCussBank())) {
                info.setCussBank(cussCompInfo.getBankName());
            }
            if (StringUtils.isEmpty((String)info.getCussAcctBank())) {
                info.setCussAcctBank(cussCompInfo.getBankAccount());
            }
            if (StringUtils.isEmpty((String)info.getCussPhone())) {
                info.setCussPhone(cussCompInfo.getPhone());
            }
        }
    }

    private static void setTotalAmt(InvoiceInfo info) {
        IObjectCollection entries = (IObjectCollection)info.get("entries");
        BigDecimal amt = SysConstant.BIGZERO;
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            InvoiceEntryInfo entryInfo = (InvoiceEntryInfo)entries.getObject(i);
            if (entryInfo.getActualAmount() == null) continue;
            amt = amt.add(entryInfo.getActualAmount());
        }
        info.setTotalAmount(amt);
    }
}

