/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.billValidator.BillValidateConfigCollection;
import com.kingdee.eas.fi.arap.billValidator.BillValidateConfigFactory;
import com.kingdee.eas.fi.arap.billValidator.BillValidateConfigInfo;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigCacheSynFactory;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ValidateConfigCache {
    private static final int MAX_CACHE_SIZE = 10000;
    private static Map configCache = Collections.synchronizedMap(new LinkedHashMap());
    public static String NULL_VALUE = "empty";
    public static String UNDERLINE = "_";
    public static String CU_ID = "00000000-0000-0000-0000-000000000000CCE7AED4";

    public static void clearCache() {
        ValidateConfigCache.localClearCache();
        ValidateConfigCacheSynFactory.getInstance().clearCache();
    }

    public static void localClearCache() {
        configCache.clear();
    }

    public static void localClearCache(Object key) {
        configCache.remove(key);
    }

    public static void localAddCache(Object cacheInfo) {
        for (int i = configCache.size(); i >= 10000; --i) {
            configCache.remove(configCache.keySet().iterator().next());
        }
        if (cacheInfo instanceof BillValidateConfigInfo) {
            BillValidateConfigInfo configInfo = (BillValidateConfigInfo)cacheInfo;
            String key = configInfo.getOrgUnit().getId().toString() + "_" + configInfo.getValidateBill().getValue();
            if (configCache.get(key) != null) {
                Object value = configCache.get(key);
                if (value instanceof String) {
                    ArrayList<BillValidateConfigInfo> configList = new ArrayList<BillValidateConfigInfo>();
                    configList.add(configInfo);
                    configCache.put(key, configList);
                } else if (value instanceof List) {
                    List configList = (List)value;
                    for (int i = 0; i < configList.size(); ++i) {
                        BillValidateConfigInfo oldCache = (BillValidateConfigInfo)configList.get(i);
                        if (!oldCache.getId().equals((Object)configInfo.getId())) continue;
                        configList.remove(oldCache);
                        break;
                    }
                    configList.add(configInfo);
                }
            } else {
                ArrayList<BillValidateConfigInfo> configList = new ArrayList<BillValidateConfigInfo>();
                configList.add(configInfo);
                configCache.put(key, configList);
            }
        }
    }

    public static Object localGetCache(Context ctx, OrgUnitInfo org, String bosType) throws BOSException, EASBizException {
        String key = org.getId() + UNDERLINE + bosType;
        Object value = configCache.get(key);
        if (value != null) {
            if (value instanceof String) {
                Object cuValue = configCache.get(value);
                if (NULL_VALUE.equals(cuValue)) {
                    return configCache.get(CU_ID + UNDERLINE + bosType);
                }
                return cuValue;
            }
            if (value instanceof List) {
                return configCache.get(key);
            }
        } else {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)org.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("validateBill", (Object)bosType, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)ValidateConfigStatus.ENABLE, CompareType.EQUALS));
            ev.setFilter(filter);
            BillValidateConfigCollection configColl = BillValidateConfigFactory.getLocalInstance(ctx).getBillValidateConfigCollection(ev);
            ArrayList<BillValidateConfigInfo> configList = new ArrayList<BillValidateConfigInfo>();
            for (int i = 0; i < configColl.size(); ++i) {
                configList.add(configColl.get(i));
            }
            if (configList.size() == 0) {
                filter.getFilterItems().clear();
                if (org.getCU() == null) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("cu.id");
                    org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()), selector);
                }
                String cuKey = org.getCU().getId() + UNDERLINE + bosType;
                configCache.put(key, cuKey);
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)org.getCU().getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("validateBill", (Object)bosType, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)ValidateConfigStatus.ENABLE, CompareType.EQUALS));
                configColl = BillValidateConfigFactory.getLocalInstance(ctx).getBillValidateConfigCollection(ev);
                for (int i = 0; i < configColl.size(); ++i) {
                    configList.add(configColl.get(i));
                }
                if (configList.size() == 0) {
                    configCache.put(cuKey, NULL_VALUE);
                    String rootCUKey = CU_ID + UNDERLINE + bosType;
                    if (configCache.get(rootCUKey) == null) {
                        filter.getFilterItems().clear();
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)CU_ID, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("validateBill", (Object)bosType, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("status", (Object)ValidateConfigStatus.ENABLE, CompareType.EQUALS));
                        configColl = BillValidateConfigFactory.getLocalInstance(ctx).getBillValidateConfigCollection(ev);
                        for (int i = 0; i < configColl.size(); ++i) {
                            configList.add(configColl.get(i));
                        }
                        if (configList.size() == 0) {
                            configCache.put(rootCUKey, NULL_VALUE);
                        } else {
                            configCache.put(rootCUKey, configList);
                        }
                    }
                    return configCache.get(rootCUKey);
                }
                configCache.put(cuKey, configList);
                return configList;
            }
            configCache.put(key, configList);
            return configList;
        }
        return null;
    }

    public static void localRemoveCache(Object cacheInfo) {
        Object value;
        BillValidateConfigInfo configInfo;
        String key;
        if (cacheInfo instanceof BillValidateConfigInfo && configCache.containsKey(key = (configInfo = (BillValidateConfigInfo)cacheInfo).getOrgUnit().getId().toString() + "_" + configInfo.getValidateBill().getValue()) && (value = configCache.get(key)) instanceof List) {
            List configList = (List)value;
            for (int i = 0; i < configList.size(); ++i) {
                BillValidateConfigInfo oldCache = (BillValidateConfigInfo)configList.get(i);
                if (!oldCache.getId().equals((Object)configInfo.getId())) continue;
                configList.remove(oldCache);
                break;
            }
            if (configList.size() == 0) {
                configCache.remove(key);
            }
        }
    }
}

