/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.arap.billValidator.BillValidateResult;
import com.kingdee.eas.fi.arap.billValidator.client.AbstractValidateResultUI;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class ValidateResultUI
extends AbstractValidateResultUI {
    private static final Logger logger = CoreUIObject.getLogger(ValidateResultUI.class);
    private static String COL_SELECT = "select";
    private static String COL_BILL_ID = "billID";
    private static String COL_BILL_NUMBER = "billNumber";
    private static String COL_VAL_NUMBER = "valConfigNumber";
    private static String COL_VAL_NAME = "valConfigName";
    private static String COL_VAL_RES = "validateRes";
    private static String COL_VAL_LV = "validateLevel";
    private static String COL_VAL_DETAIL = "validateDetail";
    private Map valResultMap = new HashMap();
    private Object retValue;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTableColumn();
        this.fillValidateRes();
    }

    private void initTableColumn() {
        this.kDTable1.checkParsed();
        this.kDTable1.getGroupManager().setGroup(true);
        KDCheckBox cb = new KDCheckBox();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)cb);
        this.kDTable1.getColumn(COL_SELECT).setEditor((ICellEditor)cellEditor);
        this.kDTable1.getColumn(COL_BILL_ID).setGroup(true);
        this.kDTable1.getColumn(COL_BILL_ID).setMergeable(true);
        this.kDTable1.getColumn(COL_SELECT).setGroup(true);
        this.kDTable1.getColumn(COL_SELECT).setMergeable(true);
        this.kDTable1.getColumn(COL_BILL_NUMBER).setGroup(true);
        this.kDTable1.getColumn(COL_BILL_NUMBER).setMergeable(true);
        this.kDTable1.getColumn(COL_BILL_NUMBER).getStyleAttributes().setFontColor(Color.BLUE);
        this.kDTable1.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    ValidateResultUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    ValidateResultUI.this.handUIException(exc);
                }
            }
        });
    }

    private void tblMain_tableClicked(KDTMouseEvent e) {
        if (e.getClickCount() == 2) {
            IRow row = this.kDTable1.getRow(e.getRowIndex());
            HashMap uiCtx = new HashMap();
            String billID = (String)row.getCell(COL_BILL_ID).getValue();
            Map idMap = (Map)this.getUIContext().get("idMap");
            if (idMap.get(billID) == null || ((List)idMap.get(billID)).size() == 0) {
                return;
            }
            uiCtx.put("InitDataObject", idMap.get(billID));
            try {
                IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.arap.client.ValidateResultSchemeNavUI", uiCtx, null, OprtState.VIEW);
                popUI.show();
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private void fillValidateRes() {
        Map uiCtx = this.getUIContext();
        Map idMap = (Map)uiCtx.get("idMap");
        Map numberMap = (Map)uiCtx.get("numberMap");
        for (Object key : idMap.keySet()) {
            List valResultList = (List)idMap.get(key);
            if (valResultList.size() == 0) {
                IRow row = this.kDTable1.addRow();
                row.getCell(COL_BILL_ID).setValue(key);
                row.getCell(COL_BILL_NUMBER).setValue(numberMap.get(key));
                row.getCell(COL_VAL_RES).setValue((Object)"\u901a\u8fc7");
                row.getCell(COL_SELECT).setValue((Object)true);
                row.getCell(COL_VAL_DETAIL).setValue((Object)"\u65e0\u5339\u914d\u7684\u6821\u9a8c\u65b9\u6848");
                continue;
            }
            HashSet<IRow> resSet = new HashSet<IRow>();
            for (int i = 0; i < valResultList.size(); ++i) {
                BillValidateResult billValidateResult = (BillValidateResult)valResultList.get(i);
                IRow row = this.kDTable1.addRow();
                row.getCell(COL_BILL_ID).setValue(key);
                row.getCell(COL_BILL_NUMBER).setValue(numberMap.get(key));
                row.getCell(COL_VAL_NUMBER).setValue((Object)billValidateResult.getBillValidateConfig().getNumber());
                row.getCell(COL_VAL_NAME).setValue((Object)billValidateResult.getBillValidateConfig().getName());
                String msg = billValidateResult.getErrMsg();
                if (StringUtils.isEmpty((String)msg)) {
                    row.getCell(COL_VAL_RES).setValue((Object)"\u901a\u8fc7");
                    resSet.add(row);
                } else {
                    row.getCell(COL_VAL_RES).setValue((Object)"\u4e0d\u901a\u8fc7");
                    row.getCell(COL_VAL_RES).getStyleAttributes().setFontColor(Color.RED);
                }
                row.getCell(COL_SELECT).setValue((Object)false);
                row.getCell(COL_VAL_LV).setValue((Object)billValidateResult.getBillValidateConfig().getValidateLevel());
                row.getCell(COL_VAL_DETAIL).setValue((Object)msg);
                this.valResultMap.put(row.getRowIndex(), billValidateResult);
            }
            if (resSet.size() != valResultList.size()) continue;
            for (Object e : resSet) {
                ((IRow)e).getCell(COL_SELECT).setValue((Object)true);
            }
        }
    }

    @Override
    public void actionContinue_actionPerformed(ActionEvent e) throws Exception {
        HashSet<Object> selectIDSet = new HashSet<Object>();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            IRow row = this.kDTable1.getRow(i);
            if (!((Boolean)row.getCell(COL_SELECT).getValue()).booleanValue()) continue;
            selectIDSet.add(row.getCell(COL_BILL_ID).getValue());
        }
        this.retValue = selectIDSet;
        this.getUIWindow().close();
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
        this.retValue = "interrupt";
    }

    public Object getRetValue() {
        return this.retValue;
    }
}

