/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.util.IncomeConfimUtil;
import com.kingdee.eas.fi.cas.validate.currency.IShutAccountBillCheck;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractShutAccountBillCheck
implements IShutAccountBillCheck {
    private final Context context;
    private final Map<String, String> queryMap = new HashMap<String, String>();
    private final Map<String, List<String>> result = new HashMap<String, List<String>>();
    public static final Map<String, String> billNameMap = new HashMap<String, String>();

    public AbstractShutAccountBillCheck(Context context) {
        this.context = context;
    }

    public void doCheck(CompanyOrgUnitInfo companyInfo, PeriodInfo currentPeriod) throws BOSException {
        this.injectQuery(this.queryMap);
        this.result.putAll(this.checkShutAccount(this.context, this.queryMap, companyInfo, currentPeriod));
    }

    public boolean hasError() {
        return !this.result.isEmpty();
    }

    public String getErrorMsg() {
        if (!this.hasError()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.result.entrySet()) {
            String bosType = entry.getKey();
            String billName = this.queryBillName(bosType);
            List<String> value = entry.getValue();
            builder.append("\n");
            builder.append(billName);
            builder.append(":\n");
            builder.append(StringUtils.arrayToString((Object[])value.toArray(), (String)"\n"));
        }
        return builder.toString();
    }

    protected abstract void injectQuery(Map<String, String> var1);

    protected abstract SystemEnum getSystemEnum();

    private String queryBillName(String bosType) {
        Locale locale = this.context.getLocale();
        if ("FC910EF3".equals(bosType)) {
            return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"AROtherBill", (Locale)locale);
        }
        if (IncomeConfimBillInfo.getBosType().equals(bosType)) {
            return IncomeConfimUtil.getResString("INMCOME_CONFIM_EDIT");
        }
        if ("FA44FD5B".equals(bosType)) {
            return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"ReciveBill", (Locale)locale);
        }
        if ("9B112F80".equals(bosType)) {
            return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"ProxyBill", (Locale)locale);
        }
        if ("48DA3A71".equals(bosType)) {
            return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"APOtherBill", (Locale)locale);
        }
        if ("40284E81".equals(bosType)) {
            return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"PaymentBill", (Locale)locale);
        }
        return null;
    }

    private Map<String, List<String>> checkShutAccount(Context ctx, Map<String, String> queryMap, CompanyOrgUnitInfo companyInfo, PeriodInfo currentPeriod) throws BOSException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Timestamp endDate = currentPeriod.getEndDate();
        endDate.setHours(23);
        endDate.setMinutes(59);
        endDate.setSeconds(59);
        for (Map.Entry<String, String> query : queryMap.entrySet()) {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)query.getValue(), (Object[])new Object[]{companyInfo.getId().toString(), currentPeriod.getBeginDate(), currentPeriod.getEndDate()});
            if (iRowSet.size() <= 0) continue;
            ArrayList<String> numbers = new ArrayList<String>();
            try {
                while (iRowSet.next()) {
                    String status = this.getStatusAlias(query.getKey(), iRowSet.getInt("status"));
                    numbers.add(iRowSet.getString("number") + "\t" + status);
                }
                map.put(query.getKey(), numbers);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return map;
    }

    private String getStatusAlias(String bosType, int value) {
        if ("FC910EF3".equals(bosType) || IncomeConfimBillInfo.getBosType().equals(bosType) || "9B112F80".equals(bosType) || "48DA3A71".equals(bosType)) {
            return BillStatusEnum.getEnum((int)value).getAlias();
        }
        if ("FA44FD5B".equals(bosType) || "40284E81".equals(bosType)) {
            return com.kingdee.eas.fi.cas.BillStatusEnum.getEnum((int)value).getAlias();
        }
        return "";
    }
}

