/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.check.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.arap.check.ICalculateCheck;
import com.kingdee.eas.fi.arap.check.ICheck;
import com.kingdee.eas.fi.arap.util.VelocityHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractArApCalculateChecker
implements ICalculateCheck<ArApBillBaseInfo> {
    protected final Context context;
    private final Map<Integer, List<String>> unpassMap = new TreeMap<Integer, List<String>>();

    public AbstractArApCalculateChecker(Context context) {
        this.context = context;
    }

    private void executeCheck(ArApBillBaseInfo origin, ArApBillBaseInfo clone) {
        AbstractObjectCollection originCollection = origin.getEntries();
        AbstractObjectCollection cloneCollection = clone.getEntries();
        for (int i = 0; i < originCollection.size(); ++i) {
            ArApBillEntryBaseInfo cloneEntry;
            ArApBillEntryBaseInfo originEntry = (ArApBillEntryBaseInfo)originCollection.getObject(i);
            List<String> unpassCheckFields = this.checkEntry(originEntry, cloneEntry = (ArApBillEntryBaseInfo)cloneCollection.getObject(i));
            if (unpassCheckFields.isEmpty()) continue;
            this.unpassMap.put(originEntry.getSeq(), unpassCheckFields);
        }
    }

    private List<String> checkEntry(ArApBillEntryBaseInfo origin, ArApBillEntryBaseInfo copy) {
        List<String> checkFields = this.getCheckFields();
        if (null == checkFields || checkFields.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> unPassFields = new ArrayList<String>(checkFields.size());
        for (String fieldName : checkFields) {
            BigDecimal originAmount = origin.getBigDecimal(fieldName);
            BigDecimal cloneAmount = copy.getBigDecimal(fieldName);
            if ((originAmount = originAmount == null ? BigDecimal.ZERO : originAmount).compareTo(cloneAmount = cloneAmount == null ? BigDecimal.ZERO : cloneAmount) == 0) continue;
            unPassFields.add(fieldName);
        }
        return unPassFields;
    }

    private boolean check(ArApBillBaseInfo origin, ArApBillBaseInfo clone) throws BOSException, EASBizException {
        this.unpassMap.clear();
        this.executeCalculate(clone);
        this.executeCheck(origin, clone);
        return this.unpassMap.isEmpty();
    }

    protected abstract void executeCalculate(ArApBillBaseInfo var1) throws BOSException, EASBizException;

    protected abstract List<String> getCheckFields();

    @Override
    public boolean check(ArApBillBaseInfo billInfo) throws BOSException, EASBizException {
        return this.check(billInfo, (ArApBillBaseInfo)billInfo.clone());
    }

    @Override
    public ICheck prepareMessage(final String template, final Map context) {
        return new ICheck(){

            @Override
            public boolean isErrorType() {
                return false;
            }

            @Override
            public String getMsg() {
                HashMap<String, String> ctxMap = new HashMap<String, String>(context);
                ArrayList unPassSeqs = new ArrayList(AbstractArApCalculateChecker.this.unpassMap.keySet());
                ctxMap.put("unPassSeqs", StringUtils.arrayToString((Object[])unPassSeqs.toArray(), (String)","));
                return VelocityHelper.format(template, ctxMap);
            }
        };
    }
}

