/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.check.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.DbUtilFacadeFactory;
import com.kingdee.eas.fi.arap.IDbUtilFacade;
import com.kingdee.eas.fi.arap.check.impl.AbstractBatchCheck;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.List;

public class ExistDownBillBatchCheckImpl
extends AbstractBatchCheck {
    public ExistDownBillBatchCheckImpl(String msg, Boolean isErrorType) {
        super(msg, isErrorType);
    }

    @Override
    public String check(Context ctx, List<String> idList) throws BOSException {
        StringBuffer numbers = new StringBuffer(100);
        StringBuffer sql = new StringBuffer(100);
        String billTable = this.getBillTable(ctx, idList);
        if (StringUtils.isEmpty((String)billTable) || idList.size() == 0) {
            return null;
        }
        sql.append(" select distinct bill.").append(this.getMsgField()).append(" as number ");
        sql.append(" from ").append(billTable).append(" bill ");
        sql.append(" inner join T_bot_relation relation on bill.fid = relation.fSrcObjectId");
        sql.append(" where bill.fid in ").append(ListUtil.transList2String(idList));
        sql.append(" order by bill.fnumber desc");
        IDbUtilFacade iDbUtilFacade = null;
        iDbUtilFacade = ctx == null ? DbUtilFacadeFactory.getRemoteInstance() : DbUtilFacadeFactory.getLocalInstance(ctx);
        IRowSet rowSet = iDbUtilFacade.executeQuery(sql.toString());
        try {
            while (rowSet.next()) {
                numbers.append(rowSet.getString("number")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (numbers.length() > 0) {
            return numbers.substring(0, numbers.length() - 1);
        }
        return null;
    }

    protected String getMsgField() {
        return "fnumber";
    }
}

