/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.arap.AgingTimeSettingCollection;
import com.kingdee.eas.fi.arap.AgingTimeSettingFactory;
import com.kingdee.eas.fi.arap.AgingTimeSettingInfo;
import com.kingdee.eas.fi.arap.IAgingTimeSetting;
import com.kingdee.eas.fi.arap.client.AbstractArApAgingTimeSettingSelectorUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ArApAgingTimeSettingSelectorUI
extends AbstractArApAgingTimeSettingSelectorUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ArApAgingTimeSettingSelectorUI.class);
    private boolean isCanceled = false;
    private String paramName = null;
    private static String COLUMN_DAYS = "days";
    private static String COLUMN_DESCRIPTION = "description";
    private static String COLUMN_BEGINDAY = "beginDay";
    private static String COLUMN_ENDDAY = "endDay";
    private boolean isOverDue = true;
    private StringBuilder retStr = new StringBuilder();
    private static Integer MAXDAY = 999999;
    private boolean dirty = false;

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTables();
        this.initData();
    }

    private void initData() throws BOSException {
        Map ctx = this.getUIContext();
        this.isOverDue = (Boolean)ctx.get("isOverDue");
        String title = ((TitledBorder)this.kDPanel1.getBorder()).getTitle();
        String borderTitle = this.isOverDue ? EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapAllResource", (String)"Have") + title.substring(1) : title;
        ((TitledBorder)this.kDPanel1.getBorder()).setTitle(borderTitle);
        AgingTimeSettingCollection ageCol = this.getRemoteInstance().getCollection("select id,days,description,isOverDue,beginDay,endDay where isOverDue = '" + (this.isOverDue ? 1 : 0) + "'");
        this.refreshRow(this.kdTable, ageCol);
        this.dirty = false;
    }

    public void refreshRow(KDTable kdTable, AgingTimeSettingCollection data) {
        if (data.size() <= 0) {
            return;
        }
        IRow row = null;
        for (int i = 0; i < data.size(); ++i) {
            row = i >= kdTable.getRowCount() ? kdTable.addRow() : kdTable.getRow(i);
            AgingTimeSettingInfo info = data.get(i);
            row.setUserObject((Object)info);
            row.getCell(COLUMN_DAYS).setValue((Object)info.getDays());
            row.getCell(COLUMN_DESCRIPTION).setValue((Object)info.getDescription());
            row.getCell(COLUMN_BEGINDAY).setValue((Object)info.getBeginDay());
            row.getCell(COLUMN_ENDDAY).setValue((Object)info.getEndDay());
        }
        int dataCount = this.getHasDateRowCount(kdTable);
        IRow tailRow = kdTable.getRow(kdTable.getRowCount() - 1);
        ICell cell = tailRow.getCell(COLUMN_DAYS);
        int day = (Integer)kdTable.getRow(dataCount - 1).getCell(COLUMN_DAYS).getValue();
        if (cell.getValue() == null) {
            IRow iRow = tailRow;
            iRow.getCell(COLUMN_DAYS).setValue(null);
            iRow.getCell(COLUMN_DESCRIPTION).setValue((Object)(day + 1 + EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapAllResource", (String)"DayUp")));
            iRow.getCell(COLUMN_BEGINDAY).setValue((Object)(day + 1));
            iRow.getCell(COLUMN_ENDDAY).setValue((Object)MAXDAY);
            iRow.getCell(COLUMN_DAYS).getStyleAttributes().setLocked(true);
        } else {
            IRow iRow = kdTable.addRow();
            iRow.getCell(COLUMN_DAYS).setValue(null);
            iRow.getCell(COLUMN_DESCRIPTION).setValue((Object)(day + 1 + EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapAllResource", (String)"DayUp")));
            iRow.getCell(COLUMN_BEGINDAY).setValue((Object)(day + 1));
            iRow.getCell(COLUMN_ENDDAY).setValue((Object)MAXDAY);
            iRow.getCell(COLUMN_DAYS).getStyleAttributes().setLocked(true);
        }
    }

    private IAgingTimeSetting getRemoteInstance() throws BOSException {
        return AgingTimeSettingFactory.getRemoteInstance();
    }

    private void initTables() {
        this.kdTable.checkParsed();
        this.kdTable.getIndexColumn().getStyleAttributes().setHided(true);
        this.kdTable.setActiveCellStatus(1);
        KDFormattedTextField txtDay = new KDFormattedTextField(0);
        txtDay.setMinimumValue((Comparable)new Integer("1"));
        txtDay.setMaximumValue((Comparable)new Integer("9999"));
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)txtDay);
        this.kdTable.removeRows();
        this.kdTable.addRows(3);
        this.kdTable.getColumn(COLUMN_DAYS).setEditor((ICellEditor)cellEditor);
        this.kdTable.getColumn(COLUMN_DESCRIPTION).getStyleAttributes().setLocked(true);
        KDTableUtil.setSelectedRow((KDTable)this.kdTable, (int)0);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void okButton_actionPerformed(ActionEvent e) throws Exception {
        this.kdTable.getEditManager().stopEditing();
        super.okButton_actionPerformed(e);
        this.getDataFromTable();
        this.save();
        this.disposeUIWindow();
    }

    private void save() throws Exception {
        if (!this.dirty) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AgingTimeSettingCollection col = ArApAgingTimeSettingSelectorUI.this.storeDataFromTable(ArApAgingTimeSettingSelectorUI.this.kdTable);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("data", (Object)col);
                map.put("isOverDue", ArApAgingTimeSettingSelectorUI.this.isOverDue);
                try {
                    ArApAgingTimeSettingSelectorUI.this.getRemoteInstance().save(map);
                }
                catch (Exception e) {
                    ArApAgingTimeSettingSelectorUI.this.handUIException(e);
                }
            }
        });
    }

    protected AgingTimeSettingCollection storeDataFromTable(KDTable kdTable) {
        AgingTimeSettingCollection result = new AgingTimeSettingCollection();
        IRow row = null;
        for (int i = 0; i < kdTable.getRowCount() && (row = kdTable.getRow(i)).getCell(COLUMN_DAYS).getValue() != null; ++i) {
            int days = (Integer)row.getCell(COLUMN_DAYS).getValue();
            String description = (String)row.getCell(COLUMN_DESCRIPTION).getValue();
            int beginDay = (Integer)row.getCell(COLUMN_BEGINDAY).getValue();
            int endDay = (Integer)row.getCell(COLUMN_ENDDAY).getValue();
            AgingTimeSettingInfo info = new AgingTimeSettingInfo();
            info.setIsOverDue(this.isOverDue);
            info.setDays(days);
            info.setDescription(description);
            info.setBeginDay(beginDay);
            info.setEndDay(endDay);
            result.add(info);
        }
        return result;
    }

    private void getDataFromTable() {
        IRow selectRows = KDTableUtil.getSelectedRow((KDTable)this.kdTable);
        if (selectRows == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"select_data"));
            SysUtil.abort();
        }
        if (selectRows.getCell(COLUMN_BEGINDAY).getValue() != null) {
            this.retStr.append(selectRows.getCell(COLUMN_BEGINDAY).getValue());
        }
        if (selectRows.getCell(COLUMN_ENDDAY).getValue() != null) {
            this.retStr.append(",").append(selectRows.getCell(COLUMN_ENDDAY).getValue());
        }
    }

    @Override
    protected void cancelButton_actionPerformed(ActionEvent e) throws Exception {
        super.cancelButton_actionPerformed(e);
    }

    @Override
    protected void tblUndue_editStopped(KDTEditEvent e) throws Exception {
        this.setViewContent(e);
    }

    private void setViewContent(KDTEditEvent e) {
        Object oldVal = e.getOldValue();
        Object val = e.getValue();
        if (oldVal == null && val == null) {
            return;
        }
        if (oldVal != null && val != null && oldVal.equals(val)) {
            return;
        }
        int rowIndex = e.getRowIndex();
        KDTable tbl = (KDTable)e.getSource();
        this.checkDayValid(tbl, rowIndex);
        this.setAllDateLbl(tbl, rowIndex);
        this.dirty = true;
    }

    private void checkDayValid(KDTable tbl, int rowIndex) {
        IRow row = tbl.getRow(rowIndex);
        Integer dayNum = (Integer)row.getCell(COLUMN_DAYS).getValue();
        if (dayNum == null) {
            row.getCell(COLUMN_DESCRIPTION).setValue(null);
        }
        int hasDateRows = this.getHasDateRowCount(tbl);
        for (int i = 1; i < hasDateRows; ++i) {
            int preDays;
            int days = (Integer)tbl.getRow(i).getCell(COLUMN_DAYS).getValue();
            if (days <= (preDays = ((Integer)tbl.getRow(i - 1).getCell(COLUMN_DAYS).getValue()).intValue())) {
                days = preDays + 10;
                tbl.getRow(i).getCell(COLUMN_DAYS).setValue((Object)new Integer(days));
                continue;
            }
            if (days >= preDays || i <= 1) continue;
            int prepDays = (Integer)tbl.getRow(i - 2).getCell(COLUMN_DAYS).getValue();
            preDays = (prepDays + days) / 2;
            tbl.getRow(i - 1).getCell(COLUMN_DAYS).setValue((Object)new Integer(preDays));
        }
    }

    private void setAllDateLbl(KDTable tbl, int rowIndex) {
        String resLbl = null;
        resLbl = tbl.getName().equals("tblOverdue") ? "Lbl_FOL" : "Lbl_FUL";
        int dayDiff = 0;
        int beginDay = 0;
        int endDay = 0;
        IRow row = null;
        int hasDateRows = this.getHasDateRowCount(tbl);
        for (int i = 0; i < hasDateRows; ++i) {
            row = tbl.getRow(i);
            dayDiff = (Integer)row.getCell(COLUMN_DAYS).getValue();
            Object[] args = null;
            if (i == 0) {
                args = new String[]{String.valueOf(1), String.valueOf(dayDiff)};
                beginDay = 1;
                endDay = dayDiff;
            } else {
                int preDiff = (Integer)tbl.getRow(i - 1).getCell(COLUMN_DAYS).getValue() + 1;
                args = new String[]{String.valueOf(preDiff), String.valueOf(dayDiff)};
                beginDay = preDiff;
                endDay = dayDiff;
            }
            String colTitle = EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)resLbl);
            row.getCell(COLUMN_DESCRIPTION).setValue((Object)MessageFormat.format(colTitle, args));
            row.getCell(COLUMN_BEGINDAY).setValue((Object)beginDay);
            row.getCell(COLUMN_ENDDAY).setValue((Object)endDay);
        }
        if (rowIndex >= 0 && rowIndex == hasDateRows - 1) {
            IRow iRow;
            int day = (Integer)tbl.getRow(rowIndex).getCell(COLUMN_DAYS).getValue();
            if (hasDateRows < tbl.getRowCount()) {
                iRow = tbl.getRow(tbl.getRowCount() - 1);
                iRow.getCell(COLUMN_DAYS).setValue(null);
                iRow.getCell(COLUMN_DESCRIPTION).setValue((Object)(day + 1 + EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapAllResource", (String)"DayUp")));
                iRow.getCell(COLUMN_BEGINDAY).setValue((Object)(day + 1));
                iRow.getCell(COLUMN_ENDDAY).setValue((Object)MAXDAY);
                iRow.getCell(COLUMN_DAYS).getStyleAttributes().setLocked(true);
            } else {
                iRow = tbl.addRow();
                iRow.getCell(COLUMN_DAYS).setValue(null);
                iRow.getCell(COLUMN_DESCRIPTION).setValue((Object)(day + 1 + EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapAllResource", (String)"DayUp")));
                iRow.getCell(COLUMN_BEGINDAY).setValue((Object)(day + 1));
                iRow.getCell(COLUMN_ENDDAY).setValue((Object)MAXDAY);
                iRow.getCell(COLUMN_DAYS).getStyleAttributes().setLocked(true);
            }
        }
    }

    private int getHasDateRowCount(KDTable tbl) {
        IRow row;
        int hasDateRows = 0;
        int n = tbl.getRowCount();
        for (int i = 0; i < n && (row = tbl.getRow(i)).getCell(COLUMN_DAYS).getValue() != null; ++i) {
            ++hasDateRows;
        }
        return hasDateRows;
    }

    @Override
    protected void btnUndueDel_actionPerformed(ActionEvent e) throws Exception {
        this.delRow(this.kdTable);
        this.setAllDateLbl(this.kdTable, this.getHasDateRowCount(this.kdTable) - 1);
        this.dirty = true;
    }

    private void delRow(KDTable tbl) throws Exception {
        logger.debug((Object)("del, rows " + tbl.getRowCount()));
        if (tbl.getRowCount() == 0) {
            return;
        }
        int del = this.getHasDateRowCount(tbl);
        if (tbl.getSelectManager().size() > 0) {
            KDTSelectBlock block = tbl.getSelectManager().get();
            if (block != null && block.getTop() != tbl.getRowCount() - 1) {
                IRow iRow = tbl.getRow(block.getTop() + 1);
                if (iRow.getCell(COLUMN_DAYS).getValue() == null) {
                    tbl.removeRow(block.getTop());
                    return;
                }
                int dd = (Integer)iRow.getCell(COLUMN_ENDDAY).getValue();
                tbl.removeRow(block.getTop());
                if (dd == MAXDAY) {
                    if (this.getHasDateRowCount(tbl) == 0) {
                        tbl.removeRow(block.getTop());
                    } else {
                        iRow = tbl.getRow(this.getHasDateRowCount(tbl) - 1);
                        int temp = (Integer)iRow.getCell(COLUMN_DAYS).getValue();
                        IRow row = tbl.getRow(block.getTop());
                        row.getCell(COLUMN_DAYS).setValue(null);
                        row.getCell(COLUMN_DESCRIPTION).setValue((Object)(temp + 1 + EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapAllResource", (String)"DayUp")));
                        row.getCell(COLUMN_BEGINDAY).setValue((Object)(temp + 1));
                        row.getCell(COLUMN_ENDDAY).setValue((Object)MAXDAY);
                        row.getCell(COLUMN_DAYS).getStyleAttributes().setLocked(true);
                    }
                }
                System.out.println();
            }
        } else if (tbl.getRowCount() > 0) {
            tbl.removeRow(tbl.getRowCount() - 1);
        }
        this.dirty = true;
    }

    @Override
    protected void btnUndueAddAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.addRow(this.kdTable);
    }

    private void addRow(KDTable tbl) throws Exception {
        int rowCount = tbl.getRowCount();
        if (rowCount <= 0) {
            tbl.addRow();
        } else {
            tbl.addRow(rowCount - 1);
        }
        logger.debug((Object)("add, rows " + tbl.getRowCount()));
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.isCanceled = true;
        this.disposeUIWindow();
    }

    protected void initWorkButton() {
        this.addButton.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.addButton.setText("");
        this.delButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.delButton.setText("");
    }

    public boolean destroyWindow() {
        this.isCanceled = true;
        return super.destroyWindow();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Object getData() {
        return this.retStr;
    }
}

